/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.filter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Principal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.slide.webdav.logger.StatusHttpServletResponseWrapper;
import org.apache.slide.webdav.util.WebdavStatus;

public class LogFilter
implements Filter {
    FilterConfig config;
    ServletContext context;
    String logFormat = "%T, %t, %P, %m, %s \"%l\", %i, %p";
    boolean outputToConsole = true;
    boolean outputToServletLog = false;
    boolean outputToFile = false;
    String outputFilePath = null;
    File outputFile = null;
    BufferedOutputStream fout = null;
    DateFormat df;
    String dateTimePattern = "dd-MMM-yyyy HH:mm:ss";

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        this.context = config.getServletContext();
        this.df = new SimpleDateFormat(this.dateTimePattern);
        String p = config.getInitParameter("logFormat");
        if (p != null && !"".equals(p)) {
            this.logFormat = p;
        }
        if ("false".equalsIgnoreCase(p = config.getInitParameter("outputToConsole"))) {
            this.outputToConsole = false;
        }
        if ("true".equalsIgnoreCase(p = config.getInitParameter("outputToServletLog"))) {
            this.outputToServletLog = true;
        }
        if ((p = config.getInitParameter("outputToFile")) != null && !"".equals(p)) {
            this.outputFilePath = p;
            this.outputFile = new File(this.outputFilePath);
            try {
                if (this.outputFile.canWrite() || this.outputFile.createNewFile()) {
                    this.fout = new BufferedOutputStream(new FileOutputStream(this.outputFilePath, true));
                    this.outputToFile = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String contentlength;
        String principal;
        HttpServletRequest req = (HttpServletRequest)request;
        StatusHttpServletResponseWrapper resp = new StatusHttpServletResponseWrapper((HttpServletResponse)response);
        long start = System.currentTimeMillis();
        String thread = Thread.currentThread().getName();
        String useragent = req.getHeader("User-Agent") != null ? req.getHeader("User-Agent") : "<user-agent-unknown>";
        String datetime = this.df.format(new Date());
        String method = req.getMethod();
        String uri = req.getRequestURI();
        Principal p = req.getUserPrincipal();
        String string = principal = p != null ? p.getName() : null;
        if (principal == null) {
            principal = "unauthenticated";
        }
        if ((contentlength = req.getHeader("Content-Length")) == null) {
            contentlength = "-";
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        int status = resp.getStatus();
        String message = WebdavStatus.getStatusText(status);
        String detail = resp.getStatusText();
        if (detail == null || "".equals(detail)) {
            detail = message;
        }
        String path = (String)req.getAttribute("slide_uri");
        long end = System.currentTimeMillis();
        this.logLine(end - start, status, thread, method, datetime, uri, path, contentlength, principal, message, detail, useragent);
    }

    private void logLine(long elapsed, int status, String thread, String method, String datetime, String uri, String path, String contentlength, String principal, String message, String detail, String useragent) throws IOException {
        StringBuffer b = new StringBuffer(this.logFormat);
        int i = b.toString().indexOf("%T");
        if (i >= 0) {
            b.replace(i, i + 2, thread);
        }
        if ((i = b.toString().indexOf("%t")) >= 0) {
            b.replace(i, i + 2, datetime);
        }
        if ((i = b.toString().indexOf("%P")) >= 0) {
            b.replace(i, i + 2, principal);
        }
        if ((i = b.toString().indexOf("%m")) >= 0) {
            b.replace(i, i + 2, method);
        }
        if ((i = b.toString().indexOf("%s")) >= 0) {
            b.replace(i, i + 2, String.valueOf(status));
        }
        if ((i = b.toString().indexOf("%l")) >= 0) {
            b.replace(i, i + 2, message);
        }
        if ((i = b.toString().indexOf("%L")) >= 0) {
            b.replace(i, i + 2, detail);
        }
        if ((i = b.toString().indexOf("%i")) >= 0) {
            b.replace(i, i + 2, String.valueOf(elapsed) + " ms");
        }
        if ((i = b.toString().indexOf("%p")) >= 0) {
            b.replace(i, i + 2, path);
        }
        if ((i = b.toString().indexOf("%u")) >= 0) {
            b.replace(i, i + 2, uri);
        }
        if ((i = b.toString().indexOf("%x")) >= 0) {
            b.replace(i, i + 2, contentlength);
        }
        if ((i = b.toString().indexOf("%A")) >= 0) {
            b.replace(i, i + 2, useragent);
        }
        if (this.outputToConsole) {
            System.out.println(b.toString());
        }
        if (this.outputToServletLog) {
            this.context.log(b.toString());
        }
        if (this.outputToFile) {
            b.append("\n");
            this.fout.write(b.toString().getBytes("UTF-8"));
            this.fout.flush();
        }
    }

    public void destroy() {
        try {
            if (this.outputToFile) {
                this.fout.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

