/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.event;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimerTask;
import org.apache.slide.event.ResourceEvent;

public class Subscriber {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$webdav$event$Subscriber == null ? (class$org$apache$slide$webdav$event$Subscriber = Subscriber.class$("org.apache.slide.webdav.event.Subscriber")) : class$org$apache$slide$webdav$event$Subscriber).getName();
    static final String UPDATE = "Update";
    static final String DELETE = "Delete";
    static final String MOVE = "Move";
    static final String NEW_MEMBER = "Update/newmember";
    static final String NEW_MAIL = "pragma/<http://schemas.microsoft.com/exchange/newmail>";
    private String callback;
    private String notificationType;
    private String uri;
    private int depth;
    private int notificationDelay;
    private int subscriptionLifetime;
    private int id;
    private long subscriptionEnd;
    private List events = new ArrayList();
    private TimerTask lifetime;
    private TimerTask notify;
    static /* synthetic */ Class class$org$apache$slide$webdav$event$Subscriber;

    public Subscriber(String uri, String callback, String notificationType, int notificationDelay, int subscriptionLifetime, int depth) {
        this.callback = callback;
        this.notificationType = notificationType;
        this.notificationDelay = notificationDelay;
        this.subscriptionLifetime = subscriptionLifetime;
        this.subscriptionEnd = System.currentTimeMillis() + (long)(subscriptionLifetime * 1000);
        this.uri = uri;
        this.depth = depth;
    }

    public void addEvent(ResourceEvent event) {
        this.events.add(event);
    }

    public List getEvents() {
        return this.events;
    }

    public void clearEvents() {
        this.events = new ArrayList();
    }

    public TimerTask getLifetime() {
        return this.lifetime;
    }

    public long getSubscriptionEnd() {
        return this.subscriptionEnd;
    }

    public void setLifetime(TimerTask lifetime) {
        this.lifetime = lifetime;
    }

    public TimerTask getNotify() {
        return this.notify;
    }

    public void setNotify(TimerTask notify) {
        this.notify = notify;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean matches(String type, ResourceEvent event) {
        String eventUri;
        if ((type.equalsIgnoreCase(this.notificationType) || type.equalsIgnoreCase(NEW_MEMBER) && this.notificationType.equalsIgnoreCase(UPDATE) && this.depth > 0 || type.equalsIgnoreCase(DELETE) && this.notificationType.equalsIgnoreCase(UPDATE) && this.depth > 0) && (eventUri = event.getUri()) != null && this.uri != null) {
            String subpath;
            StringTokenizer tokenizer;
            if (this.depth == 0 && eventUri.equals(this.uri.toString())) {
                return true;
            }
            if (this.depth == Integer.MAX_VALUE && eventUri.startsWith(this.uri.toString())) {
                return true;
            }
            if (eventUri.startsWith(this.uri.toString()) && (tokenizer = new StringTokenizer(subpath = eventUri.substring(this.uri.toString().length()), "/")).countTokens() <= this.depth) {
                return true;
            }
        }
        return false;
    }

    public boolean hasCallback() {
        return this.callback != null && this.callback.length() > 0;
    }

    public String getCallback() {
        return this.callback;
    }

    public String getNotificationType() {
        return this.notificationType;
    }

    public int getNotificationDelay() {
        return this.notificationDelay;
    }

    public void setSubscriptionLifetime(int subscriptionLifetime) {
        this.subscriptionLifetime = subscriptionLifetime;
    }

    public int getSubscriptionLifetime() {
        return this.subscriptionLifetime;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

