/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.event;

import de.zeigermann.xml.XMLEncode;
import de.zeigermann.xml.XMLOutputStreamWriter;
import de.zeigermann.xml.XMLWriter;
import de.zeigermann.xml.simpleImporter.ConversionHelpers;
import de.zeigermann.xml.simpleImporter.DefaultSimpleImportHandler;
import de.zeigermann.xml.simpleImporter.SimpleImportHandler;
import de.zeigermann.xml.simpleImporter.SimpleImporter;
import de.zeigermann.xml.simpleImporter.SimplePath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpState;
import org.apache.slide.common.Domain;
import org.apache.slide.event.ContentEvent;
import org.apache.slide.event.EventCollection;
import org.apache.slide.event.EventCollectionFilter;
import org.apache.slide.event.EventCollectionListener;
import org.apache.slide.event.ResourceEvent;
import org.apache.slide.event.VetoException;
import org.apache.slide.util.conf.Configurable;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;
import org.apache.slide.webdav.event.NotifyMethod;
import org.apache.slide.webdav.event.Subscriber;
import org.apache.slide.webdav.util.NotificationConstants;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.AttributesImpl;

public class NotificationTrigger
implements NotificationConstants,
EventCollectionListener,
Configurable {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$webdav$event$NotificationTrigger == null ? (class$org$apache$slide$webdav$event$NotificationTrigger = NotificationTrigger.class$("org.apache.slide.webdav.event.NotificationTrigger")) : class$org$apache$slide$webdav$event$NotificationTrigger).getName();
    private static final String A_INCLUDE_EVENTS = "include-events";
    private static final String A_FILENAME = "filename";
    private static final String TCP_PROTOCOL = "http://";
    private static final String UDP_PROTOCOL = "httpu://";
    private static final String E_SUBSCRIPTIONS = "subscriptions";
    private static final String E_SUBSCRIPTION = "subscription";
    private static final String A_ID = "id";
    private static final String E_URI = "uri";
    private static final String E_DEPTH = "depth";
    private static final String E_NOTIFICATION_DELAY = "notification-delay";
    private static final String E_NOTIFICATION_TYPE = "notification-type";
    private static final String E_CALLBACK = "callback";
    private static final String E_SUBSCRIPTION_END = "subscription-end";
    protected static final Timer timer = new Timer();
    protected List subscribers = new ArrayList();
    protected int subscriberId = 0;
    protected boolean includeEvents = false;
    protected DatagramSocket socket;
    protected String filename = null;
    private static NotificationTrigger notificationTrigger = new NotificationTrigger();
    static /* synthetic */ Class class$org$apache$slide$webdav$event$NotificationTrigger;

    private NotificationTrigger() {
        Domain.log((Object)"Creating notification trigger", (String)LOG_CHANNEL, (int)6);
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException exception) {
            Domain.log((Object)"Server socket creation failed, no UDP notifications available", (String)LOG_CHANNEL, (int)2);
            this.socket = null;
        }
    }

    public static NotificationTrigger getInstance() {
        return notificationTrigger;
    }

    public int addSubscriber(Subscriber subscriber) {
        Domain.log((Object)"Adding subscriber", (String)LOG_CHANNEL, (int)6);
        ++this.subscriberId;
        subscriber.setId(this.subscriberId);
        this.subscribers.add(subscriber);
        this.refreshSubscriber(subscriber, true);
        return this.subscriberId;
    }

    public boolean removeSubscriber(Subscriber subscriber) {
        Domain.log((Object)("Removing subscriber with ID: " + subscriber.getId()), (String)LOG_CHANNEL, (int)6);
        subscriber.getLifetime().cancel();
        this.saveSubscribers();
        return this.subscribers.remove(subscriber);
    }

    public void refreshSubscriber(final Subscriber subscriber, boolean persist) {
        TimerTask lifetimeTask = subscriber.getLifetime();
        if (lifetimeTask != null) {
            lifetimeTask.cancel();
        }
        if (subscriber.getSubscriptionLifetime() > 0) {
            Domain.log((Object)("Refreshing subscriber with ID: " + subscriber.getId()), (String)LOG_CHANNEL, (int)6);
            TimerTask lifetime = new TimerTask(){

                public void run() {
                    Domain.log((Object)("Removing subscriber with ID: " + subscriber.getId()), (String)LOG_CHANNEL, (int)6);
                    NotificationTrigger.this.refreshSubscriber(subscriber, true);
                }
            };
            subscriber.setLifetime(lifetime);
            timer.schedule(lifetime, subscriber.getSubscriptionLifetime() * 1000);
        }
        if (persist) {
            this.saveSubscribers();
        }
    }

    public List getSubscribers() {
        return this.subscribers;
    }

    public Subscriber getSubscriber(int id) {
        Iterator i = this.subscribers.iterator();
        while (i.hasNext()) {
            Subscriber subsciber = (Subscriber)i.next();
            if (subsciber.getId() != id) continue;
            return subsciber;
        }
        return null;
    }

    public void vetoableCollected(EventCollection collection) throws VetoException {
    }

    public void collected(EventCollection collection) {
        this.notifySubscribers(collection);
    }

    private void notifySubscribers(EventCollection collection) {
        HashMap subscriberEnumerations = new HashMap();
        ArrayList matchingSubscribers = new ArrayList();
        ContentEvent[] update = EventCollectionFilter.getChangedContents((EventCollection)collection);
        for (int i = 0; i < update.length; ++i) {
            matchingSubscribers.addAll(this.getSubscribers("Update", (ResourceEvent)update[i]));
        }
        ContentEvent[] create = EventCollectionFilter.getCreatedContents((EventCollection)collection);
        for (int i = 0; i < create.length; ++i) {
            matchingSubscribers.addAll(this.getSubscribers("Update/newmember", (ResourceEvent)create[i]));
        }
        ContentEvent[] delete = EventCollectionFilter.getRemovedContents((EventCollection)collection);
        for (int i = 0; i < delete.length; ++i) {
            matchingSubscribers.addAll(this.getSubscribers("Delete", (ResourceEvent)delete[i]));
        }
        Iterator<Object> i = matchingSubscribers.iterator();
        while (i.hasNext()) {
            final Subscriber subscriber = (Subscriber)i.next();
            if (!subscriber.hasCallback()) continue;
            if (subscriber.getNotificationDelay() == 0) {
                Integer subscriberId;
                ArrayList<Integer> idList = (ArrayList<Integer>)subscriberEnumerations.get(subscriber.getCallback());
                if (idList == null) {
                    idList = new ArrayList<Integer>();
                    subscriberEnumerations.put(subscriber.getCallback(), idList);
                }
                if (idList.contains(subscriberId = new Integer(subscriber.getId()))) continue;
                idList.add(subscriberId);
                continue;
            }
            TimerTask notifyTask = subscriber.getNotify();
            if (notifyTask != null) continue;
            Domain.log((Object)("Starting notification delay: " + subscriber.getNotificationDelay()), (String)LOG_CHANNEL, (int)6);
            notifyTask = new TimerTask(){

                public void run() {
                    NotificationTrigger.this.notifySubscriber(subscriber.getCallback(), String.valueOf(subscriber.getId()));
                    subscriber.setNotify(null);
                }
            };
            subscriber.setNotify(notifyTask);
            timer.schedule(notifyTask, subscriber.getNotificationDelay() * 1000);
        }
        i = subscriberEnumerations.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            String callBack = (String)entry.getKey();
            List idList = (List)entry.getValue();
            StringBuffer subscriberBuffer = new StringBuffer(128);
            boolean firstSubscriber = true;
            Iterator j = idList.iterator();
            while (j.hasNext()) {
                Integer id = (Integer)j.next();
                if (!firstSubscriber) {
                    subscriberBuffer.append(", ");
                }
                firstSubscriber = false;
                subscriberBuffer.append(id);
            }
            if (firstSubscriber) continue;
            this.notifySubscriber(callBack, subscriberBuffer.toString());
        }
    }

    protected void notifySubscriber(String callback, String subscribers) {
        if (callback.startsWith(TCP_PROTOCOL)) {
            Domain.log((Object)("Notify subscribers with adress='" + callback + "' via TCP with id's " + subscribers), (String)LOG_CHANNEL, (int)6);
            NotifyMethod notifyMethod = new NotifyMethod(callback.toString());
            notifyMethod.addRequestHeader("Subscription-id", subscribers);
            try {
                URL url = new URL(callback);
                notifyMethod.execute(new HttpState(), new HttpConnection(url.getHost(), url.getPort() != -1 ? url.getPort() : 80));
            }
            catch (IOException e) {
                Domain.log((Object)("Notification of subscriber '" + callback.toString() + "' failed!"));
            }
        } else if (callback.startsWith(UDP_PROTOCOL) && this.socket != null) {
            Domain.log((Object)("Notify subscribers with adress='" + callback + "' via UDP with id's " + subscribers + "\n"), (String)LOG_CHANNEL, (int)6);
            try {
                URL url = new URL(TCP_PROTOCOL + callback.substring(UDP_PROTOCOL.length()));
                String notification = "NOTIFY " + callback + " HTTP/1.1\nSubscription-id: " + subscribers;
                byte[] buf = notification.getBytes();
                InetAddress address = InetAddress.getByName(url.getHost());
                DatagramPacket packet = new DatagramPacket(buf, buf.length, address, url.getPort() != -1 ? url.getPort() : 80);
                this.socket.send(packet);
            }
            catch (IOException e) {
                Domain.log((Object)("Notification of subscriber '" + callback.toString() + "' failed!"), (String)LOG_CHANNEL, (int)2);
            }
        }
    }

    private List getSubscribers(String type, ResourceEvent event) {
        ArrayList<Subscriber> matchingSubscribers = new ArrayList<Subscriber>();
        Iterator i = this.subscribers.iterator();
        while (i.hasNext()) {
            Subscriber subscriber = (Subscriber)i.next();
            if (!subscriber.matches(type, event)) continue;
            matchingSubscribers.add(subscriber);
            subscriber.addEvent(event);
        }
        return matchingSubscribers;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration notification = configuration.getConfiguration("notification");
        this.includeEvents = notification.getAttributeAsBoolean(A_INCLUDE_EVENTS, false);
        Configuration persistSubscriptions = configuration.getConfiguration("persist-subscriptions");
        if (persistSubscriptions != null) {
            this.filename = persistSubscriptions.getAttribute(A_FILENAME);
        }
        this.loadSubscribers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSubscribers() {
        if (this.filename != null) {
            List list = this.subscribers;
            synchronized (list) {
                File file = new File(this.filename);
                if (file.exists()) {
                    try {
                        FileInputStream inputStream = new FileInputStream(this.filename);
                        SimpleImporter importer = new SimpleImporter();
                        importer.addSimpleImportHandler((SimpleImportHandler)new DefaultSimpleImportHandler(){
                            String callback;
                            String notificationType;
                            String uri;
                            int depth;
                            int notificationDelay;
                            int subscriptionLifetime;
                            int id;
                            List events = new ArrayList();

                            public void startElement(SimplePath path, String name, AttributesImpl attributes, String leadingCDdata) {
                                if (path.matches(NotificationTrigger.E_SUBSCRIPTION)) {
                                    this.id = ConversionHelpers.getInt((String)attributes.getValue(NotificationTrigger.A_ID));
                                } else if (path.matches(NotificationTrigger.E_URI)) {
                                    this.uri = leadingCDdata;
                                } else if (path.matches(NotificationTrigger.E_DEPTH)) {
                                    this.depth = Integer.valueOf(leadingCDdata);
                                } else if (path.matches(NotificationTrigger.E_CALLBACK)) {
                                    this.callback = leadingCDdata;
                                } else if (path.matches(NotificationTrigger.E_NOTIFICATION_DELAY)) {
                                    this.notificationDelay = Integer.valueOf(leadingCDdata);
                                } else if (path.matches(NotificationTrigger.E_NOTIFICATION_TYPE)) {
                                    this.notificationType = leadingCDdata;
                                } else if (path.matches(NotificationTrigger.E_SUBSCRIPTION_END)) {
                                    this.subscriptionLifetime = (int)(Long.valueOf(leadingCDdata) - System.currentTimeMillis());
                                }
                            }

                            public void endElement(SimplePath path, String name) {
                                if (path.matches(NotificationTrigger.E_SUBSCRIPTION)) {
                                    Subscriber subscriber = new Subscriber(this.uri, this.callback, this.notificationType, this.notificationDelay, this.subscriptionLifetime, this.depth);
                                    NotificationTrigger.this.subscribers.add(subscriber);
                                    NotificationTrigger.this.refreshSubscriber(subscriber, false);
                                }
                            }
                        });
                        importer.parse(new InputSource(inputStream));
                    }
                    catch (Exception e) {
                        Domain.log((Object)"Exception while restoring subscriptions. Skipping...");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSubscribers() {
        if (this.filename != null) {
            List list = this.subscribers;
            synchronized (list) {
                try {
                    FileOutputStream outputStream = new FileOutputStream(this.filename);
                    XMLOutputStreamWriter writer = new XMLOutputStreamWriter((OutputStream)outputStream);
                    writer.writeXMLDeclaration();
                    writer.writeStartTag(XMLWriter.createStartTag((String)E_SUBSCRIPTIONS));
                    Iterator i = this.subscribers.iterator();
                    while (i.hasNext()) {
                        Subscriber subscriber = (Subscriber)i.next();
                        writer.writeStartTag(XMLWriter.createStartTag((String)E_SUBSCRIPTION, (String[][])new String[][]{{A_ID, String.valueOf(subscriber.getId())}}));
                        writer.writeElementWithPCData(XMLWriter.createStartTag((String)E_URI), XMLEncode.xmlEncodeText((String)subscriber.getUri()), XMLWriter.createEndTag((String)E_URI));
                        writer.writeElementWithPCData(XMLWriter.createStartTag((String)E_DEPTH), String.valueOf(subscriber.getDepth()), XMLWriter.createEndTag((String)E_DEPTH));
                        writer.writeElementWithPCData(XMLWriter.createStartTag((String)E_CALLBACK), XMLEncode.xmlEncodeText((String)subscriber.getCallback()), XMLWriter.createEndTag((String)E_CALLBACK));
                        writer.writeElementWithPCData(XMLWriter.createStartTag((String)E_NOTIFICATION_TYPE), XMLEncode.xmlEncodeText((String)subscriber.getNotificationType()), XMLWriter.createEndTag((String)E_NOTIFICATION_TYPE));
                        writer.writeElementWithPCData(XMLWriter.createStartTag((String)E_NOTIFICATION_DELAY), String.valueOf(subscriber.getNotificationDelay()), XMLWriter.createEndTag((String)E_NOTIFICATION_DELAY));
                        writer.writeElementWithPCData(XMLWriter.createStartTag((String)E_SUBSCRIPTION_END), String.valueOf(subscriber.getSubscriptionEnd()), XMLWriter.createEndTag((String)E_SUBSCRIPTION_END));
                        writer.writeEndTag(XMLWriter.createEndTag((String)E_SUBSCRIPTION));
                    }
                    writer.writeEndTag(XMLWriter.createEndTag((String)E_SUBSCRIPTIONS));
                    outputStream.close();
                }
                catch (Exception e) {
                    Domain.log((Object)e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

