/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav;

import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.slide.authenticate.SecurityToken;
import org.apache.slide.common.Domain;
import org.apache.slide.common.DomainInitializationFailedError;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.SlideTokenWrapper;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavMethod;
import org.apache.slide.webdav.WebdavMethodFactory;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.util.DirectoryIndexGenerator;
import org.apache.slide.webdav.util.WebdavUtils;

public class WebdavServlet
extends HttpServlet {
    private static final String LOG_CHANNEL = (class$org$apache$slide$webdav$WebdavServlet == null ? (class$org$apache$slide$webdav$WebdavServlet = WebdavServlet.class$("org.apache.slide.webdav.WebdavServlet")) : class$org$apache$slide$webdav$WebdavServlet).getName();
    public static final String ATTRIBUTE_NAME = "org.apache.slide.NamespaceAccessToken";
    protected NamespaceAccessToken token;
    protected boolean directoryBrowsing = true;
    protected RequestDispatcher directoryBrowsingTemplate;
    protected DirectoryIndexGenerator directoryIndexGenerator;
    protected boolean handleLifecycle = true;
    protected WebdavMethodFactory methodFactory;
    static /* synthetic */ Class class$org$apache$slide$webdav$WebdavServlet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SimpleDateFormat sdf = new SimpleDateFormat();
        if (this.token.getLogger().isEnabled(LOG_CHANNEL, 7)) {
            this.token.getLogger().log((Object)("==> " + req.getMethod() + " start: " + sdf.format(new Date(System.currentTimeMillis())) + " [" + Thread.currentThread().getName() + "]"), LOG_CHANNEL, 7);
        }
        req.setAttribute("slide_uri", (Object)WebdavUtils.getRelativePath(req, (WebdavServletConfig)this.getServletConfig()));
        try {
            try {
                if (this.token == null) {
                    String namespaceName = req.getContextPath();
                    if (namespaceName == null || namespaceName.equals("")) {
                        namespaceName = Domain.getDefaultNamespace();
                    }
                    while (namespaceName.startsWith("/")) {
                        namespaceName = namespaceName.substring(1);
                    }
                    this.token = Domain.accessNamespace((SecurityToken)new SecurityToken((Object)this), (String)namespaceName);
                }
                resp.setStatus(200);
                String methodName = req.getMethod();
                WebdavMethod method = this.methodFactory.createMethod(methodName);
                if (method == null) {
                    throw new WebdavException(405);
                }
                method.run(req, resp);
            }
            catch (WebdavException e) {
                this.token.getLogger().log((Object)e, LOG_CHANNEL, 2);
                try {
                    resp.sendError(e.getStatusCode());
                }
                catch (Throwable ex) {
                }
                Object var7_11 = null;
                if (!this.token.getLogger().isEnabled(LOG_CHANNEL, 7)) return;
                this.token.getLogger().log((Object)("<== " + req.getMethod() + " end: " + sdf.format(new Date(System.currentTimeMillis())) + " [" + Thread.currentThread().getName() + "]"), LOG_CHANNEL, 7);
                return;
            }
            catch (Throwable e) {
                this.token.getLogger().log((Object)e, LOG_CHANNEL, 2);
                try {
                    resp.sendError(500);
                }
                catch (Throwable ex) {
                }
                Object var7_12 = null;
                if (!this.token.getLogger().isEnabled(LOG_CHANNEL, 7)) return;
                this.token.getLogger().log((Object)("<== " + req.getMethod() + " end: " + sdf.format(new Date(System.currentTimeMillis())) + " [" + Thread.currentThread().getName() + "]"), LOG_CHANNEL, 7);
                return;
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            if (!this.token.getLogger().isEnabled(LOG_CHANNEL, 7)) throw throwable;
            this.token.getLogger().log((Object)("<== " + req.getMethod() + " end: " + sdf.format(new Date(System.currentTimeMillis())) + " [" + Thread.currentThread().getName() + "]"), LOG_CHANNEL, 7);
            throw throwable;
        }
        if (!this.token.getLogger().isEnabled(LOG_CHANNEL, 7)) return;
        this.token.getLogger().log((Object)("<== " + req.getMethod() + " end: " + sdf.format(new Date(System.currentTimeMillis())) + " [" + Thread.currentThread().getName() + "]"), LOG_CHANNEL, 7);
    }

    private boolean isExtTx(HttpServletRequest req) {
        String hTxIdStr = req.getHeader("Transaction");
        return hTxIdStr != null;
    }

    private boolean isCollection(HttpServletRequest req) {
        SlideTokenWrapper slideToken = new SlideTokenWrapper(WebdavUtils.getSlideToken(req));
        slideToken.setForceStoreEnlistment(false);
        slideToken.setForceSecurity(false);
        slideToken.setForceLock(false);
        return WebdavUtils.isCollection(this.token, (SlideToken)slideToken, WebdavUtils.getRelativePath(req, (WebdavServletConfig)this.getServletConfig()));
    }

    public void init(ServletConfig config) throws ServletException {
        super.init((ServletConfig)new WebdavServletConfig(config));
    }

    public void init() throws ServletException {
        if (!WebdavServlet.isDomLevel2Parser()) {
            System.out.println("======================================================");
            System.out.println("!!! Unable to start Slide Servlet !!!");
            System.out.println("------------------------------------------------------");
            System.out.println("You are using using an incorrect older XML parser");
            System.out.println("that doesn't provide Element::getElementsByTagNameNS");
            System.out.println("consult the documentation for a list of valid XML parsers.");
            System.out.println("======================================================");
            this.log("======================================================");
            this.log("!!! Unable to start Slide Servlet !!!");
            this.log("------------------------------------------------------");
            this.log("======================================================");
            this.log("You are using using an incorrect older XML parser");
            this.log("that doesn't provide Element::getElementsByTagNameNS");
            this.log("consult the documentation for a list of valid XML parsers.");
            this.log("======================================================");
            throw new ServletException("Invalid XML parser");
        }
        String value = null;
        this.token = (NamespaceAccessToken)this.getServletContext().getAttribute(ATTRIBUTE_NAME);
        if (this.token == null) {
            String namespaceName = null;
            String domainConfigFile = null;
            value = this.getInitParameter("namespace");
            if (value != null) {
                namespaceName = value;
            }
            if ((value = this.getInitParameter("domain")) != null) {
                domainConfigFile = value;
            }
            try {
                URL domainConfigFileURL;
                if (domainConfigFile != null && (domainConfigFileURL = this.getServletContext().getResource(domainConfigFile)) != null) {
                    Domain.init((URL)domainConfigFileURL);
                }
                if (namespaceName == null) {
                    namespaceName = Domain.getDefaultNamespace();
                    this.log("No namespace specified, will use default namespace: " + namespaceName);
                }
                this.token = Domain.accessNamespace((SecurityToken)new SecurityToken((Object)this), (String)namespaceName);
                if (this.token == null) {
                    this.log("Could not access namespace " + namespaceName + ".");
                    throw new UnavailableException("Namespace " + namespaceName + " not accessible");
                }
                this.getServletContext().setAttribute(ATTRIBUTE_NAME, (Object)this.token);
            }
            catch (DomainInitializationFailedError e) {
                this.log("Could not initialize domain", e);
                throw new UnavailableException(e.toString());
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new ServletException(t.toString());
            }
        } else {
            this.handleLifecycle = false;
        }
        this.methodFactory = WebdavMethodFactory.newInstance((WebdavServletConfig)this.getServletConfig());
    }

    public void destroy() {
        if (this.handleLifecycle && this.token != null) {
            Domain.closeNamespace((NamespaceAccessToken)this.token);
        }
    }

    static boolean isDomLevel2Parser() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation().hasFeature("Core", "2.0");
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        catch (FactoryConfigurationError e) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

