/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.locking.LockStrategy;
import org.apache.ojb.odmg.locking.ReadCommittedStrategy;
import org.apache.ojb.odmg.locking.ReadUncommittedStrategy;
import org.apache.ojb.odmg.locking.RepeatableReadStrategy;
import org.apache.ojb.odmg.locking.SerializableStrategy;

public class LockStrategyFactory {
    private static LockStrategy readUncommitedStrategy = new ReadUncommittedStrategy();
    private static LockStrategy readCommitedStrategy = new ReadCommittedStrategy();
    private static LockStrategy readRepeatableStrategy = new RepeatableReadStrategy();
    private static LockStrategy serializableStrategy = new SerializableStrategy();
    private static LockStrategy noopStrategy = new NOOPStrategy();

    private LockStrategyFactory() {
    }

    public static LockStrategy getStrategyFor(Object obj) {
        int isolationLevel = LockStrategyFactory.getIsolationLevel(obj);
        switch (isolationLevel) {
            case 2: {
                return readUncommitedStrategy;
            }
            case 3: {
                return readCommitedStrategy;
            }
            case 5: {
                return readRepeatableStrategy;
            }
            case 7: {
                return serializableStrategy;
            }
            case 4: {
                return noopStrategy;
            }
            case -1: {
                return noopStrategy;
            }
        }
        return readUncommitedStrategy;
    }

    public static int getIsolationLevel(Object obj) {
        Class c = ProxyHelper.getRealClass(obj);
        int isolationLevel = 2;
        try {
            ClassDescriptor cld = TxManagerFactory.instance().getCurrentTransaction().getBroker().getClassDescriptor(c);
            isolationLevel = cld.getIsolationLevel();
        }
        catch (PersistenceBrokerException e) {
            LoggerFactory.getDefaultLogger().error("[LockStrategyFactory] Can't detect locking isolation level", (Throwable)((Object)e));
        }
        return isolationLevel;
    }

    static class NOOPStrategy
    implements LockStrategy {
        NOOPStrategy() {
        }

        public boolean readLock(TransactionImpl tx, Object obj) {
            return true;
        }

        public boolean writeLock(TransactionImpl tx, Object obj) {
            return true;
        }

        public boolean upgradeLock(TransactionImpl tx, Object obj) {
            return true;
        }

        public boolean releaseLock(TransactionImpl tx, Object obj) {
            return false;
        }

        public boolean checkRead(TransactionImpl tx, Object obj) {
            return false;
        }

        public boolean checkWrite(TransactionImpl tx, Object obj) {
            return false;
        }
    }
}

