/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.locking.AbstractLockStrategy;
import org.apache.ojb.odmg.locking.LockEntry;
import org.apache.ojb.odmg.locking.LockMap;
import org.apache.ojb.odmg.locking.LockStrategyFactory;
import org.apache.ojb.odmg.locking.ObjectLocks;

public class InMemoryLockMapImpl
implements LockMap {
    private HashMap locktable = new HashMap();
    private long m_lastCleanupAt = System.currentTimeMillis();
    private static long CLEANUP_FREQUENCY = 500L;
    private static int MAX_LOCKS_TO_CLEAN = 50;

    public LockEntry getWriter(Object obj) {
        PersistenceBroker broker = this.getBroker();
        Identity oid = new Identity(obj, broker);
        return this.getWriter(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockEntry getWriter(Identity oid) {
        this.checkTimedOutLocks();
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(oid.toString());
        }
        if (objectLocks == null) {
            return null;
        }
        return objectLocks.getWriter();
    }

    private PersistenceBroker getBroker() {
        return TxManagerFactory.instance().getCurrentTransaction().getBroker();
    }

    public Collection getReaders(Object obj) {
        this.checkTimedOutLocks();
        Identity oid = new Identity(obj, this.getBroker());
        return this.getReaders(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getReaders(Identity oid) {
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(oid.toString());
        }
        if (objectLocks == null) {
            return new Vector();
        }
        return objectLocks.getReaders().values();
    }

    public boolean addReader(TransactionImpl tx, Object obj) {
        this.checkTimedOutLocks();
        Identity oid = new Identity(obj, this.getBroker());
        LockEntry reader = new LockEntry(oid.toString(), tx.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(obj), LockEntry.LOCK_READ);
        this.addReaderInternal(reader);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReaderInternal(LockEntry reader) {
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            String oidString = reader.getOidString();
            objectLocks = (ObjectLocks)this.locktable.get(oidString);
            if (objectLocks == null) {
                objectLocks = new ObjectLocks();
                this.locktable.put(oidString, objectLocks);
            }
        }
        objectLocks.addReader(reader);
    }

    public void removeReader(TransactionImpl tx, Object obj) {
        this.checkTimedOutLocks();
        Identity oid = new Identity(obj, this.getBroker());
        String oidString = oid.toString();
        String txGuid = tx.getGUID();
        this.removeReaderInternal(oidString, txGuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReaderInternal(String oidString, String txGuid) {
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(oidString);
        }
        if (objectLocks == null) {
            return;
        }
        hashMap = this.locktable;
        synchronized (hashMap) {
            Hashtable readers = objectLocks.getReaders();
            readers.remove(txGuid);
            if (objectLocks.getWriter() == null && readers.size() == 0) {
                this.locktable.remove(oidString);
            }
        }
    }

    void removeReaderByLock(LockEntry lock) {
        String oidString = lock.getOidString();
        String txGuid = lock.getTransactionId();
        this.removeReaderInternal(oidString, txGuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriter(LockEntry writer) {
        this.checkTimedOutLocks();
        String oidString = writer.getOidString();
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(oidString);
        }
        if (objectLocks == null) {
            return;
        }
        hashMap = this.locktable;
        synchronized (hashMap) {
            Hashtable readers = objectLocks.getReaders();
            objectLocks.setWriter(null);
            if (readers.size() == 0) {
                this.locktable.remove(oidString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upgradeLock(LockEntry reader) {
        this.checkTimedOutLocks();
        String oidString = reader.getOidString();
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(oidString);
        }
        if (objectLocks == null) {
            return false;
        }
        LockEntry writer = new LockEntry(reader.getOidString(), reader.getTransactionId(), System.currentTimeMillis(), reader.getIsolationLevel(), LockEntry.LOCK_WRITE);
        objectLocks.setWriter(writer);
        objectLocks.getReaders().remove(reader.getTransactionId());
        return true;
    }

    public boolean setWriter(TransactionImpl tx, Object obj) {
        this.checkTimedOutLocks();
        Identity oid = new Identity(obj, tx.getBroker());
        LockEntry writer = new LockEntry(oid.toString(), tx.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(obj), LockEntry.LOCK_WRITE);
        String oidString = oid.toString();
        this.setWriterInternal(writer, oidString);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWriterInternal(LockEntry writer, String oidString) {
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(oidString);
            if (objectLocks == null) {
                objectLocks = new ObjectLocks();
                this.locktable.put(oidString, objectLocks);
            }
        }
        objectLocks.setWriter(writer);
    }

    void setWriterByLock(LockEntry writer) {
        String oidString = writer.getOidString();
        this.setWriterInternal(writer, oidString);
    }

    public boolean hasReadLock(TransactionImpl tx, Object obj) {
        this.checkTimedOutLocks();
        Identity oid = new Identity(obj, this.getBroker());
        String oidString = oid.toString();
        String txGuid = tx.getGUID();
        return this.hasReadLockInternal(oidString, txGuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasReadLockInternal(String oidString, String txGuid) {
        ObjectLocks objectLocks = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            objectLocks = (ObjectLocks)this.locktable.get(oidString);
        }
        if (objectLocks == null) {
            return false;
        }
        LockEntry reader = objectLocks.getReader(txGuid);
        return reader != null;
    }

    boolean hasReadLock(LockEntry entry) {
        String oidString = entry.getOidString();
        String txGuid = entry.getTransactionId();
        return this.hasReadLockInternal(oidString, txGuid);
    }

    private void checkTimedOutLocks() {
        if (System.currentTimeMillis() - this.m_lastCleanupAt > CLEANUP_FREQUENCY) {
            this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
            this.m_lastCleanupAt = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTimedOutLocks(long timeout) {
        long maxAge = System.currentTimeMillis() - timeout;
        boolean breakFromLoop = false;
        ObjectLocks temp = null;
        HashMap hashMap = this.locktable;
        synchronized (hashMap) {
            Iterator it = this.locktable.values().iterator();
            for (int count = 0; it.hasNext() && !breakFromLoop && count <= MAX_LOCKS_TO_CLEAN; ++count) {
                temp = (ObjectLocks)it.next();
                if (temp.getWriter() != null && temp.getWriter().getTimestamp() < maxAge) {
                    temp.setWriter(null);
                }
                if (temp.getYoungestReader() < maxAge) {
                    temp.getReaders().clear();
                    if (temp.getWriter() != null) continue;
                    it.remove();
                    continue;
                }
                Iterator readerIt = temp.getReaders().values().iterator();
                LockEntry readerLock = null;
                while (readerIt.hasNext()) {
                    readerLock = (LockEntry)readerIt.next();
                    if (readerLock.getTimestamp() >= maxAge) continue;
                    readerIt.remove();
                }
            }
        }
    }

    public void configure(Configuration pConfig) throws ConfigurationException {
    }

    int getSize() {
        return this.locktable.size();
    }
}

