/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.collections.ManageableHashSet;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DMapEntry;
import org.odmg.DMap;

public class DMapImpl
extends AbstractMap
implements DMap,
Serializable,
PersistenceBrokerAware {
    private static final long serialVersionUID = 7048246616243056480L;
    private transient Logger log;
    private Integer id;
    private Set entries = new ManageableHashSet();
    private PBKey pbKey;
    static /* synthetic */ Class class$org$apache$ojb$odmg$collections$DMapImpl;

    public DMapImpl() {
        this.getPBKey();
    }

    public DMapImpl(PBKey key) {
        this.pbKey = key;
    }

    protected Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$collections$DMapImpl == null ? (class$org$apache$ojb$odmg$collections$DMapImpl = DMapImpl.class$("org.apache.ojb.odmg.collections.DMapImpl")) : class$org$apache$ojb$odmg$collections$DMapImpl);
        }
        return this.log;
    }

    protected TransactionImpl getTransaction() {
        return TxManagerFactory.instance().getTransaction();
    }

    public PBKey getPBKey() {
        TransactionImpl tx;
        if (this.pbKey == null && (tx = this.getTransaction()) != null && tx.isOpen()) {
            this.pbKey = tx.getBroker().getPBKey();
        }
        return this.pbKey;
    }

    public void setPBKey(PBKey pbKey) {
        this.pbKey = pbKey;
    }

    protected DMapEntry prepareEntry(Object key, Object value) {
        return new DMapEntry(this, key, value);
    }

    public Set entrySet() {
        return this.entries;
    }

    public Integer getId() {
        return this.id;
    }

    public Object put(Object key, Object value) {
        DMapEntry entry = this.prepareEntry(key, value);
        boolean ok = this.entries.add(entry);
        if (ok) {
            TransactionImpl tx = this.getTransaction();
            if (tx != null && tx.isOpen()) {
                ArrayList regList = tx.getRegistrationList();
                RuntimeObject rt = new RuntimeObject(this, tx);
                tx.lockAndRegister(rt, 4, false, regList);
                rt = new RuntimeObject(key, tx);
                tx.lockAndRegister(rt, 1, regList);
                rt = new RuntimeObject(value, tx);
                tx.lockAndRegister(rt, 1, regList);
                rt = new RuntimeObject(entry, tx, true);
                tx.lockAndRegister(rt, 4, false, regList);
            }
            return null;
        }
        return this.get(key);
    }

    public Object remove(Object key) {
        DMapEntry e;
        Iterator i = this.entrySet().iterator();
        DMapEntry correctEntry = null;
        if (key == null) {
            while (correctEntry == null && i.hasNext()) {
                e = (DMapEntry)i.next();
                if (e.getKey() != null) continue;
                correctEntry = e;
            }
        } else {
            while (correctEntry == null && i.hasNext()) {
                e = (DMapEntry)i.next();
                if (!key.equals(e.getKey())) continue;
                correctEntry = e;
            }
        }
        Object oldValue = null;
        if (correctEntry != null) {
            oldValue = correctEntry.getValue();
            i.remove();
            TransactionImpl tx = this.getTransaction();
            if (tx != null && tx.isOpen()) {
                tx.deletePersistent(new RuntimeObject(correctEntry, tx));
            }
        }
        return oldValue;
    }

    public Set getEntries() {
        return this.entries;
    }

    public void setEntries(ManageableHashSet entries) {
        this.entries = entries;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void beforeInsert(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void beforeUpdate(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void beforeDelete(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterUpdate(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterInsert(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterDelete(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    public void afterLookup(PersistenceBroker broker) throws PersistenceBrokerException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

