/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryFactory;
import org.apache.ojb.broker.core.proxy.CollectionProxy;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.MaterializationListener;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.GUID;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.DatabaseImpl;
import org.apache.ojb.odmg.ImplementationImpl;
import org.apache.ojb.odmg.NamedRootsMap;
import org.apache.ojb.odmg.ObjectEnvelope;
import org.apache.ojb.odmg.ObjectEnvelopeTable;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionAbortedExceptionOJB;
import org.apache.ojb.odmg.TransactionExt;
import org.apache.ojb.odmg.TxUtil;
import org.apache.ojb.odmg.locking.LockManager;
import org.odmg.ClassNotPersistenceCapableException;
import org.odmg.DatabaseClosedException;
import org.odmg.LockNotGrantedException;
import org.odmg.ODMGRuntimeException;
import org.odmg.Transaction;
import org.odmg.TransactionAbortedException;
import org.odmg.TransactionInProgressException;
import org.odmg.TransactionNotInProgressException;

public class TransactionImpl
implements Transaction,
MaterializationListener,
Configurable,
CollectionProxyListener,
TransactionExt {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$TransactionImpl == null ? (class$org$apache$ojb$odmg$TransactionImpl = TransactionImpl.class$("org.apache.ojb.odmg.TransactionImpl")) : class$org$apache$ojb$odmg$TransactionImpl);
    private boolean impliciteWriteLocks;
    private boolean implicitLocking;
    private boolean ordering;
    private String txGUID;
    protected PersistenceBrokerInternal broker = null;
    private ArrayList registrationList = new ArrayList();
    private ImplementationImpl implementation;
    private NamedRootsMap namedRootsMap;
    private int txStatus = 6;
    protected ObjectEnvelopeTable objectEnvelopeTable = null;
    private DatabaseImpl curDB;
    private ArrayList registeredIndirectionHandlers = new ArrayList();
    private ArrayList registeredCollectionProxies = new ArrayList();
    private ArrayList unmaterializedLocks = new ArrayList();
    private HashMap runtimeCascadeDeleteMap = new HashMap();
    static /* synthetic */ Class class$org$apache$ojb$odmg$TransactionImpl;

    public TransactionImpl(ImplementationImpl implementation) {
        this.implementation = implementation;
        this.impliciteWriteLocks = implementation.isImpliciteWriteLocks();
        this.implicitLocking = implementation.isImplicitLocking();
        this.ordering = implementation.isOrdering();
        this.txGUID = new GUID().toString();
        this.curDB = implementation.getCurrentDatabase();
        this.namedRootsMap = new NamedRootsMap(this);
    }

    public ImplementationImpl getImplementation() {
        return this.implementation;
    }

    public NamedRootsMap getNamedRootsMap() {
        return this.namedRootsMap;
    }

    public DatabaseImpl getAssociatedDatabase() {
        return this.curDB;
    }

    protected int getStatus() {
        return this.txStatus;
    }

    protected void setStatus(int status) {
        this.txStatus = status;
    }

    private void checkForDB() {
        if (this.curDB == null || !this.curDB.isOpen()) {
            this.log.error("Transaction without a associated open Database.");
            throw new TransactionAbortedExceptionOJB("No open database found. Open the database before handling transactions");
        }
    }

    public boolean isOpen() {
        return this.getStatus() == 0 || this.getStatus() == 1 || this.getStatus() == 2 || this.getStatus() == 7 || this.getStatus() == 8;
    }

    private void checkOpen() {
        if (!this.isOpen()) {
            throw new TransactionNotInProgressException("Transaction was not open, call tx.begin() before perform action, current status is: " + TxUtil.getStatusString(this.getStatus()));
        }
    }

    public void join() {
        this.checkOpen();
        this.implementation.getTxManager().deregisterTx(this);
        this.implementation.getTxManager().registerTx(this);
    }

    public void lock(Object obj, int lockMode) throws LockNotGrantedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("lock object was called on tx " + this + ", object is " + obj.toString());
        }
        this.checkOpen();
        RuntimeObject rtObject = new RuntimeObject(obj, this);
        this.lockAndRegister(rtObject, lockMode, this.isImplicitLocking(), this.getRegistrationList());
    }

    public ArrayList getRegistrationList() {
        this.clearRegistrationList();
        return this.registrationList;
    }

    public void clearRegistrationList() {
        this.registrationList.clear();
    }

    public void lockAndRegister(RuntimeObject rtObject, int lockMode, List registeredObjects) {
        this.lockAndRegister(rtObject, lockMode, this.isImplicitLocking(), registeredObjects);
    }

    public synchronized void lockAndRegister(RuntimeObject rtObject, int lockMode, boolean cascade, List registeredObjects) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Lock and register called for " + rtObject.getIdentity());
        }
        if (!registeredObjects.contains(rtObject.getIdentity())) {
            if (cascade) {
                registeredObjects.add(rtObject.getIdentity());
                this.lockAndRegisterReferences(rtObject.getCld(), rtObject.getObjMaterialized(), lockMode, registeredObjects);
            }
            try {
                if (!rtObject.isNew()) {
                    this.doSingleLock(rtObject.getCld(), rtObject.getObj(), rtObject.getIdentity(), lockMode);
                }
                this.doSingleRegister(rtObject, lockMode);
            }
            catch (Throwable t) {
                this.implementation.getLockManager().releaseLock(this, rtObject.getIdentity(), rtObject.getObj());
                if (t instanceof LockNotGrantedException) {
                    throw (LockNotGrantedException)t;
                }
                this.log.error("Unexpected failure while locking", t);
                throw new LockNotGrantedException("Locking failed for " + rtObject.getIdentity() + ", nested exception is: [" + t.getClass().getName() + ": " + t.getMessage() + "]");
            }
            if (cascade) {
                this.lockAndRegisterCollections(rtObject.getCld(), rtObject.getObjMaterialized(), lockMode, registeredObjects);
            }
        }
    }

    void doSingleLock(ClassDescriptor cld, Object obj, Identity oid, int lockMode) throws LockNotGrantedException {
        LockManager lm = this.implementation.getLockManager();
        if (cld.isAcceptLocks()) {
            if (lockMode == 1) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Do READ lock on object: " + oid);
                }
                if (!lm.readLock(this, oid, obj)) {
                    throw new LockNotGrantedException("Can not lock for READ: " + oid);
                }
            } else if (lockMode == 4) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Do WRITE lock on object: " + oid);
                }
                if (!lm.writeLock(this, oid, obj)) {
                    throw new LockNotGrantedException("Can not lock for WRITE: " + oid);
                }
            } else if (lockMode == 2) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Do UPGRADE lock on object: " + oid);
                }
                if (!lm.upgradeLock(this, oid, obj)) {
                    throw new LockNotGrantedException("Can not lock for UPGRADE: " + oid);
                }
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Class '" + cld.getClassNameOfObject() + "' doesn't accept locks" + " (accept-locks=false) when implicite locked, so OJB skip this object: " + oid);
        }
    }

    public void leave() {
        this.checkOpen();
        this.implementation.getTxManager().deregisterTx(this);
    }

    protected synchronized void doWriteObjects(boolean isFlush) throws TransactionAbortedException, LockNotGrantedException {
        if (!this.getBroker().isInTransaction()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("call beginTransaction() on PB instance");
            }
            this.broker.beginTransaction();
        }
        this.performTransactionAwareBeforeCommit();
        this.objectEnvelopeTable.writeObjects(isFlush);
        this.namedRootsMap.performDeletion();
        this.namedRootsMap.performInsert();
        this.namedRootsMap.afterWriteCleanup();
    }

    protected synchronized void doAbort() {
        this.performTransactionAwareBeforeRollback();
        this.objectEnvelopeTable.rollback();
        this.performTransactionAwareAfterRollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doClose() {
        try {
            LockManager lm = this.getImplementation().getLockManager();
            Enumeration en = this.objectEnvelopeTable.elements();
            while (en.hasMoreElements()) {
                ObjectEnvelope oe = (ObjectEnvelope)en.nextElement();
                lm.releaseLock(this, oe.getIdentity(), oe.getObject());
            }
            Iterator it = this.unmaterializedLocks.iterator();
            while (it.hasNext()) {
                lm.releaseLock(this, it.next());
            }
            this.unRegisterFromAllIndirectionHandlers();
            this.unRegisterFromAllCollectionProxies();
            Object var5_4 = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Close Transaction and release current PB " + this.broker + " on tx " + this);
            }
            this.implementation.getTxManager().deregisterTx(this);
            this.refresh();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Close Transaction and release current PB " + this.broker + " on tx " + this);
            }
            this.implementation.getTxManager().deregisterTx(this);
            this.refresh();
            throw throwable;
        }
    }

    protected void refresh() {
        block3: {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Refresh this transaction for reuse: " + this);
            }
            try {
                this.objectEnvelopeTable.refresh();
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug("error closing object envelope table : " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.cleanupBroker();
        this.broker = null;
        this.clearRegistrationList();
        this.unmaterializedLocks.clear();
        this.txStatus = 6;
    }

    public void checkpoint() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checkpoint was called, commit changes hold locks on tx " + this);
        }
        try {
            this.checkOpen();
            this.doWriteObjects(true);
            if (this.hasBroker() && this.broker.isInTransaction()) {
                this.broker.commitTransaction();
            }
        }
        catch (Throwable t) {
            this.log.error("Checkpoint call failed, do abort transaction", t);
            this.txStatus = 1;
            this.abort();
            if (!(t instanceof ODMGRuntimeException)) {
                throw new TransactionAbortedExceptionOJB("Can't tx.checkpoint() objects: " + t.getMessage(), t);
            }
            throw (ODMGRuntimeException)t;
        }
    }

    public void flush() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Flush was called - write changes to database, do not commit, hold locks on tx " + this);
        }
        try {
            this.checkOpen();
            this.doWriteObjects(true);
        }
        catch (Throwable t) {
            this.log.error("Calling method 'tx.flush()' failed", t);
            this.txStatus = 1;
            this.abort();
            if (!(t instanceof ODMGRuntimeException)) {
                throw new TransactionAbortedExceptionOJB("Can't tx.flush() objects: " + t.getMessage(), t);
            }
            throw (ODMGRuntimeException)t;
        }
    }

    public void markDelete(Object anObject) {
        ObjectEnvelope otw = this.objectEnvelopeTable.get(anObject, false);
        otw.setModificationState(otw.getModificationState().markDelete());
    }

    public void deletePersistent(RuntimeObject rt) {
        if (rt.isProxy()) {
            Object realObj = rt.getHandler().getRealSubject();
            rt = new RuntimeObject(realObj, rt.getIdentity(), this, false);
        }
        this.lockAndRegister(rt, 4, this.getRegistrationList());
        ObjectEnvelope oe = this.objectEnvelopeTable.getByIdentity(rt.getIdentity());
        oe.refreshObjectIfNeeded(rt.getObj());
        oe.setModificationState(oe.getModificationState().markDelete());
    }

    public void markDirty(Object anObject) {
        ObjectEnvelope otw = this.objectEnvelopeTable.get(anObject, false);
        otw.refreshObjectIfNeeded(anObject);
        otw.setModificationState(otw.getModificationState().markDirty());
    }

    void markDirty(RuntimeObject rt) {
        ObjectEnvelope otw = this.objectEnvelopeTable.get(rt.getIdentity(), rt.getObj(), rt.isNew());
        otw.refreshObjectIfNeeded(rt.getObj());
        otw.setModificationState(otw.getModificationState().markDirty());
    }

    void markPersistent(RuntimeObject rtObj) {
        ObjectEnvelope oe = this.objectEnvelopeTable.getByIdentity(rtObj.getIdentity());
        if (oe == null) {
            oe = this.objectEnvelopeTable.get(rtObj.getIdentity(), rtObj.getObj(), rtObj.isNew());
        }
        if (oe.needsDelete()) {
            oe.setModificationState(oe.getModificationState().markNew());
        } else {
            oe.setModificationState(oe.getModificationState().markDirty());
        }
        oe.refreshObjectIfNeeded(rtObj.getObj());
    }

    void makePersistent(RuntimeObject rt) {
        try {
            this.lockAndRegister(rt, 4, this.getRegistrationList());
            this.markPersistent(rt);
        }
        catch (org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException ex) {
            this.log.error("Can't persist object: " + rt.getIdentity(), (Throwable)((Object)ex));
            throw new ClassNotPersistenceCapableException(ex.getMessage());
        }
    }

    public boolean isDeleted(Identity id) {
        ObjectEnvelope envelope = this.objectEnvelopeTable.getByIdentity(id);
        return envelope != null && envelope.needsDelete();
    }

    public boolean tryLock(Object obj, int lockMode) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Try to lock object was called on tx " + this);
        }
        this.checkOpen();
        try {
            this.lock(obj, lockMode);
            return true;
        }
        catch (LockNotGrantedException ex) {
            return false;
        }
    }

    public void commit() {
        this.checkOpen();
        try {
            this.prepareCommit();
            this.checkForCommit();
            this.txStatus = 8;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Commit transaction " + this);
            }
            if (this.hasBroker()) {
                this.getBroker().commitTransaction();
            }
            this.performTransactionAwareAfterCommit();
            this.doClose();
            this.txStatus = 3;
        }
        catch (Exception ex) {
            this.log.error("Error while commit objects, do abort tx " + this + ", " + ex.getMessage(), ex);
            this.txStatus = 1;
            this.abort();
            if (!(ex instanceof ODMGRuntimeException)) {
                throw new TransactionAbortedExceptionOJB("Can't commit objects: " + ex.getMessage(), ex);
            }
            throw (ODMGRuntimeException)ex;
        }
    }

    protected void checkForCommit() {
        if (this.txStatus == 1) {
            throw new TransactionAbortedExceptionOJB("Illegal tx-status: tx is already markedRollback");
        }
        if (this.txStatus != 2) {
            throw new IllegalStateException("Illegal tx-status: Do prepare commit before commit");
        }
    }

    protected void prepareCommit() throws TransactionAbortedException, LockNotGrantedException {
        if (this.txStatus == 1) {
            throw new TransactionAbortedExceptionOJB("Prepare Transaction: tx already marked for rollback");
        }
        if (this.txStatus != 0) {
            throw new IllegalStateException("Prepare Transaction: tx status is not 'active', status is " + TxUtil.getStatusString(this.txStatus));
        }
        try {
            this.txStatus = 7;
            this.doWriteObjects(false);
            this.txStatus = 2;
        }
        catch (RuntimeException e) {
            this.log.error("Could not prepare for commit", e);
            this.txStatus = 1;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        if (this.txStatus == 6 || this.txStatus == 5 || this.txStatus == 4) {
            this.log.info("Nothing to abort, tx is not active - status is " + TxUtil.getStatusString(this.txStatus));
            return;
        }
        if (this.txStatus != 0 && this.txStatus != 2 && this.txStatus != 1) {
            throw new IllegalStateException("Illegal state for abort call, state was '" + TxUtil.getStatusString(this.txStatus) + "'");
        }
        if (this.log.isEnabledFor(2)) {
            this.log.info("Abort transaction was called on tx " + this);
        }
        try {
            try {
                this.doAbort();
            }
            catch (Exception e) {
                this.log.error("Error while abort transaction, will be skipped", e);
            }
            this.implementation.getTxManager().abortExternalTx(this);
            try {
                if (this.hasBroker() && this.getBroker().isInTransaction()) {
                    this.getBroker().abortTransaction();
                }
            }
            catch (Exception e) {
                this.log.error("Error while do abort used broker instance, will be skipped", e);
            }
        }
        finally {
            this.txStatus = 4;
            this.doClose();
        }
    }

    public synchronized void begin() {
        this.checkForBegin();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Begin transaction was called on tx " + this);
        }
        this.objectEnvelopeTable = new ObjectEnvelopeTable(this);
        this.implementation.getTxManager().registerTx(this);
        this.txStatus = 0;
    }

    protected void checkForBegin() {
        if (this.curDB == null || !this.curDB.isOpen()) {
            throw new DatabaseClosedException("Database is not open. Must have an open DB to begin the Tx.");
        }
        if (this.isOpen()) {
            this.log.error("Transaction is already open");
            throw new TransactionInProgressException("Impossible to call begin on already opened tx");
        }
    }

    public String getGUID() {
        return this.txGUID;
    }

    public Object getObjectByIdentity(Identity id) throws PersistenceBrokerException {
        this.checkOpen();
        ObjectEnvelope envelope = this.objectEnvelopeTable.getByIdentity(id);
        if (envelope != null) {
            return envelope.needsDelete() ? null : envelope.getObject();
        }
        return this.getBroker().getObjectByIdentity(id);
    }

    void doSingleRegister(RuntimeObject rtObject, int lockMode) throws LockNotGrantedException, PersistenceBrokerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Register object " + rtObject.getIdentity());
        }
        Object objectToRegister = rtObject.getObj();
        if (rtObject.isProxy()) {
            IndirectionHandler handler = rtObject.getHandler();
            if (handler == null) {
                throw new OJBRuntimeException("Unexpected error, expect an proxy object as indicated: " + rtObject);
            }
            if (handler.alreadyMaterialized()) {
                objectToRegister = handler.getRealSubject();
            } else {
                this.registerToIndirectionHandler(handler);
                this.registerUnmaterializedLocks(rtObject.getObj());
                objectToRegister = null;
            }
        }
        if (objectToRegister != null) {
            ObjectEnvelope envelope = this.objectEnvelopeTable.getByIdentity(rtObject.getIdentity());
            if (envelope == null) {
                envelope = this.objectEnvelopeTable.get(rtObject.getIdentity(), objectToRegister, rtObject.isNew());
            } else {
                envelope.refreshObjectIfNeeded(objectToRegister);
            }
            if (lockMode == 4) {
                envelope.setWriteLocked(true);
            }
        }
    }

    private void lockAndRegisterReferences(ClassDescriptor cld, Object sourceObject, int lockMode, List registeredObjects) throws LockNotGrantedException {
        if (this.implicitLocking) {
            Iterator i = cld.getObjectReferenceDescriptors(true).iterator();
            while (i.hasNext()) {
                boolean isProxy;
                RuntimeObject rt;
                ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
                Object refObj = rds.getPersistentField().get(sourceObject);
                if (refObj == null || this.registrationList.contains((rt = (isProxy = ProxyHelper.isProxy(refObj)) ? new RuntimeObject(refObj, this, false) : new RuntimeObject(refObj, this)).getIdentity())) continue;
                this.lockAndRegister(rt, lockMode, registeredObjects);
            }
        }
    }

    private void lockAndRegisterCollections(ClassDescriptor cld, Object sourceObject, int lockMode, List registeredObjects) throws LockNotGrantedException {
        if (this.implicitLocking) {
            Iterator i = cld.getCollectionDescriptors(true).iterator();
            while (i.hasNext()) {
                CollectionDescriptor cds = (CollectionDescriptor)i.next();
                Object col = cds.getPersistentField().get(sourceObject);
                if (col == null) continue;
                CollectionProxy proxy = ProxyHelper.getCollectionProxy(col);
                if (proxy != null && !proxy.isLoaded()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("adding self as listener to collection proxy");
                    }
                    proxy.addListener(this);
                    this.registeredCollectionProxies.add(proxy);
                    continue;
                }
                Iterator colIterator = BrokerHelper.getCollectionIterator(col);
                Object item = null;
                try {
                    while (colIterator.hasNext()) {
                        item = colIterator.next();
                        RuntimeObject rt = new RuntimeObject(item, this);
                        if (rt.isProxy()) {
                            IndirectionHandler handler = ProxyHelper.getIndirectionHandler(item);
                            if (!handler.alreadyMaterialized()) {
                                this.registerToIndirectionHandler(handler);
                                continue;
                            }
                            item = handler.getRealSubject();
                        }
                        if (this.registrationList.contains(rt.getIdentity())) continue;
                        this.lockAndRegister(rt, lockMode, registeredObjects);
                    }
                }
                catch (LockNotGrantedException e) {
                    String eol = SystemUtils.LINE_SEPARATOR;
                    this.log.error("Lock not granted, while lock collection references[" + eol + "current reference descriptor:" + eol + cds.toXML() + eol + "object to lock: " + item + eol + "main object class: " + sourceObject.getClass().getName() + eol + "]", e);
                    throw e;
                }
            }
        }
    }

    public void beforeMaterialization(IndirectionHandler handler, Identity oid) {
    }

    public void afterMaterialization(IndirectionHandler handler, Object materializedObject) {
        try {
            Identity oid = handler.getIdentity();
            if (this.log.isDebugEnabled()) {
                this.log.debug("deferred registration: " + oid);
            }
            if (!this.isOpen()) {
                this.log.error("Proxy object materialization outside of a running tx, obj=" + oid);
                try {
                    throw new Exception("Proxy object materialization outside of a running tx, obj=" + oid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ClassDescriptor cld = this.getBroker().getClassDescriptor(materializedObject.getClass());
            RuntimeObject rt = new RuntimeObject(materializedObject, oid, cld, false, false);
            this.lockAndRegister(rt, 1, this.isImplicitLocking(), this.getRegistrationList());
        }
        catch (Throwable t) {
            this.log.error("Register materialized object with this tx failed", t);
            throw new LockNotGrantedException(t.getMessage());
        }
        this.unregisterFromIndirectionHandler(handler);
    }

    protected synchronized void unRegisterFromAllIndirectionHandlers() {
        for (int i = this.registeredIndirectionHandlers.size() - 1; i >= 0; --i) {
            this.unregisterFromIndirectionHandler((IndirectionHandler)this.registeredIndirectionHandlers.get(i));
        }
    }

    protected synchronized void unRegisterFromAllCollectionProxies() {
        for (int i = this.registeredCollectionProxies.size() - 1; i >= 0; --i) {
            this.unregisterFromCollectionProxy((CollectionProxy)this.registeredCollectionProxies.get(i));
        }
    }

    protected synchronized void unregisterFromCollectionProxy(CollectionProxy handler) {
        handler.removeListener(this);
        this.registeredCollectionProxies.remove(handler);
    }

    protected synchronized void unregisterFromIndirectionHandler(IndirectionHandler handler) {
        handler.removeListener(this);
        this.registeredIndirectionHandlers.remove(handler);
    }

    protected synchronized void registerToIndirectionHandler(IndirectionHandler handler) {
        handler.addListener(this);
        this.registeredIndirectionHandlers.add(handler);
    }

    protected void registerUnmaterializedLocks(Object obj) {
        this.unmaterializedLocks.add(obj);
    }

    public PersistenceBrokerInternal getBrokerInternal() {
        if (this.broker == null || this.broker.isClosed()) {
            this.checkOpen();
            try {
                this.checkForDB();
                this.broker = PersistenceBrokerFactoryFactory.instance().createPersistenceBroker(this.curDB.getPBKey());
            }
            catch (PBFactoryException e) {
                this.log.error("Cannot obtain PersistenceBroker from PersistenceBrokerFactory, found PBKey was " + this.curDB.getPBKey(), (Throwable)((Object)e));
                throw new PersistenceBrokerException((Throwable)((Object)e));
            }
        }
        return this.broker;
    }

    public PersistenceBroker getBroker() {
        return this.getBrokerInternal();
    }

    protected boolean hasBroker() {
        return this.broker != null && !this.broker.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupBroker() {
        if (this.hasBroker()) {
            try {
                if (this.broker.isInTransaction()) {
                    this.broker.abortTransaction();
                }
            }
            finally {
                this.broker.close();
                this.broker = null;
            }
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
    }

    public synchronized void setImplicitLocking(boolean value) {
        this.implicitLocking = value;
    }

    public boolean isImplicitLocking() {
        return this.implicitLocking;
    }

    public void beforeLoading(CollectionProxyDefaultImpl colProxy) {
    }

    public void afterLoading(CollectionProxyDefaultImpl colProxy) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("loading a proxied collection a collection: " + colProxy);
        }
        Collection data = colProxy.getData();
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!this.isOpen()) {
                this.log.error("Collection proxy materialization outside of a running tx, obj=" + o);
                try {
                    throw new Exception("Collection proxy materialization outside of a running tx, obj=" + o);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            Identity oid = this.getBroker().serviceIdentity().buildIdentity(o);
            ClassDescriptor cld = this.getBroker().getClassDescriptor(ProxyHelper.getRealClass(o));
            RuntimeObject rt = new RuntimeObject(o, oid, cld, false, ProxyHelper.isProxy(o));
            this.lockAndRegister(rt, 1, this.isImplicitLocking(), this.getRegistrationList());
        }
        this.unregisterFromCollectionProxy(colProxy);
    }

    protected void performTransactionAwareBeforeCommit() {
        Enumeration en = this.objectEnvelopeTable.elements();
        while (en.hasMoreElements()) {
            ((ObjectEnvelope)en.nextElement()).beforeCommit();
        }
    }

    protected void performTransactionAwareAfterCommit() {
        Enumeration en = this.objectEnvelopeTable.elements();
        try {
            while (en.hasMoreElements()) {
                ((ObjectEnvelope)en.nextElement()).afterCommit();
            }
        }
        catch (Exception e) {
            this.log.error("Unexpected error while perform 'TransactionAware#afterCommit()' listener after commit of objects, after commit you can't rollback - exception will be skipped.", e);
        }
    }

    protected void performTransactionAwareBeforeRollback() {
        Enumeration en = this.objectEnvelopeTable.elements();
        while (en.hasMoreElements()) {
            try {
                ((ObjectEnvelope)en.nextElement()).beforeAbort();
            }
            catch (Exception e) {
                this.log.error("Unexpected error while perform 'TransactionAware#beforeAbort()' listener before rollback of objects - exception will be skipped to complete rollback.", e);
            }
        }
    }

    protected void performTransactionAwareAfterRollback() {
        Enumeration en = this.objectEnvelopeTable.elements();
        try {
            while (en.hasMoreElements()) {
                ((ObjectEnvelope)en.nextElement()).afterAbort();
            }
        }
        catch (Exception e) {
            this.log.error("Unexpected error while perform 'TransactionAware#afterAbort()' listener after rollback of objects - exception will be skipped.", e);
        }
    }

    protected boolean isTransient(ClassDescriptor cld, Object obj, Identity oid) {
        boolean isNew;
        boolean bl = isNew = oid != null && oid.isTransient();
        if (!isNew) {
            PersistenceBroker pb = this.getBroker();
            if (cld == null) {
                cld = pb.getClassDescriptor(obj.getClass());
            }
            if (!(isNew = pb.serviceBrokerHelper().hasNullPKField(cld, obj))) {
                ObjectEnvelope mod;
                if (oid == null) {
                    oid = pb.serviceIdentity().buildIdentity(cld, obj);
                }
                isNew = (mod = this.objectEnvelopeTable.getByIdentity(oid)) != null ? mod.needsInsert() : pb.serviceObjectCache().lookup(oid) == null && !pb.serviceBrokerHelper().doesExist(cld, oid, obj);
            }
        }
        return isNew;
    }

    public void setCascadingDelete(Class target, String referenceField, boolean doCascade) {
        ClassDescriptor cld = this.getBroker().getClassDescriptor(target);
        ObjectReferenceDescriptor ord = cld.getObjectReferenceDescriptorByName(referenceField);
        if (ord == null) {
            ord = cld.getCollectionDescriptorByName(referenceField);
        }
        if (ord == null) {
            throw new CascadeSettingException("Invalid reference field name '" + referenceField + "', can't find 1:1, 1:n or m:n relation with that name in " + target);
        }
        this.runtimeCascadeDeleteMap.put(ord, doCascade ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setCascadingDelete(Class target, boolean doCascade) {
        ClassDescriptor cld = this.getBroker().getClassDescriptor(target);
        Vector extents = cld.getExtentClasses();
        Boolean result = doCascade ? Boolean.TRUE : Boolean.FALSE;
        this.setCascadingDelete(cld, result);
        if (extents != null && extents.size() > 0) {
            for (int i = 0; i < extents.size(); ++i) {
                Class extent = (Class)extents.get(i);
                ClassDescriptor tmp = this.getBroker().getClassDescriptor(extent);
                this.setCascadingDelete(tmp, result);
            }
        }
    }

    private void setCascadingDelete(ClassDescriptor cld, Boolean cascade) {
        List singleRefs = cld.getObjectReferenceDescriptors(true);
        for (int i = 0; i < singleRefs.size(); ++i) {
            Object o = singleRefs.get(i);
            this.runtimeCascadeDeleteMap.put(o, cascade);
        }
        List collectionRefs = cld.getCollectionDescriptors(true);
        for (int i = 0; i < collectionRefs.size(); ++i) {
            Object o = collectionRefs.get(i);
            this.runtimeCascadeDeleteMap.put(o, cascade);
        }
    }

    protected boolean cascadeDeleteFor(ObjectReferenceDescriptor ord) {
        Boolean runtimeSetting = (Boolean)this.runtimeCascadeDeleteMap.get(ord);
        boolean result = runtimeSetting == null ? ord.getCascadingDelete() == 23 : runtimeSetting;
        return result;
    }

    int getImpliciteLockType(int parentLockMode) {
        return parentLockMode == 4 && this.impliciteWriteLocks ? 4 : 1;
    }

    public boolean isOrdering() {
        return this.ordering;
    }

    public void setOrdering(boolean ordering) {
        this.ordering = ordering;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class CascadeSettingException
    extends OJBRuntimeException {
        public CascadeSettingException() {
        }

        public CascadeSettingException(String msg) {
            super(msg);
        }

        public CascadeSettingException(Throwable cause) {
            super(cause);
        }

        public CascadeSettingException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

