/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.ObjectModification;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.Image;
import org.apache.ojb.odmg.ObjectEnvelopeTable;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionAware;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.link.LinkEntry;
import org.apache.ojb.odmg.link.LinkEntryOneToN;
import org.apache.ojb.odmg.link.LinkEntryOneToOne;
import org.apache.ojb.odmg.states.ModificationState;
import org.apache.ojb.odmg.states.StateNewDirty;
import org.apache.ojb.odmg.states.StateOldClean;
import org.apache.ojb.odmg.states.StateOldDirty;

public class ObjectEnvelope
implements ObjectModification,
Image.ImageListener {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$ObjectEnvelope == null ? (class$org$apache$ojb$odmg$ObjectEnvelope = ObjectEnvelope.class$("org.apache.ojb.odmg.ObjectEnvelope")) : class$org$apache$ojb$odmg$ObjectEnvelope);
    static final long serialVersionUID = -829177767933340522L;
    static final int IS_MATERIALIZED_OBJECT = 11;
    static final int IS_MATERIALIZED_PROXY = 13;
    static final int IS_UNMATERIALIZED_PROXY = 17;
    private ModificationState modificationState = null;
    private Identity oid;
    private Boolean hasChanged;
    private boolean writeLocked;
    private Object myObj;
    private Map beforeImage;
    private Map currentImage;
    private ObjectEnvelopeTable buffer;
    private List linkEntryList = new ArrayList();
    static /* synthetic */ Class class$org$apache$ojb$odmg$ObjectEnvelope;

    public ObjectEnvelope(ObjectEnvelopeTable buffer, Identity oid, Object obj, boolean isNewObject) {
        this.buffer = buffer;
        this.oid = oid;
        this.myObj = ProxyHelper.getRealObject(obj);
        this.prepareInitialState(isNewObject);
        this.beforeImage = this.buildObjectImage(this.getBroker());
    }

    public PersistenceBrokerInternal getBroker() {
        return this.buffer.getTransaction().getBrokerInternal();
    }

    TransactionImpl getTx() {
        return this.buffer.getTransaction();
    }

    ObjectEnvelopeTable getEnvelopeTable() {
        return this.buffer;
    }

    public Map getBeforeImage() {
        if (this.beforeImage == null) {
            this.beforeImage = this.buildObjectImage(this.getBroker());
        }
        return this.beforeImage;
    }

    public Map getCurrentImage() {
        if (this.currentImage == null) {
            this.currentImage = this.buildObjectImage(this.getBroker());
        }
        return this.currentImage;
    }

    public void cleanup(boolean reuse, boolean wasInsert) {
        if (this.currentImage != null) {
            this.performImageCleanup(this.currentImage, reuse);
        }
        if (this.beforeImage != null) {
            this.performImageCleanup(this.beforeImage, false);
        }
        if (reuse) {
            this.refreshObjectImage(wasInsert);
        } else {
            this.myObj = null;
        }
    }

    private void performImageCleanup(Map imageMap, boolean reuse) {
        Iterator iterator = imageMap.values().iterator();
        while (iterator.hasNext()) {
            Image base = (Image)iterator.next();
            if (base == null) continue;
            base.cleanup(reuse);
        }
    }

    private void refreshObjectImage(boolean wasInsert) {
        try {
            if (this.getIdentity().isTransient()) {
                this.refreshIdentity();
            }
            if (this.currentImage != null) {
                this.beforeImage = this.currentImage;
            } else if (this.beforeImage == null) {
                this.beforeImage = this.buildObjectImage(this.getBroker());
            }
            this.currentImage = null;
            this.hasChanged = null;
            if (wasInsert) {
                this.refreshPKFields();
            }
            this.refreshLockingFields();
        }
        catch (PersistenceBrokerException e) {
            this.beforeImage = null;
            this.currentImage = null;
            this.hasChanged = null;
            this.log.error("Can't refresh object image for " + this.getIdentity(), (Throwable)((Object)e));
            throw e;
        }
    }

    private void refreshPKFields() {
        FieldDescriptor[] flds = this.getClassDescriptor().getPkFields();
        for (int i = 0; i < flds.length; ++i) {
            FieldDescriptor fld = flds[i];
            this.addFieldImage(this.beforeImage, fld);
        }
    }

    private void refreshLockingFields() {
        if (this.getClassDescriptor().isLocking()) {
            FieldDescriptor[] flds = this.getClassDescriptor().getLockingFields();
            for (int i = 0; i < flds.length; ++i) {
                FieldDescriptor fld = flds[i];
                this.addFieldImage(this.beforeImage, fld);
            }
        }
    }

    public Identity refreshIdentity() {
        Identity oldOid = this.getIdentity();
        this.oid = this.getBroker().serviceIdentity().buildIdentity(this.myObj);
        return oldOid;
    }

    public Identity getIdentity() {
        if (this.oid == null) {
            this.oid = this.getBroker().serviceIdentity().buildIdentity(this.getObject());
        }
        return this.oid;
    }

    public Object getObject() {
        return this.myObj;
    }

    public Object getRealObject() {
        return ProxyHelper.getRealObject(this.getObject());
    }

    public void refreshObjectIfNeeded(Object obj) {
        if (this.myObj != obj) {
            this.myObj = obj;
        }
    }

    public void beforeCommit() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.beforeCommit();
        }
    }

    public void afterCommit() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.afterCommit();
        }
    }

    public void beforeAbort() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.beforeAbort();
        }
    }

    public void afterAbort() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.afterAbort();
        }
    }

    private Map buildObjectImage(PersistenceBroker broker) throws PersistenceBrokerException {
        HashMap imageMap = new HashMap();
        ClassDescriptor cld = broker.getClassDescriptor(this.getObject().getClass());
        this.buildImageForSingleReferences(imageMap, cld);
        this.buildImageForFields(imageMap, cld);
        this.buildImageForCollectionReferences(imageMap, cld);
        return imageMap;
    }

    private void buildImageForSingleReferences(Map imageMap, ClassDescriptor cld) {
        Iterator iter = cld.getObjectReferenceDescriptors(true).iterator();
        while (iter.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)iter.next();
            if (rds.isSuperReferenceDescriptor()) continue;
            Object referenceObject = rds.getPersistentField().get(this.myObj);
            IndirectionHandler handler = ProxyHelper.getIndirectionHandler(referenceObject);
            if (handler == null && referenceObject != null && BrokerHelper.hasAnonymousKeyReference(rds.getClassDescriptor(), rds)) {
                this.getBroker().serviceBrokerHelper().link(this.myObj, rds, false);
            }
            Image.SingleRef singleRef = new Image.SingleRef(this, rds, referenceObject);
            imageMap.put(rds, singleRef);
        }
    }

    private void buildImageForFields(Map imageMap, ClassDescriptor cld) {
        FieldDescriptor[] fieldDescs = cld.getFieldDescriptor(true);
        for (int i = 0; i < fieldDescs.length; ++i) {
            this.addFieldImage(imageMap, fieldDescs[i]);
        }
    }

    private void addFieldImage(Map imageMap, FieldDescriptor fld) {
        Object value = fld.getPersistentField().get(this.myObj);
        value = fld.getFieldConversion().javaToSql(value);
        value = fld.getJdbcType().getFieldType().copy(value);
        imageMap.put(fld.getPersistentField().getName(), new Image.Field(fld.getJdbcType().getFieldType(), value));
    }

    private void buildImageForCollectionReferences(Map imageMap, ClassDescriptor cld) {
        Iterator collections = cld.getCollectionDescriptors(true).iterator();
        while (collections.hasNext()) {
            CollectionDescriptor cds = (CollectionDescriptor)collections.next();
            Object collectionOrArray = cds.getPersistentField().get(this.myObj);
            Image.MultipleRef colRef = new Image.MultipleRef(this, cds, collectionOrArray);
            imageMap.put(cds, colRef);
        }
    }

    public ModificationState getModificationState() {
        return this.modificationState;
    }

    public boolean needsInsert() {
        return this.getModificationState().needsInsert();
    }

    public boolean needsUpdate() {
        return this.getModificationState().needsUpdate();
    }

    public boolean needsDelete() {
        return this.getModificationState().needsDelete();
    }

    private void prepareInitialState(boolean isNewObject) {
        ModificationState initialState = isNewObject ? StateNewDirty.getInstance() : (this.isDeleted(this.oid) ? StateOldDirty.getInstance() : StateOldClean.getInstance());
        this.modificationState = initialState;
    }

    public boolean isDeleted(Identity id) {
        ObjectEnvelope envelope = this.buffer.getByIdentity(id);
        return envelope != null && envelope.needsDelete();
    }

    public void setModificationState(ModificationState newModificationState) {
        if (newModificationState != this.modificationState) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("object state transition for object " + this.oid + " (" + this.modificationState + " --> " + newModificationState + ")");
            }
            this.modificationState = newModificationState;
        }
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this);
        buf.append("Identity", (Object)this.oid).append("ModificationState", (Object)this.modificationState.toString());
        return buf.toString();
    }

    public boolean hasChanged(PersistenceBroker broker) {
        if (this.hasChanged == null) {
            Map current = null;
            try {
                current = this.getCurrentImage();
            }
            catch (Exception e) {
                this.log.warn("Could not verify object changes, mark dirty: " + this.getIdentity(), e);
            }
            if (this.beforeImage != null && current != null) {
                Iterator it = this.beforeImage.entrySet().iterator();
                this.hasChanged = Boolean.FALSE;
                while (it.hasNext()) {
                    Image imageCurrent;
                    Map.Entry entry = it.next();
                    Image imageBefore = (Image)entry.getValue();
                    if (!imageBefore.modified(imageCurrent = (Image)current.get(entry.getKey()))) continue;
                    this.hasChanged = Boolean.TRUE;
                    break;
                }
            } else {
                this.hasChanged = Boolean.TRUE;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("State detection for " + this.getIdentity() + " --> object " + (this.hasChanged != false ? "has changed" : "unchanged"));
            }
        }
        return this.hasChanged;
    }

    void markReferenceElements(PersistenceBroker broker) {
        Map oldImage = this.getBeforeImage();
        Map newImage = this.getCurrentImage();
        Iterator iter = newImage.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            if (!(key instanceof ObjectReferenceDescriptor)) continue;
            Image oldRefImage = (Image)oldImage.get(key);
            Image newRefImage = (Image)entry.getValue();
            newRefImage.performReferenceDetection(oldRefImage);
        }
    }

    public void doUpdate() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start UPDATE action for " + this.getIdentity());
        }
        this.performLinkEntries();
        this.getBroker().store(this.getObject(), this.getIdentity(), this.getClassDescriptor(), false, true);
    }

    public void doInsert() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start INSERT action for " + this.getIdentity());
        }
        this.performLinkEntries();
        this.getBroker().store(this.getObject(), this.getIdentity(), this.getClassDescriptor(), true, true);
        Identity oldOid = this.refreshIdentity();
        this.buffer.replaceRegisteredIdentity(this.getIdentity(), oldOid);
    }

    public void doDelete() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start DELETE action for " + this.getIdentity());
        }
        this.getBroker().delete(this.getObject(), true);
    }

    public void doEvictFromCache() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remove from cache " + this.getIdentity());
        }
        this.getBroker().removeFromCache(this.getIdentity());
    }

    public boolean isWriteLocked() {
        return this.writeLocked;
    }

    public void setWriteLocked(boolean writeLocked) {
        this.writeLocked = writeLocked;
    }

    ClassDescriptor getClassDescriptor() {
        return this.getBroker().getClassDescriptor(ProxyHelper.getRealClass(this.getObject()));
    }

    void addLinkOneToOne(ObjectReferenceDescriptor ord, boolean unlink) {
        LinkEntryOneToOne entry = new LinkEntryOneToOne(ord, this.getObject(), unlink);
        this.linkEntryList.add(entry);
    }

    void addLinkOneToN(CollectionDescriptor col, Object source, boolean unlink) {
        if (col.isMtoNRelation()) {
            throw new OJBRuntimeException("Expected an 1:n relation, but specified a m:n");
        }
        LinkEntryOneToN entry = new LinkEntryOneToN(source, col, this.getObject(), unlink);
        this.linkEntryList.add(entry);
    }

    private void performLinkEntries() {
        PersistenceBrokerInternal broker = this.getBroker();
        for (int i = 0; i < this.linkEntryList.size(); ++i) {
            LinkEntry linkEntry = (LinkEntry)this.linkEntryList.get(i);
            linkEntry.execute(broker);
        }
    }

    public void addedOneToOne(ObjectReferenceDescriptor ord, Object refObjOrProxy, Identity oid) {
        this.setModificationState(this.getModificationState().markDirty());
        ObjectEnvelope oe = this.buffer.getByIdentity(oid);
        if (oe == null) {
            RuntimeObject rt = new RuntimeObject(refObjOrProxy, this.getTx());
            this.getTx().lockAndRegister(rt, 1, false, this.getTx().getRegistrationList());
        }
        this.addLinkOneToOne(ord, false);
    }

    public void deletedOneToOne(ObjectReferenceDescriptor ord, Object refObjOrProxy, Identity oid, boolean needsUnlink) {
        this.setModificationState(this.getModificationState().markDirty());
        ObjectEnvelope oldRefMod = this.buffer.getByIdentity(oid);
        if (!this.buffer.isNewAssociatedObject(oid)) {
            if (this.buffer.getTransaction().cascadeDeleteFor(ord)) {
                oldRefMod.setModificationState(oldRefMod.getModificationState().markDelete());
            }
            if (needsUnlink) {
                this.addLinkOneToOne(ord, true);
            }
        }
    }

    public void addedXToN(CollectionDescriptor cod, Object refObjOrProxy, Identity oid) {
        ObjectEnvelope mod = this.buffer.getByIdentity(oid);
        if (mod == null) {
            boolean isNew = this.getTx().isTransient(null, refObjOrProxy, oid);
            mod = this.buffer.get(oid, refObjOrProxy, isNew);
        }
        if (mod.needsDelete()) {
            mod.setModificationState(mod.getModificationState().markNew());
        } else if (!cod.isMtoNRelation() || !mod.getModificationState().equals(StateOldClean.getInstance())) {
            mod.setModificationState(mod.getModificationState().markDirty());
        }
        this.buffer.addNewAssociatedIdentity(oid);
        if (cod.isMtoNRelation()) {
            this.buffer.addM2NLinkEntry(cod, this.getObject(), refObjOrProxy);
        } else {
            mod.addLinkOneToN(cod, this.getObject(), false);
        }
        if (mod.needsInsert()) {
            this.buffer.addForInsertDependent(mod);
        }
    }

    public void deletedXToN(CollectionDescriptor cod, Object refObjOrProxy, Identity oid) {
        ObjectEnvelope mod = this.buffer.getByIdentity(oid);
        if (!this.buffer.isNewAssociatedObject(oid)) {
            if (mod != null) {
                boolean cascade = this.buffer.getTransaction().cascadeDeleteFor(cod);
                if (cascade) {
                    mod.setModificationState(mod.getModificationState().markDelete());
                    this.buffer.addForDeletionDependent(mod);
                }
                if (cod.isMtoNRelation()) {
                    this.buffer.addM2NUnlinkEntry(cod, this.getObject(), refObjOrProxy);
                } else if (!cascade) {
                    mod.setModificationState(mod.getModificationState().markDirty());
                    mod.addLinkOneToN(cod, this.getObject(), true);
                }
            } else {
                throw new Image.ImageException("Unexpected behaviour, unregistered object to delete: " + oid + ", main object is " + this.getIdentity() + ", envelope object is " + this.toString());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

