/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.Configurator;
import org.apache.ojb.broker.util.factory.ConfigurableFactory;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.DatabaseImpl;
import org.apache.ojb.odmg.ImplementationExt;
import org.apache.ojb.odmg.OJBTxManager;
import org.apache.ojb.odmg.TransactionExt;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.locking.LockManager;
import org.apache.ojb.odmg.locking.LockManagerFactory;
import org.apache.ojb.odmg.oql.EnhancedOQLQuery;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DArray;
import org.odmg.DBag;
import org.odmg.DList;
import org.odmg.DMap;
import org.odmg.DSet;
import org.odmg.Database;
import org.odmg.DatabaseClosedException;
import org.odmg.ODMGRuntimeException;
import org.odmg.Transaction;

public class ImplementationImpl
implements ImplementationExt {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$ImplementationImpl == null ? (class$org$apache$ojb$odmg$ImplementationImpl = ImplementationImpl.class$("org.apache.ojb.odmg.ImplementationImpl")) : class$org$apache$ojb$odmg$ImplementationImpl);
    private DatabaseImpl currentDatabase;
    private Configurator configurator;
    private OJBTxManager ojbTxManager = TxManagerFactory.instance();
    private LockManager lockManager = LockManagerFactory.getLockManager();
    private Class oqlCollectionClass;
    private boolean impliciteWriteLocks;
    private boolean implicitLocking;
    private boolean implicitLockingBackward;
    private boolean ordering;
    static /* synthetic */ Class class$org$apache$ojb$odmg$ImplementationImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$ManageableArrayList;
    static /* synthetic */ Class class$org$apache$ojb$broker$PBKey;

    protected ImplementationImpl() {
        this.setConfigurator(PersistenceBrokerFactory.getConfigurator());
        Configuration conf = this.getConfigurator().getConfigurationFor(null);
        this.oqlCollectionClass = conf.getClass("OqlCollectionClass", class$org$apache$ojb$broker$util$collections$ManageableArrayList == null ? (class$org$apache$ojb$broker$util$collections$ManageableArrayList = ImplementationImpl.class$("org.apache.ojb.broker.util.collections.ManageableArrayList")) : class$org$apache$ojb$broker$util$collections$ManageableArrayList);
        this.impliciteWriteLocks = conf.getString("LockAssociations", "WRITE").equalsIgnoreCase("WRITE");
        this.implicitLocking = conf.getBoolean("ImplicitLocking", true);
        this.ordering = conf.getBoolean("Ordering", true);
        this.implicitLockingBackward = conf.getBoolean("ImplicitLockingBackward", false);
        if (this.log.isEnabledFor(2)) {
            this.log.info("Settings: " + this.toString());
        }
    }

    public OJBTxManager getTxManager() {
        return this.ojbTxManager;
    }

    protected LockManager getLockManager() {
        return this.lockManager;
    }

    protected synchronized void setCurrentDatabase(DatabaseImpl curDB) {
        this.currentDatabase = curDB;
    }

    protected synchronized DatabaseImpl getCurrentDatabase() {
        return this.currentDatabase;
    }

    public PBKey getCurrentPBKey() {
        return this.currentDatabase.getPBKey();
    }

    public Configurator getConfigurator() {
        return this.configurator;
    }

    public void setConfigurator(Configurator configurator) {
        this.configurator = configurator;
    }

    public Transaction newTransaction() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, must have a DB in order to create a transaction");
        }
        TransactionImpl tx = new TransactionImpl(this);
        try {
            this.getConfigurator().configure(tx);
        }
        catch (ConfigurationException e) {
            throw new ODMGRuntimeException("Error in configuration of TransactionImpl instance: " + e.getMessage());
        }
        return tx;
    }

    public Transaction currentTransaction() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, must have a DB in order to create a transaction");
        }
        return this.ojbTxManager.getTransaction();
    }

    public boolean hasOpenTransaction() {
        TransactionImpl tx = this.ojbTxManager.getTransaction();
        return tx != null && tx.isOpen();
    }

    public Database newDatabase() {
        return new DatabaseImpl(this);
    }

    public EnhancedOQLQuery newOQLQuery() {
        if (this.getCurrentDatabase() == null || !this.getCurrentDatabase().isOpen()) {
            throw new DatabaseClosedException("Database is not open");
        }
        return new OQLQueryImpl(this);
    }

    public DList newDList() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DList with a null database.");
        }
        return (DList)DListFactory.singleton.createCollectionOrMap(this.getCurrentPBKey());
    }

    public DBag newDBag() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DBag with a null database.");
        }
        return (DBag)DBagFactory.singleton.createCollectionOrMap(this.getCurrentPBKey());
    }

    public DSet newDSet() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DSet with a null database.");
        }
        return (DSet)DSetFactory.singleton.createCollectionOrMap(this.getCurrentPBKey());
    }

    public DArray newDArray() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DArray with a null database.");
        }
        return (DArray)DArrayFactory.singleton.createCollectionOrMap(this.getCurrentPBKey());
    }

    public DMap newDMap() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DMap with a null database.");
        }
        return (DMap)DMapFactory.singleton.createCollectionOrMap(this.getCurrentPBKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectId(Object obj) {
        Identity oid = null;
        PersistenceBroker broker = null;
        try {
            if (this.getCurrentDatabase() != null) {
                broker = PersistenceBrokerFactory.createPersistenceBroker(this.getCurrentDatabase().getPBKey());
            } else {
                this.log.warn("Can't find open database, try to use the default configuration");
                broker = PersistenceBrokerFactory.defaultPersistenceBroker();
            }
            oid = broker.serviceIdentity().buildIdentity(obj);
        }
        finally {
            if (broker != null) {
                broker.close();
            }
        }
        return new String(SerializationUtils.serialize((Serializable)oid));
    }

    public Database getDatabase(Object obj) {
        return this.getCurrentDatabase();
    }

    protected synchronized void registerOpenDatabase(DatabaseImpl newDB) {
        DatabaseImpl old_db = this.getCurrentDatabase();
        if (old_db != null) {
            try {
                if (old_db.isOpen()) {
                    this.log.warn("## There is still an opened database, close old one ##");
                    old_db.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Set current database " + newDB + " PBKey was " + newDB.getPBKey());
        }
        this.setCurrentDatabase(newDB);
    }

    public void setImplicitLocking(boolean value) {
        if (this.implicitLockingBackward) {
            ((TransactionExt)this.currentTransaction()).setImplicitLocking(value);
        } else {
            this.implicitLocking = value;
        }
    }

    public boolean isImplicitLocking() {
        return this.implicitLocking;
    }

    public Class getOqlCollectionClass() {
        return this.oqlCollectionClass;
    }

    public void setOqlCollectionClass(Class oqlCollectionClass) {
        this.oqlCollectionClass = oqlCollectionClass;
    }

    public void setImpliciteWriteLocks(boolean impliciteWriteLocks) {
        this.impliciteWriteLocks = impliciteWriteLocks;
    }

    public boolean isImpliciteWriteLocks() {
        return this.impliciteWriteLocks;
    }

    public boolean isOrdering() {
        return this.ordering;
    }

    public void setOrdering(boolean ordering) {
        this.ordering = ordering;
    }

    public void setImplicitLockingBackward(boolean implicitLockingBackward) {
        this.implicitLockingBackward = implicitLockingBackward;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("implicitLocking", this.isImplicitLocking()).append("implicitWriteLocks", this.isImpliciteWriteLocks()).append("ordering", this.isOrdering()).append("oqlCollectionClass", (Object)this.getOqlCollectionClass()).append("txManager", (Object)this.getTxManager()).append("lockManager", (Object)this.getLockManager()).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class DMapFactory
    extends BaseFactory {
        static final BaseFactory singleton = new DMapFactory();

        DMapFactory() {
        }

        protected String getConfigurationKey() {
            return "DMapClass";
        }
    }

    static final class DSetFactory
    extends BaseFactory {
        static final BaseFactory singleton = new DSetFactory();

        DSetFactory() {
        }

        protected String getConfigurationKey() {
            return "DSetClass";
        }
    }

    static final class DBagFactory
    extends BaseFactory {
        static final BaseFactory singleton = new DBagFactory();

        DBagFactory() {
        }

        protected String getConfigurationKey() {
            return "DBagClass";
        }
    }

    static final class DArrayFactory
    extends BaseFactory {
        static final BaseFactory singleton = new DArrayFactory();

        DArrayFactory() {
        }

        protected String getConfigurationKey() {
            return "DArrayClass";
        }
    }

    static final class DListFactory
    extends BaseFactory {
        static final BaseFactory singleton = new DListFactory();

        DListFactory() {
        }

        protected String getConfigurationKey() {
            return "DListClass";
        }
    }

    static abstract class BaseFactory
    extends ConfigurableFactory {
        BaseFactory() {
        }

        Object createCollectionOrMap() {
            return this.createNewInstance();
        }

        Object createCollectionOrMap(PBKey key) {
            return this.createNewInstance(class$org$apache$ojb$broker$PBKey == null ? (class$org$apache$ojb$broker$PBKey = ImplementationImpl.class$("org.apache.ojb.broker.PBKey")) : class$org$apache$ojb$broker$PBKey, key);
        }
    }
}

