/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo.jdoql;

import org.apache.ojb.jdo.jdoql.Expression;
import org.apache.ojb.jdo.jdoql.Type;
import org.apache.ojb.jdo.jdoql.Visitor;

public class UnaryExpression
extends Expression {
    public static final int OPERATOR_MINUS = 0;
    public static final int OPERATOR_PLUS = 1;
    public static final int OPERATOR_BITWISE_COMPLEMENT = 2;
    public static final int OPERATOR_NOT = 3;
    public static final int OPERATOR_CAST = 4;
    private int _operator;
    private Expression _inner;
    private Type _castType;
    private Class _type;

    public UnaryExpression(int operator, Expression inner) {
        this._operator = operator;
        this._inner = inner;
    }

    public UnaryExpression(Type castType, Expression inner) {
        this._operator = 4;
        this._castType = castType;
        this._inner = inner;
    }

    public int getOperator() {
        return this._operator;
    }

    public Expression getInnerExpression() {
        return this._inner;
    }

    public void replaceChild(Expression oldChild, Expression newChild) {
        this._inner.setParent(null);
        this._inner = newChild;
        this._inner.setParent(this);
    }

    public Type getCastType() {
        return this._castType;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("(");
        switch (this._operator) {
            case 1: {
                result.append("+");
                break;
            }
            case 0: {
                result.append("-");
                break;
            }
            case 2: {
                result.append("~");
                break;
            }
            case 3: {
                result.append("!");
                break;
            }
            case 4: {
                result.append("(");
                result.append(this._castType.toString());
                result.append(")");
            }
        }
        result.append(this._inner.toString());
        result.append(")");
        return result.toString();
    }

    public void setType(Class type) {
        this._type = type;
    }

    public Class getType() {
        return this._type;
    }
}

