/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.apache.commons.lang.BooleanUtils;
import org.apache.ojb.jdo.PersistenceManagerImpl;

public class PersistenceManagerFactoryImpl
implements PersistenceManagerFactory {
    private boolean m_optimistic = true;
    private boolean m_retainValues = true;
    private boolean m_restoreValues = true;
    private boolean m_nonTransactionalRead = true;
    private boolean m_nonTransactionalWrite = false;
    private boolean m_ignoreCache = true;
    private boolean m_multiThreaded = false;
    private int m_minPool = 1;
    private int m_maxPool = 1;
    private int m_msWait = 0;
    private Object m_connectionFactory;
    private String m_connectionFactoryName;
    private Object m_connectionFactory2;
    private String m_connectionFactory2Name;
    private String m_connectionDriverName;
    private String m_connectionURL;
    private String m_connectionPassword;
    private String m_connectionName;
    private String m_alias;
    private final String[] m_implementedOptions = new String[]{"javax.jdo.option.TransientTransactional", "javax.jdo.option.NontransactionalRead", "javax.jdo.option.NontransactionalWrite", "javax.jdo.option.RetainValues", "javax.jdo.option.RestoreValues", "javax.jdo.option.Optimistic", "javax.jdo.option.ApplicationIdentity", "javax.jdo.option.DatastoreIdentity", "javax.jdo.option.NonDatastoreIdentity", "javax.jdo.option.ArrayList", "javax.jdo.option.HashMap", "javax.jdo.option.Hashtable", "javax.jdo.option.LinkedList", "javax.jdo.option.TreeMap", "javax.jdo.option.TreeSet", "javax.jdo.option.Vector", "javax.jdo.option.Map", "javax.jdo.option.List", "javax.jdo.option.Array", "javax.jdo.option.NullCollection", "javax.jdo.query.JDOQL"};
    private static Properties PROPERTIES = new Properties();

    public static PersistenceManagerFactory getPersistenceManagerFactory(Properties props) {
        PersistenceManagerFactoryImpl retval = new PersistenceManagerFactoryImpl();
        retval.setOptimistic(Boolean.getBoolean(props.getProperty("javax.jdo.option.Optimistic", BooleanUtils.toStringTrueFalse((boolean)retval.getOptimistic()))));
        retval.setRetainValues(Boolean.getBoolean(props.getProperty("javax.jdo.option.RetainValues", BooleanUtils.toStringTrueFalse((boolean)retval.getRetainValues()))));
        retval.setRestoreValues(Boolean.getBoolean(props.getProperty("javax.jdo.option.RestoreValues", BooleanUtils.toStringTrueFalse((boolean)retval.getRestoreValues()))));
        retval.setIgnoreCache(Boolean.getBoolean(props.getProperty("javax.jdo.option.IgnoreCache", BooleanUtils.toStringTrueFalse((boolean)retval.getIgnoreCache()))));
        retval.setNontransactionalRead(Boolean.getBoolean(props.getProperty("javax.jdo.option.NontransactionalRead", BooleanUtils.toStringTrueFalse((boolean)retval.getNontransactionalRead()))));
        retval.setMultithreaded(Boolean.getBoolean(props.getProperty("javax.jdo.option.Multithreaded", BooleanUtils.toStringTrueFalse((boolean)retval.getMultithreaded()))));
        retval.setOptimistic(Boolean.getBoolean(props.getProperty("javax.jdo.option.Optimistic", BooleanUtils.toStringTrueFalse((boolean)retval.getOptimistic()))));
        retval.setOptimistic(Boolean.getBoolean(props.getProperty("javax.jdo.option.Optimistic", BooleanUtils.toStringTrueFalse((boolean)retval.getOptimistic()))));
        retval.setConnectionUserName(props.getProperty("javax.jdo.option.ConnectionUserName", retval.getConnectionUserName()));
        retval.setConnectionPassword(props.getProperty("javax.jdo.option.ConnectionPassword", null));
        retval.setConnectionURL(props.getProperty("javax.jdo.option.ConnectionURL", retval.getConnectionURL()));
        retval.setConnectionFactoryName(props.getProperty("javax.jdo.option.ConnectionFactoryName", retval.getConnectionFactoryName()));
        retval.setConnectionFactory2Name(props.getProperty("javax.jdo.option.ConnectionFactory2Name", retval.getConnectionFactory2Name()));
        retval.setAlias(props.getProperty("javax.jdo.option.OjbAlias", retval.getAlias()));
        return retval;
    }

    public PersistenceManager getPersistenceManager() {
        return this.getPersistenceManager(null, null, null);
    }

    public PersistenceManager getPersistenceManager(String userid, String password) {
        return this.getPersistenceManager(null, userid, password);
    }

    public PersistenceManager getPersistenceManager(String alias, String userid, String password) {
        return new PersistenceManagerImpl(this, alias, userid, password);
    }

    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public void setConnectionUserName(String s) {
        this.m_connectionName = s;
    }

    public String getConnectionUserName() {
        return this.m_connectionName;
    }

    public void setConnectionPassword(String s) {
        this.m_connectionPassword = s;
    }

    public void setConnectionURL(String s) {
        this.m_connectionURL = s;
    }

    public String getConnectionURL() {
        return this.m_connectionURL;
    }

    public void setConnectionDriverName(String s) {
        this.m_connectionDriverName = s;
    }

    public String getConnectionDriverName() {
        return this.m_connectionDriverName;
    }

    public void setConnectionFactoryName(String s) {
        this.m_connectionFactoryName = s;
    }

    public String getConnectionFactoryName() {
        return this.m_connectionFactoryName;
    }

    public void setConnectionFactory(Object o) {
        this.m_connectionFactory = o;
    }

    public Object getConnectionFactory() {
        return this.m_connectionFactory;
    }

    public void setConnectionFactory2Name(String s) {
        this.m_connectionFactory2Name = s;
    }

    public String getConnectionFactory2Name() {
        return this.m_connectionFactory2Name;
    }

    public void setConnectionFactory2(Object o) {
        this.m_connectionFactory2 = o;
    }

    public Object getConnectionFactory2() {
        return this.m_connectionFactory2;
    }

    public void setMultithreaded(boolean b) {
        this.m_multiThreaded = b;
    }

    public boolean getMultithreaded() {
        return this.m_multiThreaded;
    }

    public void setOptimistic(boolean b) {
        this.m_optimistic = b;
    }

    public boolean getOptimistic() {
        return this.m_optimistic;
    }

    public void setRetainValues(boolean b) {
        this.m_retainValues = b;
    }

    public boolean getRetainValues() {
        return this.m_retainValues;
    }

    public void setRestoreValues(boolean b) {
        this.m_restoreValues = b;
    }

    public boolean getRestoreValues() {
        return this.m_restoreValues;
    }

    public void setNontransactionalRead(boolean b) {
        this.m_nonTransactionalRead = b;
    }

    public boolean getNontransactionalRead() {
        return this.m_nonTransactionalRead;
    }

    public void setNontransactionalWrite(boolean b) {
        this.m_nonTransactionalWrite = b;
    }

    public boolean getNontransactionalWrite() {
        return this.m_nonTransactionalWrite;
    }

    public void setIgnoreCache(boolean b) {
        this.m_ignoreCache = b;
    }

    public boolean getIgnoreCache() {
        return this.m_ignoreCache;
    }

    public int getMaxPool() {
        return this.m_maxPool;
    }

    public void setMaxPool(int i) {
        this.m_maxPool = i;
    }

    public int getMinPool() {
        return this.m_minPool;
    }

    public void setMinPool(int i) {
        this.m_minPool = i;
    }

    public int getMsWait() {
        return this.m_msWait;
    }

    public void setMsWait(int i) {
        this.m_msWait = i;
    }

    public Properties getProperties() {
        return PROPERTIES;
    }

    public Collection supportedOptions() {
        return Collections.unmodifiableCollection(Arrays.asList(this.m_implementedOptions));
    }

    public void close() {
    }

    static {
        PROPERTIES.put("VendorName", "Apache ObjectRelationalBridge");
        PROPERTIES.put("VersionNumber", "1.0");
    }
}

