/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggingConfiguration;

public class PoorMansLoggerImpl
implements Logger {
    protected static final String STR_DEBUG = "DEBUG";
    protected static final String STR_INFO = "INFO";
    protected static final String STR_WARN = "WARN";
    protected static final String STR_ERROR = "ERROR";
    protected static final String STR_FATAL = "FATAL";
    protected static final String STR_DEBUG_MSG = "DEBUG: ";
    protected static final String STR_INFO_MSG = "INFO: ";
    protected static final String STR_WARN_MSG = "WARN: ";
    protected static final String STR_ERROR_MSG = "ERROR: ";
    protected static final String STR_FATAL_MSG = "FATAL: ";
    protected static final String BRAKE_OPEN = "[";
    protected static final String BRAKE_CLOSE = "] ";
    private String name;
    private int level = 0;

    public PoorMansLoggerImpl(String name) {
        this.name = name;
    }

    protected int getLevel() {
        return this.level;
    }

    void setLevel(int pLevel) {
        this.level = pLevel;
    }

    public String getName() {
        return this.name;
    }

    public void debug(Object pObject) {
        this.debug(pObject, null);
    }

    public void debug(Object message, Throwable t) {
        if (1 >= this.getLevel()) {
            this.log(STR_DEBUG_MSG, message, t);
        }
    }

    public void safeDebug(String message, Object obj) {
        this.safeDebug(message, obj, null);
    }

    public void safeDebug(String message, Object obj, Throwable t) {
        if (1 >= this.getLevel()) {
            String toString = null;
            if (obj != null) {
                try {
                    toString = obj.toString();
                }
                catch (Throwable throwable) {
                    toString = "BAD toString() impl for " + obj.getClass().getName();
                }
            }
            this.log(STR_DEBUG_MSG, message + " : " + toString, t);
        }
    }

    public void info(Object pObject) {
        this.info(pObject, null);
    }

    public void info(Object message, Throwable t) {
        if (2 >= this.getLevel()) {
            this.log(STR_INFO_MSG, message, t);
        }
    }

    public void safeInfo(String message, Object obj) {
        this.safeInfo(message, obj, null);
    }

    public void safeInfo(String message, Object obj, Throwable t) {
        if (2 >= this.getLevel()) {
            String toString = null;
            if (obj != null) {
                try {
                    toString = obj.toString();
                }
                catch (Throwable throwable) {
                    toString = "BAD toString() impl for " + obj.getClass().getName();
                }
            }
            this.log(STR_INFO_MSG, message + " : " + toString, t);
        }
    }

    public void warn(Object pObject) {
        this.warn(pObject, null);
    }

    public void warn(Object message, Throwable t) {
        if (3 >= this.getLevel()) {
            this.log(STR_WARN_MSG, message, t);
        }
    }

    public void safeWarn(String message, Object obj) {
        this.safeWarn(message, obj, null);
    }

    public void safeWarn(String message, Object obj, Throwable t) {
        if (3 >= this.getLevel()) {
            String toString = null;
            if (obj != null) {
                try {
                    toString = obj.toString();
                }
                catch (Throwable throwable) {
                    toString = "BAD toString() impl for " + obj.getClass().getName();
                }
            }
            this.log(STR_WARN_MSG, message + " : " + toString, t);
        }
    }

    public void error(Object pObject) {
        this.error(pObject, null);
    }

    public void error(Object message, Throwable t) {
        if (4 >= this.getLevel()) {
            this.log(STR_ERROR_MSG, message, t);
        }
    }

    public void safeError(String message, Object obj) {
        this.safeError(message, obj, null);
    }

    public void safeError(String message, Object obj, Throwable t) {
        if (4 >= this.getLevel()) {
            String toString = null;
            if (obj != null) {
                try {
                    toString = obj.toString();
                }
                catch (Throwable throwable) {
                    toString = "BAD toString() impl for " + obj.getClass().getName();
                }
            }
            this.log(STR_ERROR_MSG, message + " : " + toString, t);
        }
    }

    public void fatal(Object pObject) {
        this.fatal(pObject, null);
    }

    public void fatal(Object message, Throwable t) {
        if (5 >= this.getLevel()) {
            this.log(STR_FATAL_MSG, message, t);
        }
    }

    public void safeFatal(String message, Object obj) {
        this.safeFatal(message, obj, null);
    }

    public void safeFatal(String message, Object obj, Throwable t) {
        if (5 >= this.getLevel()) {
            String toString = null;
            if (obj != null) {
                try {
                    toString = obj.toString();
                }
                catch (Throwable throwable) {
                    toString = "BAD toString() impl for " + obj.getClass().getName();
                }
            }
            this.log(STR_FATAL_MSG, message + " : " + toString, t);
        }
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(1);
    }

    public boolean isEnabledFor(int priority) {
        return priority >= this.getLevel();
    }

    protected void log(String aLevel, Object obj, Throwable t) {
        System.out.print(BRAKE_OPEN + this.name + BRAKE_CLOSE + aLevel);
        if (obj != null && obj instanceof Throwable) {
            try {
                System.out.println(((Throwable)obj).getMessage());
                ((Throwable)obj).printStackTrace();
            }
            catch (Throwable ignored) {}
        } else {
            System.out.println(obj);
        }
        if (t != null) {
            try {
                System.out.println(t.getMessage());
                t.printStackTrace();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
        LoggingConfiguration lc = (LoggingConfiguration)config;
        String levelName = lc.getLogLevel(this.name);
        this.setLevel(levelName);
    }

    public void setLevel(String levelName) {
        this.level = levelName.equalsIgnoreCase(STR_DEBUG) ? 1 : (levelName.equalsIgnoreCase(STR_INFO) ? 2 : (levelName.equalsIgnoreCase(STR_WARN) ? 3 : (levelName.equalsIgnoreCase(STR_ERROR) ? 4 : (levelName.equalsIgnoreCase(STR_FATAL) ? 5 : 3))));
    }
}

