/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.io.PrintWriter;
import org.apache.commons.lang.BooleanUtils;
import org.apache.ojb.broker.util.logging.Logger;

public class LoggerWrapperPrintWriter
extends PrintWriter {
    private static final String LINESEP = System.getProperty("line.separator");
    private static final int DEFAULT_LEVEL = 2;
    private final Logger logger;
    private final int level;
    private final boolean filterEverything;

    public LoggerWrapperPrintWriter(Logger logger, int level) {
        super(System.out);
        this.logger = logger;
        this.level = level;
        this.filterEverything = !logger.isEnabledFor(level);
    }

    public LoggerWrapperPrintWriter(Logger logger) {
        this(logger, 2);
    }

    private void log(String s) {
        switch (this.level) {
            case 5: {
                this.logger.fatal(s);
                break;
            }
            case 4: {
                this.logger.error(s);
                break;
            }
            case 3: {
                this.logger.warn(s);
                break;
            }
            case 2: {
                this.logger.info(s);
                break;
            }
            case 1: {
                this.logger.debug(s);
                break;
            }
            default: {
                throw new RuntimeException("Internal OJB fault. Logger API does not permit level " + this.level);
            }
        }
    }

    private void logLn(String s) {
        if (s != null) {
            this.log(s);
        }
        this.log(LINESEP);
    }

    public void println() {
        if (!this.filterEverything) {
            this.logLn(null);
        }
    }

    public void print(char c) {
        if (!this.filterEverything) {
            this.log(new String(new char[]{c}));
        }
    }

    public void println(char c) {
        if (!this.filterEverything) {
            this.logLn(new String(new char[]{c}));
        }
    }

    public void print(double v) {
        if (!this.filterEverything) {
            this.log(Double.toString(v));
        }
    }

    public void println(double v) {
        if (!this.filterEverything) {
            this.logLn(Double.toString(v));
        }
    }

    public void print(float v) {
        if (!this.filterEverything) {
            this.log(Float.toString(v));
        }
    }

    public void println(float v) {
        if (!this.filterEverything) {
            this.logLn(Float.toString(v));
        }
    }

    public void print(int i) {
        if (!this.filterEverything) {
            this.log(Integer.toString(i));
        }
    }

    public void println(int i) {
        if (!this.filterEverything) {
            this.logLn(Integer.toString(i));
        }
    }

    public void print(long l) {
        if (!this.filterEverything) {
            this.log(Long.toString(l));
        }
    }

    public void println(long l) {
        if (!this.filterEverything) {
            this.logLn(Long.toString(l));
        }
    }

    public void print(boolean b) {
        if (!this.filterEverything) {
            this.log(BooleanUtils.toStringTrueFalse((boolean)b));
        }
    }

    public void println(boolean b) {
        if (!this.filterEverything) {
            this.logLn(BooleanUtils.toStringTrueFalse((boolean)b));
        }
    }

    public void print(char[] chars) {
        if (!this.filterEverything) {
            this.log(new String(chars));
        }
    }

    public void println(char[] chars) {
        if (!this.filterEverything) {
            this.logLn(new String(chars));
        }
    }

    public void print(Object o) {
        if (!this.filterEverything && o != null) {
            this.log(o.toString());
        }
    }

    public void println(Object o) {
        if (!this.filterEverything && o != null) {
            this.logLn(o.toString());
        }
    }

    public void print(String s) {
        if (!this.filterEverything) {
            this.log(s);
        }
    }

    public void println(String s) {
        if (!this.filterEverything) {
            this.logLn(s);
        }
    }

    public void write(int i) {
        if (!this.filterEverything) {
            this.print(i);
        }
    }

    public void write(String s) {
        if (!this.filterEverything) {
            this.print(s);
        }
    }

    public void write(char[] chars) {
        if (!this.filterEverything) {
            this.print(chars);
        }
    }

    public void write(char[] chars, int i, int i1) {
        if (!this.filterEverything) {
            this.log(new String(chars, i, i1));
        }
    }

    public void write(String s, int i, int i1) {
        if (!this.filterEverything) {
            this.log(s.substring(i, i1));
        }
    }
}

