/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.net.URL;
import java.util.Enumeration;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.logging.LoggingConfiguration;

public class Log4jLoggerImpl
implements Logger {
    private static final String FQCN = (class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl = Log4jLoggerImpl.class$("org.apache.ojb.broker.util.logging.Log4jLoggerImpl")) : class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl).getName();
    private static boolean log4jConfigured = false;
    private transient org.apache.log4j.Logger logger;
    private String name;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl;

    private static synchronized boolean isLog4JConfigured() {
        if (!log4jConfigured) {
            Enumeration en = org.apache.log4j.Logger.getRootLogger().getAllAppenders();
            if (!(en instanceof NullEnumeration)) {
                log4jConfigured = true;
            } else {
                Enumeration cats = LogManager.getCurrentLoggers();
                while (cats.hasMoreElements()) {
                    org.apache.log4j.Logger c = (org.apache.log4j.Logger)cats.nextElement();
                    if (c.getAllAppenders() instanceof NullEnumeration) continue;
                    log4jConfigured = true;
                }
            }
            if (log4jConfigured) {
                String msg = "Log4J is already configured, will not search for log4j properties file";
                LoggerFactory.getBootLogger().info(msg);
            } else {
                LoggerFactory.getBootLogger().info("Log4J is not configured");
            }
        }
        return log4jConfigured;
    }

    private static synchronized void initializeLog4JSubSystem(String configFile) {
        LoggerFactory.getBootLogger().info("Initializing Log4J using file: '" + configFile + "'");
        if (configFile == null || "".equals(configFile.trim())) {
            LoggerFactory.getBootLogger().warn("No log4j configuration file specified");
        } else {
            URL url = ClassHelper.getResource(configFile);
            LoggerFactory.getBootLogger().info("Initializing Log4J : resource from config file:" + url);
            if (url != null) {
                PropertyConfigurator.configure((URL)url);
            } else {
                PropertyConfigurator.configure((String)configFile);
            }
        }
        log4jConfigured = true;
    }

    public Log4jLoggerImpl(String name) {
        this.name = name;
    }

    public void configure(Configuration config) throws ConfigurationException {
        if (!Log4jLoggerImpl.isLog4JConfigured()) {
            LoggingConfiguration lc = (LoggingConfiguration)config;
            Log4jLoggerImpl.initializeLog4JSubSystem(lc.getLoggerConfigFile());
        }
    }

    private org.apache.log4j.Logger getLogger() {
        if (this.logger == null) {
            this.logger = org.apache.log4j.Logger.getLogger((String)this.name);
        }
        return this.logger;
    }

    public String getName() {
        return this.name;
    }

    private Level getLevel() {
        return this.getLogger().getEffectiveLevel();
    }

    public final void debug(Object pObject) {
        this.getLogger().log(FQCN, (Priority)Level.DEBUG, pObject, null);
    }

    public final void info(Object pObject) {
        this.getLogger().log(FQCN, (Priority)Level.INFO, pObject, null);
    }

    public final void warn(Object pObject) {
        this.getLogger().log(FQCN, (Priority)Level.WARN, pObject, null);
    }

    public final void error(Object pObject) {
        this.getLogger().log(FQCN, (Priority)Level.ERROR, pObject, null);
    }

    public final void fatal(Object pObject) {
        this.getLogger().log(FQCN, (Priority)Level.FATAL, pObject, null);
    }

    public void debug(Object message, Throwable obj) {
        this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, obj);
    }

    public void error(Object message, Throwable obj) {
        this.getLogger().log(FQCN, (Priority)Level.ERROR, message, obj);
    }

    public void fatal(Object message, Throwable obj) {
        this.getLogger().log(FQCN, (Priority)Level.FATAL, message, obj);
    }

    public void info(Object message, Throwable obj) {
        this.getLogger().log(FQCN, (Priority)Level.INFO, message, obj);
    }

    public void warn(Object message, Throwable obj) {
        this.getLogger().log(FQCN, (Priority)Level.WARN, message, obj);
    }

    public void safeDebug(String message, Object obj) {
        if (Level.DEBUG.isGreaterOrEqual((Priority)this.getLevel())) {
            String toString = null;
            if (obj != null) {
                try {
                    toString = obj.toString();
                }
                catch (Throwable t) {
                    toString = "BAD toString() impl for " + obj.getClass().getName();
                }
            }
            this.debug(message + " : " + toString);
        }
    }

    public void safeDebug(String message, Object obj, Throwable throwable) {
        if (Level.DEBUG.isGreaterOrEqual((Priority)this.getLevel())) {
            String toString = null;
            if (obj != null) {
                try {
                    toString = obj.toString();
                }
                catch (Throwable t) {
                    toString = "BAD toString() impl for " + obj.getClass().getName();
                }
            }
            this.debug(message + " : " + toString, throwable);
        }
    }

    public void safeInfo(String message, Object obj) {
        if (Level.INFO.isGreaterOrEqual((Priority)this.getLevel())) {
            String toString = null;
            if (obj != null) {
                try {
                    toString = obj.toString();
                }
                catch (Throwable t) {
                    toString = "BAD toString() impl for " + obj.getClass().getName();
                }
            }
            this.info(message + " : " + toString);
        }
    }

    public void safeInfo(String message, Object obj, Throwable throwable) {
        if (Level.INFO.isGreaterOrEqual((Priority)this.getLevel())) {
            String toString = null;
            if (obj != null) {
                try {
                    toString = obj.toString();
                }
                catch (Throwable t) {
                    toString = "BAD toString() impl for " + obj.getClass().getName();
                }
            }
            this.info(message + " : " + toString, throwable);
        }
    }

    public void safeWarn(String message, Object obj) {
        if (Level.WARN.isGreaterOrEqual((Priority)this.getLevel())) {
            String toString;
            try {
                toString = obj.toString();
            }
            catch (Throwable t) {
                toString = "BAD toString() impl for " + obj.getClass().getName();
            }
            this.warn(message + " : " + toString);
        }
    }

    public void safeWarn(String message, Object obj, Throwable throwable) {
        if (Level.WARN.isGreaterOrEqual((Priority)this.getLevel())) {
            String toString;
            try {
                toString = obj.toString();
            }
            catch (Throwable t) {
                toString = "BAD toString() impl for " + obj.getClass().getName();
            }
            this.warn(message + " : " + toString, throwable);
        }
    }

    public void safeError(String message, Object obj) {
        if (Level.ERROR.isGreaterOrEqual((Priority)this.getLevel())) {
            String toString;
            try {
                toString = obj.toString();
            }
            catch (Throwable t) {
                toString = "BAD toString() impl for " + obj.getClass().getName();
            }
            this.error(message + " : " + toString);
        }
    }

    public void safeError(String message, Object obj, Throwable throwable) {
        if (Level.ERROR.isGreaterOrEqual((Priority)this.getLevel())) {
            String toString;
            try {
                toString = obj.toString();
            }
            catch (Throwable t) {
                toString = "BAD toString() impl for " + obj.getClass().getName();
            }
            this.error(message + " : " + toString, throwable);
        }
    }

    public void safeFatal(String message, Object obj) {
        if (Level.FATAL.isGreaterOrEqual((Priority)this.getLevel())) {
            String toString;
            try {
                toString = obj.toString();
            }
            catch (Throwable t) {
                toString = "BAD toString() impl for " + obj.getClass().getName();
            }
            this.fatal(message + " : " + toString);
        }
    }

    public void safeFatal(String message, Object obj, Throwable throwable) {
        if (Level.FATAL.isGreaterOrEqual((Priority)this.getLevel())) {
            String toString;
            try {
                toString = obj.toString();
            }
            catch (Throwable t) {
                toString = "BAD toString() impl for " + obj.getClass().getName();
            }
            this.fatal(message + " : " + toString, throwable);
        }
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isEnabledFor(int priority) {
        org.apache.log4j.Logger log4j = this.getLogger();
        switch (priority) {
            case 1: {
                return log4j.isDebugEnabled();
            }
            case 2: {
                return log4j.isInfoEnabled();
            }
            case 3: {
                return log4j.isEnabledFor(Priority.WARN);
            }
            case 4: {
                return log4j.isEnabledFor(Priority.ERROR);
            }
            case 5: {
                return log4j.isEnabledFor(Priority.FATAL);
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

