/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.collections;

import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.collections.IRemovalAwareCollection;
import org.apache.ojb.broker.util.collections.ManageableHashSet;

public class RemovalAwareSet
extends ManageableHashSet
implements IRemovalAwareCollection {
    private Vector allObjectsToBeRemoved = new Vector();

    public void afterStore(PersistenceBroker broker) throws PersistenceBrokerException {
        this.allObjectsToBeRemoved.removeAll(this);
        Iterator iter = this.allObjectsToBeRemoved.iterator();
        while (iter.hasNext()) {
            broker.delete(iter.next());
        }
        this.allObjectsToBeRemoved.clear();
    }

    protected void registerForDeletion(Object toBeRemoved) {
        if (!this.allObjectsToBeRemoved.contains(toBeRemoved)) {
            this.allObjectsToBeRemoved.add(toBeRemoved);
        }
    }

    public boolean remove(Object o) {
        boolean result = super.remove(o);
        this.registerForDeletion(o);
        return result;
    }

    public synchronized void removeAllElements() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            this.registerForDeletion(it.next());
        }
        super.clear();
    }

    public synchronized void clear() {
        this.removeAllElements();
    }

    public void resetDeleted() {
        this.allObjectsToBeRemoved.clear();
    }
}

