/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.collections;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.MetadataManager;

public class ManageableHashMap
extends HashMap
implements ManageableCollection {
    public void ojbAdd(Object anObject) {
        if (anObject != null) {
            ClassDescriptor cd = MetadataManager.getInstance().getRepository().getDescriptorFor(anObject.getClass());
            FieldDescriptor[] fields = cd.getPkFields();
            if (fields.length > 1 || fields.length == 0) {
                throw new MetadataException("ManageableHashMap can only be used for persistence capable objects with exactly one primiary key field defined in metadata, for " + anObject.getClass() + " the" + " PK field count is " + fields.length);
            }
            Object key = fields[0].getPersistentField().get(anObject);
            this.put(key, anObject);
        }
    }

    public void ojbAddAll(ManageableCollection otherCollection) {
        Iterator it = otherCollection.ojbIterator();
        while (it.hasNext()) {
            this.ojbAdd(it.next());
        }
    }

    public Iterator ojbIterator() {
        return this.values().iterator();
    }

    public void afterStore(PersistenceBroker broker) throws PersistenceBrokerException {
    }
}

