/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.batch;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformFactory;
import org.apache.ojb.broker.util.batch.BatchConnection;

public class PreparedStatementInvocationHandler
implements InvocationHandler {
    private static final Integer ONE = new Integer(1);
    private static Method ADD_BATCH;
    private static final Method SET_BIG_DECIMAL;
    private final BatchConnection _batchConn;
    private final String _sql;
    private ArrayList _methods = new ArrayList();
    private ArrayList _params = new ArrayList();
    private Platform m_platform = null;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$PreparedStatement;

    public PreparedStatementInvocationHandler(BatchConnection batchConn, String sql, JdbcConnectionDescriptor jcd) {
        this._batchConn = batchConn;
        this._sql = sql;
        this.m_platform = PlatformFactory.getPlatformFor(jcd);
        try {
            ADD_BATCH = this.m_platform.getClass().getMethod("addBatch", class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = PreparedStatementInvocationHandler.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement);
        }
        catch (NoSuchMethodException e) {
            ADD_BATCH = null;
        }
        catch (SecurityException e) {
            // empty catch block
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (name.equals("executeUpdate")) {
            this._methods.add(ADD_BATCH);
            this._params.add(null);
            this._batchConn.nextExecuted(this._sql);
            return ONE;
        }
        if (name.equals("doExecute")) {
            this.doExecute((Connection)args[0]);
        } else if (name.startsWith("set")) {
            if (name.equals("setLong")) {
                method = SET_BIG_DECIMAL;
                args[1] = BigDecimal.valueOf((Long)args[1]);
            }
            this._methods.add(method);
            this._params.add(args);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(Connection conn) throws SQLException {
        int size = this._methods.size();
        if (size == 0) {
            return;
        }
        PreparedStatement stmt = conn.prepareStatement(this._sql);
        try {
            this.m_platform.afterStatementCreate(stmt);
        }
        catch (PlatformException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new SQLException(e.getMessage());
        }
        try {
            this.m_platform.beforeBatch(stmt);
        }
        catch (PlatformException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new SQLException(e.getMessage());
        }
        try {
            for (int i = 0; i < size; ++i) {
                Method method = (Method)this._methods.get(i);
                try {
                    if (method.equals(ADD_BATCH)) {
                        this.m_platform.addBatch(stmt);
                        continue;
                    }
                    method.invoke((Object)stmt, (Object[])this._params.get(i));
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    StringBuffer buffer = this.generateExceptionMessage(i, stmt, ex);
                    throw new SQLException(buffer.toString());
                }
                catch (IllegalAccessException ex) {
                    StringBuffer buffer = this.generateExceptionMessage(i, stmt, ex);
                    throw new SQLException(buffer.toString());
                }
                catch (InvocationTargetException ex) {
                    Throwable th = ex.getTargetException();
                    if (th == null) {
                        th = ex;
                    }
                    if (th instanceof SQLException) {
                        throw (SQLException)th;
                    }
                    throw new SQLException(th.toString());
                }
                catch (PlatformException e) {
                    throw new SQLException(e.toString());
                }
            }
            try {
                this.m_platform.executeBatch(stmt);
            }
            catch (PlatformException e) {
                if (e.getCause() instanceof SQLException) {
                    throw (SQLException)e.getCause();
                }
                throw new SQLException(e.getMessage());
            }
            Object var9_16 = null;
        }
        catch (Throwable throwable) {
            Object var9_17 = null;
            stmt.close();
            this._methods.clear();
            this._params.clear();
            throw throwable;
        }
        stmt.close();
        this._methods.clear();
        this._params.clear();
    }

    private StringBuffer generateExceptionMessage(int i, PreparedStatement stmt, Exception ex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Method of type: ");
        buffer.append(this._methods.get(i));
        buffer.append(" invoking on instance: ");
        if (this._methods.get(i).equals(ADD_BATCH)) {
            buffer.append(this.m_platform);
        } else {
            buffer.append(stmt);
        }
        buffer.append(" with parameters: ");
        if (this._methods.get(i).equals(ADD_BATCH)) {
            buffer.append(stmt);
        } else {
            buffer.append(this._params.get(i));
        }
        buffer.append(" with root: ");
        buffer.append(ex.toString());
        return buffer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Method setBigDecimal = null;
        try {
            setBigDecimal = (class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = PreparedStatementInvocationHandler.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement).getMethod("setBigDecimal", Integer.TYPE, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PreparedStatementInvocationHandler.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SET_BIG_DECIMAL = setBigDecimal;
    }
}

