/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.collections.map.ReferenceIdentityMap;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.MtoNImplementor;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.accesslayer.sql.SqlExistStatement;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.MtoNQuery;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryBySQL;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.apache.ojb.broker.query.ReportQueryByMtoNCriteria;
import org.apache.ojb.broker.util.ExceptionHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class BrokerHelper {
    public static final String REPOSITORY_NAME_SEPARATOR = "#";
    private PersistenceBrokerImpl m_broker;
    private Map sqlSelectMap = new ReferenceIdentityMap(2, 0);

    public BrokerHelper(PersistenceBrokerImpl broker) {
        this.m_broker = broker;
    }

    public static PBKey extractAllTokens(String name) {
        if (name == null) {
            throw new PersistenceBrokerException("Could not extract PBKey, given argument is 'null'");
        }
        String user = null;
        String passwd = null;
        StringTokenizer tok = new StringTokenizer(name, REPOSITORY_NAME_SEPARATOR);
        String dbName = tok.nextToken();
        if (tok.hasMoreTokens() && (user = tok.nextToken()) != null && user.trim().equals("")) {
            user = null;
        }
        if (tok.hasMoreTokens() && user != null) {
            passwd = tok.nextToken();
        }
        if (user != null && passwd == null) {
            passwd = "";
        }
        return new PBKey(dbName, user, passwd);
    }

    public static PBKey crossCheckPBKey(PBKey key) {
        PBKey defKey;
        if (key.getUser() == null && (defKey = MetadataManager.getInstance().connectionRepository().getStandardPBKeyForJcdAlias(key.getAlias())) != null) {
            return defKey;
        }
        return key;
    }

    private ClassDescriptor getRealClassDescriptor(ClassDescriptor aCld, Object anObj) {
        ClassDescriptor result = aCld.getClassOfObject() == ProxyHelper.getRealClass(anObj) ? aCld : aCld.getRepository().getDescriptorFor(anObj.getClass());
        return result;
    }

    public ValueContainer[] getKeyValues(ClassDescriptor cld, Object objectOrProxy, boolean convertToSql) throws PersistenceBrokerException {
        IndirectionHandler handler = ProxyHelper.getIndirectionHandler(objectOrProxy);
        if (handler != null) {
            return this.getKeyValues(cld, handler.getIdentity(), convertToSql);
        }
        ClassDescriptor realCld = this.getRealClassDescriptor(cld, objectOrProxy);
        return this.getValuesForObject(realCld.getPkFields(), objectOrProxy, convertToSql);
    }

    public ValueContainer[] getKeyValues(ClassDescriptor cld, Identity oid) throws PersistenceBrokerException {
        return this.getKeyValues(cld, oid, true);
    }

    public ValueContainer[] getKeyValues(ClassDescriptor cld, Identity oid, boolean convertToSql) throws PersistenceBrokerException {
        FieldDescriptor[] pkFields = cld.getPkFields();
        ValueContainer[] result = new ValueContainer[pkFields.length];
        Object[] pkValues = oid.getPrimaryKeyValues();
        try {
            for (int i = 0; i < result.length; ++i) {
                FieldDescriptor fd = pkFields[i];
                Object cv = pkValues[i];
                if (convertToSql) {
                    cv = fd.getFieldConversion().javaToSql(cv);
                }
                result[i] = new ValueContainer(cv, fd.getJdbcType());
            }
        }
        catch (Exception e) {
            throw new PersistenceBrokerException("Can't generate primary key values for given Identity " + oid, e);
        }
        return result;
    }

    public ValueContainer[] getKeyValues(ClassDescriptor cld, Object objectOrProxy) throws PersistenceBrokerException {
        return this.getKeyValues(cld, objectOrProxy, true);
    }

    public boolean representsNull(FieldDescriptor fld, Object aValue) {
        if (aValue == null) {
            return true;
        }
        boolean result = false;
        if (aValue instanceof Number && ((Number)aValue).longValue() == 0L) {
            Class type = fld.getPersistentField().getType();
            if (type != null) {
                result = type.isPrimitive();
            }
        } else if (aValue instanceof String && ((String)aValue).length() == 0) {
            result = fld.isPrimaryKey();
        }
        return result;
    }

    public boolean hasNullPKField(ClassDescriptor cld, Object obj) {
        FieldDescriptor[] fields = cld.getPkFields();
        boolean hasNull = false;
        IndirectionHandler handler = ProxyHelper.getIndirectionHandler(obj);
        if (handler == null || handler.alreadyMaterialized()) {
            FieldDescriptor fld;
            if (handler != null) {
                obj = handler.getRealSubject();
            }
            for (int i = 0; i < fields.length && !(hasNull = this.representsNull(fld = fields[i], fld.getPersistentField().get(obj))); ++i) {
            }
        }
        return hasNull;
    }

    private Object setAutoIncrementValue(FieldDescriptor fd, Object obj) {
        PersistentField f = fd.getPersistentField();
        try {
            Object result = this.m_broker.serviceSequenceManager().getUniqueValue(fd);
            f.set(obj, result);
            return result;
        }
        catch (MetadataException e) {
            throw new PersistenceBrokerException("Error while trying to autoincrement field " + f.getDeclaringClass() + REPOSITORY_NAME_SEPARATOR + f.getName(), (Throwable)((Object)e));
        }
        catch (SequenceManagerException e) {
            throw new PersistenceBrokerException("Could not get key value", (Throwable)((Object)e));
        }
    }

    public ValueContainer[] getValuesForObject(FieldDescriptor[] fields, Object obj, boolean convertToSql, boolean assignAutoincrement) throws PersistenceBrokerException {
        ValueContainer[] result = new ValueContainer[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor fd = fields[i];
            Object cv = fd.getPersistentField().get(obj);
            if (assignAutoincrement && fd.isAutoIncrement() && this.representsNull(fd, cv)) {
                cv = this.setAutoIncrementValue(fd, obj);
            }
            if (convertToSql) {
                cv = fd.getFieldConversion().javaToSql(cv);
            }
            result[i] = new ValueContainer(cv, fd.getJdbcType());
        }
        return result;
    }

    public ValueContainer[] getValuesForObject(FieldDescriptor[] fields, Object obj, boolean convertToSql) throws PersistenceBrokerException {
        return this.getValuesForObject(fields, obj, convertToSql, false);
    }

    public ValueContainer[] getNonKeyRwValues(ClassDescriptor cld, Object obj) throws PersistenceBrokerException {
        return this.getValuesForObject(cld.getNonPkRwFields(), obj, true);
    }

    public ValueContainer[] getAllRwValues(ClassDescriptor cld, Object obj) throws PersistenceBrokerException {
        return this.getValuesForObject(cld.getAllRwFields(), obj, true);
    }

    public Object[] extractValueArray(ValueContainer[] containers) {
        Object[] result = new Object[containers.length];
        for (int i = 0; i < containers.length; ++i) {
            result[i] = containers[i].getValue();
        }
        return result;
    }

    public boolean assertValidPksForStore(FieldDescriptor[] fieldDescriptors, Object[] pkValues) {
        int fieldDescriptorSize = fieldDescriptors.length;
        for (int i = 0; i < fieldDescriptorSize; ++i) {
            FieldDescriptor fld = fieldDescriptors[i];
            if (fld.isAutoIncrement() || fld.isLocking() || !this.representsNull(fld, pkValues[i])) continue;
            return false;
        }
        return true;
    }

    public boolean assertValidPkForDelete(ClassDescriptor cld, Object obj) {
        if (!ProxyHelper.isProxy(obj)) {
            FieldDescriptor[] fieldDescriptors = cld.getPkFields();
            int fieldDescriptorSize = fieldDescriptors.length;
            for (int i = 0; i < fieldDescriptorSize; ++i) {
                FieldDescriptor fd = fieldDescriptors[i];
                Object pkValue = fd.getPersistentField().get(obj);
                if (!this.representsNull(fd, pkValue)) continue;
                return false;
            }
        }
        return true;
    }

    public Query getCountQuery(Query aQuery) {
        if (aQuery instanceof QueryBySQL) {
            return this.getQueryBySqlCount((QueryBySQL)aQuery);
        }
        if (aQuery instanceof ReportQueryByCriteria) {
            return this.getReportQueryByCriteriaCount((ReportQueryByCriteria)aQuery);
        }
        return this.getQueryByCriteriaCount((QueryByCriteria)aQuery);
    }

    private Query getQueryBySqlCount(QueryBySQL aQuery) {
        int orderPos;
        String countSql = aQuery.getSql();
        int fromPos = countSql.toUpperCase().indexOf(" FROM ");
        if (fromPos >= 0) {
            countSql = "select count(*)" + countSql.substring(fromPos);
        }
        if ((orderPos = countSql.toUpperCase().indexOf(" ORDER BY ")) >= 0) {
            countSql = countSql.substring(0, orderPos);
        }
        return new QueryBySQL(aQuery.getSearchClass(), countSql);
    }

    private Query getQueryByCriteriaCount(QueryByCriteria aQuery) {
        int idx;
        Class searchClass = aQuery.getSearchClass();
        ReportQueryByCriteria countQuery = null;
        Criteria countCrit = null;
        String[] columns = new String[1];
        if (aQuery.getCriteria() != null) {
            countCrit = aQuery.getCriteria().copy(false, false, false);
        }
        if (aQuery.isDistinct()) {
            FieldDescriptor[] pkFields = this.m_broker.getClassDescriptor(searchClass).getPkFields();
            String[] keyColumns = new String[pkFields.length];
            if (pkFields.length > 1) {
                for (idx = 0; idx < pkFields.length; ++idx) {
                    keyColumns[idx] = pkFields[idx].getColumnName();
                }
            } else {
                for (idx = 0; idx < pkFields.length; ++idx) {
                    keyColumns[idx] = pkFields[idx].getAttributeName();
                }
            }
            columns[0] = "count(distinct " + this.getPlatform().concatenate(keyColumns) + ")";
        } else {
            columns[0] = "count(*)";
        }
        if (aQuery instanceof MtoNQuery) {
            MtoNQuery mnQuery = (MtoNQuery)((Object)aQuery);
            ReportQueryByMtoNCriteria mnReportQuery = new ReportQueryByMtoNCriteria(searchClass, columns, countCrit);
            mnReportQuery.setIndirectionTable(mnQuery.getIndirectionTable());
            countQuery = mnReportQuery;
        } else {
            countQuery = new ReportQueryByCriteria(searchClass, columns, countCrit);
        }
        Iterator outerJoinPath = aQuery.getOuterJoinPaths().iterator();
        while (outerJoinPath.hasNext()) {
            String path = (String)outerJoinPath.next();
            if (!aQuery.isPathOuterJoin(path)) continue;
            countQuery.setPathOuterJoin(path);
        }
        List orderBy = aQuery.getOrderBy();
        if (orderBy != null && !orderBy.isEmpty()) {
            String[] joinAttributes = new String[orderBy.size()];
            for (idx = 0; idx < orderBy.size(); ++idx) {
                joinAttributes[idx] = ((FieldHelper)orderBy.get((int)idx)).name;
            }
            countQuery.setJoinAttributes(joinAttributes);
        }
        return countQuery;
    }

    private Query getReportQueryByCriteriaCount(ReportQueryByCriteria aQuery) {
        ReportQueryByCriteria countQuery = (ReportQueryByCriteria)this.getQueryByCriteriaCount(aQuery);
        countQuery.setJoinAttributes(aQuery.getAttributes());
        Iterator iter = aQuery.getGroupBy().iterator();
        while (iter.hasNext()) {
            countQuery.addGroupBy((FieldHelper)iter.next());
        }
        return countQuery;
    }

    private Platform getPlatform() {
        return this.m_broker.serviceSqlGenerator().getPlatform();
    }

    public boolean doesExist(ClassDescriptor cld, Identity oid, Object obj) {
        boolean result = false;
        String sql = (String)this.sqlSelectMap.get(cld);
        if (sql == null) {
            sql = new SqlExistStatement(cld, LoggerFactory.getDefaultLogger()).getStatement();
            this.sqlSelectMap.put(cld, sql);
        }
        ValueContainer[] pkValues = oid == null ? this.getKeyValues(cld, obj, true) : this.getKeyValues(cld, oid);
        StatementManagerIF sm = this.m_broker.serviceStatementManager();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = sm.getPreparedStatement(cld, sql, false, 1, false);
            sm.bindValues(stmt, pkValues, 1);
            rs = stmt.executeQuery();
            result = rs.next();
            sm.closeResources(stmt, rs);
        }
        catch (SQLException e) {
            try {
                throw ExceptionHelper.generateException("[BrokerHelper#doesExist] Can't check if specified object is already persisted", e, sql, cld, pkValues, null, obj);
            }
            catch (Throwable throwable) {
                sm.closeResources(stmt, rs);
                throw throwable;
            }
        }
        return result;
    }

    public void link(Object obj, boolean insert) {
        this.linkOrUnlink(true, obj, insert);
    }

    public void unlink(Object obj) {
        this.linkOrUnlink(false, obj, false);
    }

    private void linkOrUnlink(boolean doLink, Object obj, boolean insert) {
        Iterator descriptors;
        ClassDescriptor cld = this.m_broker.getDescriptorRepository().getDescriptorFor(obj.getClass());
        if (cld.getObjectReferenceDescriptors().size() > 0) {
            descriptors = cld.getObjectReferenceDescriptors().iterator();
            while (descriptors.hasNext()) {
                ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)descriptors.next();
                this.linkOrUnlinkOneToOne(doLink, obj, ord, insert);
            }
        }
        if (cld.getCollectionDescriptors().size() > 0) {
            descriptors = cld.getCollectionDescriptors().iterator();
            while (descriptors.hasNext()) {
                CollectionDescriptor cod = (CollectionDescriptor)descriptors.next();
                this.linkOrUnlinkXToMany(doLink, obj, cod, insert);
            }
        }
    }

    public void link(Object obj, ObjectReferenceDescriptor ord, boolean insert) {
        this.linkOrUnlink(true, obj, ord, insert);
    }

    public boolean link(Object obj, String attributeName, boolean insert) {
        return this.linkOrUnlink(true, obj, attributeName, insert);
    }

    public boolean link(Object obj, String attributeName, Object reference, boolean insert) {
        ClassDescriptor cld = this.m_broker.getDescriptorRepository().getDescriptorFor(ProxyHelper.getRealClass(obj));
        boolean match = false;
        ObjectReferenceDescriptor ord = cld.getObjectReferenceDescriptorByName(attributeName);
        if (ord != null) {
            this.linkOrUnlinkOneToOne(true, obj, ord, insert);
            match = true;
        } else {
            CollectionDescriptor cod = cld.getCollectionDescriptorByName(attributeName);
            if (cod != null) {
                this.linkOrUnlinkXToMany(true, obj, cod, insert);
                match = true;
            }
        }
        return match;
    }

    public boolean unlink(Object source, String attributeName, Object target) {
        return this.linkOrUnlink(false, source, attributeName, false);
    }

    public boolean unlink(Object source, String attributeName) {
        return this.linkOrUnlink(false, source, attributeName, false);
    }

    public void unlink(Object obj, ObjectReferenceDescriptor ord, boolean insert) {
        this.linkOrUnlink(false, obj, ord, insert);
    }

    private boolean linkOrUnlink(boolean doLink, Object obj, String attributeName, boolean insert) {
        boolean match = false;
        ClassDescriptor cld = this.m_broker.getDescriptorRepository().getDescriptorFor(ProxyHelper.getRealClass(obj));
        ObjectReferenceDescriptor ord = cld.getObjectReferenceDescriptorByName(attributeName);
        if (ord != null) {
            this.linkOrUnlinkOneToOne(doLink, obj, ord, insert);
            match = true;
        } else {
            CollectionDescriptor cod = cld.getCollectionDescriptorByName(attributeName);
            if (cod != null) {
                this.linkOrUnlinkXToMany(doLink, obj, cod, insert);
                match = true;
            }
        }
        return match;
    }

    private void linkOrUnlink(boolean doLink, Object obj, ObjectReferenceDescriptor ord, boolean insert) {
        if (ord instanceof CollectionDescriptor) {
            this.linkOrUnlinkXToMany(doLink, obj, (CollectionDescriptor)ord, insert);
        } else {
            this.linkOrUnlinkOneToOne(doLink, obj, ord, insert);
        }
    }

    private void linkOrUnlinkXToMany(boolean doLink, Object obj, CollectionDescriptor cod, boolean insert) {
        if (doLink) {
            if (cod.isMtoNRelation()) {
                this.m_broker.linkMtoN(obj, cod, insert);
            } else {
                this.m_broker.linkOneToMany(obj, cod, insert);
            }
        } else {
            this.m_broker.unlinkXtoN(obj, cod);
        }
    }

    private void linkOrUnlinkOneToOne(boolean doLink, Object obj, ObjectReferenceDescriptor ord, boolean insert) {
        ClassDescriptor cld = ord.getClassDescriptor();
        if (cld.isInterface()) {
            cld = this.m_broker.getDescriptorRepository().getDescriptorFor(ProxyHelper.getRealClass(obj));
        }
        if (doLink) {
            this.m_broker.linkOneToOne(obj, cld, ord, insert);
        } else {
            this.m_broker.unlinkFK(obj, cld, ord);
            ord.getPersistentField().set(obj, null);
        }
    }

    public void unlink(Object source, CollectionDescriptor cds, List referencesToUnlink) {
        for (int i = 0; i < referencesToUnlink.size(); ++i) {
            this.unlink(source, cds, referencesToUnlink.get(i));
        }
    }

    public void unlink(Object source, CollectionDescriptor cds, Object referenceToUnlink) {
        if (cds.isMtoNRelation()) {
            this.m_broker.deleteMtoNImplementor(new MtoNImplementor(cds, source, referenceToUnlink));
        } else {
            ClassDescriptor cld = this.m_broker.getClassDescriptor(referenceToUnlink.getClass());
            this.m_broker.unlinkFK(referenceToUnlink, cld, cds);
        }
    }

    public void link(Object source, CollectionDescriptor cds, List referencesToLink) {
        for (int i = 0; i < referencesToLink.size(); ++i) {
            this.link(source, cds, referencesToLink.get(i));
        }
    }

    public void link(Object source, CollectionDescriptor cds, Object referenceToLink) {
        if (cds.isMtoNRelation()) {
            this.m_broker.addMtoNImplementor(new MtoNImplementor(cds, source, referenceToLink));
        } else {
            ClassDescriptor cld = this.m_broker.getClassDescriptor(referenceToLink.getClass());
            this.m_broker.link(referenceToLink, cld, cds, source, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Iterator getCollectionIterator(Object collectionOrArray) {
        void var1_1;
        ArrayIterator colIterator;
        if (collectionOrArray instanceof ManageableCollection) {
            colIterator = ((ManageableCollection)collectionOrArray).ojbIterator();
        } else if (collectionOrArray instanceof Collection) {
            colIterator = ((Collection)collectionOrArray).iterator();
        } else if (collectionOrArray.getClass().isArray()) {
            colIterator = new ArrayIterator(collectionOrArray);
        } else {
            throw new OJBRuntimeException("Given object collection of type '" + (collectionOrArray != null ? collectionOrArray.getClass().toString() : "null") + "' can not be managed by OJB. Use Array, Collection or ManageableCollection instead!");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Object[] getCollectionArray(Object collectionOrArray) {
        void var1_1;
        Object[] result;
        if (collectionOrArray instanceof Collection) {
            result = ((Collection)collectionOrArray).toArray();
        } else if (collectionOrArray instanceof ManageableCollection) {
            ArrayList newCol = new ArrayList();
            CollectionUtils.addAll(newCol, (Iterator)((ManageableCollection)collectionOrArray).ojbIterator());
            result = newCol.toArray();
        } else if (collectionOrArray.getClass().isArray()) {
            result = (Object[])collectionOrArray;
        } else {
            throw new OJBRuntimeException("Given object collection of type '" + (collectionOrArray != null ? collectionOrArray.getClass().toString() : "null") + "' can not be managed by OJB. Use Array, Collection or ManageableCollection instead!");
        }
        return var1_1;
    }

    public static boolean hasAnonymousKeyReference(ClassDescriptor cld, ObjectReferenceDescriptor rds) {
        boolean result = false;
        FieldDescriptor[] fkFields = rds.getForeignKeyFieldDescriptors(cld);
        for (int i = 0; i < fkFields.length; ++i) {
            FieldDescriptor fkField = fkFields[i];
            if (!fkField.isAnonymous()) continue;
            result = true;
            break;
        }
        return result;
    }
}

