/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.Reader;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.JoinSyntaxTypes;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.query.LikeCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PlatformDefaultImpl
implements Platform,
JoinSyntaxTypes {
    protected Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$platforms$PlatformDefaultImpl == null ? (class$org$apache$ojb$broker$platforms$PlatformDefaultImpl = PlatformDefaultImpl.class$("org.apache.ojb.broker.platforms.PlatformDefaultImpl")) : class$org$apache$ojb$broker$platforms$PlatformDefaultImpl);
    private static final String INITIALIZATION_CHECK_AUTOCOMMIT = "initializationCheck";
    private static final String FALSE_STR = "false";
    protected boolean m_batchUpdatesChecked = false;
    protected boolean m_supportsBatchUpdates = false;
    static /* synthetic */ Class class$org$apache$ojb$broker$platforms$PlatformDefaultImpl;

    public boolean supportsBatchOperations() {
        return this.m_supportsBatchUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForBatchSupport(Connection conn) {
        if (!this.m_batchUpdatesChecked) {
            try {
                DatabaseMetaData meta = conn.getMetaData();
                this.m_supportsBatchUpdates = meta.supportsBatchUpdates();
            }
            catch (Throwable th) {
                this.log.info("Batch support check failed", th);
                this.m_supportsBatchUpdates = false;
            }
            finally {
                this.m_batchUpdatesChecked = true;
            }
        }
    }

    public void afterStatementCreate(Statement stmt) throws PlatformException {
    }

    public void beforeStatementClose(Statement stmt, ResultSet rs) throws PlatformException {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new PlatformException("Resultset closing failed", e);
            }
        }
    }

    public void afterStatementClose(Statement stmt, ResultSet rs) throws PlatformException {
    }

    public void beforeBatch(PreparedStatement stmt) throws PlatformException {
    }

    public void addBatch(PreparedStatement stmt) throws PlatformException {
        try {
            stmt.addBatch();
        }
        catch (SQLException e) {
            throw new PlatformException("Failure while calling 'addBatch' on given Statement object", e);
        }
    }

    public int[] executeBatch(PreparedStatement stmt) throws PlatformException {
        try {
            return stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new PlatformException("Failure while calling 'executeBatch' on given Statement object", e);
        }
    }

    public void initializeJdbcConnection(JdbcConnectionDescriptor jcd, Connection conn) throws PlatformException {
        if (jcd.getBatchMode()) {
            this.checkForBatchSupport(conn);
        }
        switch (jcd.getUseAutoCommit()) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    if (jcd.getAttribute(INITIALIZATION_CHECK_AUTOCOMMIT, FALSE_STR).equalsIgnoreCase(FALSE_STR) || conn.getAutoCommit()) break;
                    conn.setAutoCommit(true);
                }
                catch (SQLException e) {
                    if (!jcd.isIgnoreAutoCommitExceptions()) {
                        throw new PlatformException("Connection initializing: setAutoCommit(true) failed", e);
                    }
                    this.log.info("Connection initializing: setAutoCommit jdbc-driver problems. " + e.getMessage());
                }
                break;
            }
            case 2: {
                try {
                    if (!conn.getAutoCommit()) break;
                    conn.setAutoCommit(false);
                    break;
                }
                catch (SQLException e) {
                    if (!jcd.isIgnoreAutoCommitExceptions()) {
                        throw new PlatformException("Connection initializing: setAutoCommit(false) failed", e);
                    }
                    this.log.info("Connection initializing: setAutoCommit jdbc-driver problems. " + e.getMessage());
                }
            }
        }
    }

    public void changeAutoCommitState(JdbcConnectionDescriptor jcd, Connection con, boolean newState) {
        if (con == null) {
            this.log.error("Given m_connection was null, cannot prepare autoCommit state");
            return;
        }
        if (1 == jcd.getUseAutoCommit()) {
            try {
                con.setAutoCommit(newState);
            }
            catch (SQLException e) {
                if (jcd.isIgnoreAutoCommitExceptions()) {
                    this.log.info("Set autoCommit(" + newState + ") failed: " + e.getMessage());
                }
                this.log.error("Set autoCommit(" + newState + ") failed", e);
                throw new PersistenceBrokerException("Set autoCommit(false) failed", e);
            }
        }
    }

    public void setObjectForStatement(PreparedStatement ps, int index, Object value, int sqlType) throws SQLException {
        if (sqlType == -1 && value instanceof String) {
            String s = (String)value;
            ps.setCharacterStream(index, (Reader)new StringReader(s), s.length());
        } else if (sqlType == 3 || sqlType == 2) {
            ps.setObject(index, value);
        } else {
            ps.setObject(index, value, sqlType);
        }
    }

    public void setNullForStatement(PreparedStatement ps, int index, int sqlType) throws SQLException {
        ps.setNull(index, sqlType);
    }

    public byte getJoinSyntaxType() {
        return 0;
    }

    public boolean useCountForResultsetSize() {
        return false;
    }

    public String createSequenceQuery(String sequenceName, Properties prop) {
        return this.createSequenceQuery(sequenceName);
    }

    public String createSequenceQuery(String sequenceName) {
        throw new UnsupportedOperationException("This feature is not supported by this implementation");
    }

    public String nextSequenceQuery(String sequenceName) {
        throw new UnsupportedOperationException("This feature is not supported by this implementation");
    }

    public String dropSequenceQuery(String sequenceName) {
        throw new UnsupportedOperationException("This feature is not supported by this implementation");
    }

    public CallableStatement prepareNextValProcedureStatement(Connection con, String procedureName, String sequenceName) throws PlatformException {
        throw new UnsupportedOperationException("Not supported by this implementation");
    }

    public String getLastInsertIdentityQuery(String tableName) {
        throw new UnsupportedOperationException("This feature is not supported by this implementation");
    }

    public void addPagingSql(StringBuffer anSqlString) {
    }

    public boolean bindPagingParametersFirst() {
        return false;
    }

    public boolean supportsPaging() {
        return false;
    }

    public int bindPagingParameters(PreparedStatement ps, int index, int startAt, int endAt) throws SQLException {
        ps.setInt(index, startAt - 1);
        ps.setInt(++index, endAt - (startAt - 1));
        return ++index;
    }

    protected String getConcatenationCharacter() {
        return "||";
    }

    public boolean supportsMultiColumnCountDistinct() {
        return true;
    }

    public String concatenate(String[] theColumns) {
        if (theColumns.length == 1) {
            return theColumns[0];
        }
        StringBuffer buf = new StringBuffer();
        String concatChar = this.getConcatenationCharacter();
        for (int i = 0; i < theColumns.length; ++i) {
            if (i > 0) {
                buf.append(" ").append(concatChar).append(" ");
            }
            buf.append(theColumns[i]);
        }
        return buf.toString();
    }

    public String getEscapeClause(LikeCriteria aCriteria) {
        char escapeChar;
        String value = (String)aCriteria.getValue();
        if (value.indexOf(escapeChar = LikeCriteria.getEscapeCharacter()) >= 0) {
            return " ESCAPE '" + escapeChar + "'";
        }
        return "";
    }

    public void registerOutResultSet(CallableStatement stmt, int position) throws SQLException {
        stmt.registerOutParameter(position, 1111);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

