/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldBase;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;

public class PersistentFieldIntrospectorImpl
extends PersistentFieldBase {
    private static final long serialVersionUID = 8805309492150404444L;
    private Class type;
    private transient List propertyGraph;

    public PersistentFieldIntrospectorImpl() {
    }

    public PersistentFieldIntrospectorImpl(Class aClass, String aPropertyName) {
        super(aClass, aPropertyName);
    }

    public Class getType() {
        if (this.type == null) {
            this.type = this.getPropertyDescriptor().getPropertyType();
        }
        return this.type;
    }

    public void set(Object target, Object value) throws MetadataException {
        PropertyDescriptor pd;
        if (target == null) {
            return;
        }
        List propertyDescriptors = this.getPropertyGraph();
        int size = propertyDescriptors.size() - 1;
        for (int i = 0; i < size; ++i) {
            pd = (PropertyDescriptor)propertyDescriptors.get(i);
            Object attribute = this.getValueFrom(pd, target);
            if (attribute != null || value != null) {
                if (attribute == null) {
                    try {
                        attribute = ClassHelper.newInstance(pd.getPropertyType());
                    }
                    catch (Exception e) {
                        throw new MetadataException("Can't instantiate nested object of type '" + pd.getPropertyType() + "' for field '" + pd.getName() + "'", e);
                    }
                }
            } else {
                return;
            }
            this.setValueFor(pd, target, attribute);
            target = attribute;
        }
        pd = (PropertyDescriptor)propertyDescriptors.get(size);
        this.setValueFor(pd, target, value);
    }

    public Object get(Object target) throws MetadataException {
        PropertyDescriptor pd;
        List propertyDescriptors = this.getPropertyGraph();
        for (int i = 0; i < propertyDescriptors.size() && (target = this.getValueFrom(pd = (PropertyDescriptor)propertyDescriptors.get(i), target)) != null; ++i) {
        }
        return target;
    }

    private Object getValueFrom(PropertyDescriptor pd, Object target) {
        if (target == null) {
            return null;
        }
        Method m = pd.getReadMethod();
        if (m != null) {
            try {
                return m.invoke(ProxyHelper.getRealObject(target), null);
            }
            catch (Throwable e) {
                this.logProblem(pd, target, null, "Can't read value from given object");
                throw new MetadataException("Error invoking method:" + m.getName() + " in object " + target.getClass().getName(), e);
            }
        }
        throw new MetadataException("Can't get ReadMethod for property:" + pd.getName() + " in object " + target.getClass().getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setValueFor(PropertyDescriptor pd, Object target, Object value) {
        Method m = pd.getWriteMethod();
        Object[] args = new Object[]{value};
        if (m == null) throw new MetadataException("Can't get WriteMethod for property:" + pd.getName() + " in object:" + target.getClass().getName());
        try {
            if (value == null && m.getParameterTypes()[0].isPrimitive()) return;
            m.invoke(ProxyHelper.getRealObject(target), args);
            return;
        }
        catch (Throwable e) {
            this.logProblem(pd, target, value, "Can't set value on given object.");
            throw new MetadataException("Error invoking method:" + m.getName() + " in object:" + target.getClass().getName(), e);
        }
    }

    private List getPropertyGraph() {
        if (this.propertyGraph == null) {
            this.propertyGraph = this.buildPropertyGraph();
        }
        return this.propertyGraph;
    }

    private List buildPropertyGraph() {
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        String[] fields = StringUtils.split((String)this.getName(), (String)"::");
        PropertyDescriptor pd = null;
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i];
            pd = pd == null ? PersistentFieldIntrospectorImpl.findPropertyDescriptor(this.getDeclaringClass(), fieldName) : PersistentFieldIntrospectorImpl.findPropertyDescriptor(pd.getPropertyType(), fieldName);
            result.add(pd);
        }
        return result;
    }

    protected static PropertyDescriptor findPropertyDescriptor(Class aClass, String aPropertyName) {
        PropertyDescriptor descriptor = null;
        try {
            BeanInfo info = Introspector.getBeanInfo(aClass);
            PropertyDescriptor[] pd = info.getPropertyDescriptors();
            for (int i = 0; i < pd.length; ++i) {
                if (!pd[i].getName().equals(aPropertyName)) continue;
                descriptor = pd[i];
                break;
            }
            if (descriptor == null) {
                throw new MetadataException("Can't find property " + aPropertyName + " in " + aClass.getName());
            }
            return descriptor;
        }
        catch (IntrospectionException ex) {
            throw new MetadataException("Can't find property " + aPropertyName + " in " + aClass.getName(), ex);
        }
    }

    protected PropertyDescriptor getPropertyDescriptor() {
        return (PropertyDescriptor)this.getPropertyGraph().get(this.getPropertyGraph().size() - 1);
    }

    public boolean makeAccessible() {
        return false;
    }

    public boolean usesAccessorsAndMutators() {
        return true;
    }

    protected void logProblem(PropertyDescriptor pd, Object anObject, Object aValue, String msg) {
        Logger logger = this.getLog();
        logger.error("Error in [PersistentFieldPropertyImpl], " + msg);
        logger.error("Declaring class [" + this.getDeclaringClass().getName() + "]");
        logger.error("Property Name [" + this.getName() + "]");
        logger.error("Property Type [" + pd.getPropertyType().getName() + "]");
        if (anObject != null) {
            logger.error("anObject was class [" + anObject.getClass().getName() + "]");
        } else {
            logger.error("anObject was null");
        }
        if (aValue != null) {
            logger.error("aValue was class [" + aValue.getClass().getName() + "]");
        } else {
            logger.error("aValue was null");
        }
    }
}

