/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.AnonymousPersistentField;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldFactory;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class SuperReferenceDescriptor
extends ObjectReferenceDescriptor {
    private transient Logger log;
    public static final String SUPER_FIELD_INTERNAL_NAME = "ojbSuperFieldInternal";
    public static final String SUPER_FIELD_NAME = "super";
    private Boolean javaInheritance;
    private Map declaredInheritanceFields = new HashMap();
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$SuperReferenceDescriptor$SuperReferenceField;

    public SuperReferenceDescriptor(ClassDescriptor descriptor) {
        super(descriptor);
        super.setPersistentField(new SuperReferenceField(this));
        super.setLazy(false);
        super.setCascadeRetrieve(true);
        super.setCascadingStore(23);
        super.setCascadingDelete(23);
    }

    public boolean isSuperReferenceDescriptor() {
        return true;
    }

    public void setItemClass(Class c) {
        super.setItemClass(c);
        this.getClassDescriptor().setBaseClass(c.getName());
    }

    public void setPersistentField(Class c, String fieldname) {
    }

    public void setPersistentField(PersistentField pf) {
    }

    public void setLazy(boolean lazy) {
        this.getLog().info("Not allowed to change this property, will ignore setting");
    }

    public void setCascadeRetrieve(boolean b) {
        this.getLog().info("Not allowed to change this property, will ignore setting");
    }

    public void setCascadingStore(int cascade) {
        this.getLog().info("Not allowed to change this property, will ignore setting");
    }

    public void setCascadingStore(String value) {
        this.getLog().info("Not allowed to change this property, will ignore setting");
    }

    public void setCascadingDelete(int cascade) {
        this.getLog().info("Not allowed to change this property, will ignore setting");
    }

    public void setCascadingDelete(String value) {
        this.getLog().info("Not allowed to change this property, will ignore setting");
    }

    public void setCascadeStore(boolean cascade) {
        this.getLog().info("Not allowed to change this property, will ignore setting");
    }

    public void setCascadeDelete(boolean cascade) {
        this.getLog().info("Not allowed to change this property, will ignore setting");
    }

    public SuperReferenceField getInheritanceField() {
        return (SuperReferenceField)this.getPersistentField();
    }

    public boolean isJavaInheritance() {
        if (this.javaInheritance == null) {
            this.javaInheritance = this.getClassDescriptor().getSuperClassDescriptor().getClassOfObject().isAssignableFrom(this.getClassDescriptor().getClassOfObject()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.javaInheritance;
    }

    synchronized PersistentField getDeclaredInheritanceField(Class target, String name) {
        PersistentField pf;
        HashMap<String, PersistentField> fields = (HashMap<String, PersistentField>)this.declaredInheritanceFields.get(target);
        if (fields == null) {
            fields = new HashMap<String, PersistentField>();
            this.declaredInheritanceFields.put(target, fields);
        }
        if ((pf = (PersistentField)fields.get(name)) == null) {
            pf = PersistentFieldFactory.createPersistentField(target, name);
            fields.put(name, pf);
        }
        return pf;
    }

    private Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$SuperReferenceDescriptor$SuperReferenceField == null ? (class$org$apache$ojb$broker$metadata$SuperReferenceDescriptor$SuperReferenceField = SuperReferenceDescriptor.class$("org.apache.ojb.broker.metadata.SuperReferenceDescriptor$SuperReferenceField")) : class$org$apache$ojb$broker$metadata$SuperReferenceDescriptor$SuperReferenceField);
        }
        return this.log;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class SuperReferenceField
    extends AnonymousPersistentField {
        private transient Logger log;
        private SuperReferenceDescriptor superRef;

        public SuperReferenceField(SuperReferenceDescriptor superRef) {
            super(SuperReferenceDescriptor.SUPER_FIELD_INTERNAL_NAME);
            this.superRef = superRef;
        }

        private Logger getLog() {
            if (this.log == null) {
                this.log = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$SuperReferenceDescriptor$SuperReferenceField == null ? (class$org$apache$ojb$broker$metadata$SuperReferenceDescriptor$SuperReferenceField = SuperReferenceDescriptor.class$("org.apache.ojb.broker.metadata.SuperReferenceDescriptor$SuperReferenceField")) : class$org$apache$ojb$broker$metadata$SuperReferenceDescriptor$SuperReferenceField);
            }
            return this.log;
        }

        public synchronized void set(Object target, Object value) throws MetadataException {
            ClassDescriptor superCld = this.superRef.getClassDescriptor().getSuperClassDescriptor();
            if (this.superRef.isJavaInheritance()) {
                this.copyFields(superCld, target, superCld, value, true, true);
            } else {
                this.copyFields(this.superRef.getClassDescriptor(), target, superCld, value, false, false);
            }
        }

        public synchronized Object get(Object obj) throws MetadataException {
            if (obj == null) {
                return null;
            }
            if (this.superRef.isJavaInheritance()) {
                return obj;
            }
            return this.getObjectWithDeclaredSuperClass(obj);
        }

        private Object getObjectWithDeclaredSuperClass(Object obj) {
            Object value = this.getFromFieldCache(obj);
            if (value == null) {
                ClassDescriptor baseCld = null;
                try {
                    baseCld = this.superRef.getClassDescriptor().getSuperClassDescriptor();
                    value = ClassHelper.buildNewObjectInstance(baseCld);
                }
                catch (Exception e) {
                    throw new MetadataException("Can't create new base class object for '" + (baseCld != null ? baseCld.getClassNameOfObject() : null) + "'", e);
                }
                this.copyFields(baseCld, value, this.superRef.getClassDescriptor(), obj, true, false);
                this.putToFieldCache(obj, value);
            }
            return value;
        }

        void copyFields(ClassDescriptor targetCld, Object target, ClassDescriptor sourceCld, Object source, boolean targetIsSuper, boolean javaInheritance) {
            PersistentField pf;
            int i;
            if (this.getLog().isDebugEnabled()) {
                String msg = "Copy fields from " + SystemUtils.LINE_SEPARATOR + "source object '" + (source != null ? source.getClass().getName() : null) + "'" + SystemUtils.LINE_SEPARATOR + "using source fields declared in '" + sourceCld.getClassNameOfObject() + "'" + SystemUtils.LINE_SEPARATOR + "to target object '" + (target != null ? target.getClass().getName() : null) + "'" + SystemUtils.LINE_SEPARATOR + "using target fields declared in '" + targetCld.getClassNameOfObject() + "'" + SystemUtils.LINE_SEPARATOR + "the fields to copy are declared in '" + (targetIsSuper ? targetCld.getClassNameOfObject() : sourceCld.getClassNameOfObject()) + "' class" + SystemUtils.LINE_SEPARATOR + "the used classes are associated by java inheritance: " + javaInheritance + SystemUtils.LINE_SEPARATOR;
                this.getLog().debug(msg);
            }
            FieldDescriptor[] fields = targetIsSuper ? targetCld.getFieldDescriptions() : sourceCld.getFieldDescriptions();
            for (int i2 = 0; i2 < fields.length; ++i2) {
                FieldDescriptor field = fields[i2];
                if (field.isAnonymous()) continue;
                this.performFieldCopy(target, targetCld, source, sourceCld, field.getPersistentField(), targetIsSuper, javaInheritance);
            }
            Vector refs = targetIsSuper ? targetCld.getCollectionDescriptors() : sourceCld.getCollectionDescriptors();
            for (i = 0; i < refs.size(); ++i) {
                CollectionDescriptor col = (CollectionDescriptor)refs.get(i);
                pf = col.getPersistentField();
                this.performFieldCopy(target, targetCld, source, sourceCld, pf, targetIsSuper, javaInheritance);
            }
            refs = targetIsSuper ? targetCld.getObjectReferenceDescriptors() : sourceCld.getObjectReferenceDescriptors();
            for (i = 0; i < refs.size(); ++i) {
                ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)refs.get(i);
                pf = ord.getPersistentField();
                this.performFieldCopy(target, targetCld, source, sourceCld, pf, targetIsSuper, javaInheritance);
            }
        }

        private void performFieldCopy(Object target, ClassDescriptor targetCld, Object source, ClassDescriptor sourceCld, PersistentField pf, boolean targetIsSuper, boolean javaInheritance) {
            if (javaInheritance) {
                pf.set(target, pf.get(source));
            } else if (targetIsSuper) {
                if (pf instanceof SuperReferenceField) {
                    this.log.error("Declared inheritance doesn't support nested super references, target '" + targetCld.getClassNameOfObject() + "' has super reference");
                } else {
                    PersistentField tmp = this.superRef.getDeclaredInheritanceField(sourceCld.getClassOfObject(), pf.getName());
                    pf.set(target, tmp.get(source));
                }
            } else {
                PersistentField tmp = this.superRef.getDeclaredInheritanceField(targetCld.getClassOfObject(), pf.getName());
                tmp.set(target, pf.get(source));
            }
        }
    }
}

