/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import org.apache.ojb.broker.metadata.RepositoryElements;
import org.apache.ojb.broker.util.DoubleHashtable;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class RepositoryTags
implements RepositoryElements {
    private DoubleHashtable table = new DoubleHashtable();
    private static RepositoryTags instance = new RepositoryTags();

    private RepositoryTags() {
        this.table.put("descriptor-repository", new Integer(0));
        this.table.put("version", new Integer(67));
        this.table.put("isolation-level", new Integer(34));
        this.table.put("jdbc-connection-descriptor", new Integer(1));
        this.table.put("platform", new Integer(2));
        this.table.put("schema", new Integer(5));
        this.table.put("jcd-alias", new Integer(82));
        this.table.put("default-connection", new Integer(80));
        this.table.put("driver", new Integer(6));
        this.table.put("protocol", new Integer(7));
        this.table.put("subprotocol", new Integer(8));
        this.table.put("dbalias", new Integer(9));
        this.table.put("username", new Integer(10));
        this.table.put("password", new Integer(11));
        this.table.put("eager-release", new Integer(74));
        this.table.put("batch-mode", new Integer(83));
        this.table.put("useAutoCommit", new Integer(90));
        this.table.put("ignoreAutoCommitExceptions", new Integer(91));
        this.table.put("class-descriptor", new Integer(12));
        this.table.put("class", new Integer(13));
        this.table.put("proxy", new Integer(35));
        this.table.put("extent-class", new Integer(33));
        this.table.put("extends", new Integer(76));
        this.table.put("table", new Integer(14));
        this.table.put("orderby", new Integer(36));
        this.table.put("conversion", new Integer(30));
        this.table.put("row-reader", new Integer(32));
        this.table.put("field-descriptor", new Integer(15));
        this.table.put("name", new Integer(16));
        this.table.put("column", new Integer(17));
        this.table.put("jdbc-type", new Integer(18));
        this.table.put("primarykey", new Integer(19));
        this.table.put("autoincrement", new Integer(31));
        this.table.put("sequence-name", new Integer(77));
        this.table.put("nullable", new Integer(50));
        this.table.put("indexed", new Integer(51));
        this.table.put("length", new Integer(52));
        this.table.put("precision", new Integer(53));
        this.table.put("scale", new Integer(54));
        this.table.put("access", new Integer(99));
        this.table.put("reference-descriptor", new Integer(20));
        this.table.put("class-ref", new Integer(22));
        this.table.put("foreignkey", new Integer(49));
        this.table.put("auto-retrieve", new Integer(24));
        this.table.put("auto-update", new Integer(25));
        this.table.put("auto-delete", new Integer(26));
        this.table.put("collection-descriptor", new Integer(27));
        this.table.put("element-class-ref", new Integer(29));
        this.table.put("inverse-foreignkey", new Integer(38));
        this.table.put("collection-class", new Integer(37));
        this.table.put("indirection-table", new Integer(39));
        this.table.put("fk-pointing-to-element-class", new Integer(40));
        this.table.put("fk-pointing-to-this-class", new Integer(41));
        this.table.put("jndi-datasource-name", new Integer(44));
        this.table.put("jdbc-level", new Integer(45));
        this.table.put("locking", new Integer(46));
        this.table.put("update-lock", new Integer(98));
        this.table.put("refresh", new Integer(47));
        this.table.put("proxy", new Integer(48));
        this.table.put("sort", new Integer(3));
        this.table.put("otm-dependent", new Integer(102));
        this.table.put("index-descriptor", new Integer(94));
        this.table.put("index-column", new Integer(95));
        this.table.put("unique", new Integer(96));
        this.table.put("name", new Integer(97));
        this.table.put("maxActive", new Integer(55));
        this.table.put("maxIdle", new Integer(56));
        this.table.put("maxWait", new Integer(57));
        this.table.put("minEvictableIdleTimeMillis", new Integer(58));
        this.table.put("numTestsPerEvictionRun", new Integer(59));
        this.table.put("testOnBorrow", new Integer(60));
        this.table.put("testOnReturn", new Integer(61));
        this.table.put("testWhileIdle", new Integer(62));
        this.table.put("timeBetweenEvictionRunsMillis", new Integer(63));
        this.table.put("whenExhaustedAction", new Integer(64));
        this.table.put("validationQuery", new Integer(79));
        this.table.put("logAbandoned", new Integer(87));
        this.table.put("removeAbandoned", new Integer(85));
        this.table.put("removeAbandonedTimeout", new Integer(86));
        this.table.put("connectionFactory", new Integer(66));
        this.table.put("connection-pool", new Integer(65));
        this.table.put("class-ref", new Integer(68));
        this.table.put("id", new Integer(69));
        this.table.put("field-id-ref", new Integer(70));
        this.table.put("field-ref", new Integer(84));
        this.table.put("attribute", new Integer(71));
        this.table.put("attribute-name", new Integer(72));
        this.table.put("attribute-value", new Integer(73));
        this.table.put("documentation", new Integer(75));
        this.table.put("accept-locks", new Integer(78));
        this.table.put("sequence-manager", new Integer(88));
        this.table.put("className", new Integer(89));
        this.table.put("query-customizer", new Integer(92));
        this.table.put("initialization-method", new Integer(93));
        this.table.put("factory-class", new Integer(100));
        this.table.put("factory-method", new Integer(101));
        this.table.put("insert-procedure", new Integer(103));
        this.table.put("update-procedure", new Integer(104));
        this.table.put("delete-procedure", new Integer(105));
        this.table.put("constant-argument", new Integer(106));
        this.table.put("runtime-argument", new Integer(107));
        this.table.put("return", new Integer(111));
        this.table.put("value", new Integer(112));
        this.table.put("return-field-ref", new Integer(108));
        this.table.put("include-pk-only", new Integer(110));
        this.table.put("include-all-fields", new Integer(109));
        this.table.put("object-cache", new Integer(113));
        this.table.put("proxy-prefetching-limit", new Integer(114));
    }

    public static RepositoryTags getInstance() {
        return instance;
    }

    public String getTagById(int elementId) {
        return (String)this.table.getKeyByValue(new Integer(elementId));
    }

    public String getOpeningTagById(int elementId) {
        return "<" + this.table.getKeyByValue(new Integer(elementId)) + ">";
    }

    public String getOpeningTagNonClosingById(int elementId) {
        return "<" + this.table.getKeyByValue(new Integer(elementId));
    }

    public String getOpeningTagById(int elementId, String attributes) {
        return "<" + this.table.getKeyByValue(new Integer(elementId)) + " " + attributes + ">";
    }

    public String getAttribute(int elementId, String value) {
        return this.table.getKeyByValue(new Integer(elementId)) + "=\"" + value + "\"";
    }

    public String getClosingTagById(int elementId) {
        return "</" + this.table.getKeyByValue(new Integer(elementId)) + ">";
    }

    public int getIdByTag(String tag) {
        Integer value = (Integer)this.table.getValueByKey(tag);
        if (value == null) {
            LoggerFactory.getDefaultLogger().error("** " + this.getClass().getName() + ": Tag '" + tag + "' is not defined. **");
        }
        return value;
    }

    public String getCompleteTagById(int elementId, String characters) {
        String result = this.getOpeningTagById(elementId);
        result = result + characters;
        result = result + this.getClosingTagById(elementId);
        return result;
    }
}

