/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.util.XmlHelper;
import org.apache.ojb.broker.util.pooling.PoolConfiguration;

public class ConnectionPoolDescriptor
extends PoolConfiguration
implements Serializable,
XmlCapable {
    private static final long serialVersionUID = -3071461685659671879L;
    public static final String JDBC_PROPERTY_NAME_PREFIX = "jdbc.";
    private static final int JDBC_PROPERTY_NAME_LENGTH = "jdbc.".length();
    public static final String DBCP_PROPERTY_NAME_PREFIX = "dbcp.";
    private static final int DBCP_PROPERTY_NAME_LENGTH = "dbcp.".length();
    protected Properties jdbcProperties;
    protected Properties dbcpProperties;
    public static final String FETCH_SIZE = "fetchSize";
    private Class connectionFactory;

    public ConnectionPoolDescriptor() {
        this.init();
    }

    private void init() {
        this.jdbcProperties = new Properties();
        this.dbcpProperties = new Properties();
        this.setFetchSize(0);
        this.setTestOnBorrow(true);
        this.setTestOnReturn(false);
        this.setTestWhileIdle(false);
        this.setLogAbandoned(false);
        this.setRemoveAbandoned(false);
    }

    public Class getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(Class connectionFactory) {
        if (connectionFactory == null) {
            throw new MetadataException("Given ConnectionFactory was null");
        }
        this.connectionFactory = connectionFactory;
    }

    public int getFetchSize() {
        return Integer.parseInt(this.getProperty(FETCH_SIZE));
    }

    public void setFetchSize(int fetchSize) {
        this.setProperty(FETCH_SIZE, Integer.toString(fetchSize));
    }

    public Properties getJdbcProperties() {
        return this.jdbcProperties;
    }

    public Properties getDbcpProperties() {
        return this.dbcpProperties;
    }

    public void addAttribute(String attributeName, String attributeValue) {
        if (attributeName != null && attributeName.startsWith(JDBC_PROPERTY_NAME_PREFIX)) {
            String jdbcPropertyName = attributeName.substring(JDBC_PROPERTY_NAME_LENGTH);
            this.jdbcProperties.setProperty(jdbcPropertyName, attributeValue);
        } else if (attributeName != null && attributeName.startsWith(DBCP_PROPERTY_NAME_PREFIX)) {
            String dbcpPropertyName = attributeName.substring(DBCP_PROPERTY_NAME_LENGTH);
            this.dbcpProperties.setProperty(dbcpPropertyName, attributeValue);
        } else {
            super.addAttribute(attributeName, attributeValue);
        }
    }

    public String toXML() {
        RepositoryTags tags = RepositoryTags.getInstance();
        String eol = SystemUtils.LINE_SEPARATOR;
        StringBuffer buf = new StringBuffer();
        buf.append("      ").append(tags.getOpeningTagById(65)).append(eol);
        buf.append("         " + tags.getAttribute(55, "" + this.getMaxActive()) + eol);
        buf.append("         " + tags.getAttribute(56, "" + this.getMaxIdle()) + eol);
        buf.append("         " + tags.getAttribute(57, "" + this.getMaxWait()) + eol);
        buf.append("         " + tags.getAttribute(58, "" + this.getMinEvictableIdleTimeMillis()) + eol);
        buf.append("         " + tags.getAttribute(59, "" + this.getNumTestsPerEvictionRun()) + eol);
        buf.append("         " + tags.getAttribute(60, "" + this.isTestOnBorrow()) + eol);
        buf.append("         " + tags.getAttribute(61, "" + this.isTestOnReturn()) + eol);
        buf.append("         " + tags.getAttribute(62, "" + this.isTestWhileIdle()) + eol);
        buf.append("         " + tags.getAttribute(63, "" + this.getTimeBetweenEvictionRunsMillis()) + eol);
        buf.append("         " + tags.getAttribute(64, "" + this.getWhenExhaustedAction()) + eol);
        buf.append("         " + tags.getAttribute(79, "" + this.getValidationQuery()) + eol);
        buf.append("         " + tags.getAttribute(87, "" + this.isLogAbandoned()) + eol);
        buf.append("         " + tags.getAttribute(85, "" + this.isRemoveAbandoned()) + eol);
        buf.append("         " + tags.getAttribute(86, "" + this.getRemoveAbandonedTimeout()) + eol);
        buf.append("         <!-- ");
        buf.append(eol);
        buf.append("         Add JDBC-level properties here, like fetchSize.");
        buf.append("         Attributes with name prefix \"jdbc.\" are passed directly to the JDBC driver.");
        buf.append(eol);
        buf.append("         e.g. <attribute attribute-name=\"fetchSize\" attribute-value=\"100\"/>");
        buf.append(eol);
        buf.append("         -->");
        XmlHelper.appendSerializedAttributes(buf, "         ", this);
        buf.append("      ").append(tags.getClosingTagById(65)).append(eol);
        return buf.toString();
    }
}

