/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PBLifeCycleEvent;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.accesslayer.PagingIterator;
import org.apache.ojb.broker.accesslayer.PlainPrefetcher;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcher;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyListener;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.MaterializationListener;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class QueryReferenceBroker {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$QueryReferenceBroker == null ? (class$org$apache$ojb$broker$core$QueryReferenceBroker = QueryReferenceBroker.class$("org.apache.ojb.broker.core.QueryReferenceBroker")) : class$org$apache$ojb$broker$core$QueryReferenceBroker);
    private PersistenceBrokerImpl pb;
    private HashMap m_retrievalTasks;
    private ArrayList prefetchingListeners;
    private final boolean batchRetrieval = true;
    private final boolean prefetchProxies = true;
    private Class classToPrefetch;
    private PBLifeCycleEvent afterLookupEvent;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$QueryReferenceBroker;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareCollection;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$ManageableArrayList;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareList;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareSet;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$ManageableHashSet;
    static /* synthetic */ Class class$org$apache$ojb$broker$ManageableCollection;

    public QueryReferenceBroker(PersistenceBrokerImpl pb) {
        this.pb = pb;
        this.afterLookupEvent = new PBLifeCycleEvent(pb, PBLifeCycleEvent.Type.AFTER_LOOKUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManageableCollection getCollectionByQuery(Class collectionClass, Class itemClass, Query query) throws ClassNotPersistenceCapableException, PersistenceBrokerException {
        boolean isRetrievalTasksCreated;
        if (this.log.isDebugEnabled()) {
            this.log.debug("getCollectionByQuery (" + collectionClass + ", " + itemClass + ", " + query + ")");
        }
        ClassDescriptor cld = this.pb.getClassDescriptor(itemClass);
        ManageableCollection result = null;
        OJBIterator iter = null;
        int fullSize = -1;
        int size = 0;
        boolean bl = isRetrievalTasksCreated = this.m_retrievalTasks == null;
        if (isRetrievalTasksCreated) {
            this.m_retrievalTasks = new HashMap();
        }
        this.pb.getInternalCache().enableMaterializationCache();
        try {
            try {
                result = (ManageableCollection)collectionClass.newInstance();
                iter = this.pb.getIteratorFromQuery(query, cld);
                iter.disableLifeCycleEvents();
                if (iter instanceof PagingIterator) {
                    fullSize = iter.fullSize();
                }
                while (iter.hasNext()) {
                    Object candidate = iter.next();
                    if (candidate == null) continue;
                    IndirectionHandler handler = ProxyHelper.getIndirectionHandler(candidate);
                    if (handler != null || itemClass.isAssignableFrom(candidate.getClass())) {
                        result.ojbAdd(candidate);
                        ++size;
                    } else {
                        this.log.warn("Candidate object [" + candidate + "] class [" + candidate.getClass().getName() + "] is not a subtype of [" + itemClass.getName() + "] or any type of proxy. NOT INCLUDED in result collection");
                    }
                    if (handler == null || cld.getProxyPrefetchingLimit() <= 0 || !this.addRetrievalTask(candidate, this)) continue;
                    new PBMaterializationListener(candidate, this.m_retrievalTasks, this, cld.getProxyPrefetchingLimit());
                }
                if (isRetrievalTasksCreated) {
                    Class saveClassToPrefetch = this.classToPrefetch;
                    this.classToPrefetch = null;
                    try {
                        this.performRetrievalTasks();
                    }
                    finally {
                        this.classToPrefetch = saveClassToPrefetch;
                    }
                }
                Iterator resultIter = result.ojbIterator();
                while (resultIter.hasNext()) {
                    Object obj = resultIter.next();
                    this.afterLookupEvent.setTarget(obj);
                    this.pb.fireBrokerEvent(this.afterLookupEvent);
                    this.afterLookupEvent.setTarget(null);
                }
                this.pb.getInternalCache().disableMaterializationCache();
            }
            catch (RuntimeException e) {
                this.pb.getInternalCache().doLocalClear();
                throw e;
            }
            catch (Exception ex) {
                this.pb.getInternalCache().doLocalClear();
                this.log.error(ex);
                throw new PersistenceBrokerException(ex);
            }
            Object var14_15 = null;
            if (iter != null) {
                iter.releaseDbResources();
            }
            if (isRetrievalTasksCreated) {
                this.m_retrievalTasks = null;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (iter != null) {
                iter.releaseDbResources();
            }
            if (isRetrievalTasksCreated) {
                this.m_retrievalTasks = null;
            }
            throw throwable;
        }
        if (fullSize < 0) {
            fullSize = size;
        }
        query.fullSize(fullSize);
        return result;
    }

    public ManageableCollection getCollectionByQuery(Class collectionClass, Query query, boolean lazy) throws PersistenceBrokerException {
        try {
            ManageableCollection result = query == null ? (ManageableCollection)collectionClass.newInstance() : (lazy ? this.pb.getProxyFactory().createCollectionProxy(this.pb.getPBKey(), query, collectionClass) : this.getCollectionByQuery(collectionClass, query.getSearchClass(), query));
            return result;
        }
        catch (Exception e) {
            if (e instanceof PersistenceBrokerException) {
                throw (PersistenceBrokerException)((Object)e);
            }
            throw new PersistenceBrokerException(e);
        }
    }

    public Collection getCollectionByQuery(Query query, boolean lazy) throws PersistenceBrokerException {
        return (Collection)((Object)this.getCollectionByQuery(class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection, query, lazy));
    }

    /*
     * WARNING - void declaration
     */
    private Class getCollectionTypeClass(CollectionDescriptor cds) throws PersistenceBrokerException {
        void var3_3;
        Class collType;
        Class fieldType = cds.getPersistentField().getType();
        if (fieldType.isArray() || fieldType.isAssignableFrom(class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection)) {
            Class clazz = cds.isMtoNRelation() ? (class$org$apache$ojb$broker$util$collections$ManageableArrayList == null ? (class$org$apache$ojb$broker$util$collections$ManageableArrayList = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.ManageableArrayList")) : class$org$apache$ojb$broker$util$collections$ManageableArrayList) : (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection);
            collType = clazz;
        } else if (fieldType.isAssignableFrom(class$org$apache$ojb$broker$util$collections$RemovalAwareList == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareList = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareList")) : class$org$apache$ojb$broker$util$collections$RemovalAwareList)) {
            Class clazz = cds.isMtoNRelation() ? (class$org$apache$ojb$broker$util$collections$ManageableArrayList == null ? (class$org$apache$ojb$broker$util$collections$ManageableArrayList = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.ManageableArrayList")) : class$org$apache$ojb$broker$util$collections$ManageableArrayList) : (class$org$apache$ojb$broker$util$collections$RemovalAwareList == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareList = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareList")) : class$org$apache$ojb$broker$util$collections$RemovalAwareList);
            collType = clazz;
        } else if (fieldType.isAssignableFrom(class$org$apache$ojb$broker$util$collections$RemovalAwareSet == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareSet = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareSet")) : class$org$apache$ojb$broker$util$collections$RemovalAwareSet)) {
            Class clazz = cds.isMtoNRelation() ? (class$org$apache$ojb$broker$util$collections$ManageableHashSet == null ? (class$org$apache$ojb$broker$util$collections$ManageableHashSet = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.ManageableHashSet")) : class$org$apache$ojb$broker$util$collections$ManageableHashSet) : (class$org$apache$ojb$broker$util$collections$RemovalAwareSet == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareSet = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareSet")) : class$org$apache$ojb$broker$util$collections$RemovalAwareSet);
            collType = clazz;
        } else if ((class$org$apache$ojb$broker$ManageableCollection == null ? (class$org$apache$ojb$broker$ManageableCollection = QueryReferenceBroker.class$("org.apache.ojb.broker.ManageableCollection")) : class$org$apache$ojb$broker$ManageableCollection).isAssignableFrom(fieldType)) {
            collType = fieldType;
        } else {
            throw new MetadataException("Cannot determine a default collection type for collection " + cds.getAttributeName() + " in type " + cds.getClassDescriptor().getClassNameOfObject());
        }
        return var3_3;
    }

    private boolean addRetrievalTask(Object obj, Object key) {
        ArrayList<Object> owners = (ArrayList<Object>)this.m_retrievalTasks.get(key);
        boolean isFirst = false;
        if (owners == null) {
            owners = new ArrayList<Object>();
            this.m_retrievalTasks.put(key, owners);
            isFirst = true;
        }
        owners.add(obj);
        return isFirst;
    }

    public void performRetrievalTasks() {
        if (this.m_retrievalTasks == null) {
            return;
        }
        while (this.m_retrievalTasks.size() > 0) {
            HashMap tmp = this.m_retrievalTasks;
            this.m_retrievalTasks = new HashMap();
            Iterator it = tmp.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                if (!(key instanceof ObjectReferenceDescriptor)) continue;
                ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)key;
                ArrayList owners = (ArrayList)entry.getValue();
                if (ord.isLazy() || ord.getItemProxyClass() != null) continue;
                RelationshipPrefetcher prefetcher = this.pb.getRelationshipPrefetcherFactory().createRelationshipPrefetcher(ord);
                prefetcher.prefetchRelationship(owners);
                it.remove();
            }
        }
    }

    public void retrieveReference(Object obj, ClassDescriptor cld, ObjectReferenceDescriptor rds, boolean forced) {
        Object refObj = null;
        if (forced || rds.getCascadeRetrieve()) {
            this.pb.getInternalCache().enableMaterializationCache();
            try {
                Identity id = this.getReferencedObjectIdentity(obj, rds, cld);
                boolean isRefObjDefined = true;
                if (id == null) {
                    refObj = null;
                } else if (this.pb.serviceObjectCache().lookup(id) != null) {
                    refObj = this.pb.doGetObjectByIdentity(id);
                    if (rds.isSuperReferenceDescriptor()) {
                        ClassDescriptor superCld = cld.getRepository().getDescriptorFor(rds.getItemClass());
                        this.retrieveReferences(refObj, superCld, false);
                        this.retrieveCollections(refObj, superCld, false);
                    }
                } else if (this.m_retrievalTasks != null && !rds.isLazy() && rds.getItemProxyClass() == null) {
                    this.addRetrievalTask(obj, rds);
                    isRefObjDefined = false;
                } else {
                    refObj = this.getReferencedObject(id, rds);
                }
                if (isRefObjDefined) {
                    IndirectionHandler handler;
                    PersistentField refField = rds.getPersistentField();
                    refField.set(obj, refObj);
                    if (refObj != null && this.m_retrievalTasks != null && rds.getProxyPrefetchingLimit() > 0 && (handler = ProxyHelper.getIndirectionHandler(refObj)) != null && this.addRetrievalTask(obj, rds)) {
                        new PBMaterializationListener(obj, this.m_retrievalTasks, rds, rds.getProxyPrefetchingLimit());
                    }
                }
                this.pb.getInternalCache().disableMaterializationCache();
            }
            catch (RuntimeException e) {
                this.pb.getInternalCache().doLocalClear();
                throw e;
            }
        }
    }

    public void retrieveProxyReference(Object obj, ClassDescriptor cld, ObjectReferenceDescriptor rds, boolean forced) {
        Object refObj = null;
        this.pb.getInternalCache().enableMaterializationCache();
        try {
            IndirectionHandler handler;
            Identity id = this.getReferencedObjectIdentity(obj, rds, cld);
            if (id != null) {
                refObj = this.pb.createProxy(rds.getItemClass(), id);
            }
            PersistentField refField = rds.getPersistentField();
            refField.set(obj, refObj);
            if (refObj != null && this.m_retrievalTasks != null && rds.getProxyPrefetchingLimit() > 0 && (handler = ProxyHelper.getIndirectionHandler(refObj)) != null && this.addRetrievalTask(obj, rds)) {
                new PBMaterializationListener(obj, this.m_retrievalTasks, rds, rds.getProxyPrefetchingLimit());
            }
            this.pb.getInternalCache().disableMaterializationCache();
        }
        catch (RuntimeException e) {
            this.pb.getInternalCache().doLocalClear();
            throw e;
        }
    }

    public void retrieveReferences(Object newObj, ClassDescriptor cld, boolean forced) throws PersistenceBrokerException {
        Iterator i = cld.getObjectReferenceDescriptors().iterator();
        Class saveClassToPrefetch = this.classToPrefetch;
        this.classToPrefetch = null;
        this.pb.getInternalCache().enableMaterializationCache();
        try {
            while (i.hasNext()) {
                ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
                this.retrieveReference(newObj, cld, rds, forced);
            }
            this.pb.getInternalCache().disableMaterializationCache();
        }
        catch (RuntimeException e) {
            this.pb.getInternalCache().doLocalClear();
            throw e;
        }
        finally {
            this.classToPrefetch = saveClassToPrefetch;
        }
    }

    public void retrieveProxyReferences(Object newObj, ClassDescriptor cld, boolean forced) throws PersistenceBrokerException {
        Iterator i = cld.getObjectReferenceDescriptors().iterator();
        Class saveClassToPrefetch = this.classToPrefetch;
        this.classToPrefetch = null;
        this.pb.getInternalCache().enableMaterializationCache();
        try {
            while (i.hasNext()) {
                ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
                this.retrieveProxyReference(newObj, cld, rds, forced);
            }
            this.pb.getInternalCache().disableMaterializationCache();
        }
        catch (RuntimeException e) {
            this.pb.getInternalCache().doLocalClear();
            throw e;
        }
        finally {
            this.classToPrefetch = saveClassToPrefetch;
        }
    }

    private Identity getReferencedObjectIdentity(Object obj, ObjectReferenceDescriptor rds, ClassDescriptor cld) {
        Object[] fkValues = rds.getForeignKeyValues(obj, cld);
        FieldDescriptor[] fkFieldDescriptors = rds.getForeignKeyFieldDescriptors(cld);
        boolean hasNullifiedFKValue = this.hasNullifiedFK(fkFieldDescriptors, fkValues);
        if (hasNullifiedFKValue) {
            Object referencedObject;
            if (BrokerHelper.hasAnonymousKeyReference(cld, rds) && (referencedObject = rds.getPersistentField().get(obj)) != null) {
                return this.pb.serviceIdentity().buildIdentity(referencedObject);
            }
        } else {
            return this.pb.serviceIdentity().buildIdentity(rds.getItemClass(), this.pb.getTopLevelClass(rds.getItemClass()), fkValues);
        }
        return null;
    }

    private boolean hasNullifiedFK(FieldDescriptor[] fkFieldDescriptors, Object[] fkValues) {
        boolean result = true;
        for (int i = 0; i < fkValues.length; ++i) {
            if (this.pb.serviceBrokerHelper().representsNull(fkFieldDescriptors[i], fkValues[i])) continue;
            result = false;
            break;
        }
        return result;
    }

    private Object getReferencedObject(Identity id, ObjectReferenceDescriptor rds) {
        Class baseClassForProxy = rds.isLazy() ? rds.getItemClass() : rds.getItemProxyClass();
        if (baseClassForProxy != null) {
            try {
                return this.pb.createProxy(baseClassForProxy, id);
            }
            catch (Exception e) {
                this.log.error("Error while instantiate object " + id + ", msg: " + e.getMessage(), e);
                if (e instanceof PersistenceBrokerException) {
                    throw (PersistenceBrokerException)((Object)e);
                }
                throw new PersistenceBrokerException(e);
            }
        }
        return this.pb.doGetObjectByIdentity(id);
    }

    public void retrieveCollection(Object obj, ClassDescriptor cld, CollectionDescriptor cds, boolean forced) {
        this.doRetrieveCollection(obj, cld, cds, forced, cds.isLazy());
    }

    public void retrieveProxyCollection(Object obj, ClassDescriptor cld, CollectionDescriptor cds, boolean forced) {
        this.doRetrieveCollection(obj, cld, cds, forced, true);
    }

    private void doRetrieveCollection(Object obj, ClassDescriptor cld, CollectionDescriptor cds, boolean forced, boolean lazyLoad) {
        if (forced || cds.getCascadeRetrieve()) {
            if (this.m_retrievalTasks != null && !cds.isLazy() && !cds.hasProxyItems() && cds.getQueryCustomizer() == null) {
                this.addRetrievalTask(obj, cds);
            } else {
                Class collectionClass = cds.getCollectionClass();
                PersistentField collectionField = cds.getPersistentField();
                Query fkQuery = this.getFKQuery(obj, cld, cds);
                this.pb.getInternalCache().enableMaterializationCache();
                try {
                    Object value;
                    if (collectionClass == null) {
                        Collection result = (Collection)((Object)this.getCollectionByQuery(this.getCollectionTypeClass(cds), fkQuery, lazyLoad));
                        if (collectionField.getType().isArray()) {
                            int length = result.size();
                            Class<?> itemtype = collectionField.getType().getComponentType();
                            Object resultArray = Array.newInstance(itemtype, length);
                            int j = 0;
                            Iterator iter = result.iterator();
                            while (iter.hasNext()) {
                                Array.set(resultArray, j, iter.next());
                                ++j;
                            }
                            collectionField.set(obj, resultArray);
                        } else {
                            collectionField.set(obj, result);
                        }
                        value = result;
                    } else {
                        ManageableCollection result = this.getCollectionByQuery(collectionClass, fkQuery, lazyLoad);
                        collectionField.set(obj, result);
                        value = result;
                    }
                    if (this.m_retrievalTasks != null && cds.getProxyPrefetchingLimit() > 0 && cds.getQueryCustomizer() == null && ProxyHelper.isCollectionProxy(value) && this.addRetrievalTask(obj, cds)) {
                        new PBCollectionProxyListener(obj, this.m_retrievalTasks, cds, cds.getProxyPrefetchingLimit());
                    }
                    this.pb.getInternalCache().disableMaterializationCache();
                }
                catch (RuntimeException e) {
                    this.pb.getInternalCache().doLocalClear();
                    throw e;
                }
            }
        }
    }

    private Query getFKQuery(Object obj, ClassDescriptor cld, CollectionDescriptor cds) {
        QueryByCriteria fkQueryCrit = cds.isMtoNRelation() ? this.getFKQueryMtoN(obj, cld, cds) : this.getFKQuery1toN(obj, cld, cds);
        if (!cds.getOrderBy().isEmpty()) {
            Iterator iter = cds.getOrderBy().iterator();
            while (iter.hasNext()) {
                fkQueryCrit.addOrderBy((FieldHelper)iter.next());
            }
        }
        Query fkQuery = cds.getQueryCustomizer() != null ? cds.getQueryCustomizer().customizeQuery(obj, this.pb, cds, fkQueryCrit) : fkQueryCrit;
        return fkQuery;
    }

    private QueryByCriteria getFKQueryMtoN(Object obj, ClassDescriptor cld, CollectionDescriptor cod) {
        int i;
        ValueContainer[] values = this.pb.serviceBrokerHelper().getKeyValues(cld, obj);
        String[] thisClassFks = cod.getFksToThisClass();
        String[] itemClassFks = cod.getFksToItemClass();
        ClassDescriptor refCld = this.pb.getClassDescriptor(cod.getItemClass());
        Criteria criteria = new Criteria();
        for (i = 0; i < thisClassFks.length; ++i) {
            criteria.addEqualTo(cod.getIndirectionTable() + "." + thisClassFks[i], values[i].getValue());
        }
        for (i = 0; i < itemClassFks.length; ++i) {
            criteria.addEqualToField(cod.getIndirectionTable() + "." + itemClassFks[i], refCld.getPkFields()[i].getAttributeName());
        }
        return QueryFactory.newQuery(refCld.getClassOfObject(), cod.getIndirectionTable(), criteria);
    }

    private QueryByCriteria getFKQuery1toN(Object obj, ClassDescriptor cld, CollectionDescriptor cod) {
        ValueContainer[] container = this.pb.serviceBrokerHelper().getKeyValues(cld, obj);
        ClassDescriptor refCld = this.pb.getClassDescriptor(cod.getItemClass());
        FieldDescriptor[] fields = cod.getForeignKeyFieldDescriptors(refCld);
        Criteria criteria = new Criteria();
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor fld = fields[i];
            criteria.addEqualTo(fld.getAttributeName(), container[i].getValue());
        }
        return QueryFactory.newQuery(refCld.getClassOfObject(), criteria);
    }

    public Query getPKQuery(Identity oid) {
        Object[] values = oid.getPrimaryKeyValues();
        ClassDescriptor cld = this.pb.getClassDescriptor(oid.getObjectsTopLevelClass());
        FieldDescriptor[] fields = cld.getPkFields();
        Criteria criteria = new Criteria();
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor fld = fields[i];
            criteria.addEqualTo(fld.getAttributeName(), values[i]);
        }
        return QueryFactory.newQuery(cld.getClassOfObject(), criteria);
    }

    public void retrieveCollections(Object newObj, ClassDescriptor cld, boolean forced) throws PersistenceBrokerException {
        this.doRetrieveCollections(newObj, cld, forced, false);
    }

    public void retrieveProxyCollections(Object newObj, ClassDescriptor cld, boolean forced) throws PersistenceBrokerException {
        this.doRetrieveCollections(newObj, cld, forced, true);
    }

    private void doRetrieveCollections(Object newObj, ClassDescriptor cld, boolean forced, boolean forceProxyCollection) throws PersistenceBrokerException {
        Iterator i = cld.getCollectionDescriptors().iterator();
        Class saveClassToPrefetch = this.classToPrefetch;
        this.classToPrefetch = null;
        this.pb.getInternalCache().enableMaterializationCache();
        try {
            while (i.hasNext()) {
                CollectionDescriptor cds = (CollectionDescriptor)i.next();
                if (forceProxyCollection) {
                    this.retrieveProxyCollection(newObj, cld, cds, forced);
                    continue;
                }
                this.retrieveCollection(newObj, cld, cds, forced);
            }
            this.pb.getInternalCache().disableMaterializationCache();
        }
        catch (RuntimeException e) {
            this.pb.getInternalCache().doLocalClear();
            throw e;
        }
        finally {
            this.classToPrefetch = saveClassToPrefetch;
        }
    }

    public void removePrefetchingListeners() {
        if (this.prefetchingListeners != null) {
            Iterator it = this.prefetchingListeners.iterator();
            while (it.hasNext()) {
                PBPrefetchingListener listener = (PBPrefetchingListener)it.next();
                listener.removeThisListener();
            }
            this.prefetchingListeners.clear();
        }
    }

    public Class getClassToPrefetch() {
        return this.classToPrefetch;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PBCollectionProxyListener
    extends PBPrefetchingListener
    implements CollectionProxyListener {
        CollectionProxyDefaultImpl _listenedCollection;

        PBCollectionProxyListener(Object owner, HashMap retrievalTasks, CollectionDescriptor key, int limit) {
            super(owner, retrievalTasks, key, limit);
        }

        protected void addThisListenerTo(Object owner) {
            PersistentField collectionField = ((CollectionDescriptor)this._key).getPersistentField();
            this._listenedCollection = (CollectionProxyDefaultImpl)collectionField.get(owner);
            this._listenedCollection.addListener(this);
        }

        protected void removeThisListener() {
            if (this._listenedCollection != null) {
                this._listenedCollection.removeListener(this);
                this._listenedCollection = null;
            }
        }

        protected RelationshipPrefetcher getPrefetcher(Object listenedObject) {
            return QueryReferenceBroker.this.pb.getRelationshipPrefetcherFactory().createRelationshipPrefetcher((CollectionDescriptor)this._key);
        }

        public void beforeLoading(CollectionProxyDefaultImpl col) {
            this.prefetch(col);
        }

        public void afterLoading(CollectionProxyDefaultImpl col) {
        }
    }

    abstract class PBPrefetchingListener {
        private HashMap _retrievalTasks;
        private int _limit;
        protected Object _key;

        PBPrefetchingListener(Object owner, HashMap retrievalTasks, Object key, int limit) {
            this._retrievalTasks = retrievalTasks;
            this._key = key;
            this._limit = limit + 1;
            if (QueryReferenceBroker.this.prefetchingListeners == null) {
                QueryReferenceBroker.this.prefetchingListeners = new ArrayList();
            }
            this.addThisListenerTo(owner);
            QueryReferenceBroker.this.prefetchingListeners.add(this);
        }

        protected abstract void addThisListenerTo(Object var1);

        protected abstract void removeThisListener();

        protected abstract RelationshipPrefetcher getPrefetcher(Object var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void prefetch(Object listenedObject) {
            boolean prefetchingAll;
            List toPrefetch;
            ArrayList owners = (ArrayList)this._retrievalTasks.get(this._key);
            this.removeThisListener();
            if (owners == null) {
                return;
            }
            RelationshipPrefetcher prefetcher = this.getPrefetcher(listenedObject);
            if (owners.size() <= this._limit) {
                toPrefetch = owners;
                prefetchingAll = true;
            } else {
                toPrefetch = owners.subList(0, this._limit);
                prefetchingAll = false;
            }
            Class saveClassToPrefetch = QueryReferenceBroker.this.classToPrefetch;
            QueryReferenceBroker.this.classToPrefetch = prefetcher.getItemClassDescriptor().getClassOfObject();
            try {
                prefetcher.prefetchRelationship(toPrefetch);
            }
            finally {
                QueryReferenceBroker.this.classToPrefetch = saveClassToPrefetch;
            }
            if (prefetchingAll) {
                this._retrievalTasks.remove(this._key);
            } else {
                toPrefetch.clear();
                this.addThisListenerTo(owners.get(0));
            }
        }
    }

    class PBMaterializationListener
    extends PBPrefetchingListener
    implements MaterializationListener {
        private IndirectionHandler _listenedHandler;

        PBMaterializationListener(Object owner, HashMap retrievalTasks, Object key, int limit) {
            super(owner, retrievalTasks, key, limit);
        }

        protected void addThisListenerTo(Object owner) {
            this._listenedHandler = ProxyHelper.getIndirectionHandler(owner);
            if (this._listenedHandler != null) {
                this._listenedHandler.addListener(this);
            }
        }

        protected void removeThisListener() {
            if (this._listenedHandler != null) {
                this._listenedHandler.removeListener(this);
                this._listenedHandler = null;
            }
        }

        protected RelationshipPrefetcher getPrefetcher(Object listenedObject) {
            if (this._key instanceof ObjectReferenceDescriptor) {
                return QueryReferenceBroker.this.pb.getRelationshipPrefetcherFactory().createRelationshipPrefetcher((ObjectReferenceDescriptor)this._key);
            }
            IndirectionHandler handler = (IndirectionHandler)listenedObject;
            return new PlainPrefetcher(QueryReferenceBroker.this.pb, handler.getIdentity().getObjectsTopLevelClass());
        }

        public void beforeMaterialization(IndirectionHandler handler, Identity oid) {
            this.prefetch(handler);
        }

        public void afterMaterialization(IndirectionHandler handler, Object materializedObject) {
        }
    }
}

