/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerInternal;

public class PersistenceBrokerThreadMapping {
    private static Collection loadedHMs = new HashSet();
    private static ThreadLocal currentBrokerMap = new ThreadLocal();

    public static void setCurrentPersistenceBroker(PBKey key, PersistenceBrokerInternal broker) throws PBFactoryException {
        HashMap<PBKey, WeakHashMap<PersistenceBrokerInternal, Object>> map = (HashMap<PBKey, WeakHashMap<PersistenceBrokerInternal, Object>>)currentBrokerMap.get();
        WeakHashMap<PersistenceBrokerInternal, Object> set = null;
        if (map == null) {
            map = new HashMap<PBKey, WeakHashMap<PersistenceBrokerInternal, Object>>();
            currentBrokerMap.set(map);
            loadedHMs.add(map);
        } else {
            set = (WeakHashMap<PersistenceBrokerInternal, Object>)map.get(key);
        }
        if (set == null) {
            set = new WeakHashMap<PersistenceBrokerInternal, Object>();
            map.put(key, set);
        }
        set.put(broker, null);
    }

    public static void unsetCurrentPersistenceBroker(PBKey key, PersistenceBrokerInternal broker) throws PBFactoryException {
        HashMap map = (HashMap)currentBrokerMap.get();
        WeakHashMap set = null;
        if (map != null) {
            set = (WeakHashMap)map.get(key);
            if (set != null) {
                set.remove(broker);
                if (set.isEmpty()) {
                    map.remove(key);
                }
            }
            if (map.isEmpty()) {
                currentBrokerMap.set(null);
                loadedHMs.remove(map);
            }
        }
    }

    public static PersistenceBrokerInternal currentPersistenceBroker(PBKey key) throws PBFactoryException, PersistenceBrokerException {
        HashMap map = (HashMap)currentBrokerMap.get();
        PersistenceBrokerInternal broker = null;
        if (map == null) {
            return null;
        }
        WeakHashMap set = (WeakHashMap)map.get(key);
        if (set == null) {
            return null;
        }
        Iterator it = set.keySet().iterator();
        while (it.hasNext()) {
            PersistenceBrokerInternal tmp = (PersistenceBrokerInternal)it.next();
            if (tmp == null || tmp.isClosed()) {
                it.remove();
                continue;
            }
            broker = tmp;
            if (!tmp.isInTransaction()) continue;
            break;
        }
        return broker;
    }

    public static void shutdown() {
        Iterator it = loadedHMs.iterator();
        while (it.hasNext()) {
            ((HashMap)it.next()).clear();
        }
        loadedHMs.clear();
        loadedHMs = null;
        currentBrokerMap = null;
    }
}

