/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryFactory;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryIF;
import org.apache.ojb.broker.core.PersistenceBrokerThreadMapping;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.interceptor.InterceptorFactory;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PersistenceBrokerFactoryBaseImpl
implements PersistenceBrokerFactoryIF {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$PersistenceBrokerFactoryBaseImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactoryBaseImpl = PersistenceBrokerFactoryBaseImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactoryBaseImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactoryBaseImpl);
    private Class implementationClass;
    private long instanceCount;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerFactoryBaseImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$PBKey;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerFactoryIF;

    public PersistenceBrokerFactoryBaseImpl() {
        this.configure(OjbConfigurator.getInstance().getConfigurationFor(null));
    }

    public void setDefaultKey(PBKey key) {
        try {
            MetadataManager.getInstance().setDefaultPBKey(key);
        }
        catch (Exception e) {
            throw new PBFactoryException(e);
        }
    }

    public PBKey getDefaultKey() {
        return MetadataManager.getInstance().getDefaultPBKey();
    }

    protected PersistenceBrokerInternal createNewBrokerInstance(PBKey key) throws PBFactoryException {
        if (key == null) {
            throw new PBFactoryException("Could not create new broker with PBkey argument 'null'");
        }
        if (MetadataManager.getInstance().connectionRepository().getDescriptor(key) == null) {
            throw new PBFactoryException("Given PBKey " + key + " does not match in metadata configuration");
        }
        if (log.isEnabledFor(2)) {
            log.info("Create new PB instance for PBKey " + key + ", already created persistence broker instances: " + this.instanceCount);
            ++this.instanceCount;
        }
        PersistenceBrokerInternal instance = null;
        Class[] types = new Class[]{class$org$apache$ojb$broker$PBKey == null ? (class$org$apache$ojb$broker$PBKey = PersistenceBrokerFactoryBaseImpl.class$("org.apache.ojb.broker.PBKey")) : class$org$apache$ojb$broker$PBKey, class$org$apache$ojb$broker$core$PersistenceBrokerFactoryIF == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactoryIF = PersistenceBrokerFactoryBaseImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactoryIF")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactoryIF};
        Object[] args = new Object[]{key, this};
        try {
            instance = (PersistenceBrokerInternal)ClassHelper.newInstance(this.implementationClass, types, args);
            OjbConfigurator.getInstance().configure(instance);
            instance = (PersistenceBrokerInternal)InterceptorFactory.getInstance().createInterceptorFor(instance);
        }
        catch (Exception e) {
            log.error("Creation of a new PB instance failed", e);
            throw new PBFactoryException("Creation of a new PB instance failed", e);
        }
        return instance;
    }

    public PersistenceBrokerInternal createPersistenceBroker(PBKey pbKey) throws PBFactoryException {
        if (log.isDebugEnabled()) {
            log.debug("Obtain broker from pool, used PBKey is " + pbKey);
        }
        pbKey = BrokerHelper.crossCheckPBKey(pbKey);
        try {
            return this.createNewBrokerInstance(pbKey);
        }
        catch (Exception e) {
            throw new PBFactoryException("Borrow broker from pool failed, using PBKey " + pbKey, e);
        }
    }

    public PersistenceBrokerInternal createPersistenceBroker(String jcdAlias, String user, String password) throws PBFactoryException {
        return this.createPersistenceBroker(new PBKey(jcdAlias, user, password));
    }

    public PersistenceBrokerInternal defaultPersistenceBroker() throws PBFactoryException {
        if (this.getDefaultKey() == null) {
            throw new PBFactoryException("There was no 'default-connection' attribute enabled in the jdbc connection descriptor");
        }
        return this.createPersistenceBroker(this.getDefaultKey());
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.implementationClass = ((PersistenceBrokerConfiguration)((Object)config)).getPersistenceBrokerClass();
    }

    public synchronized void releaseAllInstances() {
        this.instanceCount = 0L;
    }

    public int activePersistenceBroker() {
        return 0;
    }

    public void shutdown() {
        try {
            ConnectionFactoryFactory.getInstance().createConnectionFactory().releaseAllResources();
            PersistenceBrokerThreadMapping.shutdown();
            MetadataManager.getInstance().shutdown();
        }
        catch (RuntimeException e) {
            log.error("Error while shutdown of OJB", e);
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

