/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import org.apache.ojb.broker.PBLifeCycleEvent;
import org.apache.ojb.broker.PBLifeCycleListener;
import org.apache.ojb.broker.PBListener;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBrokerEvent;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerInternal;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class PersistenceBrokerAbstractImpl
implements PersistenceBrokerInternal {
    private static final PBStateListener[] NO_STATE_LISTENERS = new PBStateListener[0];
    private static final PBLifeCycleListener[] NO_LIFECYCLE_LISTENERS = new PBLifeCycleListener[0];
    private boolean txCheck;
    private PBStateListener[] permanentStateListeners = NO_STATE_LISTENERS;
    private PBStateListener[] temporaryStateListeners = NO_STATE_LISTENERS;
    private PBLifeCycleListener[] permanentLifeCycleListeners = NO_LIFECYCLE_LISTENERS;
    private PBLifeCycleListener[] temporaryLifeCycleListeners = NO_LIFECYCLE_LISTENERS;
    protected final PBStateEvent AFTER_OPEN_EVENT = new PBStateEvent(this, PBStateEvent.Type.AFTER_OPEN);
    protected final PBStateEvent AFTER_BEGIN_EVENT = new PBStateEvent(this, PBStateEvent.Type.AFTER_BEGIN);
    protected final PBStateEvent AFTER_COMMIT_EVENT = new PBStateEvent(this, PBStateEvent.Type.AFTER_COMMIT);
    protected final PBStateEvent AFTER_ROLLBACK_EVENT = new PBStateEvent(this, PBStateEvent.Type.AFTER_ROLLBACK);
    protected final PBStateEvent BEFORE_BEGIN_EVENT = new PBStateEvent(this, PBStateEvent.Type.BEFORE_BEGIN);
    protected final PBStateEvent BEFORE_COMMIT_EVENT = new PBStateEvent(this, PBStateEvent.Type.BEFORE_COMMIT);
    protected final PBStateEvent BEFORE_ROLLBACK_EVENT = new PBStateEvent(this, PBStateEvent.Type.BEFORE_ROLLBACK);
    protected final PBStateEvent BEFORE_CLOSE_EVENT = new PBStateEvent(this, PBStateEvent.Type.BEFORE_CLOSE);
    protected PBLifeCycleEvent BEFORE_STORE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.BEFORE_INSERT);
    protected PBLifeCycleEvent AFTER_STORE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.AFTER_INSERT);
    protected PBLifeCycleEvent BEFORE_DELETE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.BEFORE_DELETE);
    protected PBLifeCycleEvent AFTER_DELETE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.AFTER_DELETE);
    protected PBLifeCycleEvent AFTER_LOOKUP_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.AFTER_LOOKUP);
    protected PBLifeCycleEvent BEFORE_UPDATE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.BEFORE_UPDATE);
    protected PBLifeCycleEvent AFTER_UPDATE_EVENT = new PBLifeCycleEvent(this, PBLifeCycleEvent.Type.AFTER_UPDATE);
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerAbstractImpl;

    public void configure(Configuration pConfig) throws ConfigurationException {
        this.txCheck = pConfig.getBoolean("TxCheck", false);
    }

    public boolean isTxCheck() {
        return this.txCheck;
    }

    public void setTxCheck(boolean txCheck) {
        this.txCheck = txCheck;
    }

    public void addListener(PBListener listener) throws PersistenceBrokerException {
        this.addListener(listener, false);
    }

    public void addListener(PBListener listener, boolean permanent) throws PersistenceBrokerException {
        PBListener[] newListeners;
        if (listener instanceof PBStateListener) {
            if (permanent) {
                if (!this.contains(this.permanentStateListeners, listener)) {
                    newListeners = new PBStateListener[this.permanentStateListeners.length + 1];
                    System.arraycopy(this.permanentStateListeners, 0, newListeners, 0, this.permanentStateListeners.length);
                    newListeners[newListeners.length - 1] = (PBStateListener)listener;
                    this.permanentStateListeners = newListeners;
                }
            } else if (!this.contains(this.temporaryStateListeners, listener)) {
                newListeners = new PBStateListener[this.temporaryStateListeners.length + 1];
                System.arraycopy(this.temporaryStateListeners, 0, newListeners, 0, this.temporaryStateListeners.length);
                newListeners[newListeners.length - 1] = (PBStateListener)listener;
                this.temporaryStateListeners = newListeners;
            }
        }
        if (listener instanceof PBLifeCycleListener) {
            if (permanent) {
                if (!this.contains(this.permanentLifeCycleListeners, listener)) {
                    newListeners = new PBLifeCycleListener[this.permanentLifeCycleListeners.length + 1];
                    System.arraycopy(this.permanentLifeCycleListeners, 0, newListeners, 0, this.permanentLifeCycleListeners.length);
                    newListeners[newListeners.length - 1] = (PBLifeCycleListener)listener;
                    this.permanentLifeCycleListeners = newListeners;
                }
            } else if (!this.contains(this.temporaryLifeCycleListeners, listener)) {
                newListeners = new PBLifeCycleListener[this.temporaryLifeCycleListeners.length + 1];
                System.arraycopy(this.temporaryLifeCycleListeners, 0, newListeners, 0, this.temporaryLifeCycleListeners.length);
                newListeners[newListeners.length - 1] = (PBLifeCycleListener)listener;
                this.temporaryLifeCycleListeners = newListeners;
            }
        }
    }

    public void removeListener(PBListener listener) throws PersistenceBrokerException {
        int i;
        int pos;
        PBListener[] newListeners;
        if (listener instanceof PBStateListener) {
            if (this.contains(this.permanentStateListeners, listener)) {
                newListeners = new PBStateListener[this.permanentStateListeners.length - 1];
                pos = 0;
                for (i = 0; i < this.permanentStateListeners.length; ++i) {
                    if (this.permanentStateListeners[i] == listener) continue;
                    newListeners[pos++] = this.permanentStateListeners[i];
                }
                this.permanentStateListeners = newListeners;
            }
            if (this.contains(this.temporaryStateListeners, listener)) {
                newListeners = new PBStateListener[this.temporaryStateListeners.length - 1];
                pos = 0;
                for (i = 0; i < this.temporaryStateListeners.length; ++i) {
                    if (this.temporaryStateListeners[i] == listener) continue;
                    newListeners[pos++] = this.temporaryStateListeners[i];
                }
                this.temporaryStateListeners = newListeners;
            }
        }
        if (listener instanceof PBLifeCycleListener) {
            if (this.contains(this.permanentLifeCycleListeners, listener)) {
                newListeners = new PBLifeCycleListener[this.permanentLifeCycleListeners.length - 1];
                pos = 0;
                for (i = 0; i < this.permanentLifeCycleListeners.length; ++i) {
                    if (this.permanentLifeCycleListeners[i] == listener) continue;
                    newListeners[pos++] = this.permanentLifeCycleListeners[i];
                }
                this.permanentLifeCycleListeners = newListeners;
            }
            if (this.contains(this.temporaryLifeCycleListeners, listener)) {
                newListeners = new PBLifeCycleListener[this.temporaryLifeCycleListeners.length - 1];
                pos = 0;
                for (i = 0; i < this.temporaryLifeCycleListeners.length; ++i) {
                    if (this.temporaryLifeCycleListeners[i] == listener) continue;
                    newListeners[pos++] = this.temporaryLifeCycleListeners[i];
                }
                this.temporaryLifeCycleListeners = newListeners;
            }
        }
    }

    protected boolean contains(PBListener[] listeners, PBListener listener) {
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (listeners[i] != listener) continue;
            return true;
        }
        return false;
    }

    public void removeAllListeners(boolean permanent) throws PersistenceBrokerException {
        if (permanent) {
            this.permanentStateListeners = NO_STATE_LISTENERS;
            this.permanentLifeCycleListeners = NO_LIFECYCLE_LISTENERS;
        }
        this.temporaryStateListeners = NO_STATE_LISTENERS;
        this.temporaryLifeCycleListeners = NO_LIFECYCLE_LISTENERS;
    }

    public void removeAllListeners() throws PersistenceBrokerException {
        this.removeAllListeners(false);
    }

    public void fireBrokerEvent(PersistenceBrokerEvent event) {
        if (event instanceof PBLifeCycleEvent) {
            this.fireBrokerEvent((PBLifeCycleEvent)event);
        } else if (event instanceof PBStateEvent) {
            this.fireBrokerEvent((PBStateEvent)event);
        } else {
            LoggerFactory.getDefaultLogger().error((class$org$apache$ojb$broker$core$PersistenceBrokerAbstractImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerAbstractImpl = PersistenceBrokerAbstractImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerAbstractImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerAbstractImpl).getName() + ": Unkown PersistenceBrokerEvent was fired " + event);
        }
    }

    public void fireBrokerEvent(PBLifeCycleEvent event) {
        int i;
        if (event.getPersitenceBrokerAware() != null) {
            this.performCallBack(event);
        }
        PBLifeCycleListener[] permanent = this.permanentLifeCycleListeners;
        PBLifeCycleListener[] temporary = this.temporaryLifeCycleListeners;
        for (i = permanent.length - 1; i >= 0; --i) {
            this.notifiyObjectLifeCycleListener(permanent[i], event);
        }
        for (i = temporary.length - 1; i >= 0; --i) {
            this.notifiyObjectLifeCycleListener(temporary[i], event);
        }
    }

    public void fireBrokerEvent(PBStateEvent event) {
        int i;
        PBStateListener[] permanent = this.permanentStateListeners;
        PBStateListener[] temporary = this.temporaryStateListeners;
        for (i = permanent.length - 1; i >= 0; --i) {
            this.notifiyStateListener(permanent[i], event);
        }
        for (i = temporary.length - 1; i >= 0; --i) {
            this.notifiyStateListener(temporary[i], event);
        }
    }

    private void performCallBack(PBLifeCycleEvent event) {
        if (event.getPersitenceBrokerAware() == null) {
            return;
        }
        switch (event.getEventType().typeId()) {
            case 6: {
                event.getPersitenceBrokerAware().afterLookup(event.getTriggeringBroker());
                break;
            }
            case 3: {
                event.getPersitenceBrokerAware().beforeUpdate(event.getTriggeringBroker());
                break;
            }
            case 4: {
                event.getPersitenceBrokerAware().afterUpdate(event.getTriggeringBroker());
                break;
            }
            case 1: {
                event.getPersitenceBrokerAware().beforeInsert(event.getTriggeringBroker());
                break;
            }
            case 7: {
                event.getPersitenceBrokerAware().afterInsert(event.getTriggeringBroker());
                break;
            }
            case 2: {
                event.getPersitenceBrokerAware().beforeDelete(event.getTriggeringBroker());
                break;
            }
            case 5: {
                event.getPersitenceBrokerAware().afterDelete(event.getTriggeringBroker());
            }
        }
    }

    private void notifiyStateListener(PBStateListener listener, PBStateEvent stateEvent) {
        switch (stateEvent.getEventType().typeId()) {
            case 3: {
                listener.beforeCommit(stateEvent);
                break;
            }
            case 6: {
                listener.afterCommit(stateEvent);
                break;
            }
            case 2: {
                listener.beforeBegin(stateEvent);
                break;
            }
            case 5: {
                listener.afterBegin(stateEvent);
                break;
            }
            case 1: {
                listener.beforeClose(stateEvent);
                break;
            }
            case 7: {
                listener.afterOpen(stateEvent);
                break;
            }
            case 8: {
                listener.afterRollback(stateEvent);
                break;
            }
            case 4: {
                listener.beforeRollback(stateEvent);
            }
        }
    }

    private void notifiyObjectLifeCycleListener(PBLifeCycleListener listener, PBLifeCycleEvent lifeEvent) {
        switch (lifeEvent.getEventType().typeId()) {
            case 6: {
                listener.afterLookup(lifeEvent);
                break;
            }
            case 3: {
                listener.beforeUpdate(lifeEvent);
                break;
            }
            case 4: {
                listener.afterUpdate(lifeEvent);
                break;
            }
            case 1: {
                listener.beforeInsert(lifeEvent);
                break;
            }
            case 7: {
                listener.afterInsert(lifeEvent);
                break;
            }
            case 2: {
                listener.beforeDelete(lifeEvent);
                break;
            }
            case 5: {
                listener.afterDelete(lifeEvent);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

