/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.MtoNImplementor;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.JdbcType;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class MtoNBroker {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$MtoNBroker == null ? (class$org$apache$ojb$broker$core$MtoNBroker = MtoNBroker.class$("org.apache.ojb.broker.core.MtoNBroker")) : class$org$apache$ojb$broker$core$MtoNBroker);
    private PersistenceBrokerImpl pb;
    private List tempObjects = new ArrayList();
    static /* synthetic */ Class class$org$apache$ojb$broker$core$MtoNBroker;

    public MtoNBroker(PersistenceBrokerImpl broker) {
        this.pb = broker;
    }

    public void reset() {
        this.tempObjects.clear();
    }

    public void storeMtoNImplementor(CollectionDescriptor cod, Object realObject, Object otherObj, Collection mnKeys) {
        ClassDescriptor cld = this.pb.getDescriptorRepository().getDescriptorFor(realObject.getClass());
        Object[] pkValues = this.pb.serviceBrokerHelper().getKeyValues(cld, realObject);
        Object[] pkColumns = cod.getFksToThisClass();
        ClassDescriptor otherCld = this.pb.getDescriptorRepository().getDescriptorFor(ProxyHelper.getRealClass(otherObj));
        ValueContainer[] otherPkValues = this.pb.serviceBrokerHelper().getKeyValues(otherCld, otherObj);
        String[] otherPkColumns = cod.getFksToItemClass();
        String table = cod.getIndirectionTable();
        Key key = new Key(otherPkValues);
        if (mnKeys.contains(key)) {
            return;
        }
        for (int i = 0; i < otherPkColumns.length; ++i) {
            int index = ArrayUtils.indexOf((Object[])pkColumns, (Object)otherPkColumns[i]);
            if (index == -1) continue;
            pkColumns = (String[])ArrayUtils.remove((Object[])pkColumns, (int)index);
            pkValues = (ValueContainer[])ArrayUtils.remove((Object[])pkValues, (int)index);
        }
        String[] cols = this.mergeColumns((String[])pkColumns, otherPkColumns);
        String insertStmt = this.pb.serviceSqlGenerator().getInsertMNStatement(table, (String[])pkColumns, otherPkColumns);
        ValueContainer[] values = this.mergeContainer((ValueContainer[])pkValues, otherPkValues);
        GenericObject gObj = new GenericObject(table, cols, values);
        if (!this.tempObjects.contains(gObj)) {
            this.pb.serviceJdbcAccess().executeUpdateSQL(insertStmt, cld, (ValueContainer[])pkValues, otherPkValues);
            this.tempObjects.add(gObj);
        }
    }

    public List getMtoNImplementor(CollectionDescriptor cod, Object obj) {
        FieldDescriptor[] itemClassPKFields;
        ResultSetAndStatement rs = null;
        ArrayList<Key> result = new ArrayList<Key>();
        ClassDescriptor cld = this.pb.getDescriptorRepository().getDescriptorFor(obj.getClass());
        ValueContainer[] pkValues = this.pb.serviceBrokerHelper().getKeyValues(cld, obj);
        String[] pkColumns = cod.getFksToThisClass();
        String[] fkColumns = cod.getFksToItemClass();
        String table = cod.getIndirectionTable();
        String selectStmt = this.pb.serviceSqlGenerator().getSelectMNStatement(table, fkColumns, pkColumns);
        ClassDescriptor itemCLD = this.pb.getDescriptorRepository().getDescriptorFor(cod.getItemClass());
        Collection extents = this.pb.getDescriptorRepository().getAllConcreteSubclassDescriptors(itemCLD);
        if (extents.size() > 0) {
            itemCLD = (ClassDescriptor)extents.iterator().next();
        }
        if ((itemClassPKFields = itemCLD.getPkFields()).length != fkColumns.length) {
            throw new PersistenceBrokerException("All pk fields of the element-class need to be declared in the indirection table. Element class is " + itemCLD.getClassNameOfObject() + " with " + itemClassPKFields.length + " pk-fields." + " Declared 'fk-pointing-to-element-class' elements in collection-descriptor are" + fkColumns.length);
        }
        try {
            rs = this.pb.serviceJdbcAccess().executeSQL(selectStmt, cld, pkValues, false);
            while (rs.m_rs.next()) {
                ValueContainer[] row = new ValueContainer[fkColumns.length];
                for (int i = 0; i < row.length; ++i) {
                    row[i] = new ValueContainer(rs.m_rs.getObject(i + 1), itemClassPKFields[i].getJdbcType());
                }
                result.add(new Key(row));
            }
        }
        catch (PersistenceBrokerException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException(e);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return result;
    }

    public void deleteMtoNImplementor(CollectionDescriptor cod, Object obj) {
        ClassDescriptor cld = this.pb.getDescriptorRepository().getDescriptorFor(obj.getClass());
        ValueContainer[] pkValues = this.pb.serviceBrokerHelper().getKeyValues(cld, obj);
        String[] pkColumns = cod.getFksToThisClass();
        String table = cod.getIndirectionTable();
        String deleteStmt = this.pb.serviceSqlGenerator().getDeleteMNStatement(table, pkColumns, null);
        this.pb.serviceJdbcAccess().executeUpdateSQL(deleteStmt, cld, pkValues, null);
    }

    public void deleteMtoNImplementor(CollectionDescriptor cod, Object obj, Iterator collectionIterator, Collection mnKeys) {
        if (mnKeys.isEmpty() || collectionIterator == null) {
            return;
        }
        ArrayList workList = new ArrayList(mnKeys);
        ClassDescriptor relatedCld = this.pb.getDescriptorRepository().getDescriptorFor(cod.getItemClass());
        while (collectionIterator.hasNext()) {
            Object relatedObj = collectionIterator.next();
            Key relatedObjKeys = new Key(this.pb.serviceBrokerHelper().getKeyValues(relatedCld, relatedObj, true));
            workList.remove(relatedObjKeys);
        }
        ClassDescriptor cld = this.pb.getDescriptorRepository().getDescriptorFor(obj.getClass());
        ValueContainer[] pkValues = this.pb.serviceBrokerHelper().getKeyValues(cld, obj);
        String[] pkColumns = cod.getFksToThisClass();
        String[] fkColumns = cod.getFksToItemClass();
        String table = cod.getIndirectionTable();
        Iterator iter = workList.iterator();
        while (iter.hasNext()) {
            ValueContainer[] fkValues = ((Key)iter.next()).m_containers;
            String deleteStmt = this.pb.serviceSqlGenerator().getDeleteMNStatement(table, pkColumns, fkColumns);
            this.pb.serviceJdbcAccess().executeUpdateSQL(deleteStmt, cld, pkValues, fkValues);
        }
    }

    public void storeMtoNImplementor(MtoNImplementor m2n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Storing M2N implementor [" + m2n + "]");
        }
        this.insertOrDeleteMtoNImplementor(m2n, true);
    }

    public void deleteMtoNImplementor(MtoNImplementor m2n) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deleting M2N implementor [" + m2n + "]");
        }
        this.insertOrDeleteMtoNImplementor(m2n, false);
    }

    private void insertOrDeleteMtoNImplementor(MtoNImplementor m2nImpl, boolean insert) throws PersistenceBrokerException {
        DescriptorRepository dr = this.pb.getDescriptorRepository();
        Object leftObject = m2nImpl.getLeftObject();
        Class leftClass = m2nImpl.getLeftClass();
        Object rightObject = m2nImpl.getRightObject();
        Class rightClass = m2nImpl.getRightClass();
        ClassDescriptor leftCld = dr.getDescriptorFor(leftClass);
        ClassDescriptor rightCld = dr.getDescriptorFor(rightClass);
        CollectionDescriptor wanted = m2nImpl.getLeftDescriptor();
        if (leftObject == null || rightObject == null) {
            this.log.error("Can't handle MtoNImplementor in correct way, found a 'null' object");
        } else {
            ValueContainer[] leftPkValues = this.pb.serviceBrokerHelper().getKeyValues(leftCld, leftObject);
            ValueContainer[] rightPkValues = this.pb.serviceBrokerHelper().getKeyValues(rightCld, rightObject);
            String[] pkLeftColumns = wanted.getFksToThisClass();
            String[] pkRightColumns = wanted.getFksToItemClass();
            String table = wanted.getIndirectionTable();
            if (table == null) {
                throw new PersistenceBrokerException("Can't remove MtoN implementor without an indirection table");
            }
            String[] cols = this.mergeColumns(pkLeftColumns, pkRightColumns);
            ValueContainer[] values = this.mergeContainer(leftPkValues, rightPkValues);
            if (insert) {
                String stmt = this.pb.serviceSqlGenerator().getInsertMNStatement(table, pkLeftColumns, pkRightColumns);
                GenericObject gObj = new GenericObject(table, cols, values);
                if (!this.tempObjects.contains(gObj)) {
                    this.pb.serviceJdbcAccess().executeUpdateSQL(stmt, leftCld, leftPkValues, rightPkValues);
                    this.tempObjects.add(gObj);
                }
            } else {
                String stmt = this.pb.serviceSqlGenerator().getDeleteMNStatement(table, pkLeftColumns, pkRightColumns);
                this.pb.serviceJdbcAccess().executeUpdateSQL(stmt, leftCld, leftPkValues, rightPkValues);
            }
        }
    }

    private String[] mergeColumns(String[] first, String[] second) {
        String[] cols = new String[first.length + second.length];
        System.arraycopy(first, 0, cols, 0, first.length);
        System.arraycopy(second, 0, cols, first.length, second.length);
        return cols;
    }

    private ValueContainer[] mergeContainer(ValueContainer[] first, ValueContainer[] second) {
        ValueContainer[] values = new ValueContainer[first.length + second.length];
        System.arraycopy(first, 0, values, 0, first.length);
        System.arraycopy(second, 0, values, first.length, second.length);
        return values;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class GenericObject {
        private String tablename;
        private String[] columnNames;
        private ValueContainer[] values;

        public GenericObject(String tablename, String[] columnNames, ValueContainer[] values) {
            this.tablename = tablename;
            this.columnNames = columnNames;
            this.values = values;
            if (values != null && columnNames.length != values.length) {
                throw new OJBRuntimeException("Column name array and value array have NOT same length");
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            boolean result = false;
            if (obj instanceof GenericObject) {
                GenericObject other = (GenericObject)obj;
                boolean bl = result = this.tablename.equalsIgnoreCase(other.tablename) && this.columnNames != null && other.columnNames != null && this.columnNames.length == other.columnNames.length;
                if (result) {
                    for (int i = 0; i < this.columnNames.length; ++i) {
                        int otherIndex = other.indexForColumn(this.columnNames[i]);
                        if (otherIndex < 0) {
                            result = false;
                            break;
                        }
                        result = this.values[i].equals(other.values[otherIndex]);
                        if (!result) break;
                    }
                }
            }
            return result;
        }

        int indexForColumn(String name) {
            int result = -1;
            for (int i = 0; i < this.columnNames.length; ++i) {
                if (!this.columnNames[i].equals(name)) continue;
                result = i;
                break;
            }
            return result;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public ValueContainer getValueFor(String columnName) {
            try {
                return this.values[this.indexForColumn(columnName)];
            }
            catch (Exception e) {
                throw new OJBRuntimeException("Can't find value for column " + columnName + (this.indexForColumn(columnName) < 0 ? ". Column name was not found" : ""), e);
            }
        }

        public String getTablename() {
            return this.tablename;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public ValueContainer[] getValues() {
            return this.values;
        }

        public void setValues(ValueContainer[] values) {
            this.values = values;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("tableName", (Object)this.tablename).append("columnNames", (Object[])this.columnNames).append("values", (Object[])this.values).toString();
        }
    }

    private static final class Key {
        final ValueContainer[] m_containers;

        Key(ValueContainer[] containers) {
            this.m_containers = new ValueContainer[containers.length];
            for (int i = 0; i < containers.length; ++i) {
                Object value = containers[i].getValue();
                JdbcType type = containers[i].getJdbcType();
                if (value instanceof Number) {
                    value = new Long(((Number)value).longValue());
                }
                this.m_containers[i] = new ValueContainer(value, type);
            }
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((Object[])this.m_containers, (Object[])otherKey.m_containers);
            return eb.isEquals();
        }

        public int hashCode() {
            HashCodeBuilder hb = new HashCodeBuilder();
            hb.append((Object[])this.m_containers);
            return hb.toHashCode();
        }
    }
}

