/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.util.Map;
import org.apache.commons.collections.map.ReferenceIdentityMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.IdentityFactory;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.sequence.SequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerTransientImpl;

public class IdentityFactoryImpl
implements IdentityFactory,
PBStateListener {
    private PersistenceBroker broker;
    private Map objectToIdentityMap;
    private SequenceManager transientSequenceManager;

    public IdentityFactoryImpl(PersistenceBroker broker) {
        this.broker = broker;
        this.objectToIdentityMap = new ReferenceIdentityMap(2, 0, true);
        this.transientSequenceManager = new SequenceManagerTransientImpl(broker);
        broker.addListener(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Identity createTransientOrRealIdentity(ClassDescriptor cld, Object objOrProxy) {
        if (objOrProxy == null) {
            throw new OJBRuntimeException("Can't create Identity for 'null'-object");
        }
        Identity result = null;
        Class topLevelClass = null;
        Class<?> realClass = null;
        Object[] pks = null;
        try {
            IndirectionHandler handler = ProxyHelper.getIndirectionHandler(objOrProxy);
            Object object = objOrProxy;
            synchronized (object) {
                if (handler != null) {
                    result = handler.getIdentity();
                } else {
                    realClass = objOrProxy.getClass();
                    topLevelClass = this.broker.getTopLevelClass(objOrProxy.getClass());
                    if (cld == null) {
                        cld = this.broker.getClassDescriptor(objOrProxy.getClass());
                    }
                    BrokerHelper helper = this.broker.serviceBrokerHelper();
                    FieldDescriptor[] fields = cld.getPkFields();
                    pks = new Object[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        FieldDescriptor fld = fields[i];
                        Object value = fld.getPersistentField().get(objOrProxy);
                        if (helper.representsNull(fld, value)) {
                            result = (Identity)this.objectToIdentityMap.get(objOrProxy);
                            if (result != null) break;
                            pks[i] = this.transientSequenceManager.getUniqueValue(fld);
                            result = new Identity(realClass, topLevelClass, pks, true);
                            this.objectToIdentityMap.put(objOrProxy, result);
                            break;
                        }
                        pks[i] = value;
                    }
                    if (result == null) {
                        result = new Identity(realClass, topLevelClass, pks, false);
                    }
                }
            }
        }
        catch (ClassNotPersistenceCapableException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.createException(e, "Can not init Identity for given object.", objOrProxy, topLevelClass, realClass, pks);
        }
        return result;
    }

    public Identity buildIdentity(Object obj) {
        return this.createTransientOrRealIdentity(this.broker.getClassDescriptor(ProxyHelper.getRealClass(obj)), obj);
    }

    public Identity buildIdentity(ClassDescriptor cld, Object obj) {
        return this.createTransientOrRealIdentity(cld, obj);
    }

    public Identity buildIdentity(Class realClass, Class topLevelClass, String[] pkFieldNames, Object[] pkValues) {
        FieldDescriptor[] flds;
        Object[] orderedPKValues = pkValues;
        if (pkValues == null) {
            throw new NullPointerException("Given primary key value array can't be null");
        }
        if ((pkValues.length != 1 || pkFieldNames != null && pkFieldNames.length != 1) && !this.isOrdered(flds = this.broker.getClassDescriptor(realClass).getPkFields(), pkFieldNames)) {
            orderedPKValues = this.reorderFieldValues(flds, pkFieldNames, pkValues);
        }
        return new Identity(realClass, topLevelClass, orderedPKValues);
    }

    private Object[] reorderFieldValues(FieldDescriptor[] flds, String[] fieldNames, Object[] fieldValues) {
        Object[] orderedValues = new Object[flds.length];
        for (int i = 0; i < flds.length; ++i) {
            String fieldName = flds[i].getPersistentField().getName();
            int realPosition = this.findIndexForName(fieldNames, fieldName);
            orderedValues[i] = fieldValues[realPosition];
        }
        return orderedValues;
    }

    private int findIndexForName(String[] fieldNames, String searchName) {
        for (int i = 0; i < fieldNames.length; ++i) {
            if (!searchName.equals(fieldNames[i])) continue;
            return i;
        }
        throw new PersistenceBrokerException("Can't find field name '" + searchName + "' in given array of field names");
    }

    private boolean isOrdered(FieldDescriptor[] flds, String[] pkFieldNames) {
        if (flds.length > 1 && pkFieldNames == null || flds.length != pkFieldNames.length) {
            throw new PersistenceBrokerException("pkFieldName length does not match number of defined PK fields. Expected number of PK fields is " + flds.length + ", given number was " + (pkFieldNames != null ? pkFieldNames.length : 0));
        }
        boolean result = true;
        for (int i = 0; i < flds.length; ++i) {
            FieldDescriptor fld = flds[i];
            result = result && fld.getPersistentField().getName().equals(pkFieldNames[i]);
        }
        return result;
    }

    public Identity buildIdentity(Class realClass, String[] pkFieldNames, Object[] pkValues) {
        return this.buildIdentity(realClass, this.broker.getTopLevelClass(realClass), pkFieldNames, pkValues);
    }

    public Identity buildIdentity(Class realClass, Class topLevelClass, Object[] pkValues) {
        return new Identity(realClass, topLevelClass, pkValues);
    }

    public Identity buildIdentity(Class realClass, Object pkValue) {
        return this.buildIdentity(realClass, (String[])null, new Object[]{pkValue});
    }

    private PersistenceBrokerException createException(Exception ex, String message, Object objectToIdentify, Class topLevelClass, Class realClass, Object[] pks) {
        String eol = SystemUtils.LINE_SEPARATOR;
        StringBuffer msg = new StringBuffer();
        if (message == null) {
            msg.append("Unexpected error: ");
        } else {
            msg.append(message).append(" :");
        }
        if (topLevelClass != null) {
            msg.append(eol).append("objectTopLevelClass=").append(topLevelClass.getName());
        }
        if (realClass != null) {
            msg.append(eol).append("objectRealClass=").append(realClass.getName());
        }
        if (pks != null) {
            msg.append(eol).append("pkValues=").append(ArrayUtils.toString((Object)pks));
        }
        if (objectToIdentify != null) {
            msg.append(eol).append("object to identify: ").append(objectToIdentify);
        }
        if (ex != null) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)ex);
            if (rootCause != null) {
                msg.append(eol).append("The root stack trace is --> ");
                String rootStack = ExceptionUtils.getStackTrace((Throwable)rootCause);
                msg.append(eol).append(rootStack);
            }
            return new PersistenceBrokerException(msg.toString(), ex);
        }
        return new PersistenceBrokerException(msg.toString());
    }

    public void afterBegin(PBStateEvent event) {
    }

    public void afterCommit(PBStateEvent event) {
        if (this.objectToIdentityMap.size() > 0) {
            this.objectToIdentityMap.clear();
        }
    }

    public void afterRollback(PBStateEvent event) {
        if (this.objectToIdentityMap.size() > 0) {
            this.objectToIdentityMap.clear();
        }
    }

    public void beforeClose(PBStateEvent event) {
        if (this.objectToIdentityMap.size() > 0) {
            this.objectToIdentityMap.clear();
        }
    }

    public void beforeRollback(PBStateEvent event) {
    }

    public void afterOpen(PBStateEvent event) {
    }

    public void beforeBegin(PBStateEvent event) {
    }

    public void beforeCommit(PBStateEvent event) {
    }
}

