/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.CacheDistributor;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.ObjectCacheInternal;
import org.apache.ojb.broker.cache.RuntimeCacheException;
import org.apache.ojb.broker.core.DelegatingPersistenceBroker;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ObjectCacheTwoLevelImpl
implements ObjectCacheInternal,
PBStateListener {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$cache$ObjectCacheTwoLevelImpl == null ? (class$org$apache$ojb$broker$cache$ObjectCacheTwoLevelImpl = ObjectCacheTwoLevelImpl.class$("org.apache.ojb.broker.cache.ObjectCacheTwoLevelImpl")) : class$org$apache$ojb$broker$cache$ObjectCacheTwoLevelImpl);
    public static final String APPLICATION_CACHE_PROP = "applicationCache";
    public static final String COPY_STRATEGY_PROP = "copyStrategy";
    public static final String FORCE_PROXIES = "forceProxies";
    private static final String DEF_COPY_STRATEGY = (class$org$apache$ojb$broker$cache$ObjectCacheTwoLevelImpl$CopyStrategyImpl == null ? (class$org$apache$ojb$broker$cache$ObjectCacheTwoLevelImpl$CopyStrategyImpl = ObjectCacheTwoLevelImpl.class$("org.apache.ojb.broker.cache.ObjectCacheTwoLevelImpl$CopyStrategyImpl")) : class$org$apache$ojb$broker$cache$ObjectCacheTwoLevelImpl$CopyStrategyImpl).getName();
    private static final String DEF_APP_CACHE = (class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl == null ? (class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl = ObjectCacheTwoLevelImpl.class$("org.apache.ojb.broker.cache.ObjectCacheDefaultImpl")) : class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl).getName();
    private HashMap sessionCache;
    private int invokeCounter;
    private ReferenceQueue queue = new ReferenceQueue();
    private ObjectCacheInternal applicationCache;
    private CopyStrategy copyStrategy;
    private PersistenceBrokerImpl broker;
    private boolean forceProxies = false;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$ObjectCacheTwoLevelImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$ObjectCacheTwoLevelImpl$CopyStrategyImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$DelegatingPersistenceBroker;
    static /* synthetic */ Class class$org$apache$ojb$broker$PersistenceBroker;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$ObjectCacheInternal;

    public ObjectCacheTwoLevelImpl(PersistenceBroker broker, Properties prop) {
        if (broker instanceof PersistenceBrokerImpl) {
            this.broker = (PersistenceBrokerImpl)broker;
        } else if (broker instanceof DelegatingPersistenceBroker) {
            this.broker = (PersistenceBrokerImpl)((DelegatingPersistenceBroker)broker).getInnermostDelegate();
        } else {
            throw new RuntimeCacheException("Can't initialize two level cache, expect instance of" + (class$org$apache$ojb$broker$core$PersistenceBrokerImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerImpl = ObjectCacheTwoLevelImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerImpl) + " or of " + (class$org$apache$ojb$broker$core$DelegatingPersistenceBroker == null ? (class$org$apache$ojb$broker$core$DelegatingPersistenceBroker = ObjectCacheTwoLevelImpl.class$("org.apache.ojb.broker.core.DelegatingPersistenceBroker")) : class$org$apache$ojb$broker$core$DelegatingPersistenceBroker) + " to setup application cache, but was " + broker);
        }
        this.sessionCache = new HashMap(100);
        this.setupApplicationCache(this.broker, prop);
        broker.addListener(this, true);
    }

    public PersistenceBrokerImpl getBroker() {
        return this.broker;
    }

    private void setupApplicationCache(PersistenceBrokerImpl broker, Properties prop) {
        String applicationCacheName;
        String copyStrategyName;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start setup application cache for broker " + broker);
        }
        if (prop == null) {
            prop = new Properties();
        }
        if ((copyStrategyName = prop.getProperty(COPY_STRATEGY_PROP, DEF_COPY_STRATEGY).trim()).length() == 0) {
            copyStrategyName = DEF_COPY_STRATEGY;
        }
        if ((applicationCacheName = prop.getProperty(APPLICATION_CACHE_PROP, DEF_APP_CACHE).trim()).length() == 0) {
            applicationCacheName = DEF_APP_CACHE;
        }
        String forceProxyValue = prop.getProperty(FORCE_PROXIES, "false").trim();
        this.forceProxies = Boolean.valueOf(forceProxyValue);
        if (this.forceProxies && broker.getProxyFactory().interfaceRequiredForProxyGeneration()) {
            this.log.warn("'forceProxies' is set to true, however a ProxyFactory implementation [" + broker.getProxyFactory().getClass().getName() + "] " + " that requires persistent objects to implement an inteface is being used. Please ensure " + "that all persistent objects implement an interface, or change the ProxyFactory setting to a dynamic " + "proxy generator (like ProxyFactoryCGLIBImpl).");
        }
        Class[] type = new Class[]{class$org$apache$ojb$broker$PersistenceBroker == null ? (class$org$apache$ojb$broker$PersistenceBroker = ObjectCacheTwoLevelImpl.class$("org.apache.ojb.broker.PersistenceBroker")) : class$org$apache$ojb$broker$PersistenceBroker, class$java$util$Properties == null ? (class$java$util$Properties = ObjectCacheTwoLevelImpl.class$("java.util.Properties")) : class$java$util$Properties};
        Object[] objects = new Object[]{broker, prop};
        try {
            ObjectCache temp;
            this.copyStrategy = (CopyStrategy)ClassHelper.newInstance(copyStrategyName);
            Class target = ClassHelper.getClass(applicationCacheName);
            if (target.equals(class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl == null ? (class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl = ObjectCacheTwoLevelImpl.class$("org.apache.ojb.broker.cache.ObjectCacheDefaultImpl")) : class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl)) {
                prop.setProperty("autoSync", "false");
            }
            if (!((temp = (ObjectCache)ClassHelper.newInstance(target, type, objects)) instanceof ObjectCacheInternal)) {
                this.log.warn("Specified application cache class doesn't implement '" + (class$org$apache$ojb$broker$cache$ObjectCacheInternal == null ? (class$org$apache$ojb$broker$cache$ObjectCacheInternal = ObjectCacheTwoLevelImpl.class$("org.apache.ojb.broker.cache.ObjectCacheInternal")) : class$org$apache$ojb$broker$cache$ObjectCacheInternal).getName() + "'. For best interaction only specify caches implementing the internal object cache interface.");
                temp = new CacheDistributor.ObjectCacheInternalWrapper(temp);
            }
            this.applicationCache = (ObjectCacheInternal)temp;
        }
        catch (Exception e) {
            throw new MetadataException("Can't setup application cache. Specified application cache was '" + applicationCacheName + "', copy strategy was '" + copyStrategyName + "'", e);
        }
        if (this.log.isEnabledFor(2)) {
            ToStringBuilder buf = new ToStringBuilder((Object)this);
            buf.append(COPY_STRATEGY_PROP, (Object)copyStrategyName).append(APPLICATION_CACHE_PROP, (Object)applicationCacheName);
            this.log.info("Setup cache: " + buf.toString());
        }
    }

    public ObjectCacheInternal getApplicationCache() {
        return this.applicationCache;
    }

    private Object lookupFromApplicationCache(Identity oid) {
        Object result = null;
        Object obj = this.getApplicationCache().lookup(oid);
        if (obj != null) {
            result = this.copyStrategy.read(this.broker, obj);
        }
        return result;
    }

    private boolean putToApplicationCache(Identity oid, Object obj, boolean cacheIfNew) {
        Object oldTarget = null;
        if (!cacheIfNew) {
            oldTarget = this.getApplicationCache().lookup(oid);
        }
        Object target = this.copyStrategy.write(this.broker, obj, oldTarget);
        if (cacheIfNew) {
            return this.getApplicationCache().cacheIfNew(oid, target);
        }
        this.getApplicationCache().cache(oid, target);
        return false;
    }

    public void resetSessionCache() {
        this.sessionCache.clear();
        this.invokeCounter = 0;
    }

    private void pushToApplicationCache(int typeToProcess, int typeAfterProcess) {
        Iterator iter = this.sessionCache.values().iterator();
        while (iter.hasNext()) {
            CacheEntry entry = (CacheEntry)iter.next();
            Object result = entry.get();
            if (result == null) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Object in session cache was gc, nothing to push to application cache");
                continue;
            }
            if (entry.type != typeToProcess) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Move obj from session cache --> application cache : " + entry.oid);
            }
            if (!ProxyHelper.isMaterialized(result)) continue;
            this.putToApplicationCache(entry.oid, ProxyHelper.getRealObject(result), false);
            entry.type = typeAfterProcess;
        }
    }

    public void doInternalCache(Identity oid, Object obj, int type) {
        this.processQueue();
        if (type == 11) {
            boolean result = this.putToApplicationCache(oid, obj, true);
            CacheEntry entry = new CacheEntry(oid, obj, 7, this.queue);
            if (result) {
                this.putToSessionCache(oid, entry, false);
            } else {
                this.putToSessionCache(oid, entry, true);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("The 'new' materialized object was already in cache, will not push it to application cache: " + oid);
                }
            }
        } else {
            CacheEntry entry = new CacheEntry(oid, obj, type, this.queue);
            this.putToSessionCache(oid, entry, false);
        }
    }

    public Object lookup(Identity oid) {
        Object result = null;
        CacheEntry entry = (CacheEntry)this.sessionCache.get(oid);
        if (entry != null) {
            result = entry.get();
        }
        if (result == null && (result = this.lookupFromApplicationCache(oid)) != null) {
            this.doInternalCache(oid, result, 7);
            this.materializeFullObject(result);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Materialized object from second level cache: " + oid);
            }
        }
        if (result != null && this.log.isDebugEnabled()) {
            this.log.debug("Match for: " + oid);
        }
        return result;
    }

    public void materializeFullObject(Object target) {
        ClassDescriptor cld = this.broker.getClassDescriptor(target.getClass());
        boolean forced = false;
        if (this.forceProxies) {
            this.broker.getReferenceBroker().retrieveProxyReferences(target, cld, false);
            this.broker.getReferenceBroker().retrieveProxyCollections(target, cld, false);
        } else {
            this.broker.getReferenceBroker().retrieveReferences(target, cld, false);
            this.broker.getReferenceBroker().retrieveCollections(target, cld, false);
        }
    }

    public void remove(Identity oid) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remove object " + oid);
        }
        this.sessionCache.remove(oid);
        this.getApplicationCache().remove(oid);
    }

    public void clear() {
        this.sessionCache.clear();
        this.getApplicationCache().clear();
    }

    public void cache(Identity oid, Object obj) {
        this.doInternalCache(oid, obj, 0);
    }

    public boolean cacheIfNew(Identity oid, Object obj) {
        boolean result = this.putToApplicationCache(oid, obj, true);
        if (result) {
            CacheEntry entry = new CacheEntry(oid, obj, 7, this.queue);
            this.putToSessionCache(oid, entry, true);
        }
        return result;
    }

    private void putToSessionCache(Identity oid, CacheEntry entry, boolean onlyIfNew) {
        if (onlyIfNew) {
            if (!this.sessionCache.containsKey(oid)) {
                this.sessionCache.put(oid, entry);
            }
        } else {
            this.sessionCache.put(oid, entry);
        }
    }

    private void processQueue() {
        CacheEntry sv;
        while ((sv = (CacheEntry)this.queue.poll()) != null) {
            this.sessionCache.remove(sv.oid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCommit(PBStateEvent event) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("afterCommit() call, push objects to application cache");
        }
        if (this.invokeCounter != 0) {
            this.log.error("** Please check method calls of ObjectCacheTwoLevelImpl#enableMaterialization and ObjectCacheTwoLevelImpl#disableMaterialization, number of calls have to be equals **");
        }
        try {
            this.pushToApplicationCache(5, 7);
        }
        finally {
            this.resetSessionCache();
        }
    }

    public void beforeClose(PBStateEvent event) {
        if (!this.broker.isInTransaction()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Clearing the session cache");
            }
            this.resetSessionCache();
        }
    }

    public void beforeRollback(PBStateEvent event) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("beforeRollback()");
        }
        this.resetSessionCache();
    }

    public void afterOpen(PBStateEvent event) {
    }

    public void beforeBegin(PBStateEvent event) {
    }

    public void afterBegin(PBStateEvent event) {
    }

    public void beforeCommit(PBStateEvent event) {
    }

    public void afterRollback(PBStateEvent event) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CopyStrategyImpl
    implements CopyStrategy {
        static final String CLASS_NAME_STR = "ojbClassName11";

        public Object read(PersistenceBroker broker, Object obj) {
            HashMap source = (HashMap)obj;
            String className = (String)source.get(CLASS_NAME_STR);
            ClassDescriptor cld = broker.getDescriptorRepository().getDescriptorFor(className);
            Object target = ClassHelper.buildNewObjectInstance(cld);
            FieldDescriptor[] flds = cld.getFieldDescriptor(true);
            int length = flds.length;
            for (int i = 0; i < length; ++i) {
                FieldDescriptor fld = flds[i];
                Object value = source.get(fld.getPersistentField().getName());
                if (value != null) {
                    value = fld.getJdbcType().getFieldType().copy(value);
                }
                value = fld.getFieldConversion().sqlToJava(value);
                fld.getPersistentField().set(target, value);
            }
            return target;
        }

        public Object write(PersistenceBroker broker, Object obj, Object oldObject) {
            ClassDescriptor cld = broker.getClassDescriptor(obj.getClass());
            HashMap target = oldObject != null ? (HashMap)oldObject : new HashMap();
            FieldDescriptor[] flds = cld.getFieldDescriptor(true);
            int length = flds.length;
            for (int i = 0; i < length; ++i) {
                FieldDescriptor fld = flds[i];
                Object value = fld.getPersistentField().get(obj);
                value = fld.getFieldConversion().javaToSql(value);
                value = fld.getJdbcType().getFieldType().copy(value);
                target.put(fld.getPersistentField().getName(), value);
            }
            target.put(CLASS_NAME_STR, obj.getClass().getName());
            return target;
        }
    }

    public static interface CopyStrategy {
        public Object read(PersistenceBroker var1, Object var2);

        public Object write(PersistenceBroker var1, Object var2, Object var3);
    }

    static final class CacheEntry
    extends SoftReference
    implements Serializable {
        private int type;
        private Identity oid;

        public CacheEntry(Identity oid, Object obj, int type, ReferenceQueue q) {
            super(obj, q);
            this.oid = oid;
            this.type = type;
        }
    }
}

