/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.io.File;
import java.io.FileWriter;
import org.apache.ddlutils.io.DataDtdWriter;
import org.apache.ddlutils.model.Database;
import org.apache.ojb.broker.ant.Command;
import org.apache.ojb.broker.ant.DdlUtilsDataHandling;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class WriteDtdToFileCommand
extends Command {
    private File _outputFile;

    public void setOutputFile(File outputFile) {
        this._outputFile = outputFile;
    }

    public boolean isRequiringModel() {
        return true;
    }

    public void execute(Task task, Database dbModel, DescriptorRepository objModel) throws BuildException {
        if (this._outputFile == null) {
            throw new BuildException("No output file specified");
        }
        if (this._outputFile.exists() && !this._outputFile.canWrite()) {
            throw new BuildException("Cannot overwrite output file " + this._outputFile.getAbsolutePath());
        }
        try {
            FileWriter outputWriter = new FileWriter(this._outputFile);
            DataDtdWriter dtdWriter = new DataDtdWriter();
            DdlUtilsDataHandling handling = new DdlUtilsDataHandling();
            handling.setModel(dbModel, objModel);
            handling.getDataDTD(outputWriter);
            outputWriter.close();
            task.log("Written DTD to " + this._outputFile.getAbsolutePath(), 2);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to write to output file " + this._outputFile.getAbsolutePath(), (Throwable)ex);
        }
    }
}

