/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ddlutils.model.Database;
import org.apache.ojb.broker.ant.Command;
import org.apache.ojb.broker.ant.DdlUtilsDataHandling;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class WriteDataToDatabaseCommand
extends Command {
    private File _singleDataFile = null;
    private ArrayList _fileSets = new ArrayList();
    private Boolean _useBatchMode;
    private Integer _batchSize;

    public void addConfiguredFileset(FileSet fileset) {
        this._fileSets.add(fileset);
    }

    public void setDataFile(File dataFile) {
        this._singleDataFile = dataFile;
    }

    public void setBatchSize(int batchSize) {
        this._batchSize = new Integer(batchSize);
    }

    public void setUseBatchMode(boolean useBatchMode) {
        this._useBatchMode = useBatchMode;
    }

    public void execute(Task task, Database dbModel, DescriptorRepository objModel) throws BuildException {
        try {
            DdlUtilsDataHandling handling = new DdlUtilsDataHandling();
            handling.setModel(dbModel, objModel);
            handling.setPlatform(this.getPlatform());
            if (this._singleDataFile != null) {
                this.readSingleDataFile(task, handling, this._singleDataFile);
            } else {
                Iterator it = this._fileSets.iterator();
                while (it.hasNext()) {
                    FileSet fileSet = (FileSet)it.next();
                    File fileSetDir = fileSet.getDir(task.getProject());
                    DirectoryScanner scanner = fileSet.getDirectoryScanner(task.getProject());
                    String[] files = scanner.getIncludedFiles();
                    for (int idx = 0; files != null && idx < files.length; ++idx) {
                        this.readSingleDataFile(task, handling, new File(fileSetDir, files[idx]));
                    }
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException((Throwable)ex);
        }
    }

    private void readSingleDataFile(Task task, DdlUtilsDataHandling handling, File dataFile) {
        if (!dataFile.exists()) {
            task.log("Could not find data file " + dataFile.getAbsolutePath(), 0);
        } else if (!dataFile.isFile()) {
            task.log("Path " + dataFile.getAbsolutePath() + " does not denote a data file", 0);
        } else if (!dataFile.canRead()) {
            task.log("Could not read data file " + dataFile.getAbsolutePath(), 0);
        } else {
            int batchSize = 1;
            if (this._useBatchMode != null && this._useBatchMode.booleanValue() && this._batchSize != null) {
                batchSize = this._batchSize;
            }
            try {
                handling.insertData(new FileReader(dataFile), batchSize);
                task.log("Read data file " + dataFile.getAbsolutePath(), 2);
            }
            catch (Exception ex) {
                if (this.isFailOnError()) {
                    throw new BuildException("Could not read data file " + dataFile.getAbsolutePath(), (Throwable)ex);
                }
                task.log("Could not read data file " + dataFile.getAbsolutePath(), 0);
            }
        }
    }
}

