/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.ant.DBUtility;
import org.apache.ojb.broker.ant.VerifyMappingsTask;
import org.apache.ojb.broker.locking.IsolationLevels;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.RepositoryElements;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryVerifierHandler
extends DefaultHandler
implements RepositoryElements,
IsolationLevels {
    private Logger logger;
    private DescriptorRepository m_repository;
    private JdbcConnectionDescriptor m_CurrentJCD;
    private ClassDescriptor m_CurrentCLD;
    private FieldDescriptor m_CurrentFLD;
    private ObjectReferenceDescriptor m_CurrentORD;
    private CollectionDescriptor m_CurrentCOD;
    private String m_CurrentString;
    private VerifyMappingsTask m_callingTask;
    private DBUtility m_dBUtility;
    private Class m_currentClass = null;
    private String m_CurrentTable = null;
    private boolean m_currentTableExists = false;
    private int defIsoLevel = 2;
    private RepositoryTags tags = RepositoryTags.getInstance();
    private Collection m_VerifyExceptions = new ArrayList(69);
    private Collection m_VerifyWarnings = new ArrayList(69);
    private int m_lastId = 0;
    private Constructor m_persistConstructor = null;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;

    public RepositoryVerifierHandler(VerifyMappingsTask callingTask) {
        this.m_callingTask = callingTask;
        this.m_callingTask.logWarning("Loaded RepositoryVerifierHandler.");
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    private int getLiteralId(String literal) throws PersistenceBrokerException {
        try {
            return this.tags.getIdByTag(literal);
        }
        catch (NullPointerException t) {
            throw new MetadataException("unknown literal: '" + literal + "'", t);
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        this.m_CurrentString = null;
        try {
            switch (this.getLiteralId(qName)) {
                case 0: {
                    String defIso = atts.getValue(this.tags.getTagById(34));
                    if (defIso == null) break;
                    this.defIsoLevel = this.getIsoLevel(defIso);
                    break;
                }
                case 1: {
                    this.m_CurrentJCD = new JdbcConnectionDescriptor();
                    String platform = atts.getValue(this.tags.getTagById(2));
                    this.m_CurrentJCD.setDbms(platform);
                    String level = atts.getValue(this.tags.getTagById(45));
                    this.m_CurrentJCD.setJdbcLevel(level);
                    String driver = atts.getValue(this.tags.getTagById(6));
                    this.m_CurrentJCD.setDriver(driver);
                    String protocol = atts.getValue(this.tags.getTagById(7));
                    this.m_CurrentJCD.setProtocol(protocol);
                    String subprotocol = atts.getValue(this.tags.getTagById(8));
                    this.m_CurrentJCD.setSubProtocol(subprotocol);
                    String dbalias = atts.getValue(this.tags.getTagById(9));
                    this.m_CurrentJCD.setDbAlias(dbalias);
                    String datasource = atts.getValue(this.tags.getTagById(44));
                    this.m_CurrentJCD.setDatasourceName(datasource);
                    String user = atts.getValue(this.tags.getTagById(10));
                    this.m_CurrentJCD.setUserName(user);
                    String password = atts.getValue(this.tags.getTagById(11));
                    this.m_CurrentJCD.setPassWord(password);
                    this.m_dBUtility = this.getDBUtility(this.m_CurrentJCD);
                    break;
                }
                case 12: {
                    String isoLevel = atts.getValue(this.tags.getTagById(34));
                    String classname = atts.getValue(this.tags.getTagById(13));
                    try {
                        this.m_currentClass = this.m_callingTask.loadClass(classname);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new MetadataException("Can't load class-descriptor class '" + classname + "'.");
                    }
                    this.m_CurrentTable = atts.getValue(this.tags.getTagById(14));
                    if (this.m_CurrentTable == null) break;
                    this.m_currentTableExists = this.m_dBUtility.exists(this.m_CurrentTable);
                    if (this.m_currentTableExists) break;
                    throw new MetadataException("The table '" + this.m_CurrentTable + "' does not exist in the database.");
                }
                case 33: {
                    String classname = atts.getValue("class-ref");
                    try {
                        Class classExtent = this.m_callingTask.loadClass(classname);
                        break;
                    }
                    catch (ClassNotFoundException ex) {
                        throw new MetadataException("Can't load extent-class class '" + classname + "'.");
                    }
                }
                case 15: {
                    String strId = atts.getValue("id");
                    this.m_lastId = strId == null ? this.m_lastId + 1 : Integer.parseInt(strId);
                    this.m_CurrentFLD = new FieldDescriptor(null, this.m_lastId);
                    String fieldName = atts.getValue(this.tags.getTagById(16));
                    if (this.m_currentClass == null) break;
                    this.confirmFieldExists(this.m_currentClass, fieldName);
                    String columnName = atts.getValue(this.tags.getTagById(17));
                    this.m_CurrentFLD.setColumnName(columnName);
                    String jdbcType = atts.getValue(this.tags.getTagById(18));
                    this.m_CurrentFLD.setColumnType(jdbcType);
                    if (this.m_currentTableExists) {
                        if (this.m_callingTask.getUseStrictTypeChecking()) {
                            this.m_dBUtility.exists(this.m_CurrentTable, columnName, jdbcType, this.m_callingTask.getIgnoreFieldNameCase());
                            break;
                        }
                        this.m_dBUtility.existsUseWarnings(this.m_CurrentTable, columnName, jdbcType, this.m_callingTask.getIgnoreFieldNameCase());
                    }
                    break;
                }
                case 20: {
                    if (this.m_currentClass == null) break;
                    name = atts.getValue(this.tags.getTagById(16));
                    this.confirmFieldExists(this.m_currentClass, name);
                    String classRef = atts.getValue(this.tags.getTagById(22));
                    try {
                        Class refClass = this.m_callingTask.loadClass(classRef);
                        break;
                    }
                    catch (ClassNotFoundException ex) {
                        throw new MetadataException("Can't find class-ref '" + classRef + "' in reference-descriptor '" + name + "'.");
                    }
                }
                case 27: {
                    String elementClassRef;
                    if (this.m_currentClass == null) break;
                    name = atts.getValue(this.tags.getTagById(16));
                    this.confirmFieldExists(this.m_currentClass, name);
                    String collectionClass = atts.getValue(this.tags.getTagById(37));
                    if (collectionClass != null) {
                        try {
                            Class oCollectionClass = this.m_callingTask.loadClass(collectionClass);
                        }
                        catch (ClassNotFoundException ex) {
                            throw new MetadataException("Can't find collection-class '" + collectionClass + "' in collection-descriptor '" + name + "'.");
                        }
                    }
                    if ((elementClassRef = atts.getValue(this.tags.getTagById(29))) != null) {
                        try {
                            Class oElementClassRef = this.m_callingTask.loadClass(elementClassRef);
                        }
                        catch (ClassNotFoundException ex) {
                            throw new MetadataException("Can't find element-class-ref '" + elementClassRef + "' in collection-descriptor '" + name + "'.");
                        }
                    }
                    break;
                }
            }
        }
        catch (MetadataException mde) {
            this.m_callingTask.logWarning(" --> Mapping Error: " + mde.getMessage());
            this.m_VerifyExceptions.add(mde);
        }
        catch (NullPointerException garbage) {
        }
        catch (SQLWarning sqlw) {
            this.m_callingTask.logInfo(" --> DB Mapping Warning: " + sqlw.getMessage());
            this.m_VerifyWarnings.add(sqlw);
        }
        catch (SQLException sqle) {
            this.m_callingTask.logWarning(" --> DB Mapping Error: " + sqle.getMessage());
            this.m_VerifyExceptions.add(sqle);
        }
        catch (Exception ex) {
            this.logger.error(ex);
            throw new PersistenceBrokerException(ex);
        }
    }

    public void endElement(String uri, String name, String qName) {
        try {
            switch (this.getLiteralId(qName)) {
                case 0: {
                    if (this.m_dBUtility == null) break;
                    this.m_dBUtility.release();
                    break;
                }
                case 1: {
                    break;
                }
                case 12: {
                    this.m_currentClass = null;
                    this.m_CurrentTable = null;
                    this.m_currentTableExists = false;
                    this.m_CurrentCLD = null;
                    break;
                }
                case 33: {
                    break;
                }
                case 15: {
                    this.m_CurrentFLD = null;
                    break;
                }
                case 20: {
                    this.m_CurrentORD = null;
                    break;
                }
                case 27: 
                case 49: {
                    this.m_CurrentCOD = null;
                    break;
                }
                case 38: {
                    break;
                }
                case 41: {
                    break;
                }
                case 40: {
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException(ex);
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.m_CurrentString = this.m_CurrentString == null ? new String(ch, start, length) : this.m_CurrentString + new String(ch, start, length);
    }

    public void error(SAXParseException e) throws SAXException {
        try {
            if (this.m_dBUtility != null) {
                this.m_dBUtility.release();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        throw e;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        try {
            if (this.m_dBUtility != null) {
                this.m_dBUtility.release();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        throw e;
    }

    private int getIsoLevel(String isoLevel) {
        if (isoLevel.equalsIgnoreCase("read-uncommitted")) {
            return 2;
        }
        if (isoLevel.equalsIgnoreCase("read-committed")) {
            return 3;
        }
        if (isoLevel.equalsIgnoreCase("repeatable-read")) {
            return 5;
        }
        if (isoLevel.equalsIgnoreCase("serializable")) {
            return 7;
        }
        if (isoLevel.equalsIgnoreCase("optimistic")) {
            return 4;
        }
        return this.defIsoLevel;
    }

    public int getErrorCount() {
        return this.m_VerifyExceptions.size();
    }

    public int getWarningCount() {
        return this.m_VerifyWarnings.size();
    }

    private DBUtility getDBUtility(JdbcConnectionDescriptor jcd) throws MetadataException, MalformedURLException, ClassNotFoundException {
        String url;
        String password;
        String userName;
        String driver;
        DBUtility retval = null;
        if (this.m_callingTask.hasConnectionInfo()) {
            this.m_callingTask.logWarning("Using DB conection info from Ant task.");
            driver = this.m_callingTask.getJdbcDriver();
            userName = this.m_callingTask.getLogon();
            password = this.m_callingTask.getPassword();
            url = this.m_callingTask.getUrl();
        } else {
            this.m_callingTask.logWarning("Using DB conection info from ojb repository connection descriptor.");
            driver = jcd.getDriver();
            userName = jcd.getUserName();
            password = jcd.getPassWord();
            url = jcd.getProtocol() + ":" + jcd.getSubProtocol() + ":" + jcd.getDbAlias();
        }
        try {
            Class jdbcDriver = this.m_callingTask.loadClass(driver);
            DriverManager.registerDriver((Driver)jdbcDriver.newInstance());
            retval = new DBUtility(url, userName, password);
        }
        catch (ClassNotFoundException cnfe) {
            throw cnfe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetadataException("Could not connect to database with url (" + url + "), driver (" + driver + "), logon (" + userName + "), password (" + password + ").", e);
        }
        return retval;
    }

    private Constructor getPersistenceClassConstructor() throws NoSuchMethodException {
        if (this.m_persistConstructor == null) {
            Class persistentClass = this.m_callingTask.getPersistentFieldClass();
            Class[] aConTypes = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = RepositoryVerifierHandler.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$String == null ? (class$java$lang$String = RepositoryVerifierHandler.class$("java.lang.String")) : class$java$lang$String};
            this.m_persistConstructor = persistentClass.getConstructor(aConTypes);
        }
        return this.m_persistConstructor;
    }

    protected void confirmFieldExists(Class classToCheck, String fieldName) throws MetadataException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Object[] aConParams = new Object[]{classToCheck, fieldName};
        try {
            this.getPersistenceClassConstructor().newInstance(aConParams);
        }
        catch (InvocationTargetException ite) {
            throw new MetadataException(ite.getTargetException().getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

