/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.task.DatabaseTaskBase;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.ant.Command;
import org.apache.ojb.broker.ant.WriteDataSqlToFileCommand;
import org.apache.ojb.broker.ant.WriteDataToDatabaseCommand;
import org.apache.ojb.broker.ant.WriteDtdToFileCommand;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.RepositoryPersistor;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class RepositoryDataTask
extends DatabaseTaskBase {
    private ArrayList _commands = new ArrayList();
    private String _jcdAlias;
    private File _ojbPropertiesFile;
    private File _repositoryFile;
    private File _singleSchemaFile = null;
    private ArrayList _fileSets = new ArrayList();
    private boolean _useInternalDtd = true;

    public void setJcdAlias(String alias) {
        this._jcdAlias = alias;
    }

    public String getJcdAlias() {
        return this._jcdAlias;
    }

    public File getOjbPropertiesFile() {
        return this._ojbPropertiesFile;
    }

    public void setOjbPropertiesFile(File ojbPropertiesFile) {
        this._ojbPropertiesFile = ojbPropertiesFile;
    }

    public File getRepositoryFile() {
        return this._repositoryFile;
    }

    public void setRepositoryFile(File file) {
        this._repositoryFile = file;
    }

    public void setUseInternalDtd(boolean useInternalDtd) {
        this._useInternalDtd = useInternalDtd;
    }

    public void addConfiguredFileset(FileSet fileset) {
        this._fileSets.add(fileset);
    }

    public void setSchemaFile(File schemaFile) {
        this._singleSchemaFile = schemaFile;
    }

    public void addWriteDtdToFile(WriteDtdToFileCommand command) {
        this._commands.add(command);
    }

    public void addWriteDataToDatabase(WriteDataToDatabaseCommand command) {
        this._commands.add(command);
    }

    public void addWriteDataSqlToFile(WriteDataSqlToFileCommand command) {
        this._commands.add(command);
    }

    protected Database readModel() {
        DatabaseIO reader = new DatabaseIO();
        Database model = null;
        reader.setUseInternalDtd(this._useInternalDtd);
        if (this._singleSchemaFile != null && !this._fileSets.isEmpty()) {
            throw new BuildException("Please use either the schemafile attribute or the sub fileset element, but not both");
        }
        if (this._singleSchemaFile != null) {
            model = this.readSingleSchemaFile(reader, this._singleSchemaFile);
        } else {
            Iterator it = this._fileSets.iterator();
            while (it.hasNext()) {
                FileSet fileSet = (FileSet)it.next();
                File fileSetDir = fileSet.getDir(this.getProject());
                DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                String[] files = scanner.getIncludedFiles();
                for (int idx = 0; files != null && idx < files.length; ++idx) {
                    Database curModel = this.readSingleSchemaFile(reader, new File(fileSetDir, files[idx]));
                    if (model == null) {
                        model = curModel;
                        continue;
                    }
                    if (curModel == null) continue;
                    try {
                        model.mergeWith(curModel);
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        throw new BuildException("Could not merge with schema from file " + files[idx] + ": " + ex.getLocalizedMessage(), (Throwable)ex);
                    }
                }
            }
        }
        return model;
    }

    private Database readSingleSchemaFile(DatabaseIO reader, File schemaFile) {
        Database model = null;
        if (!schemaFile.isFile()) {
            this.log("Path " + schemaFile.getAbsolutePath() + " does not denote a schema file", 0);
        } else if (!schemaFile.canRead()) {
            this.log("Could not read schema file " + schemaFile.getAbsolutePath(), 0);
        } else {
            try {
                model = reader.read(schemaFile);
                this.log("Read schema file " + schemaFile.getAbsolutePath(), 2);
            }
            catch (Exception ex) {
                throw new BuildException("Could not read schema file " + schemaFile.getAbsolutePath() + ": " + ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return model;
    }

    private MetadataManager initOJB() {
        try {
            if (this._ojbPropertiesFile == null) {
                this._ojbPropertiesFile = new File("OJB.properties");
                if (!this._ojbPropertiesFile.exists()) {
                    throw new BuildException("Could not find OJB.properties, please specify it via the ojbpropertiesfile attribute");
                }
            } else {
                if (!this._ojbPropertiesFile.exists()) {
                    throw new BuildException("Could not load the specified OJB properties file " + this._ojbPropertiesFile);
                }
                this.log("Using properties file " + this._ojbPropertiesFile.getAbsolutePath(), 2);
                System.setProperty("OJB.properties", this._ojbPropertiesFile.getAbsolutePath());
            }
            MetadataManager metadataManager = MetadataManager.getInstance();
            RepositoryPersistor persistor = new RepositoryPersistor();
            if (this._repositoryFile != null) {
                if (!this._repositoryFile.exists()) {
                    throw new BuildException("Could not load the specified repository file " + this._repositoryFile);
                }
                this.log("Loading repository file " + this._repositoryFile.getAbsolutePath(), 2);
                metadataManager.mergeConnectionRepository(persistor.readConnectionRepository(this._repositoryFile.getAbsolutePath()));
                metadataManager.mergeDescriptorRepository(persistor.readDescriptorRepository(this._repositoryFile.getAbsolutePath()));
            } else if (metadataManager.connectionRepository().getAllDescriptor().isEmpty() && metadataManager.getGlobalRepository().getDescriptorTable().isEmpty()) {
                Properties props = new Properties();
                props.load(new FileInputStream(this._ojbPropertiesFile));
                String repositoryPath = props.getProperty("repositoryFile", "repository.xml");
                File repositoryFile = new File(repositoryPath);
                if (!repositoryFile.exists()) {
                    repositoryFile = new File(this._ojbPropertiesFile.getParentFile(), repositoryPath);
                }
                metadataManager.mergeConnectionRepository(persistor.readConnectionRepository(repositoryFile.getAbsolutePath()));
                metadataManager.mergeDescriptorRepository(persistor.readDescriptorRepository(repositoryFile.getAbsolutePath()));
            }
            if (metadataManager.getDefaultPBKey() == null) {
                Iterator it = metadataManager.connectionRepository().getAllDescriptor().iterator();
                while (it.hasNext()) {
                    JdbcConnectionDescriptor descriptor = (JdbcConnectionDescriptor)it.next();
                    if (!descriptor.isDefaultConnection()) continue;
                    metadataManager.setDefaultPBKey(new PBKey(descriptor.getJcdAlias(), descriptor.getUserName(), descriptor.getPassWord()));
                    break;
                }
            }
            return metadataManager;
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this._commands.isEmpty()) {
            this.log("No sub tasks specified, so there is nothing to do.", 2);
            return;
        }
        ClassLoader sysClassLoader = Thread.currentThread().getContextClassLoader();
        AntClassLoader newClassLoader = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), true);
        Thread.currentThread().setContextClassLoader((ClassLoader)newClassLoader);
        try {
            MetadataManager manager = this.initOJB();
            Database dbModel = this.readModel();
            DescriptorRepository objModel = manager.getGlobalRepository();
            if (dbModel == null) {
                throw new BuildException("No database model specified");
            }
            Iterator it = this._commands.iterator();
            while (it.hasNext()) {
                Command cmd = (Command)it.next();
                cmd.setPlatform(this.getPlatform());
                cmd.execute((Task)this, dbModel, objModel);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(sysClassLoader);
        }
    }
}

