/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.JoinSyntaxTypes;
import org.apache.ojb.broker.accesslayer.sql.SqlSelectStatement;
import org.apache.ojb.broker.accesslayer.sql.SqlStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.SuperReferenceDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.query.BetweenCriteria;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.ExistsCriteria;
import org.apache.ojb.broker.query.FieldCriteria;
import org.apache.ojb.broker.query.InCriteria;
import org.apache.ojb.broker.query.LikeCriteria;
import org.apache.ojb.broker.query.MtoNQuery;
import org.apache.ojb.broker.query.NullCriteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryBySQL;
import org.apache.ojb.broker.query.SelectionCriteria;
import org.apache.ojb.broker.query.SqlCriteria;
import org.apache.ojb.broker.query.UserAlias;
import org.apache.ojb.broker.util.SqlHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class SqlQueryStatement
implements SqlStatement,
JoinSyntaxTypes {
    private static final String ALIAS_SEPARATOR = ".";
    private static final String M_N_ALIAS = "M_N";
    private String sql;
    private SqlQueryStatement m_parentStatement;
    private Logger m_logger;
    private TableAlias m_root;
    private TableAlias m_search;
    private QueryByCriteria m_query;
    private HashMap m_pathToAlias = new HashMap();
    private HashMap m_cldToAlias = new HashMap();
    private HashMap m_joinTreeToCriteria = new HashMap();
    private Platform m_platform;
    private ClassDescriptor m_baseCld;
    private ClassDescriptor m_searchCld;
    private int m_aliasCount = 0;
    protected HashMap m_attrToFld = new HashMap();
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement$TableAlias;

    public SqlQueryStatement(Platform pf, ClassDescriptor cld, Query query, Logger logger) {
        this(null, pf, cld, query, logger);
    }

    public SqlQueryStatement(SqlQueryStatement parent, Platform pf, ClassDescriptor cld, Query query, Logger logger) {
        this.m_logger = logger != null ? logger : LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement == null ? (class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement = SqlQueryStatement.class$("org.apache.ojb.broker.accesslayer.sql.SqlQueryStatement")) : class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement);
        this.m_parentStatement = parent;
        this.m_query = (QueryByCriteria)query;
        this.m_platform = pf;
        this.m_searchCld = cld;
        this.m_baseCld = this.m_query == null || this.m_query.getBaseClass() == this.m_query.getSearchClass() ? this.m_searchCld : cld.getRepository().getDescriptorFor(query.getBaseClass());
        this.m_root = this.createTableAlias(this.m_baseCld, null, "");
        if (this.m_query instanceof MtoNQuery) {
            MtoNQuery mnQuery = (MtoNQuery)((Object)this.m_query);
            TableAlias mnAlias = new TableAlias(mnQuery.getIndirectionTable(), M_N_ALIAS);
            this.setTableAliasForPath(mnQuery.getIndirectionTable(), null, mnAlias);
        }
        this.m_search = this.m_searchCld == this.m_baseCld ? this.m_root : this.getTableAlias(this.m_query.getObjectProjectionAttribute(), false, null, null, this.m_query.getPathClasses());
        this.buildSuperJoinTree(this.m_root, this.m_baseCld, "", false);
        this.buildMultiJoinTree(this.m_root, this.m_baseCld, "", true);
        if (query != null) {
            this.splitCriteria();
        }
    }

    protected ClassDescriptor getBaseClassDescriptor() {
        return this.m_baseCld;
    }

    protected ClassDescriptor getSearchClassDescriptor() {
        return this.m_searchCld;
    }

    protected AttributeInfo getAttributeInfo(String attr, boolean useOuterJoins, UserAlias aUserAlias, Map pathClasses) {
        TableAlias tableAlias;
        AttributeInfo result = new AttributeInfo();
        SqlHelper.PathInfo pathInfo = SqlHelper.splitPath(attr);
        String colName = pathInfo.column;
        if (colName.startsWith("parentQuery.") && this.m_parentStatement != null) {
            String[] fieldNameRef = new String[]{colName.substring("parentQuery.".length())};
            return this.m_parentStatement.getAttributeInfo(fieldNameRef[0], useOuterJoins, aUserAlias, pathClasses);
        }
        int sp = colName.lastIndexOf(ALIAS_SEPARATOR);
        if (sp == -1) {
            tableAlias = this.getRoot();
        } else {
            String[] fieldNameRef;
            String pathName = colName.substring(0, sp);
            tableAlias = this.getTableAlias(pathName, useOuterJoins, aUserAlias, fieldNameRef = new String[]{colName.substring(sp + 1)}, pathClasses);
            if (tableAlias == null && colName.lastIndexOf(ALIAS_SEPARATOR) == -1) {
                tableAlias = this.getTableAlias(pathName, useOuterJoins, new UserAlias(pathName, pathName, pathName), null, pathClasses);
            }
            if (tableAlias != null) {
                pathInfo.column = fieldNameRef[0];
            }
        }
        result.tableAlias = tableAlias;
        result.pathInfo = pathInfo;
        return result;
    }

    protected String getColName(TableAlias aTableAlias, SqlHelper.PathInfo aPathInfo, boolean translate) {
        String result = null;
        if (!translate) {
            return aPathInfo.column;
        }
        if (aTableAlias.cld == null && M_N_ALIAS.equals(aTableAlias.alias)) {
            return this.getIndirectionTableColName(aTableAlias, aPathInfo.path);
        }
        FieldDescriptor fld = this.getFieldDescriptor(aTableAlias, aPathInfo);
        if (fld != null) {
            this.m_attrToFld.put(aPathInfo.path, fld);
            if (!fld.getClassDescriptor().getFullTableName().equals(aTableAlias.table) && aTableAlias.hasJoins()) {
                Iterator itr = aTableAlias.joins.iterator();
                while (itr.hasNext()) {
                    Join join = (Join)itr.next();
                    if (!join.right.table.equals(fld.getClassDescriptor().getFullTableName())) continue;
                    result = join.right.alias + ALIAS_SEPARATOR + fld.getColumnName();
                    break;
                }
                if (result == null) {
                    result = aPathInfo.column;
                }
            } else {
                result = aTableAlias.alias + ALIAS_SEPARATOR + fld.getColumnName();
            }
        } else {
            result = "*".equals(aPathInfo.column) ? aPathInfo.column : aPathInfo.column;
        }
        return result;
    }

    protected boolean appendColName(TableAlias aTableAlias, SqlHelper.PathInfo aPathInfo, boolean translate, StringBuffer buf) {
        String prefix = aPathInfo.prefix;
        String suffix = aPathInfo.suffix;
        String colName = this.getColName(aTableAlias, aPathInfo, translate);
        if (prefix != null) {
            buf.append(prefix);
        }
        buf.append(colName);
        if (suffix != null) {
            buf.append(suffix);
        }
        return true;
    }

    protected FieldDescriptor getFieldDescriptor(TableAlias aTableAlias, SqlHelper.PathInfo aPathInfo) {
        FieldDescriptor fld = null;
        String colName = aPathInfo.column;
        if (aTableAlias != null && (fld = aTableAlias.cld.getFieldDescriptorByName(colName)) == null) {
            ObjectReferenceDescriptor ord = aTableAlias.cld.getObjectReferenceDescriptorByName(colName);
            fld = ord != null ? this.getFldFromReference(aTableAlias, ord) : this.getFldFromJoin(aTableAlias, colName);
        }
        return fld;
    }

    private FieldDescriptor getFldFromJoin(TableAlias aTableAlias, String aColName) {
        FieldDescriptor fld = null;
        if (aTableAlias.joins != null) {
            Iterator itr = aTableAlias.joins.iterator();
            while (itr.hasNext()) {
                Join join = (Join)itr.next();
                ClassDescriptor cld = join.right.cld;
                if (cld == null || (fld = cld.getFieldDescriptorByName(aColName)) == null) continue;
                break;
            }
        }
        return fld;
    }

    private FieldDescriptor getFldFromReference(TableAlias aTableAlias, ObjectReferenceDescriptor anOrd) {
        FieldDescriptor fld = null;
        if (aTableAlias == this.getRoot()) {
            FieldDescriptor[] fk = anOrd.getForeignKeyFieldDescriptors(aTableAlias.cld);
            if (fk.length > 0) {
                fld = fk[0];
            }
        } else {
            ClassDescriptor cld = aTableAlias.cld.getRepository().getDescriptorFor(anOrd.getItemClass());
            if (cld != null) {
                fld = aTableAlias.cld.getFieldDescriptorByName(cld.getPkFields()[0].getPersistentField().getName());
            }
        }
        return fld;
    }

    protected boolean appendColName(String attr, boolean useOuterJoins, UserAlias aUserAlias, StringBuffer buf) {
        AttributeInfo attrInfo = this.getAttributeInfo(attr, useOuterJoins, aUserAlias, this.getQuery().getPathClasses());
        TableAlias tableAlias = attrInfo.tableAlias;
        return this.appendColName(tableAlias, attrInfo.pathInfo, tableAlias != null, buf);
    }

    protected boolean appendColName(String attr, String attrAlias, boolean useOuterJoins, UserAlias aUserAlias, StringBuffer buf) {
        AttributeInfo attrInfo = this.getAttributeInfo(attr, useOuterJoins, aUserAlias, this.getQuery().getPathClasses());
        TableAlias tableAlias = attrInfo.tableAlias;
        SqlHelper.PathInfo pi = attrInfo.pathInfo;
        pi.suffix = pi.suffix != null ? pi.suffix + " as " + attrAlias : " as " + attrAlias;
        return this.appendColName(tableAlias, pi, true, buf);
    }

    protected void ensureColumns(List columns, List existingColumns) {
        if (columns == null || columns.isEmpty()) {
            return;
        }
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            FieldHelper cf = (FieldHelper)iter.next();
            if (existingColumns.contains(cf.name)) continue;
            this.getAttributeInfo(cf.name, false, null, this.getQuery().getPathClasses());
        }
    }

    protected List ensureColumns(List columns, List existingColumns, StringBuffer buf) {
        if (columns == null || columns.isEmpty()) {
            return existingColumns;
        }
        Iterator iter = columns.iterator();
        int ojb_col = existingColumns.size() + 1;
        while (iter.hasNext()) {
            FieldHelper cf = (FieldHelper)iter.next();
            if (existingColumns.contains(cf.name)) continue;
            existingColumns.add(cf.name);
            buf.append(",");
            this.appendColName(cf.name, "ojb_col_" + ojb_col, false, null, buf);
            ++ojb_col;
        }
        return existingColumns;
    }

    protected void appendWhereClause(StringBuffer where, Criteria crit, StringBuffer stmt) {
        if (where.length() == 0) {
            where = null;
        }
        if (where != null || crit != null && !crit.isEmpty()) {
            stmt.append(" WHERE ");
            this.appendClause(where, crit, stmt);
        }
    }

    protected void appendHavingClause(StringBuffer having, Criteria crit, StringBuffer stmt) {
        if (having.length() == 0) {
            having = null;
        }
        if (having != null || crit != null) {
            stmt.append(" HAVING ");
            this.appendClause(having, crit, stmt);
        }
    }

    protected void appendClause(StringBuffer clause, Criteria crit, StringBuffer stmt) {
        if (clause != null) {
            stmt.append(clause.toString());
        }
        if (crit != null) {
            if (clause == null) {
                stmt.append(this.asSQLStatement(crit));
            } else {
                stmt.append(" AND (");
                stmt.append(this.asSQLStatement(crit));
                stmt.append(")");
            }
        }
    }

    private String asSQLStatement(Criteria crit) {
        Enumeration e = crit.getElements();
        StringBuffer statement = new StringBuffer();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Criteria) {
                Criteria pc = (Criteria)o;
                if (pc.isEmpty()) continue;
                String addAtStart = "";
                String addAtEnd = "";
                if (pc.isEmbraced()) {
                    addAtStart = " (";
                    addAtEnd = ")";
                }
                switch (pc.getType()) {
                    case 0: {
                        if (statement.length() > 0) {
                            statement.append(" OR ");
                        }
                        statement.append(addAtStart);
                        statement.append(this.asSQLStatement(pc));
                        statement.append(addAtEnd);
                        break;
                    }
                    case 1: {
                        if (statement.length() > 0) {
                            statement.insert(0, "( ");
                            statement.append(") AND ");
                        }
                        statement.append(addAtStart);
                        statement.append(this.asSQLStatement(pc));
                        statement.append(addAtEnd);
                    }
                }
                continue;
            }
            SelectionCriteria c = (SelectionCriteria)o;
            if (statement.length() > 0) {
                statement.insert(0, "(");
                statement.append(") AND ");
            }
            this.appendSQLClause(c, statement);
        }
        if (crit.isNegative()) {
            statement.insert(0, " NOT (");
            statement.append(")");
        }
        return statement.length() == 0 ? null : statement.toString();
    }

    private void appendBetweenCriteria(TableAlias alias, SqlHelper.PathInfo pathInfo, BetweenCriteria c, StringBuffer buf) {
        this.appendColName(alias, pathInfo, c.isTranslateAttribute(), buf);
        buf.append(c.getClause());
        this.appendParameter(c.getValue(), buf);
        buf.append(" AND ");
        this.appendParameter(c.getValue2(), buf);
    }

    private void appendExistsCriteria(ExistsCriteria c, StringBuffer buf) {
        Query subQuery = (Query)c.getValue();
        buf.append(c.getClause());
        this.appendSubQuery(subQuery, buf);
    }

    private void appendFieldCriteria(TableAlias alias, SqlHelper.PathInfo pathInfo, FieldCriteria c, StringBuffer buf) {
        this.appendColName(alias, pathInfo, c.isTranslateAttribute(), buf);
        buf.append(c.getClause());
        if (c.isTranslateField()) {
            this.appendColName((String)c.getValue(), false, c.getUserAlias(), buf);
        } else {
            buf.append(c.getValue());
        }
    }

    private String getIndirectionTableColName(TableAlias mnAlias, String path) {
        int dotIdx = path.lastIndexOf(ALIAS_SEPARATOR);
        String column = path.substring(dotIdx);
        return mnAlias.alias + column;
    }

    private void appendInCriteria(TableAlias alias, SqlHelper.PathInfo pathInfo, InCriteria c, StringBuffer buf) {
        this.appendColName(alias, pathInfo, c.isTranslateAttribute(), buf);
        buf.append(c.getClause());
        if (c.getValue() instanceof Collection) {
            Object[] values = ((Collection)c.getValue()).toArray();
            int size = ((Collection)c.getValue()).size();
            buf.append("(");
            if (size > 0) {
                for (int i = 0; i < size - 1; ++i) {
                    this.appendParameter(values[i], buf);
                    buf.append(",");
                }
                this.appendParameter(values[size - 1], buf);
            }
            buf.append(")");
        } else {
            this.appendParameter(c.getValue(), buf);
        }
    }

    private void appendNullCriteria(TableAlias alias, SqlHelper.PathInfo pathInfo, NullCriteria c, StringBuffer buf) {
        this.appendColName(alias, pathInfo, c.isTranslateAttribute(), buf);
        buf.append(c.getClause());
    }

    private void appendSQLCriteria(SqlCriteria c, StringBuffer buf) {
        buf.append(c.getClause());
    }

    private void appendSelectionCriteria(TableAlias alias, SqlHelper.PathInfo pathInfo, SelectionCriteria c, StringBuffer buf) {
        this.appendColName(alias, pathInfo, c.isTranslateAttribute(), buf);
        buf.append(c.getClause());
        this.appendParameter(c.getValue(), buf);
    }

    private void appendLikeCriteria(TableAlias alias, SqlHelper.PathInfo pathInfo, LikeCriteria c, StringBuffer buf) {
        this.appendColName(alias, pathInfo, c.isTranslateAttribute(), buf);
        buf.append(c.getClause());
        this.appendParameter(c.getValue(), buf);
        buf.append(this.m_platform.getEscapeClause(c));
    }

    protected void appendCriteria(TableAlias alias, SqlHelper.PathInfo pathInfo, SelectionCriteria c, StringBuffer buf) {
        if (c instanceof FieldCriteria) {
            this.appendFieldCriteria(alias, pathInfo, (FieldCriteria)c, buf);
        } else if (c instanceof NullCriteria) {
            this.appendNullCriteria(alias, pathInfo, (NullCriteria)c, buf);
        } else if (c instanceof BetweenCriteria) {
            this.appendBetweenCriteria(alias, pathInfo, (BetweenCriteria)c, buf);
        } else if (c instanceof InCriteria) {
            this.appendInCriteria(alias, pathInfo, (InCriteria)c, buf);
        } else if (c instanceof SqlCriteria) {
            this.appendSQLCriteria((SqlCriteria)c, buf);
        } else if (c instanceof ExistsCriteria) {
            this.appendExistsCriteria((ExistsCriteria)c, buf);
        } else if (c instanceof LikeCriteria) {
            this.appendLikeCriteria(alias, pathInfo, (LikeCriteria)c, buf);
        } else {
            this.appendSelectionCriteria(alias, pathInfo, c, buf);
        }
    }

    protected void appendSQLClause(SelectionCriteria c, StringBuffer buf) {
        if (c instanceof SqlCriteria) {
            buf.append(c.getAttribute());
            return;
        }
        if (c.getAttribute() instanceof Query) {
            Query q = (Query)c.getAttribute();
            buf.append("(");
            buf.append(this.getSubQuerySQL(q));
            buf.append(")");
            buf.append(c.getClause());
            this.appendParameter(c.getValue(), buf);
            return;
        }
        AttributeInfo attrInfo = this.getAttributeInfo((String)c.getAttribute(), false, c.getUserAlias(), c.getPathClasses());
        TableAlias alias = attrInfo.tableAlias;
        if (alias != null) {
            boolean hasExtents = alias.hasExtents();
            if (hasExtents) {
                buf.append("(");
                this.appendCriteria(alias, attrInfo.pathInfo, c, buf);
                c.setNumberOfExtentsToBind(alias.extents.size());
                Iterator iter = alias.iterateExtents();
                while (iter.hasNext()) {
                    TableAlias tableAlias = (TableAlias)iter.next();
                    buf.append(" OR ");
                    this.appendCriteria(tableAlias, attrInfo.pathInfo, c, buf);
                }
                buf.append(")");
            } else {
                this.appendCriteria(alias, attrInfo.pathInfo, c, buf);
            }
        } else {
            this.appendCriteria(alias, attrInfo.pathInfo, c, buf);
        }
    }

    private void appendParameter(Object value, StringBuffer buf) {
        if (value instanceof Query) {
            this.appendSubQuery((Query)value, buf);
        } else {
            buf.append("?");
        }
    }

    private void appendSubQuery(Query subQuery, StringBuffer buf) {
        buf.append(" (");
        buf.append(this.getSubQuerySQL(subQuery));
        buf.append(") ");
    }

    private String getSubQuerySQL(Query subQuery) {
        ClassDescriptor cld = this.getRoot().cld.getRepository().getDescriptorFor(subQuery.getSearchClass());
        String sql = subQuery instanceof QueryBySQL ? ((QueryBySQL)subQuery).getSql() : new SqlSelectStatement(this, this.m_platform, cld, subQuery, this.m_logger).getStatement();
        return sql;
    }

    private TableAlias getTableAlias(String aPath, boolean useOuterJoins, UserAlias aUserAlias, String[] fieldRef, Map pathClasses) {
        TableAlias curr;
        String pathAlias;
        String attrPath = null;
        boolean outer = useOuterJoins;
        List hintClasses = null;
        String string = pathAlias = aUserAlias == null ? null : aUserAlias.getAlias(aPath);
        if (pathClasses != null) {
            hintClasses = (List)pathClasses.get(aPath);
        }
        if ((curr = this.getTableAliasForPath(aPath, pathAlias, hintClasses)) != null) {
            return curr;
        }
        ArrayList descriptors = this.getRoot().cld.getAttributeDescriptorsForPath(aPath, pathClasses);
        TableAlias prev = this.getRoot();
        if ((descriptors == null || descriptors.size() == 0) && prev.hasJoins()) {
            Iterator itr = prev.iterateJoins();
            while (itr.hasNext()) {
                prev = ((Join)itr.next()).left;
                descriptors = prev.cld.getAttributeDescriptorsForPath(aPath, pathClasses);
                if (descriptors.size() <= 0) continue;
            }
        }
        int pathLength = descriptors.size();
        for (int i = 0; i < pathLength; ++i) {
            Object[] keys;
            Object[] prevKeys;
            ClassDescriptor cld;
            if (!(descriptors.get(i) instanceof ObjectReferenceDescriptor)) continue;
            ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)descriptors.get(i);
            String attr = ord.getAttributeName();
            attrPath = attrPath == null ? attr : attrPath + ALIAS_SEPARATOR + attr;
            if (pathClasses != null) {
                hintClasses = (List)pathClasses.get(attrPath);
            }
            boolean bl = outer = outer || this.getQuery().isPathOuterJoin(attrPath);
            if (ord instanceof CollectionDescriptor) {
                CollectionDescriptor cod = (CollectionDescriptor)ord;
                cld = this.getItemClassDescriptor(cod, hintClasses);
                if (!cod.isMtoNRelation()) {
                    prevKeys = prev.cld.getPkFields();
                    keys = cod.getForeignKeyFieldDescriptors(cld);
                } else {
                    String mnUserAlias;
                    String mnAttrPath = attrPath + "*";
                    TableAlias indirect = this.getTableAliasForPath(mnAttrPath, mnUserAlias = aUserAlias == null ? null : aUserAlias + "*", null);
                    if (indirect == null) {
                        indirect = this.createTableAlias(cod.getIndirectionTable(), mnAttrPath, mnUserAlias);
                        prevKeys = prev.cld.getPkFields();
                        keys = cod.getFksToThisClass();
                        this.addJoin(prev, prevKeys, indirect, keys, outer, attr + "*");
                    }
                    prev = indirect;
                    prevKeys = cod.getFksToItemClass();
                    keys = cld.getPkFields();
                }
            } else {
                cld = this.getItemClassDescriptor(ord, hintClasses);
                if (!prev.cld.equals(ord.getClassDescriptor())) {
                    TableAlias ordAlias = this.getTableAliasForClassDescriptor(ord.getClassDescriptor());
                    Join join = prev.getJoin(ordAlias);
                    if (join != null) {
                        join.isOuter = join.isOuter || outer;
                    }
                    prev = ordAlias;
                }
                prevKeys = ord.getForeignKeyFieldDescriptors(prev.cld);
                keys = cld.getPkFields();
                if (fieldRef != null && i == pathLength - 1) {
                    FieldDescriptor[] pk = cld.getPkFields();
                    for (int j = 0; j < pk.length; ++j) {
                        if (!pk[j].getAttributeName().equals(fieldRef[0])) continue;
                        fieldRef[0] = ((FieldDescriptor)prevKeys[j]).getAttributeName();
                        return prev;
                    }
                }
            }
            pathAlias = aUserAlias == null ? null : aUserAlias.getAlias(attrPath);
            curr = this.getTableAliasForPath(attrPath, pathAlias, hintClasses);
            if (curr == null) {
                curr = this.createTableAlias(cld, attrPath, pathAlias, hintClasses);
                outer = outer || curr.cld == prev.cld || curr.hasExtents() || useOuterJoins;
                this.addJoin(prev, prevKeys, curr, keys, outer, attr);
                this.buildSuperJoinTree(curr, cld, aPath, outer);
            }
            prev = curr;
        }
        this.m_logger.debug("Result of getTableAlias(): " + curr);
        return curr;
    }

    private void addJoin(TableAlias left, Object[] leftKeys, TableAlias right, Object[] rightKeys, boolean outer, String name) {
        Object[] extKeys;
        TableAlias extAlias;
        int i;
        left.addJoin(new Join(left, leftKeys, right, rightKeys, outer, name));
        if (right.hasExtents()) {
            for (i = 0; i < right.extents.size(); ++i) {
                extAlias = (TableAlias)right.extents.get(i);
                extKeys = this.getExtentFieldDescriptors(extAlias, (FieldDescriptor[])rightKeys);
                left.addJoin(new Join(left, leftKeys, extAlias, extKeys, true, name));
            }
        }
        if (left.hasExtents()) {
            for (i = 0; i < left.extents.size(); ++i) {
                extAlias = (TableAlias)left.extents.get(i);
                extKeys = this.getExtentFieldDescriptors(extAlias, (FieldDescriptor[])leftKeys);
                TableAlias rightCopy = right.copy("C" + i);
                right.extents.add(rightCopy);
                right.extents.addAll(rightCopy.extents);
                this.addJoin(extAlias, extKeys, rightCopy, rightKeys, true, name);
            }
        }
    }

    private FieldDescriptor[] getExtentFieldDescriptors(TableAlias extAlias, FieldDescriptor[] fds) {
        FieldDescriptor[] result = new FieldDescriptor[fds.length];
        for (int i = 0; i < fds.length; ++i) {
            result[i] = extAlias.cld.getFieldDescriptorByName(fds[i].getAttributeName());
        }
        return result;
    }

    private char getAliasChar() {
        char result = 'A';
        if (this.m_parentStatement != null) {
            result = (char)(this.m_parentStatement.getAliasChar() + '\u0001');
        }
        return result;
    }

    private TableAlias createTableAlias(ClassDescriptor aCld, String aPath, String aUserAlias, List hints) {
        if (aUserAlias == null) {
            return this.createTableAlias(aCld, hints, aPath);
        }
        return this.createTableAlias(aCld, hints, aUserAlias + ALIAS_SEPARATOR + aPath);
    }

    private TableAlias createTableAlias(ClassDescriptor cld, List hints, String path) {
        boolean lookForExtents = false;
        if (!cld.getExtentClasses().isEmpty() && path.length() > 0) {
            lookForExtents = true;
        }
        String aliasName = String.valueOf(this.getAliasChar()) + this.m_aliasCount++;
        TableAlias alias = new TableAlias(cld, aliasName, lookForExtents, hints);
        this.setTableAliasForPath(path, hints, alias);
        return alias;
    }

    private TableAlias createTableAlias(String aTable, String aPath, String aUserAlias) {
        if (aUserAlias == null) {
            return this.createTableAlias(aTable, aPath);
        }
        return this.createTableAlias(aTable, aUserAlias + ALIAS_SEPARATOR + aPath);
    }

    private TableAlias createTableAlias(String table, String path) {
        if (table == null) {
            this.getLogger().warn("Creating TableAlias without table for path: " + path);
        }
        String aliasName = String.valueOf(this.getAliasChar()) + this.m_aliasCount++;
        TableAlias alias = new TableAlias(table, aliasName);
        this.setTableAliasForPath(path, null, alias);
        this.m_logger.debug("createTableAlias2: path: " + path + " tableAlias: " + alias);
        return alias;
    }

    private TableAlias getTableAliasForPath(String aPath, List hintClasses) {
        return (TableAlias)this.m_pathToAlias.get(this.buildAliasKey(aPath, hintClasses));
    }

    private void setTableAliasForPath(String aPath, List hintClasses, TableAlias anAlias) {
        this.m_pathToAlias.put(this.buildAliasKey(aPath, hintClasses), anAlias);
    }

    private String buildAliasKey(String aPath, List hintClasses) {
        if (hintClasses == null || hintClasses.isEmpty()) {
            return aPath;
        }
        StringBuffer buf = new StringBuffer(aPath);
        Iterator iter = hintClasses.iterator();
        while (iter.hasNext()) {
            Class hint = (Class)iter.next();
            buf.append(" ");
            buf.append(hint.getName());
        }
        return buf.toString();
    }

    protected TableAlias getTableAliasForClassDescriptor(ClassDescriptor aCld) {
        return (TableAlias)this.m_cldToAlias.get(aCld);
    }

    private void setTableAliasForClassDescriptor(ClassDescriptor aCld, TableAlias anAlias) {
        if (this.m_cldToAlias.get(aCld) == null) {
            this.m_cldToAlias.put(aCld, anAlias);
        }
    }

    private TableAlias getTableAliasForPath(String aPath, String aUserAlias, List hintClasses) {
        if (aUserAlias == null) {
            return this.getTableAliasForPath(aPath, hintClasses);
        }
        return this.getTableAliasForPath(aUserAlias + ALIAS_SEPARATOR + aPath, hintClasses);
    }

    private ClassDescriptor getItemClassDescriptor(ObjectReferenceDescriptor ord, List hintClasses) {
        DescriptorRepository repo = ord.getClassDescriptor().getRepository();
        if (hintClasses == null || hintClasses.isEmpty()) {
            return repo.getDescriptorFor(ord.getItemClass());
        }
        Class resultClass = (Class)hintClasses.get(0);
        Iterator iter = hintClasses.iterator();
        while (iter.hasNext()) {
            Class clazz = (Class)iter.next();
            Class superClazz = clazz.getSuperclass();
            if (superClazz != null && resultClass.equals(superClazz.getSuperclass()) || !hintClasses.contains(superClazz)) continue;
            resultClass = superClazz;
        }
        return repo.getDescriptorFor(resultClass);
    }

    protected void appendOrderByClause(List orderByFields, List selectedFields, StringBuffer buf) {
        if (orderByFields == null || orderByFields.size() == 0) {
            return;
        }
        buf.append(" ORDER BY ");
        for (int i = 0; i < orderByFields.size(); ++i) {
            FieldHelper cf = (FieldHelper)orderByFields.get(i);
            int colNumber = selectedFields.indexOf(cf.name);
            if (i > 0) {
                buf.append(",");
            }
            if (colNumber >= 0) {
                buf.append(colNumber + 1);
            } else {
                this.appendColName(cf.name, false, null, buf);
            }
            if (cf.isAscending) continue;
            buf.append(" DESC");
        }
    }

    protected void appendGroupByClause(List groupByFields, StringBuffer buf) {
        if (groupByFields == null || groupByFields.size() == 0) {
            return;
        }
        buf.append(" GROUP BY ");
        for (int i = 0; i < groupByFields.size(); ++i) {
            FieldHelper cf = (FieldHelper)groupByFields.get(i);
            if (i > 0) {
                buf.append(",");
            }
            this.appendColName(cf.name, false, null, buf);
        }
    }

    protected void appendTableWithJoins(TableAlias alias, StringBuffer where, StringBuffer buf) {
        int stmtFromPos = 0;
        byte joinSyntax = this.getJoinSyntaxType();
        if (joinSyntax == 0) {
            stmtFromPos = buf.length();
        }
        if (alias == this.getRoot()) {
            if (this.getQuery() instanceof MtoNQuery) {
                MtoNQuery mnQuery = (MtoNQuery)((Object)this.m_query);
                buf.append(this.getTableAliasForPath(mnQuery.getIndirectionTable(), null).getTableAndAlias());
                buf.append(", ");
            }
            buf.append(alias.getTableAndAlias());
        } else if (joinSyntax != 1) {
            buf.append(alias.getTableAndAlias());
        }
        if (!alias.hasJoins()) {
            return;
        }
        Iterator it = alias.iterateJoins();
        while (it.hasNext()) {
            Join join = (Join)it.next();
            if (joinSyntax == 0) {
                this.appendJoinSQL92(join, where, buf);
                if (!it.hasNext()) continue;
                buf.insert(stmtFromPos, "(");
                buf.append(")");
                continue;
            }
            if (joinSyntax == 1) {
                this.appendJoinSQL92NoParen(join, where, buf);
                continue;
            }
            this.appendJoin(where, buf, join);
        }
    }

    private void appendJoin(StringBuffer where, StringBuffer buf, Join join) {
        buf.append(",");
        this.appendTableWithJoins(join.right, where, buf);
        if (where.length() > 0) {
            where.append(" AND ");
        }
        join.appendJoinEqualities(where);
    }

    private void appendJoinSQL92(Join join, StringBuffer where, StringBuffer buf) {
        if (join.isOuter) {
            buf.append(" LEFT OUTER JOIN ");
        } else {
            buf.append(" INNER JOIN ");
        }
        if (join.right.hasJoins()) {
            buf.append("(");
            this.appendTableWithJoins(join.right, where, buf);
            buf.append(")");
        } else {
            this.appendTableWithJoins(join.right, where, buf);
        }
        buf.append(" ON ");
        join.appendJoinEqualities(buf);
    }

    private void appendJoinSQL92NoParen(Join join, StringBuffer where, StringBuffer buf) {
        if (join.isOuter) {
            buf.append(" LEFT OUTER JOIN ");
        } else {
            buf.append(" INNER JOIN ");
        }
        buf.append(join.right.getTableAndAlias());
        buf.append(" ON ");
        join.appendJoinEqualities(buf);
        this.appendTableWithJoins(join.right, where, buf);
    }

    private void buildJoinTree(Criteria crit) {
        Enumeration e = crit.getElements();
        while (e.hasMoreElements()) {
            boolean useOuterJoin;
            Object o = e.nextElement();
            if (o instanceof Criteria) {
                this.buildJoinTree((Criteria)o);
                continue;
            }
            SelectionCriteria c = (SelectionCriteria)o;
            if (c instanceof SqlCriteria) continue;
            boolean bl = useOuterJoin = crit.getType() == 0;
            if (c.getAttribute() != null && c.getAttribute() instanceof String) {
                this.buildJoinTreeForColumn((String)c.getAttribute(), useOuterJoin, c.getUserAlias(), c.getPathClasses());
            }
            if (!(c instanceof FieldCriteria)) continue;
            FieldCriteria cc = (FieldCriteria)c;
            this.buildJoinTreeForColumn((String)cc.getValue(), useOuterJoin, c.getUserAlias(), c.getPathClasses());
        }
    }

    private void buildJoinTreeForColumn(String aColName, boolean useOuterJoin, UserAlias aUserAlias, Map pathClasses) {
        String pathName = SqlHelper.cleanPath(aColName);
        int sepPos = pathName.lastIndexOf(ALIAS_SEPARATOR);
        if (sepPos >= 0) {
            this.getTableAlias(pathName.substring(0, sepPos), useOuterJoin, aUserAlias, new String[]{pathName.substring(sepPos + 1)}, pathClasses);
        }
    }

    protected void buildSuperJoinTree(TableAlias left, ClassDescriptor cld, String name, boolean useOuterJoin) {
        ClassDescriptor superCld = cld.getSuperClassDescriptor();
        if (superCld != null) {
            SuperReferenceDescriptor superRef = cld.getSuperReference();
            Object[] leftFields = superRef.getForeignKeyFieldDescriptors(cld);
            TableAlias base_alias = this.getTableAliasForPath(name, null, null);
            String aliasName = String.valueOf(this.getAliasChar()) + this.m_aliasCount++;
            TableAlias right = new TableAlias(superCld, aliasName, useOuterJoin, null);
            Join join1to1 = new Join(left, leftFields, right, superCld.getPkFields(), useOuterJoin, "superClass");
            base_alias.addJoin(join1to1);
            this.buildSuperJoinTree(right, superCld, name, useOuterJoin);
        }
    }

    private void buildMultiJoinTree(TableAlias left, ClassDescriptor cld, String name, boolean useOuterJoin) {
        DescriptorRepository repository = cld.getRepository();
        Class[] multiJoinedClasses = repository.getSubClassesMultipleJoinedTables(cld, false);
        for (int i = 0; i < multiJoinedClasses.length; ++i) {
            ClassDescriptor subCld = repository.getDescriptorFor(multiJoinedClasses[i]);
            SuperReferenceDescriptor srd = subCld.getSuperReference();
            if (srd == null) continue;
            Object[] leftFields = subCld.getPkFields();
            Object[] rightFields = srd.getForeignKeyFieldDescriptors(subCld);
            TableAlias base_alias = this.getTableAliasForPath(name, null, null);
            String aliasName = String.valueOf(this.getAliasChar()) + this.m_aliasCount++;
            TableAlias right = new TableAlias(subCld, aliasName, false, null);
            Join join1to1 = new Join(left, leftFields, right, rightFields, useOuterJoin, "subClass");
            base_alias.addJoin(join1to1);
            this.buildMultiJoinTree(right, subCld, name, useOuterJoin);
        }
    }

    protected void splitCriteria() {
        Criteria whereCrit = this.getQuery().getCriteria();
        Criteria havingCrit = this.getQuery().getHavingCriteria();
        if (whereCrit == null || whereCrit.isEmpty()) {
            this.getJoinTreeToCriteria().put(this.getRoot(), null);
        } else {
            this.getJoinTreeToCriteria().put(this.getRoot(), whereCrit);
            this.buildJoinTree(whereCrit);
        }
        if (havingCrit != null && !havingCrit.isEmpty()) {
            this.buildJoinTree(havingCrit);
        }
    }

    protected QueryByCriteria getQuery() {
        return this.m_query;
    }

    protected TableAlias getRoot() {
        return this.m_root;
    }

    protected void setRoot(TableAlias root) {
        this.m_root = root;
    }

    protected TableAlias getSearchTable() {
        return this.m_search;
    }

    protected HashMap getJoinTreeToCriteria() {
        return this.m_joinTreeToCriteria;
    }

    protected byte getJoinSyntaxType() {
        return this.m_platform.getJoinSyntaxType();
    }

    protected Logger getLogger() {
        return this.m_logger;
    }

    public String getStatement() {
        if (this.sql == null) {
            this.sql = this.buildStatement();
        }
        return this.sql;
    }

    protected abstract String buildStatement();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class Join {
        final TableAlias left;
        final String[] leftKeys;
        final TableAlias right;
        final String[] rightKeys;
        boolean isOuter;
        final String name;

        Join(TableAlias left, Object[] leftKeys, TableAlias right, Object[] rightKeys, boolean isOuter, String name) {
            this.left = left;
            this.leftKeys = this.getColumns(leftKeys);
            this.right = right;
            this.rightKeys = this.getColumns(rightKeys);
            this.isOuter = isOuter;
            this.name = name;
        }

        private String[] getColumns(Object[] keys) {
            String[] columns = new String[keys.length];
            if (keys instanceof FieldDescriptor[]) {
                FieldDescriptor[] kd = (FieldDescriptor[])keys;
                for (int i = 0; i < columns.length; ++i) {
                    columns[i] = kd[i].getColumnName();
                }
            } else {
                for (int i = 0; i < columns.length; ++i) {
                    columns[i] = keys[i].toString();
                }
            }
            return columns;
        }

        void appendJoinEqualities(StringBuffer buf) {
            byte joinSyntax = SqlQueryStatement.this.getJoinSyntaxType();
            for (int i = 0; i < this.leftKeys.length; ++i) {
                if (i > 0) {
                    buf.append(" AND ");
                }
                buf.append(this.left.alias);
                buf.append(SqlQueryStatement.ALIAS_SEPARATOR);
                buf.append(this.leftKeys[i]);
                if (this.isOuter && joinSyntax == 3) {
                    buf.append("*=");
                } else {
                    buf.append("=");
                }
                buf.append(this.right.alias);
                buf.append(SqlQueryStatement.ALIAS_SEPARATOR);
                buf.append(this.rightKeys[i]);
                if (!this.isOuter || joinSyntax != 2) continue;
                buf.append("(+)");
            }
        }

        public boolean equals(Object obj) {
            Join j = (Join)obj;
            return this.name.equals(j.name) && this.isOuter == j.isOuter && this.right.equals(j.right);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.left.alias + " -> " + this.right.alias;
        }
    }

    final class TableAlias {
        Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement$TableAlias == null ? (class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement$TableAlias = SqlQueryStatement.class$("org.apache.ojb.broker.accesslayer.sql.SqlQueryStatement$TableAlias")) : class$org$apache$ojb$broker$accesslayer$sql$SqlQueryStatement$TableAlias);
        ClassDescriptor cld;
        String table;
        final String alias;
        List extents = new ArrayList();
        List hints = new ArrayList();
        List joins;

        TableAlias(String aTable, String anAlias) {
            this.cld = null;
            this.table = aTable;
            this.alias = anAlias;
        }

        TableAlias(ClassDescriptor aCld, String anAlias) {
            this(aCld, anAlias, false, null);
        }

        TableAlias(ClassDescriptor aCld, String anAlias, boolean lookForExtents, List hints) {
            this.cld = aCld;
            this.table = aCld.getFullTableName();
            this.alias = anAlias;
            boolean useHintsOnExtents = false;
            SqlQueryStatement.this.setTableAliasForClassDescriptor(aCld, this);
            if (hints != null && hints.size() > 0) {
                useHintsOnExtents = true;
            }
            this.logger.debug("TableAlias(): using hints ? " + useHintsOnExtents);
            if (lookForExtents) {
                ClassDescriptor[] extCLDs = aCld.getRepository().getAllConcreteSubclassDescriptors(aCld).toArray(new ClassDescriptor[0]);
                HashMap<String, TableAlias> extMap = new HashMap<String, TableAlias>();
                int firstNonAbstractExtentIndex = 0;
                for (int i = 0; i < extCLDs.length; ++i) {
                    ClassDescriptor extCd = extCLDs[i];
                    Class extClass = extCd.getClassOfObject();
                    if (useHintsOnExtents && !hints.contains(extClass)) {
                        this.logger.debug("Skipping class [" + extClass + "] from extents List");
                        ++firstNonAbstractExtentIndex;
                        continue;
                    }
                    String extTable = extCd.getFullTableName();
                    if (aCld.isAbstract() && i == firstNonAbstractExtentIndex) {
                        this.cld = extCd;
                        this.table = extTable;
                        continue;
                    }
                    if (extMap.get(extTable) != null || extTable.equals(this.table)) continue;
                    extMap.put(extTable, new TableAlias(extCd, anAlias + "E" + i, false, hints));
                }
                this.extents.addAll(extMap.values());
            }
            if (this.cld == null) {
                throw new PersistenceBrokerSQLException("Table is NULL for alias: " + this.alias);
            }
        }

        ClassDescriptor getClassDescriptor() {
            return this.cld;
        }

        String getTableAndAlias() {
            return this.table + " " + this.alias;
        }

        boolean hasExtents() {
            return !this.extents.isEmpty();
        }

        Iterator iterateExtents() {
            return this.extents.iterator();
        }

        TableAlias copy(String aPostfix) {
            Iterator iter = this.iterateExtents();
            TableAlias result = this.cld == null ? new TableAlias(this.table, this.alias + aPostfix) : new TableAlias(this.cld, this.alias + aPostfix);
            while (iter.hasNext()) {
                TableAlias temp = (TableAlias)iter.next();
                result.extents.add(temp.copy(aPostfix));
            }
            return result;
        }

        void addJoin(Join join) {
            if (this.joins == null) {
                this.joins = new ArrayList();
            }
            this.joins.add(join);
        }

        Iterator iterateJoins() {
            return this.joins.iterator();
        }

        boolean hasJoins() {
            return this.joins != null;
        }

        Join getJoin(TableAlias anAlias) {
            Join result = null;
            if (this.joins != null) {
                Iterator iter = this.joins.iterator();
                while (iter.hasNext()) {
                    Join join = (Join)iter.next();
                    if (!join.right.equals(anAlias)) continue;
                    result = join;
                    break;
                }
            }
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(1024);
            boolean first = true;
            sb.append(this.getTableAndAlias());
            if (this.joins != null) {
                sb.append(" [");
                Iterator it = this.joins.iterator();
                while (it.hasNext()) {
                    Join join = (Join)it.next();
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append("-(");
                    sb.append(join.name);
                    sb.append(")->");
                    sb.append(join.right);
                }
                sb.append("]");
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            TableAlias t = (TableAlias)obj;
            return this.table.equals(t.table);
        }

        public int hashCode() {
            return this.table.hashCode();
        }
    }

    static final class AttributeInfo {
        TableAlias tableAlias;
        SqlHelper.PathInfo pathInfo;

        AttributeInfo() {
        }
    }
}

