/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.sql;

import java.lang.ref.WeakReference;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.sql.SqlStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.logging.Logger;

public abstract class SqlPkStatement
implements SqlStatement {
    private WeakReference m_classDescriptor;
    private Logger m_logger;

    public SqlPkStatement(ClassDescriptor aCld, Logger aLogger) {
        this.m_classDescriptor = new WeakReference<ClassDescriptor>(aCld);
        this.m_logger = aLogger;
    }

    protected void appendTable(ClassDescriptor cld, StringBuffer stmt) {
        stmt.append(cld.getFullTableName());
    }

    protected Logger getLogger() {
        return this.m_logger;
    }

    protected ClassDescriptor getClassDescriptor() {
        ClassDescriptor cld = (ClassDescriptor)this.m_classDescriptor.get();
        if (cld == null) {
            throw new OJBRuntimeException("Requested ClassDescriptor instance was already GC by JVM");
        }
        return cld;
    }

    protected void appendWhereClause(FieldDescriptor[] fields, StringBuffer stmt) throws PersistenceBrokerException {
        stmt.append(" WHERE ");
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor fmd = fields[i];
            stmt.append(fmd.getColumnName());
            stmt.append(" = ? ");
            if (i >= fields.length - 1) continue;
            stmt.append(" AND ");
        }
    }

    protected void appendWhereClause(ClassDescriptor cld, boolean useLocking, StringBuffer stmt) {
        FieldDescriptor[] lockingFields;
        FieldDescriptor[] pkFields;
        FieldDescriptor[] fields = pkFields = cld.getPkFields();
        if (useLocking && (lockingFields = cld.getLockingFields()).length > 0) {
            fields = new FieldDescriptor[pkFields.length + lockingFields.length];
            System.arraycopy(pkFields, 0, fields, 0, pkFields.length);
            System.arraycopy(lockingFields, 0, fields, pkFields.length, lockingFields.length);
        }
        this.appendWhereClause(fields, stmt);
    }
}

