/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.ojb.broker.accesslayer.sql.SqlPkStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.logging.Logger;

public class SqlInsertStatement
extends SqlPkStatement {
    private String sql;

    public SqlInsertStatement(ClassDescriptor cld, Logger logger) {
        super(cld, logger);
    }

    public String getStatement() {
        if (this.sql == null) {
            StringBuffer stmt = new StringBuffer(1024);
            ClassDescriptor cld = this.getClassDescriptor();
            stmt.append("INSERT INTO ");
            this.appendTable(cld, stmt);
            stmt.append(" (");
            this.appendListOfColumns(cld, stmt);
            stmt.append(")");
            this.appendListOfValues(cld, stmt);
            this.sql = stmt.toString();
        }
        return this.sql;
    }

    private List appendListOfColumns(ClassDescriptor cld, StringBuffer buf) {
        FieldDescriptor[] fields = cld.getAllRwFields();
        ArrayList<String> columnList = new ArrayList<String>();
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(fields[i].getColumnName());
            columnList.add(fields[i].getAttributeName());
        }
        return columnList;
    }

    private void appendListOfValues(ClassDescriptor cld, StringBuffer stmt) {
        FieldDescriptor[] fields = cld.getAllRwFields();
        if (fields.length == 0) {
            return;
        }
        stmt.append(" VALUES (");
        for (int i = 0; i < fields.length; ++i) {
            stmt.append("?");
            if (i >= fields.length - 1) continue;
            stmt.append(",");
        }
        stmt.append(") ");
    }
}

