/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.accesslayer.RowReader;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.SqlHelper;

public class RowReaderDefaultImpl
implements RowReader {
    private static final String OJB_CONCRETE_CLASS_KEY = "ojbTemporaryNoneColumnKey";
    private static final Object[] NO_ARGS = new Object[0];
    private ClassDescriptor m_cld;

    public RowReaderDefaultImpl(ClassDescriptor cld) {
        this.m_cld = cld;
    }

    public Object readObjectFrom(Map row) throws PersistenceBrokerException {
        ClassDescriptor cld = this.selectClassDescriptor(row);
        return this.buildOrRefreshObject(row, cld, null);
    }

    public void refreshObject(Object instance, Map row) {
        ClassDescriptor targetClassDescriptor = this.selectClassDescriptor(row);
        this.buildOrRefreshObject(row, targetClassDescriptor, instance);
    }

    protected Object buildOrRefreshObject(Map row, ClassDescriptor targetClassDescriptor, Object targetObject) {
        Method initializationMethod;
        Object result = targetObject;
        FieldDescriptor[] fields = targetClassDescriptor.getFieldDescriptor(true);
        if (targetObject == null) {
            result = ClassHelper.buildNewObjectInstance(targetClassDescriptor);
        }
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor fmd = fields[i];
            fmd.getPersistentField().set(result, row.get(fmd.getColumnName()));
        }
        if (targetObject == null && (initializationMethod = targetClassDescriptor.getInitializationMethod()) != null) {
            try {
                initializationMethod.invoke(result, NO_ARGS);
            }
            catch (Exception ex) {
                throw new PersistenceBrokerException("Unable to invoke initialization method:" + initializationMethod.getName() + " for class:" + this.m_cld.getClassOfObject(), ex);
            }
        }
        return result;
    }

    public void readObjectArrayFrom(ResultSetAndStatement rs_stmt, Map row) {
        FieldDescriptor[] fields;
        if (this.m_cld.getSuperClass() != null) {
            fields = this.m_cld.getFieldDescriptorsInHeirarchy();
        } else {
            String ojbConcreteClass = this.extractOjbConcreteClass(this.m_cld, rs_stmt.m_rs, row);
            if (ojbConcreteClass != null) {
                ClassDescriptor cld = this.m_cld.getRepository().getDescriptorFor(ojbConcreteClass);
                row.put(OJB_CONCRETE_CLASS_KEY, cld.getClassOfObject());
                fields = cld.getFieldDescriptor(true);
            } else {
                String ojbClass = SqlHelper.getOjbClassName(rs_stmt.m_rs);
                if (ojbClass != null) {
                    ClassDescriptor cld = this.m_cld.getRepository().getDescriptorFor(ojbClass);
                    row.put(OJB_CONCRETE_CLASS_KEY, cld.getClassOfObject());
                    fields = cld.getFieldDescriptor(true);
                } else {
                    fields = this.m_cld.getFieldDescriptor(true);
                }
            }
        }
        this.readValuesFrom(rs_stmt, row, fields);
    }

    public void readPkValuesFrom(ResultSetAndStatement rs_stmt, Map row) {
        String ojbClass = SqlHelper.getOjbClassName(rs_stmt.m_rs);
        ClassDescriptor cld = ojbClass != null ? this.m_cld.getRepository().getDescriptorFor(ojbClass) : this.m_cld;
        FieldDescriptor[] pkFields = cld.getPkFields();
        this.readValuesFrom(rs_stmt, row, pkFields);
    }

    protected void readValuesFrom(ResultSetAndStatement rs_stmt, Map row, FieldDescriptor[] fields) {
        int size = fields.length;
        FieldDescriptor fld = null;
        try {
            for (int j = 0; j < size; ++j) {
                fld = fields[j];
                if (row.containsKey(fld.getColumnName())) continue;
                int idx = rs_stmt.m_sql.getColumnIndex(fld);
                Object val = fld.getJdbcType().getObjectFromColumn(rs_stmt.m_rs, null, fld.getColumnName(), idx);
                row.put(fld.getColumnName(), fld.getFieldConversion().sqlToJava(val));
            }
        }
        catch (SQLException t) {
            throw new PersistenceBrokerException("Error reading class '" + (fld != null ? fld.getClassDescriptor().getClassNameOfObject() : this.m_cld.getClassNameOfObject()) + "' from result set, current read field was '" + (fld != null ? fld.getPersistentField().getName() + "'" : null), t);
        }
    }

    protected String extractOjbConcreteClass(ClassDescriptor cld, ResultSet rs, Map row) {
        FieldDescriptor fld = this.m_cld.getOjbConcreteClassField();
        if (fld == null) {
            return null;
        }
        try {
            Object tmp = fld.getJdbcType().getObjectFromColumn(rs, fld.getColumnName());
            String result = (String)fld.getFieldConversion().sqlToJava(tmp);
            String string = result = result != null ? result.trim() : null;
            if (result == null || result.length() == 0) {
                throw new PersistenceBrokerException("ojbConcreteClass field for class " + cld.getClassNameOfObject() + " returned null or 0-length string");
            }
            row.put(fld.getColumnName(), result);
            return result;
        }
        catch (SQLException e) {
            throw new PersistenceBrokerException("Unexpected error while try to read 'ojbConcretClass' field from result set using column name " + fld.getColumnName() + " main class" + " was " + this.m_cld.getClassNameOfObject(), e);
        }
    }

    protected ClassDescriptor selectClassDescriptor(Map row) throws PersistenceBrokerException {
        ClassDescriptor result = this.m_cld;
        Class ojbConcreteClass = (Class)row.get(OJB_CONCRETE_CLASS_KEY);
        if (ojbConcreteClass != null && (result = this.m_cld.getRepository().getDescriptorFor(ojbConcreteClass)) == null) {
            throw new PersistenceBrokerException("Can't find class-descriptor for ojbConcreteClass '" + ojbConcreteClass + "', the main class was " + this.m_cld.getClassNameOfObject());
        }
        return result;
    }

    public void setClassDescriptor(ClassDescriptor cld) {
        this.m_cld = cld;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.m_cld;
    }
}

