/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.CollectionPrefetcher;
import org.apache.ojb.broker.accesslayer.MtoNCollectionPrefetcher;
import org.apache.ojb.broker.accesslayer.ReferencePrefetcher;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcher;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;

public class RelationshipPrefetcherFactory {
    private PersistenceBrokerImpl broker;

    public RelationshipPrefetcherFactory(PersistenceBrokerImpl broker) {
        this.broker = broker;
    }

    public RelationshipPrefetcher createRelationshipPrefetcher(ObjectReferenceDescriptor ord) {
        if (ord instanceof CollectionDescriptor) {
            CollectionDescriptor cds = (CollectionDescriptor)ord;
            if (cds.isMtoNRelation()) {
                return new MtoNCollectionPrefetcher(this.broker, cds);
            }
            return new CollectionPrefetcher(this.broker, cds);
        }
        return new ReferencePrefetcher(this.broker, ord);
    }

    public RelationshipPrefetcher createRelationshipPrefetcher(ClassDescriptor anOwnerCld, String aRelationshipName) {
        ObjectReferenceDescriptor ord = anOwnerCld.getCollectionDescriptorByName(aRelationshipName);
        if (ord == null && (ord = anOwnerCld.getObjectReferenceDescriptorByName(aRelationshipName)) == null) {
            throw new PersistenceBrokerException("Relationship named '" + aRelationshipName + "' not found in owner class " + (anOwnerCld != null ? anOwnerCld.getClassNameOfObject() : null));
        }
        return this.createRelationshipPrefetcher(ord);
    }
}

