/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryAbstractImpl;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ConnectionFactoryPooledImpl
extends ConnectionFactoryAbstractImpl {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl = ConnectionFactoryPooledImpl.class$("org.apache.ojb.broker.accesslayer.ConnectionFactoryPooledImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl);
    private Map poolMap = new HashMap();
    private final Object poolSynch = new Object();
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor;

    public void releaseJdbcConnection(JdbcConnectionDescriptor jcd, Connection con) throws LookupException {
        ObjectPool op = (ObjectPool)this.poolMap.get(jcd.getPBKey());
        try {
            op.returnObject((Object)con);
        }
        catch (Exception e) {
            throw new LookupException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection checkOutJdbcConnection(JdbcConnectionDescriptor jcd) throws LookupException {
        Connection conn;
        ObjectPool op = (ObjectPool)this.poolMap.get(jcd.getPBKey());
        if (op == null) {
            Object object = this.poolSynch;
            synchronized (object) {
                this.log.info("Create new connection pool:" + jcd);
                op = this.createConnectionPool(jcd);
                this.poolMap.put(jcd.getPBKey(), op);
            }
        }
        try {
            conn = (Connection)op.borrowObject();
        }
        catch (NoSuchElementException e) {
            int active = 0;
            int idle = 0;
            try {
                active = op.getNumActive();
                idle = op.getNumIdle();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw new LookupException("Could not borrow connection from pool, seems ObjectPool is exhausted. Active/Idle instances in pool=" + active + "/" + idle + ". " + (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor == null ? (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor = ConnectionFactoryPooledImpl.class$("org.apache.ojb.broker.metadata.JdbcConnectionDescriptor")) : class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor).getName() + ":  " + jcd, e);
        }
        catch (Exception e) {
            int active = 0;
            int idle = 0;
            try {
                active = op.getNumActive();
                idle = op.getNumIdle();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw new LookupException("Could not borrow connection from pool. Active/Idle instances in pool=" + active + "/" + idle + ". " + (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor == null ? (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor = ConnectionFactoryPooledImpl.class$("org.apache.ojb.broker.metadata.JdbcConnectionDescriptor")) : class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor).getName() + ":  " + jcd, e);
        }
        return conn;
    }

    public ObjectPool createConnectionPool(JdbcConnectionDescriptor jcd) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("createPool was called");
        }
        ConPoolFactory pof = new ConPoolFactory(this, jcd);
        GenericObjectPool.Config conf = jcd.getConnectionPoolDescriptor().getObjectPoolConfig();
        return new GenericObjectPool((PoolableObjectFactory)pof, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllResources() {
        Object object = this.poolSynch;
        synchronized (object) {
            Collection pools = this.poolMap.values();
            this.poolMap = new HashMap(this.poolMap.size());
            ObjectPool op = null;
            Iterator iterator = pools.iterator();
            while (iterator.hasNext()) {
                try {
                    op = (ObjectPool)iterator.next();
                    op.close();
                }
                catch (Exception e) {
                    this.log.error("Exception occured while closing pool " + op, e);
                }
            }
        }
        super.releaseAllResources();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ConPoolFactory
    extends BasePoolableObjectFactory {
        private final JdbcConnectionDescriptor jcd;
        private final ConnectionFactoryPooledImpl cf;
        private int failedValidationQuery;

        public ConPoolFactory(ConnectionFactoryPooledImpl cf, JdbcConnectionDescriptor jcd) {
            this.cf = cf;
            this.jcd = jcd;
        }

        public boolean validateObject(Object obj) {
            boolean isValid = false;
            if (obj != null) {
                String validationQuery;
                Connection con = (Connection)obj;
                try {
                    isValid = !con.isClosed();
                }
                catch (SQLException e) {
                    ConnectionFactoryPooledImpl.this.log.warn("Connection validation failed: " + e.getMessage());
                    if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                        ConnectionFactoryPooledImpl.this.log.debug(e);
                    }
                    isValid = false;
                }
                if (isValid && (validationQuery = this.jcd.getConnectionPoolDescriptor().getValidationQuery()) != null) {
                    isValid = this.validateConnection(con, validationQuery);
                }
            }
            return isValid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean validateConnection(Connection conn, String query) {
            boolean isValid;
            block25: {
                SQLException t2;
                ResultSet rset;
                PreparedStatement stmt;
                block24: {
                    block23: {
                        stmt = null;
                        rset = null;
                        isValid = false;
                        if (this.failedValidationQuery > 100) {
                            --this.failedValidationQuery;
                            throw new OJBRuntimeException("Validation of connection " + conn + " using validation query '" + query + "' failed more than 100 times.");
                        }
                        stmt = conn.prepareStatement(query);
                        stmt.setMaxRows(1);
                        stmt.setFetchSize(1);
                        rset = stmt.executeQuery();
                        if (rset.next()) {
                            this.failedValidationQuery = 0;
                            isValid = true;
                            break block23;
                        }
                        ++this.failedValidationQuery;
                        ConnectionFactoryPooledImpl.this.log.warn("Validation query '" + query + "' result set does not match, discard connection");
                        isValid = false;
                    }
                    Object var8_6 = null;
                    try {
                        if (rset != null) {
                            rset.close();
                        }
                    }
                    catch (SQLException t2) {
                        if (!ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) break block24;
                        ConnectionFactoryPooledImpl.this.log.debug("ResultSet already closed.", t2);
                    }
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    break block25;
                }
                catch (SQLException t2) {
                    if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                        ConnectionFactoryPooledImpl.this.log.debug("Statement already closed.", t2);
                    }
                    break block25;
                }
                {
                    catch (SQLException e) {
                        block26: {
                            ++this.failedValidationQuery;
                            ConnectionFactoryPooledImpl.this.log.warn("Validation query for connection failed, discard connection. Query was '" + query + "', Message was " + e.getMessage());
                            if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                                ConnectionFactoryPooledImpl.this.log.debug(e);
                            }
                            Object var8_7 = null;
                            try {
                                if (rset != null) {
                                    rset.close();
                                }
                            }
                            catch (SQLException t2) {
                                if (!ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) break block26;
                                ConnectionFactoryPooledImpl.this.log.debug("ResultSet already closed.", t2);
                            }
                        }
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                            break block25;
                        }
                        catch (SQLException t2) {
                            if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                                ConnectionFactoryPooledImpl.this.log.debug("Statement already closed.", t2);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    block28: {
                        block27: {
                            Object var8_8 = null;
                            try {
                                if (rset != null) {
                                    rset.close();
                                }
                            }
                            catch (SQLException t2) {
                                if (!ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) break block27;
                                ConnectionFactoryPooledImpl.this.log.debug("ResultSet already closed.", t2);
                            }
                        }
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException t2) {
                            if (!ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) break block28;
                            ConnectionFactoryPooledImpl.this.log.debug("Statement already closed.", t2);
                        }
                    }
                    throw throwable;
                }
            }
            return isValid;
        }

        public Object makeObject() throws Exception {
            if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                ConnectionFactoryPooledImpl.this.log.debug("makeObject called");
            }
            return this.cf.newConnectionFromDriverManager(this.jcd);
        }

        public void destroyObject(Object obj) throws Exception {
            ConnectionFactoryPooledImpl.this.log.info("Destroy object was called, try to close connection: " + obj);
            try {
                ((Connection)obj).close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

