/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.ojb.broker.accesslayer.ConnectionFactory;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformFactory;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class ConnectionFactoryAbstractImpl
implements ConnectionFactory {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$ConnectionFactoryAbstractImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryAbstractImpl = ConnectionFactoryAbstractImpl.class$("org.apache.ojb.broker.accesslayer.ConnectionFactoryAbstractImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactoryAbstractImpl);
    private Map dataSourceCache = new HashMap();
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactoryAbstractImpl;

    public abstract Connection checkOutJdbcConnection(JdbcConnectionDescriptor var1) throws LookupException;

    public abstract void releaseJdbcConnection(JdbcConnectionDescriptor var1, Connection var2) throws LookupException;

    public void releaseConnection(JdbcConnectionDescriptor jcd, Connection con) {
        if (con == null) {
            return;
        }
        if (jcd.isDataSource()) {
            try {
                con.close();
            }
            catch (SQLException e) {
                this.log.error("Closing connection failed", e);
            }
        } else {
            try {
                this.releaseJdbcConnection(jcd, con);
            }
            catch (LookupException e) {
                this.log.error("Unexpected exception when return connection " + con + " to pool using " + jcd, (Throwable)((Object)e));
            }
        }
    }

    public Connection lookupConnection(JdbcConnectionDescriptor jcd) throws LookupException {
        Connection conn;
        if (jcd.isDataSource()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("do datasource lookup, name: " + jcd.getDatasourceName() + ", user: " + jcd.getUserName());
            }
            conn = this.newConnectionFromDataSource(jcd);
        } else {
            conn = this.checkOutJdbcConnection(jcd);
        }
        return conn;
    }

    protected void initializeJdbcConnection(Connection con, JdbcConnectionDescriptor jcd) throws LookupException {
        try {
            PlatformFactory.getPlatformFor(jcd).initializeJdbcConnection(jcd, con);
        }
        catch (PlatformException e) {
            throw new LookupException("Platform dependent initialization of connection failed", (Throwable)((Object)e));
        }
    }

    public synchronized void releaseAllResources() {
        this.dataSourceCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection newConnectionFromDataSource(JdbcConnectionDescriptor jcd) throws LookupException {
        Connection retval = null;
        DataSource ds = jcd.getDataSource();
        if (ds == null) {
            ds = (DataSource)this.dataSourceCache.get(jcd.getDatasourceName());
        }
        try {
            if (ds == null) {
                Map map = this.dataSourceCache;
                synchronized (map) {
                    InitialContext ic = new InitialContext();
                    ds = (DataSource)ic.lookup(jcd.getDatasourceName());
                    this.dataSourceCache.put(jcd.getDatasourceName(), ds);
                }
            }
            retval = jcd.getUserName() == null ? ds.getConnection() : ds.getConnection(jcd.getUserName(), jcd.getPassWord());
        }
        catch (SQLException sqlEx) {
            this.log.error("SQLException thrown while trying to get Connection from Datasource (" + jcd.getDatasourceName() + ")", sqlEx);
            throw new LookupException("SQLException thrown while trying to get Connection from Datasource (" + jcd.getDatasourceName() + ")", sqlEx);
        }
        catch (NamingException namingEx) {
            this.log.error("Naming Exception while looking up DataSource (" + jcd.getDatasourceName() + ")", namingEx);
            throw new LookupException("Naming Exception while looking up DataSource (" + jcd.getDatasourceName() + ")", namingEx);
        }
        this.initializeJdbcConnection(retval, jcd);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Create new connection using DataSource: " + retval);
        }
        return retval;
    }

    protected Connection newConnectionFromDriverManager(JdbcConnectionDescriptor jcd) throws LookupException {
        Connection retval = null;
        String driver = jcd.getDriver();
        String url = this.getDbURL(jcd);
        try {
            ClassHelper.getClass(driver, true);
            String user = jcd.getUserName();
            String password = jcd.getPassWord();
            Properties properties = this.getJdbcProperties(jcd, user, password);
            retval = properties.isEmpty() ? (user == null ? DriverManager.getConnection(url) : DriverManager.getConnection(url, user, password)) : DriverManager.getConnection(url, properties);
        }
        catch (SQLException sqlEx) {
            this.log.error("Error getting Connection from DriverManager with url (" + url + ") and driver (" + driver + ")", sqlEx);
            throw new LookupException("Error getting Connection from DriverManager with url (" + url + ") and driver (" + driver + ")", sqlEx);
        }
        catch (ClassNotFoundException cnfEx) {
            this.log.error(cnfEx);
            throw new LookupException("A class was not found", cnfEx);
        }
        catch (Exception e) {
            this.log.error("Instantiation of jdbc driver failed", e);
            throw new LookupException("Instantiation of jdbc driver failed", e);
        }
        this.initializeJdbcConnection(retval, jcd);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Create new connection using DriverManager: " + retval);
        }
        return retval;
    }

    protected Properties getJdbcProperties(JdbcConnectionDescriptor jcd, String user, String password) {
        Properties jdbcProperties = jcd.getConnectionPoolDescriptor().getJdbcProperties();
        if (user != null) {
            jdbcProperties.put("user", user);
            jdbcProperties.put("password", password);
        }
        return jdbcProperties;
    }

    protected Properties getJdbcProperties(JdbcConnectionDescriptor jcd) {
        String user = jcd.getUserName();
        String password = jcd.getPassWord();
        return this.getJdbcProperties(jcd, user, password);
    }

    protected String getDbURL(JdbcConnectionDescriptor jcd) {
        return jcd.isDataSource() ? jcd.getDatasourceName() : jcd.getProtocol() + ":" + jcd.getSubProtocol() + ":" + jcd.getDbAlias();
    }

    protected String getJcdDescription(JdbcConnectionDescriptor jcd) {
        return "Connection for JdbcConnectionDescriptor (" + (jcd.getDatasourceName() != null ? "datasource: " + jcd.getDatasourceName() : "db-url: " + this.getDbURL(jcd) + ", user: " + jcd.getUserName()) + ")";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

