/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.accesslayer.RsIterator;

public class ChainingIterator
implements OJBIterator {
    private List m_rsIterators = new ArrayList();
    private OJBIterator m_activeIterator = null;
    private int m_activeIteratorIndex = 0;
    private int m_fullSize = -1;
    private int m_currentCursorPosition = 0;
    private boolean disableLifeCycleEvents = false;

    public ChainingIterator() {
    }

    public ChainingIterator(List iterators) {
        Iterator checkIterator = iterators.iterator();
        while (checkIterator.hasNext()) {
            OJBIterator temp = (OJBIterator)checkIterator.next();
            this.addIterator(temp);
        }
    }

    public void addIterator(OJBIterator iterator) {
        if (iterator != null && iterator.hasNext()) {
            this.setNextIterator();
            this.m_rsIterators.add(iterator);
        }
    }

    public int size() throws PersistenceBrokerException {
        if (this.m_fullSize == -1) {
            int size = 0;
            Iterator it = this.m_rsIterators.iterator();
            while (it.hasNext()) {
                size += ((OJBIterator)it.next()).size();
            }
            this.m_fullSize = size;
        }
        return this.m_fullSize;
    }

    public int fullSize() throws PersistenceBrokerException {
        return this.size();
    }

    public boolean absolute(int row) throws PersistenceBrokerException {
        boolean retval;
        block8: {
            boolean movedToAbsolute;
            block7: {
                if (row == 0) {
                    return true;
                }
                if (row == 1) {
                    this.m_activeIteratorIndex = 0;
                    this.m_activeIterator = (OJBIterator)this.m_rsIterators.get(this.m_activeIteratorIndex);
                    this.m_activeIterator.absolute(1);
                    return true;
                }
                if (row == -1) {
                    this.m_activeIteratorIndex = this.m_rsIterators.size();
                    this.m_activeIterator = (OJBIterator)this.m_rsIterators.get(this.m_activeIteratorIndex);
                    this.m_activeIterator.absolute(-1);
                    return true;
                }
                movedToAbsolute = false;
                retval = false;
                this.setNextIterator();
                if (row <= 0) break block7;
                int sizeCount = 0;
                Iterator it = this.m_rsIterators.iterator();
                OJBIterator temp = null;
                while (it.hasNext() && !movedToAbsolute) {
                    temp = (OJBIterator)it.next();
                    if (temp.size() < row) {
                        sizeCount += temp.size();
                        continue;
                    }
                    this.m_currentCursorPosition = row - sizeCount;
                    retval = temp.absolute(this.m_currentCursorPosition);
                    movedToAbsolute = true;
                }
                break block8;
            }
            if (row >= 0) break block8;
            int sizeCount = 0;
            OJBIterator temp = null;
            for (int i = this.m_rsIterators.size(); i >= 0 && !movedToAbsolute; --i) {
                temp = (OJBIterator)this.m_rsIterators.get(i);
                if (temp.size() < row) {
                    sizeCount += temp.size();
                    continue;
                }
                this.m_currentCursorPosition = row + sizeCount;
                retval = temp.absolute(this.m_currentCursorPosition);
                movedToAbsolute = true;
            }
        }
        return retval;
    }

    public boolean relative(int row) throws PersistenceBrokerException {
        if (row == 0) {
            return true;
        }
        boolean movedToRelative = false;
        boolean retval = false;
        this.setNextIterator();
        if (row > 0) {
            if (row > this.m_activeIterator.size() - this.m_currentCursorPosition) {
                int positionCounter = this.m_activeIterator.size() - this.m_currentCursorPosition;
                for (int i = this.m_activeIteratorIndex + 1; i < this.m_rsIterators.size() && !movedToRelative; ++i) {
                    this.m_activeIteratorIndex = i;
                    this.m_currentCursorPosition = 0;
                    this.m_activeIterator = (OJBIterator)this.m_rsIterators.get(this.m_activeIteratorIndex);
                    if (row - positionCounter > this.m_activeIterator.size()) continue;
                    this.m_currentCursorPosition = row - positionCounter;
                    retval = this.m_activeIterator.relative(this.m_currentCursorPosition);
                    movedToRelative = true;
                }
            } else {
                retval = this.m_activeIterator.relative(row);
                movedToRelative = true;
            }
        }
        return retval;
    }

    public void releaseDbResources() {
        Iterator it = this.m_rsIterators.iterator();
        while (it.hasNext()) {
            ((OJBIterator)it.next()).releaseDbResources();
        }
    }

    public boolean hasNext() {
        this.setNextIterator();
        if (this.m_activeIterator == null) {
            return false;
        }
        return this.m_activeIterator.hasNext();
    }

    public Object next() {
        this.setNextIterator();
        ++this.m_currentCursorPosition;
        return this.m_activeIterator.next();
    }

    public void remove() {
        this.setNextIterator();
        this.m_activeIterator.remove();
    }

    private boolean setNextIterator() {
        boolean retval = false;
        if (this.m_activeIterator == null) {
            if (this.m_rsIterators.size() > 0) {
                this.m_activeIteratorIndex = 0;
                this.m_currentCursorPosition = 0;
                this.m_activeIterator = (OJBIterator)this.m_rsIterators.get(this.m_activeIteratorIndex);
            }
        } else if (!this.m_activeIterator.hasNext() && this.m_rsIterators.size() > this.m_activeIteratorIndex + 1) {
            ++this.m_activeIteratorIndex;
            this.m_currentCursorPosition = 0;
            this.m_activeIterator = (OJBIterator)this.m_rsIterators.get(this.m_activeIteratorIndex);
            retval = true;
        }
        return retval;
    }

    public boolean containsIteratorForTable(String aTable) {
        boolean result = false;
        if (this.m_rsIterators != null) {
            for (int i = 0; i < this.m_rsIterators.size(); ++i) {
                OJBIterator it = (OJBIterator)this.m_rsIterators.get(i);
                if (it instanceof RsIterator) {
                    if (!((RsIterator)it).getClassDescriptor().getFullTableName().equals(aTable)) continue;
                    result = true;
                    break;
                }
                if (!(it instanceof ChainingIterator)) continue;
                result = ((ChainingIterator)it).containsIteratorForTable(aTable);
            }
        }
        return result;
    }

    public void disableLifeCycleEvents() {
        Iterator iterators = this.m_rsIterators.iterator();
        while (iterators.hasNext()) {
            OJBIterator iter = (OJBIterator)iterators.next();
            iter.disableLifeCycleEvents();
        }
    }
}

