/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker;

import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.CollectionDescriptor;

public class MtoNImplementor {
    private Object leftObject;
    private Object rightObject;
    private Class leftClass;
    private Class rightClass;
    private CollectionDescriptor leftDescriptor;

    public MtoNImplementor(PersistenceBroker pb, CollectionDescriptor leftDescriptor, Object left, Object right) {
        this.init(leftDescriptor, left, right);
    }

    public MtoNImplementor(PersistenceBroker pb, String leftFieldName, Object left, Object right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("both objects must exist");
        }
        CollectionDescriptor cod = pb.getClassDescriptor(ProxyHelper.getRealClass(left)).getCollectionDescriptorByName(leftFieldName);
        this.init(cod, left, right);
    }

    public MtoNImplementor(CollectionDescriptor leftDescriptor, Object left, Object right) {
        this.init(leftDescriptor, left, right);
    }

    private void init(CollectionDescriptor leftDescriptor, Object left, Object right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("both objects must exist");
        }
        this.leftDescriptor = leftDescriptor;
        this.leftObject = left;
        this.rightObject = right;
        this.leftClass = ProxyHelper.getRealClass(this.leftObject);
        this.rightClass = ProxyHelper.getRealClass(this.rightObject);
    }

    public CollectionDescriptor getLeftDescriptor() {
        return this.leftDescriptor;
    }

    public Class getLeftClass() {
        return this.leftClass;
    }

    public Class getRightClass() {
        return this.rightClass;
    }

    public Object getLeftObject() {
        return this.leftObject;
    }

    public Object getRightObject() {
        return this.rightObject;
    }
}

