/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.InterruptedIOException;
import org.mortbay.util.Code;
import org.mortbay.util.LifeCycle;

public abstract class LifeCycleThread
implements LifeCycle,
Runnable {
    private boolean _running;
    private boolean _daemon;
    private Thread _thread;

    public boolean isDaemon() {
        return this._daemon;
    }

    public void setDaemon(boolean d) {
        this._daemon = d;
    }

    public Thread getThread() {
        return this._thread;
    }

    public boolean isStarted() {
        return this._running;
    }

    public synchronized void start() throws Exception {
        if (this._running) {
            Code.debug("Already started");
            return;
        }
        this._running = true;
        if (this._thread == null) {
            this._thread = new Thread(this);
            this._thread.setDaemon(this._daemon);
        }
        this._thread.start();
    }

    public synchronized void stop() throws InterruptedException {
        this._running = false;
        if (this._thread != null) {
            this._thread.interrupt();
            this._thread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            while (this._running) {
                try {
                    this.loop();
                }
                catch (InterruptedException e) {
                    if (!Code.verbose()) continue;
                    Code.ignore(e);
                }
                catch (InterruptedIOException e) {
                    if (!Code.verbose()) continue;
                    Code.ignore(e);
                }
                catch (Exception e) {
                    if (!this.exception(e)) continue;
                    break;
                }
                catch (Error e) {
                    if (!this.error(e)) continue;
                    break;
                }
            }
        }
        finally {
            this._running = false;
        }
    }

    public boolean exception(Exception e) {
        Code.warning(e);
        return true;
    }

    public boolean error(Error e) {
        Code.warning(e);
        return true;
    }

    public abstract void loop() throws InterruptedException, InterruptedIOException, Exception;
}

