/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.Externalizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.MalformedURLException;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.mortbay.http.BasicAuthenticator;
import org.mortbay.http.ClientCertAuthenticator;
import org.mortbay.http.DigestAuthenticator;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.UserRealm;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FormAuthenticator;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpContext;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.util.Code;
import org.mortbay.util.JarResource;
import org.mortbay.util.Log;
import org.mortbay.util.MultiException;
import org.mortbay.util.Resource;
import org.mortbay.xml.XmlConfiguration;
import org.mortbay.xml.XmlParser;

public class WebApplicationContext
extends ServletHttpContext
implements Externalizable {
    private String _deploymentDescriptor;
    private String _defaultsDescriptor = "org/mortbay/jetty/servlet/webdefault.xml";
    private String _war;
    private boolean _extract;
    private boolean _ignorewebjetty;
    private transient String _name;
    private transient FormAuthenticator _formAuthenticator;
    private transient Map _resourceAliases;
    private transient Resource _webApp;
    private transient Resource _webInf;
    private transient Set _warnings;
    private transient WebApplicationHandler _webAppHandler;
    private transient Map _tagLibMap;
    private transient ArrayList _contextListeners;
    private transient ArrayList _contextAttributeListeners;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$WebApplicationHandler;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$ServletHandler;

    public WebApplicationContext() {
    }

    public WebApplicationContext(String webApp) {
        this._war = webApp;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getContextPath());
        out.writeObject(this.getVirtualHosts());
        HttpHandler[] handlers = this.getHandlers();
        for (int i = 0; i < handlers.length && !(handlers[i] instanceof WebApplicationHandler); ++i) {
            out.writeObject(handlers[i]);
        }
        out.writeObject(this.getAttributes());
        out.writeBoolean(this.isRedirectNullPath());
        out.writeInt(this.getMaxCachedFileSize());
        out.writeInt(this.getMaxCacheSize());
        out.writeBoolean(this.getStatsOn());
        out.writeObject(this.getPermissions());
        out.writeBoolean(this.isClassLoaderJava2Compliant());
        out.writeObject(this._deploymentDescriptor);
        out.writeObject(this._defaultsDescriptor);
        out.writeObject(this._war);
        out.writeBoolean(this._extract);
        out.writeBoolean(this._ignorewebjetty);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setContextPath((String)in.readObject());
        this.setVirtualHosts((String[])in.readObject());
        Object o = in.readObject();
        while (o instanceof HttpHandler) {
            this.addHandler((HttpHandler)o);
            o = in.readObject();
        }
        this.setAttributes((Map)o);
        this.setRedirectNullPath(in.readBoolean());
        this.setMaxCachedFileSize(in.readInt());
        this.setMaxCacheSize(in.readInt());
        this.setStatsOn(in.readBoolean());
        this.setPermissions((PermissionCollection)in.readObject());
        this.setClassLoaderJava2Compliant(in.readBoolean());
        this._deploymentDescriptor = (String)in.readObject();
        this._defaultsDescriptor = (String)in.readObject();
        this._war = (String)in.readObject();
        this._extract = in.readBoolean();
        this._ignorewebjetty = in.readBoolean();
    }

    public void setWAR(String war) {
        this._war = war;
    }

    public String getWAR() {
        return this._war;
    }

    public WebApplicationHandler getWebApplicationHandler() {
        if (this._webAppHandler == null) {
            this.getServletHandler();
        }
        return this._webAppHandler;
    }

    private void resolveWebApp() throws IOException {
        if (this._webApp == null && this._war != null && this._war.length() > 0) {
            Resource jarWebApp;
            this._webApp = Resource.newResource(this._war);
            if (this._webApp.getAlias() != null) {
                Log.event(this._webApp + " anti-aliased to " + this._webApp.getAlias());
                this._webApp = Resource.newResource(this._webApp.getAlias());
            }
            if (Code.debug()) {
                Code.debug((Object)"Try webapp=", (Object)(this._webApp + ", exists=" + this._webApp.exists() + ", directory=" + this._webApp.isDirectory()));
            }
            if (this._webApp.exists() && !this._webApp.isDirectory() && !this._webApp.toString().startsWith("jar:") && (jarWebApp = Resource.newResource("jar:" + this._webApp + "!/")).exists() && jarWebApp.isDirectory()) {
                this._webApp = jarWebApp;
                this._war = this._webApp.toString();
                if (Code.debug()) {
                    Code.debug((Object)"Try webapp=", (Object)(this._webApp + ", exists=" + this._webApp.exists() + ", directory=" + this._webApp.isDirectory()));
                }
            }
            if (this._webApp.exists() && (!this._webApp.isDirectory() || this._extract && this._webApp.getFile() == null || this._extract && this._webApp.getFile() != null && !this._webApp.getFile().isDirectory())) {
                File tempDir = new File(this.getTempDirectory(), "webapp");
                if (tempDir.exists()) {
                    tempDir.delete();
                }
                tempDir.mkdir();
                tempDir.deleteOnExit();
                Log.event("Extract " + this._war + " to " + tempDir);
                JarResource.extract(this._webApp, tempDir, true);
                this._webApp = Resource.newResource(tempDir.getCanonicalPath());
                if (Code.debug()) {
                    Code.debug((Object)"Try webapp=", (Object)(this._webApp + ", exists=" + this._webApp.exists() + ", directory=" + this._webApp.isDirectory()));
                }
            }
            if (!this._webApp.exists() || !this._webApp.isDirectory()) {
                Code.warning("Web application not found " + this._war);
                throw new FileNotFoundException(this._war);
            }
            Code.debug((Object)"webapp=", (Object)this._webApp);
            this._webInf = this._webApp.addPath("WEB-INF/");
            if (!this._webInf.exists() || !this._webInf.isDirectory()) {
                this._webInf = null;
            } else {
                Resource work = this._webInf.addPath("work");
                if (work.exists() && work.isDirectory() && work.getFile() != null && work.getFile().canWrite() && this.getAttribute("javax.servlet.context.tempdir") == null) {
                    this.setAttribute("javax.servlet.context.tempdir", work.getFile());
                }
            }
            super.setBaseResource(this._webApp);
        }
    }

    public synchronized ServletHandler getServletHandler() {
        if (this._webAppHandler == null) {
            this._webAppHandler = (WebApplicationHandler)this.getHandler(class$org$mortbay$jetty$servlet$WebApplicationHandler == null ? (class$org$mortbay$jetty$servlet$WebApplicationHandler = WebApplicationContext.class$("org.mortbay.jetty.servlet.WebApplicationHandler")) : class$org$mortbay$jetty$servlet$WebApplicationHandler);
            if (this._webAppHandler == null) {
                if (this.getHandler(class$org$mortbay$jetty$servlet$ServletHandler == null ? (class$org$mortbay$jetty$servlet$ServletHandler = WebApplicationContext.class$("org.mortbay.jetty.servlet.ServletHandler")) : class$org$mortbay$jetty$servlet$ServletHandler) != null) {
                    throw new IllegalStateException("Cannot have ServletHandler in WebApplicationContext");
                }
                this._webAppHandler = new WebApplicationHandler();
                this.addHandler(this._webAppHandler);
            }
        }
        return this._webAppHandler;
    }

    public void setPermissions(PermissionCollection permissions) {
        if (!this._ignorewebjetty) {
            Code.warning("Permissions set with web-jetty.xml enabled");
        }
        super.setPermissions(permissions);
    }

    public boolean isIgnoreWebJetty() {
        return this._ignorewebjetty;
    }

    public void setIgnoreWebJetty(boolean b) {
        this._ignorewebjetty = b;
        if (b && this.getPermissions() != null) {
            Code.warning("Permissions set with web-jetty.xml enabled");
        }
    }

    public void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        this._tagLibMap = new HashMap(3);
        Thread thread = Thread.currentThread();
        ClassLoader lastContextLoader = thread.getContextClassLoader();
        MultiException mex = null;
        try {
            ServletHolder jspHolder;
            Map.Entry entry;
            XmlParser xmlParser = new XmlParser();
            Resource dtd22 = Resource.newSystemResource("/javax/servlet/resources/web-app_2_2.dtd");
            Resource dtd23 = Resource.newSystemResource("/javax/servlet/resources/web-app_2_3.dtd");
            xmlParser.redirectEntity("web-app_2_2.dtd", dtd22);
            xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", dtd22);
            xmlParser.redirectEntity("web.dtd", dtd23);
            xmlParser.redirectEntity("web-app_2_3.dtd", dtd23);
            xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", dtd23);
            this.resolveWebApp();
            this.getServletHandler();
            if (this._webInf != null && this._webInf.isDirectory()) {
                Resource classes = this._webInf.addPath("classes/");
                if (classes.exists()) {
                    super.setClassPath(classes.toString());
                } else {
                    super.setClassPath(null);
                }
                Resource lib = this._webInf.addPath("lib/");
                super.setClassPaths(lib, true);
            }
            this.initClassLoader(true);
            thread.setContextClassLoader(this.getClassLoader());
            this.initialize();
            if (this._defaultsDescriptor != null && this._defaultsDescriptor.length() > 0) {
                Resource dftResource = Resource.newSystemResource(this._defaultsDescriptor);
                if (dftResource == null) {
                    dftResource = Resource.newResource(this._defaultsDescriptor);
                }
                XmlParser.Node defaultConfig = xmlParser.parse(dftResource.getURL());
                this.initialize(defaultConfig);
            }
            if (this._webInf != null && this._webInf.isDirectory()) {
                Resource web = this._webInf.addPath("web.xml");
                if (!web.exists()) {
                    Log.event("No WEB-INF/web.xml in " + this._war + ". Serving files and default/dynamic servlets only");
                } else {
                    XmlParser.Node config = null;
                    this._deploymentDescriptor = web.toString();
                    config = xmlParser.parse(web.getURL());
                    this.initialize(config);
                }
                Resource jetty = this._webInf.addPath("web-jetty.xml");
                if (!jetty.exists()) {
                    jetty = this._webInf.addPath("jetty-web.xml");
                }
                if (!this._ignorewebjetty && jetty.exists()) {
                    Code.debug("Configure: " + jetty);
                    XmlConfiguration jetty_config = new XmlConfiguration(jetty.getURL());
                    jetty_config.configure(this);
                }
            }
            if ((entry = this._webAppHandler.getHolderEntry("test.jsp")) != null && (jspHolder = (ServletHolder)entry.getValue()) != null && jspHolder.getInitParameter("classpath") == null) {
                String fileClassPath = this.getFileClassPath();
                jspHolder.setInitParameter("classpath", fileClassPath);
                Code.debug((Object)"Set classpath=", fileClassPath, (Object)" for ", jspHolder);
            }
            this._webAppHandler.setAutoInitializeServlets(false);
            super.start();
            mex = new MultiException();
            if (super.isStarted() && this._contextListeners != null && this._webAppHandler != null) {
                ServletContextEvent event = new ServletContextEvent(this.getServletContext());
                for (int i = 0; i < this._contextListeners.size(); ++i) {
                    try {
                        ((ServletContextListener)this._contextListeners.get(i)).contextInitialized(event);
                        continue;
                    }
                    catch (Exception ex) {
                        mex.add(ex);
                    }
                }
            }
            if (this._webAppHandler != null && this._webAppHandler.isStarted()) {
                try {
                    this._webAppHandler.initializeServlets();
                }
                catch (Exception ex) {
                    mex.add(ex);
                }
            }
        }
        catch (Exception e) {
            Code.warning("Configuration error on " + this._war, e);
            throw e;
        }
        finally {
            thread.setContextClassLoader(lastContextLoader);
        }
        if (mex != null) {
            mex.ifExceptionThrow();
        }
    }

    public void stop() throws InterruptedException {
        if (this._contextListeners != null) {
            if (this._webAppHandler != null) {
                ServletContextEvent event = new ServletContextEvent(this.getServletContext());
                int i = this._contextListeners.size();
                while (i-- > 0) {
                    ((ServletContextListener)this._contextListeners.get(i)).contextDestroyed(event);
                }
            }
            this._contextListeners.clear();
        }
        if (this._contextAttributeListeners != null) {
            this._contextAttributeListeners.clear();
        }
        super.stop();
        this.clearSecurityConstraints();
        if (this._webAppHandler != null) {
            this.removeHandler(this._webAppHandler);
        }
        this._webAppHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        block6: {
            if (!this.isStarted()) {
                return false;
            }
            try {
                super.handle(pathInContext, pathParams, httpRequest, httpResponse);
                Object var6_5 = null;
                if (httpRequest.isHandled()) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (!httpRequest.isHandled()) {
                    httpResponse.sendError(404);
                }
                httpRequest.setHandled(true);
                if (!httpResponse.isCommitted()) {
                    httpResponse.commit();
                }
                throw throwable;
            }
            httpResponse.sendError(404);
        }
        httpRequest.setHandled(true);
        if (!httpResponse.isCommitted()) {
            httpResponse.commit();
        }
        return true;
    }

    public synchronized void addEventListener(EventListener listener) throws IllegalArgumentException {
        boolean known = false;
        if (listener instanceof ServletContextListener) {
            known = true;
            if (this._contextListeners == null) {
                this._contextListeners = new ArrayList(3);
            }
            this._contextListeners.add(listener);
        }
        if (listener instanceof ServletContextAttributeListener) {
            known = true;
            if (this._contextAttributeListeners == null) {
                this._contextAttributeListeners = new ArrayList(3);
            }
            this._contextAttributeListeners.add(listener);
        }
        if (!known) {
            throw new IllegalArgumentException("Unknown " + listener);
        }
    }

    public synchronized void removeEventListener(EventListener listener) {
        if (listener instanceof ServletContextListener && this._contextListeners != null) {
            this._contextListeners.remove(listener);
        }
        if (listener instanceof ServletContextAttributeListener && this._contextAttributeListeners != null) {
            this._contextAttributeListeners.remove(listener);
        }
    }

    public synchronized void setAttribute(String name, Object value) {
        Object old = super.getAttribute(name);
        super.setAttribute(name, value);
        if (this._contextAttributeListeners != null && this._webAppHandler != null) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.getServletContext(), name, old != null ? old : value);
            for (int i = 0; i < this._contextAttributeListeners.size(); ++i) {
                ServletContextAttributeListener l = (ServletContextAttributeListener)this._contextAttributeListeners.get(i);
                if (old == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (value == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    public synchronized void removeAttribute(String name) {
        Object old = super.getAttribute(name);
        super.removeAttribute(name);
        if (old != null && this._contextAttributeListeners != null && this._webAppHandler != null) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.getServletContext(), name, old);
            for (int i = 0; i < this._contextAttributeListeners.size(); ++i) {
                ServletContextAttributeListener l = (ServletContextAttributeListener)this._contextAttributeListeners.get(i);
                l.attributeRemoved(event);
            }
        }
    }

    public String getDisplayName() {
        return this._name;
    }

    public String getDeploymentDescriptor() {
        return this._deploymentDescriptor;
    }

    public void setDefaultsDescriptor(String defaults) {
        this._defaultsDescriptor = defaults;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setExtractWAR(boolean extract) {
        this._extract = extract;
    }

    public boolean getExtractWAR() {
        return this._extract;
    }

    protected void initialize() throws Exception {
    }

    protected void initialize(XmlParser.Node config) throws ClassNotFoundException, UnavailableException {
        Iterator iter = config.iterator();
        XmlParser.Node node = null;
        while (iter.hasNext()) {
            try {
                Object o = iter.next();
                if (!(o instanceof XmlParser.Node)) continue;
                node = (XmlParser.Node)o;
                String name = node.getTag();
                this.initWebXmlElement(name, node);
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                Code.warning("Configuration problem at " + node, e);
                throw new UnavailableException("Configuration problem");
            }
        }
    }

    protected void initWebXmlElement(String element, XmlParser.Node node) throws Exception {
        if ("display-name".equals(element)) {
            this.initDisplayName(node);
        } else if (!"description".equals(element)) {
            if ("context-param".equals(element)) {
                this.initContextParam(node);
            } else if ("servlet".equals(element)) {
                this.initServlet(node);
            } else if ("servlet-mapping".equals(element)) {
                this.initServletMapping(node);
            } else if ("session-config".equals(element)) {
                this.initSessionConfig(node);
            } else if ("mime-mapping".equals(element)) {
                this.initMimeConfig(node);
            } else if ("welcome-file-list".equals(element)) {
                this.initWelcomeFileList(node);
            } else if ("error-page".equals(element)) {
                this.initErrorPage(node);
            } else if ("taglib".equals(element)) {
                this.initTagLib(node);
            } else if ("resource-ref".equals(element)) {
                Code.debug((Object)"No implementation: ", (Object)node);
            } else if ("security-constraint".equals(element)) {
                this.initSecurityConstraint(node);
            } else if ("login-config".equals(element)) {
                this.initLoginConfig(node);
            } else if ("security-role".equals(element)) {
                this.initSecurityRole(node);
            } else if ("filter".equals(element)) {
                this.initFilter(node);
            } else if ("filter-mapping".equals(element)) {
                this.initFilterMapping(node);
            } else if ("listener".equals(element)) {
                this.initListener(node);
            } else {
                if (this._warnings == null) {
                    this._warnings = new HashSet(3);
                }
                if (this._warnings.contains(element)) {
                    Code.debug((Object)"Not Implemented: ", (Object)node);
                } else {
                    this._warnings.add(element);
                    Code.debug((Object)"Element ", element, (Object)" not handled in ", this);
                    Code.debug(node);
                }
            }
        }
    }

    protected void initDisplayName(XmlParser.Node node) {
        this._name = node.toString(false, true);
    }

    protected void initContextParam(XmlParser.Node node) {
        String name = node.getString("param-name", false, true);
        String value = node.getString("param-value", false, true);
        Code.debug((Object)"ContextParam: ", name, (Object)"=", value);
        this.setInitParameter(name, value);
    }

    protected void initFilter(XmlParser.Node node) throws ClassNotFoundException, UnavailableException {
        String name = node.getString("filter-name", false, true);
        String className = node.getString("filter-class", false, true);
        if (className == null) {
            Code.warning("Missing filter-class in " + node);
            return;
        }
        if (name == null) {
            name = className;
        }
        FilterHolder holder = this._webAppHandler.defineFilter(name, className);
        holder.addAppliesTo("REQUEST");
        Iterator iter = node.iterator("init-param");
        while (iter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            holder.put(pname, pvalue);
        }
    }

    protected void initFilterMapping(XmlParser.Node node) {
        String filterName = node.getString("filter-name", false, true);
        String pathSpec = node.getString("url-pattern", false, true);
        String servletName = node.getString("servlet-name", false, true);
        if (servletName != null) {
            this._webAppHandler.mapServletToFilter(servletName, filterName);
        } else {
            this._webAppHandler.mapPathToFilter(pathSpec, filterName);
        }
    }

    protected void initServlet(XmlParser.Node node) throws ClassNotFoundException, UnavailableException, IOException, MalformedURLException {
        String roleName;
        String name = node.getString("servlet-name", false, true);
        String className = node.getString("servlet-class", false, true);
        String jspFile = null;
        if (className == null) {
            Map.Entry entry;
            jspFile = node.getString("jsp-file", false, true);
            if (jspFile != null && (entry = this._webAppHandler.getHolderEntry(jspFile)) != null) {
                className = ((ServletHolder)entry.getValue()).getClassName();
            }
            if (className == null) {
                Code.warning("Missing servlet-class|jsp-file in " + node);
                return;
            }
        }
        if (name == null) {
            name = className;
        }
        ServletHolder holder = this._webAppHandler.newServletHolder(name, className, jspFile);
        if (jspFile != null) {
            this.initClassLoader(true);
            holder.setInitParameter("classpath", this.getFileClassPath());
        }
        Iterator iParamsIter = node.iterator("init-param");
        while (iParamsIter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iParamsIter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            holder.put(pname, pvalue);
        }
        XmlParser.Node startup = node.get("load-on-startup");
        if (startup != null) {
            String s = startup.toString(false, true).toLowerCase();
            if (s.startsWith("t")) {
                Code.warning("Deprecated boolean load-on-startup.  Please use integer");
                holder.setInitOrder(1);
            } else {
                int order = 0;
                try {
                    if (s != null && s.trim().length() > 0) {
                        order = Integer.parseInt(s);
                    }
                }
                catch (Exception e) {
                    Code.warning("Cannot parse load-on-startup " + s + ". Please use integer");
                    Code.ignore(e);
                }
                holder.setInitOrder(order);
            }
        }
        Iterator sRefsIter = node.iterator("security-role-ref");
        while (sRefsIter.hasNext()) {
            XmlParser.Node securityRef = (XmlParser.Node)sRefsIter.next();
            roleName = securityRef.getString("role-name", false, true);
            String roleLink = securityRef.getString("role-link", false, true);
            if (roleName != null && roleName.length() > 0 && roleLink != null && roleLink.length() > 0) {
                Code.debug("link role ", roleName, " to ", roleLink, " for ", this);
                holder.setUserRoleLink(roleName, roleLink);
                continue;
            }
            Code.warning("Ignored invalid security-role-ref element: servlet-name=" + name + ", " + securityRef);
        }
        XmlParser.Node run_as = node.get("run-as");
        if (run_as != null && (roleName = run_as.getString("role-name", false, true)) != null) {
            holder.setRunAs(roleName);
        }
    }

    protected void initServletMapping(XmlParser.Node node) {
        String name = node.getString("servlet-name", false, true);
        String pathSpec = node.getString("url-pattern", false, true);
        this._webAppHandler.mapPathToServlet(pathSpec, name);
    }

    protected void initListener(XmlParser.Node node) {
        String className = node.getString("listener-class", false, true);
        Object listener = null;
        try {
            Class listenerClass = this.loadClass(className);
            listener = listenerClass.newInstance();
        }
        catch (Exception e) {
            Code.warning("Could not instantiate listener " + className, e);
            return;
        }
        if (!(listener instanceof EventListener)) {
            Code.warning("Not an EventListener: " + listener);
            return;
        }
        boolean known = false;
        if (listener instanceof ServletContextListener || listener instanceof ServletContextAttributeListener) {
            known = true;
            this.addEventListener(listener);
        }
        if (listener instanceof HttpSessionActivationListener || listener instanceof HttpSessionAttributeListener || listener instanceof HttpSessionBindingListener || listener instanceof HttpSessionListener) {
            known = true;
            this._webAppHandler.addEventListener(listener);
        }
        if (!known) {
            Code.warning("Unknown: " + listener);
        }
    }

    protected void initSessionConfig(XmlParser.Node node) {
        XmlParser.Node tNode = node.get("session-timeout");
        if (tNode != null) {
            int timeout = Integer.parseInt(tNode.toString(false, true));
            this._webAppHandler.setSessionInactiveInterval(timeout * 60);
        }
    }

    protected void initMimeConfig(XmlParser.Node node) {
        String extension = node.getString("extension", false, true);
        if (extension != null && extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        String mimeType = node.getString("mime-type", false, true);
        this.setMimeMapping(extension, mimeType);
    }

    protected void initWelcomeFileList(XmlParser.Node node) {
        this.setWelcomeFiles(null);
        Iterator iter = node.iterator("welcome-file");
        while (iter.hasNext()) {
            XmlParser.Node indexNode = (XmlParser.Node)iter.next();
            String index = indexNode.toString(false, true);
            Code.debug((Object)"Index: ", (Object)index);
            this.addWelcomeFile(index);
        }
    }

    protected void initErrorPage(XmlParser.Node node) {
        String error = node.getString("error-code", false, true);
        if (error == null || error.length() == 0) {
            error = node.getString("exception-type", false, true);
        }
        String location = node.getString("location", false, true);
        this.setErrorPage(error, location);
    }

    protected void initTagLib(XmlParser.Node node) {
        String uri = node.getString("taglib-uri", false, true);
        String location = node.getString("taglib-location", false, true);
        this._tagLibMap.put(uri, location);
        this.setResourceAlias(uri, location);
    }

    protected void initSecurityConstraint(XmlParser.Node node) {
        XmlParser.Node data;
        SecurityConstraint scBase = new SecurityConstraint();
        XmlParser.Node auths = node.get("auth-constraint");
        if (auths != null) {
            scBase.setAuthenticate(true);
            Iterator iter = auths.iterator("role-name");
            while (iter.hasNext()) {
                String role = ((XmlParser.Node)iter.next()).toString(false, true);
                scBase.addRole(role);
            }
        }
        if ((data = node.get("user-data-constraint")) != null) {
            String guarantee = (data = data.get("transport-guarantee")).toString(false, true).toUpperCase();
            if (guarantee == null || guarantee.length() == 0 || "NONE".equals(guarantee)) {
                scBase.setDataConstraint(0);
            } else if ("INTEGRAL".equals(guarantee)) {
                scBase.setDataConstraint(1);
            } else if ("CONFIDENTIAL".equals(guarantee)) {
                scBase.setDataConstraint(2);
            } else {
                Code.warning("Unknown user-data-constraint:" + guarantee);
                scBase.setDataConstraint(2);
            }
        }
        Iterator iter = node.iterator("web-resource-collection");
        while (iter.hasNext()) {
            XmlParser.Node collection = (XmlParser.Node)iter.next();
            String name = collection.getString("web-resource-name", false, true);
            SecurityConstraint sc = (SecurityConstraint)scBase.clone();
            sc.setName(name);
            Iterator iter2 = collection.iterator("http-method");
            while (iter2.hasNext()) {
                sc.addMethod(((XmlParser.Node)iter2.next()).toString(false, true));
            }
            iter2 = collection.iterator("url-pattern");
            while (iter2.hasNext()) {
                String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                this.addSecurityConstraint(url, sc);
            }
        }
    }

    protected void initLoginConfig(XmlParser.Node node) {
        XmlParser.Node formConfig;
        XmlParser.Node name;
        XmlParser.Node method = node.get("auth-method");
        if (method != null) {
            SecurityConstraint.Authenticator authenticator = null;
            String m = method.toString(false, true);
            if ("FORM".equals(m)) {
                authenticator = this._formAuthenticator = new FormAuthenticator();
            } else if ("BASIC".equals(m)) {
                authenticator = new BasicAuthenticator();
            } else if ("DIGEST".equals(m)) {
                authenticator = new DigestAuthenticator();
            } else if ("CLIENT_CERT".equals(m)) {
                authenticator = new ClientCertAuthenticator();
            } else if ("CLIENT-CERT".equals(m)) {
                authenticator = new ClientCertAuthenticator();
            } else {
                Code.warning("UNKNOWN AUTH METHOD: " + m);
            }
            this.setAuthenticator(authenticator);
        }
        if ((name = node.get("realm-name")) != null) {
            this.setRealmName(name.toString(false, true));
        }
        if ((formConfig = node.get("form-login-config")) != null) {
            if (this._formAuthenticator == null) {
                Code.warning("FORM Authentication miss-configured");
            } else {
                XmlParser.Node errorPage;
                XmlParser.Node loginPage = formConfig.get("form-login-page");
                if (loginPage != null) {
                    this._formAuthenticator.setLoginPage(loginPage.toString(false, true));
                }
                if ((errorPage = formConfig.get("form-error-page")) != null) {
                    String ep = errorPage.toString(false, true);
                    this._formAuthenticator.setErrorPage(ep);
                }
            }
        }
    }

    protected void initSecurityRole(XmlParser.Node node) {
    }

    protected UserRealm getUserRealm(String name) {
        return this.getHttpServer().getRealm(name);
    }

    public String toString() {
        return "WebApplicationContext[" + this.getHttpContextName() + "," + (this._name == null ? this._war : this._name) + "]";
    }

    public void setClassPath(String classPath) {
        Code.warning("ClassPath should not be set for WebApplication");
        super.setClassPath(classPath);
    }

    public void setResourceBase(String resourceBase) {
        Code.warning("ResourceBase should not be set for WebApplication");
        super.setResourceBase(resourceBase);
    }

    public void setBaseResource(Resource baseResource) {
        Code.warning("BaseResource should not be set for WebApplication");
        super.setBaseResource(baseResource);
    }

    public Map getTagLibMap() {
        return this._tagLibMap;
    }

    public void setResourceAlias(String alias, String uri) {
        if (this._resourceAliases == null) {
            this._resourceAliases = new HashMap(5);
        }
        this._resourceAliases.put(alias, uri);
    }

    public String getResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.get(alias);
    }

    public String removeResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.remove(alias);
    }

    public Resource getResource(String uriInContext) throws IOException {
        IOException ioe = null;
        Resource resource = null;
        try {
            resource = super.getResource(uriInContext);
            if (resource != null && resource.exists()) {
                return resource;
            }
        }
        catch (IOException e) {
            ioe = e;
        }
        String aliasedUri = this.getResourceAlias(uriInContext);
        if (aliasedUri != null) {
            return super.getResource(aliasedUri);
        }
        if (ioe != null) {
            throw ioe;
        }
        return resource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

