/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.mortbay.http.HttpContext;
import org.mortbay.util.Code;
import org.mortbay.util.IO;
import org.mortbay.util.Resource;

public class ContextLoader
extends URLClassLoader {
    private boolean _java2compliant = false;
    private ClassLoader _parent;
    private PermissionCollection _permissions;
    private String _urlClassPath;

    public ContextLoader(HttpContext context, String classPath, ClassLoader parent, PermissionCollection permisions) throws MalformedURLException, IOException {
        super(new URL[0], parent);
        this._permissions = permisions;
        this._parent = parent;
        if (this._parent == null) {
            this._parent = ContextLoader.getSystemClassLoader();
        }
        if (classPath == null) {
            this._urlClassPath = "";
        } else {
            StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
            while (tokenizer.hasMoreTokens()) {
                URL url;
                Resource resource = Resource.newResource(tokenizer.nextToken());
                Code.debug((Object)"Path resource=", (Object)resource);
                File file = resource.getFile();
                if (file != null) {
                    url = resource.getURL();
                    this.addURL(url);
                    this._urlClassPath = this._urlClassPath == null ? url.toString() : this._urlClassPath + "," + url.toString();
                    continue;
                }
                if (!resource.isDirectory() && file == null) {
                    InputStream in = resource.getInputStream();
                    File lib = new File(context.getTempDirectory(), "lib");
                    if (!lib.exists()) {
                        lib.mkdir();
                        lib.deleteOnExit();
                    }
                    File jar = File.createTempFile("Jetty-", ".jar", lib);
                    jar.deleteOnExit();
                    Code.debug((Object)"Extract ", resource, (Object)" to ", jar);
                    FileOutputStream out = new FileOutputStream(jar);
                    IO.copy(in, out);
                    out.close();
                    URL url2 = jar.toURL();
                    this.addURL(url2);
                    this._urlClassPath = this._urlClassPath == null ? url2.toString() : this._urlClassPath + "," + url2.toString();
                    continue;
                }
                url = resource.getURL();
                this.addURL(url);
                this._urlClassPath = this._urlClassPath == null ? url.toString() : this._urlClassPath + "," + url.toString();
            }
        }
        if (Code.debug()) {
            Code.debug((Object)"ClassPath=", (Object)this._urlClassPath);
            Code.debug((Object)"Permissions=", (Object)this._permissions);
            Code.debug((Object)"URL=", Arrays.asList(this.getURLs()));
        }
    }

    public void setJava2Compliant(boolean compliant) {
        this._java2compliant = compliant;
    }

    public boolean isJava2Compliant() {
        return this._java2compliant;
    }

    public String toString() {
        if (Code.debug()) {
            return "ContextLoader@" + this.hashCode() + "(" + this._urlClassPath + ") / " + this._parent.toString();
        }
        return "ContextLoader@" + this.hashCode();
    }

    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection pc = this._permissions == null ? super.getPermissions(cs) : this._permissions;
        Code.debug("loader.getPermissions(" + cs + ")=" + pc);
        return pc;
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        ClassNotFoundException ex = null;
        boolean tried_parent = false;
        if (c == null && (this._java2compliant || this.isSystemPath(name))) {
            if (Code.verbose()) {
                Code.debug((Object)"try loadClass ", name, (Object)" from ", this._parent);
            }
            tried_parent = true;
            try {
                c = this._parent.loadClass(name);
                if (Code.verbose()) {
                    Code.debug((Object)"loaded ", c);
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null) {
            if (Code.verbose()) {
                Code.debug((Object)"try findClass ", name, (Object)" from ", this._urlClassPath);
            }
            try {
                c = this.findClass(name);
                if (Code.verbose()) {
                    Code.debug((Object)"loaded ", c);
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null && !tried_parent) {
            if (Code.verbose()) {
                Code.debug((Object)"try loadClass ", name, (Object)" from ", this._parent);
            }
            c = this._parent.loadClass(name);
            if (Code.verbose()) {
                Code.debug((Object)"loaded ", c);
            }
        }
        if (c == null) {
            throw ex;
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public synchronized URL getResource(String name) {
        URL url = null;
        boolean tried_parent = false;
        if (this._java2compliant || this.isSystemPath(name)) {
            if (Code.verbose()) {
                Code.debug((Object)"try getResource ", name, (Object)" from ", this._parent);
            }
            tried_parent = true;
            url = this._parent.getResource(name);
        }
        if (url == null) {
            if (Code.verbose()) {
                Code.debug((Object)"try findResource ", name, (Object)" from ", this._urlClassPath);
            }
            if ((url = this.findResource(name)) == null && name.startsWith("/")) {
                Code.debug((Object)"HACK leading / off ", (Object)name);
                url = this.findResource(name.substring(1));
            }
        }
        if (url == null && !tried_parent) {
            if (Code.verbose()) {
                Code.debug((Object)"try getResource ", name, (Object)" from ", this._parent);
            }
            url = this._parent.getResource(name);
        }
        if (url != null && Code.verbose()) {
            Code.debug((Object)"found ", (Object)url);
        }
        return url;
    }

    public boolean isSystemPath(String name) {
        return name.startsWith("java.") || name.startsWith("javax.servlet.") || name.startsWith("javax.xml.") || name.startsWith("org.mortbay.") || name.startsWith("org.xml.") || name.startsWith("org.w3c.") || name.startsWith("java/") || name.startsWith("javax/servlet/") || name.startsWith("javax/xml/") || name.startsWith("org/mortbay/") || name.startsWith("org/xml/") || name.startsWith("org/w3c/") || name.startsWith("/java/") || name.startsWith("/javax/servlet/") || name.startsWith("/javax/xml/") || name.startsWith("/org/mortbay/") || name.startsWith("/org/xml/") || name.startsWith("/org/w3c/");
    }
}

