/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.text.UnicodeSet;
import java.util.Locale;
import java.util.ResourceBundle;

public final class LocaleData {
    private static final String EXEMPLAR_CHARS = "ExemplarCharacters";
    private static final String MEASUREMENT_SYSTEM = "MeasurementSystem";
    private static final String PAPER_SIZE = "PaperSize";

    private LocaleData() {
    }

    public static UnicodeSet getExemplarSet(Locale locale) {
        ResourceBundle bundle = ICULocaleData.getLocaleElements(locale);
        String pattern = bundle.getString(EXEMPLAR_CHARS);
        return new UnicodeSet(pattern);
    }

    public static final MeasurementSystem getMeasurementSystem(Locale locale) {
        ResourceBundle bundle = ICULocaleData.getLocaleElements(locale);
        Object obj = bundle.getObject(MEASUREMENT_SYSTEM);
        if (obj != null && obj instanceof Integer) {
            int system = (Integer)obj;
            if (MeasurementSystem.US.equals(system)) {
                return MeasurementSystem.US;
            }
            if (MeasurementSystem.SI.equals(system)) {
                return MeasurementSystem.SI;
            }
        }
        return null;
    }

    public static final PaperSize getPaperSize(Locale locale) {
        ResourceBundle bundle = ICULocaleData.getLocaleElements(locale);
        Object obj = bundle.getObject(PAPER_SIZE);
        if (obj != null && obj instanceof Integer[]) {
            Integer[] size = (Integer[])obj;
            return new PaperSize(size[0], size[1]);
        }
        return null;
    }

    public static final class PaperSize {
        private int height;
        private int width;

        private PaperSize(int h, int w) {
            this.height = h;
            this.width = w;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }
    }

    public static final class MeasurementSystem {
        public static final MeasurementSystem SI = new MeasurementSystem(0);
        public static final MeasurementSystem US = new MeasurementSystem(1);
        private int systemID;

        private MeasurementSystem(int id) {
            this.systemID = id;
        }

        private boolean equals(int id) {
            return this.systemID == id;
        }
    }
}

