/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.util.ByteArrayWrapper;

public final class RawCollationKey
extends ByteArrayWrapper {
    public RawCollationKey() {
    }

    public RawCollationKey(int capacity) {
        this.bytes = new byte[capacity];
    }

    public RawCollationKey(byte[] bytes) {
        this.bytes = bytes;
    }

    public RawCollationKey(byte[] bytes, int size) {
        if (size < 0 || size != 0 && bytes == null || bytes.length < size) {
            throw new ArrayIndexOutOfBoundsException("Expected bytes.length >= size");
        }
        this.bytes = bytes;
        this.size = size;
    }

    public int compareTo(RawCollationKey target) {
        int i = 0;
        while (this.bytes[i] != 0 && target.bytes[i] != 0) {
            byte key = this.bytes[i];
            byte targetkey = target.bytes[i];
            if (key == targetkey) {
                ++i;
                continue;
            }
            if (key >= 0) {
                if (targetkey < 0 || key < targetkey) {
                    return -1;
                }
                return 1;
            }
            if (targetkey >= 0 || key > targetkey) {
                return 1;
            }
            return -1;
        }
        if (this.bytes[i] == target.bytes[i]) {
            return 0;
        }
        if (this.bytes[i] == 0) {
            return -1;
        }
        return 1;
    }
}

