/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.apps;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.fop.fonts.FontFileReader;
import org.apache.fop.fonts.TTFCmapEntry;
import org.apache.fop.fonts.TTFFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TTFReader {
    private boolean invokedStandalone = false;

    private static String[] parseArguments(HashMap options, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    options.put(args[i], args[i + 1]);
                    ++i;
                } else {
                    options.put(args[i], "");
                }
            } else {
                arguments.add(args[i]);
            }
            ++i;
        }
        String[] argStrings = new String[arguments.size()];
        arguments.toArray(argStrings);
        return argStrings;
    }

    private static final void displayUsage() {
        System.out.println(" java org.apache.fop.fonts.apps.TTFReader [options] fontfile.ttf xmlfile.xml\n");
        System.out.println(" where options can be:\n");
        System.out.println("-enc ansi");
        System.out.println("     With this option you create a WinAnsi encoded font.\n");
        System.out.println("     The default is to create a CID keyed font.");
        System.out.println("     If you're not going to use characters outside the");
        System.out.println("     pdfencoding range (almost the same as iso-8889-1)");
        System.out.println("     you can add this option.");
        System.out.println("-ttcname <fontname>");
        System.out.println("     If you're reading data from a TrueType Collection");
        System.out.println("     (.ttc file) you must specify which font from the");
        System.out.println("     collection you will read metrics from. If you read");
        System.out.println("     from a .ttc file without this option, the fontnames");
        System.out.println("      will be listed for you.");
        System.out.println(" -fn <fontname>\n");
        System.out.println("     default is to use the fontname in the .ttf file, but\n     you can override that name to make sure that the\n");
        System.out.println("     embedded font is used (if you're embedding fonts)\n");
        System.out.println("     instead of installed fonts when viewing documents with Acrobat Reader.\n");
    }

    public static void main(String[] args) {
        String enc;
        String embFile = null;
        String embResource = null;
        String className = null;
        String fontName = null;
        String ttcName = null;
        boolean isCid = true;
        HashMap options = new HashMap();
        String[] arguments = TTFReader.parseArguments(options, args);
        TTFReader app = new TTFReader();
        app.invokedStandalone = true;
        System.out.println("TTF Reader v1.1.1");
        System.out.println();
        if (options.get("-enc") != null && "ansi".equals(enc = (String)options.get("-enc"))) {
            isCid = false;
        }
        if (options.get("-ttcname") != null) {
            ttcName = (String)options.get("-ttcname");
        }
        if (options.get("-ef") != null) {
            embFile = (String)options.get("-ef");
        }
        if (options.get("-er") != null) {
            embResource = (String)options.get("-er");
        }
        if (options.get("-fn") != null) {
            fontName = (String)options.get("-fn");
        }
        if (options.get("-cn") != null) {
            className = (String)options.get("-cn");
        }
        if (arguments.length != 2 || options.get("-h") != null || options.get("-help") != null || options.get("--help") != null) {
            TTFReader.displayUsage();
        } else {
            TTFFile ttf = app.loadTTF(arguments[0], ttcName);
            if (ttf != null) {
                Document doc = app.constructFontXML(ttf, fontName, className, embResource, embFile, isCid, ttcName);
                if (isCid) {
                    System.out.println("Creating CID encoded metrics");
                } else {
                    System.out.println("Creating WinAnsi encoded metrics");
                }
                if (doc != null) {
                    app.writeFontXML(doc, arguments[1]);
                }
                if (ttf.isEmbeddable()) {
                    System.out.println("This font contains no embedding license restrictions");
                } else {
                    System.out.println("** Note: This font contains license retrictions for\n         embedding. This font shouldn't be embedded.");
                }
            }
        }
    }

    public TTFFile loadTTF(String fileName, String fontName) {
        TTFFile ttfFile = new TTFFile();
        try {
            System.out.println("Reading " + fileName + "...");
            System.out.println();
            FontFileReader reader = new FontFileReader(fileName);
            ttfFile.readFont(reader, fontName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return ttfFile;
    }

    public void writeFontXML(Document doc, String target) {
        System.out.println("Writing xml font file " + target + "...");
        System.out.println();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(new File(target)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Document constructFontXML(TTFFile ttf, String fontName, String className, String resource, String file, boolean isCid, String ttcName) {
        int i;
        Document doc;
        System.out.println("Creating xml font file...");
        System.out.println();
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            System.out.println("Can't create DOM implementation " + e.getMessage());
            return null;
        }
        Element root = doc.createElement("font-metrics");
        doc.appendChild(root);
        if (isCid) {
            root.setAttribute("type", "TYPE0");
        } else {
            root.setAttribute("type", "TRUETYPE");
        }
        Element el = doc.createElement("font-name");
        root.appendChild(el);
        String s = this.stripWhiteSpace(ttf.getPostscriptName());
        if (fontName != null) {
            el.appendChild(doc.createTextNode(this.stripWhiteSpace(fontName)));
        } else {
            el.appendChild(doc.createTextNode(s));
        }
        el = doc.createElement("embed");
        root.appendChild(el);
        if (file != null && ttf.isEmbeddable()) {
            el.setAttribute("file", file);
        }
        if (resource != null && ttf.isEmbeddable()) {
            el.setAttribute("class", resource);
        }
        el = doc.createElement("cap-height");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(String.valueOf(ttf.getCapHeight())));
        el = doc.createElement("x-height");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(String.valueOf(ttf.getXHeight())));
        el = doc.createElement("ascender");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(String.valueOf(ttf.getLowerCaseAscent())));
        el = doc.createElement("descender");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(String.valueOf(ttf.getLowerCaseDescent())));
        Element bbox = doc.createElement("bbox");
        root.appendChild(bbox);
        int[] bb = ttf.getFontBBox();
        String[] names = new String[]{"left", "bottom", "right", "top"};
        int i2 = 0;
        while (i2 < 4) {
            el = doc.createElement(names[i2]);
            bbox.appendChild(el);
            el.appendChild(doc.createTextNode(String.valueOf(bb[i2])));
            ++i2;
        }
        el = doc.createElement("flags");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(String.valueOf(ttf.getFlags())));
        el = doc.createElement("stemv");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(ttf.getStemV()));
        el = doc.createElement("italicangle");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(ttf.getItalicAngle()));
        if (ttcName != null) {
            el = doc.createElement("ttc-name");
            root.appendChild(el);
            el.appendChild(doc.createTextNode(ttcName));
        }
        el = doc.createElement("subtype");
        root.appendChild(el);
        if (isCid) {
            el.appendChild(doc.createTextNode("TYPE0"));
            Element mel = doc.createElement("multibyte-extras");
            root.appendChild(mel);
            el = doc.createElement("cid-type");
            mel.appendChild(el);
            el.appendChild(doc.createTextNode("CIDFontType2"));
            el = doc.createElement("default-width");
            mel.appendChild(el);
            el.appendChild(doc.createTextNode("0"));
            el = doc.createElement("bfranges");
            mel.appendChild(el);
            ArrayList cmaps = ttf.getCMaps();
            i = 0;
            while (i < cmaps.size()) {
                TTFCmapEntry ce = (TTFCmapEntry)cmaps.get(i);
                Element el2 = doc.createElement("bf");
                el.appendChild(el2);
                el2.setAttribute("us", String.valueOf(ce.unicodeStart));
                el2.setAttribute("ue", String.valueOf(ce.unicodeEnd));
                el2.setAttribute("gi", String.valueOf(ce.glyphStartIndex));
                ++i;
            }
            el = doc.createElement("cid-widths");
            el.setAttribute("start-index", "0");
            mel.appendChild(el);
            int[] wx = ttf.getWidths();
            int i3 = 0;
            while (i3 < wx.length) {
                Element wxel = doc.createElement("wx");
                wxel.setAttribute("w", String.valueOf(wx[i3]));
                el.appendChild(wxel);
                ++i3;
            }
        } else {
            el.appendChild(doc.createTextNode("TRUETYPE"));
            Element sel = doc.createElement("singlebyte-extras");
            root.appendChild(sel);
            el = doc.createElement("encoding");
            sel.appendChild(el);
            el.appendChild(doc.createTextNode(ttf.getCharSetName()));
            el = doc.createElement("first-char");
            sel.appendChild(el);
            el.appendChild(doc.createTextNode(String.valueOf(ttf.getFirstChar())));
            el = doc.createElement("last-char");
            sel.appendChild(el);
            el.appendChild(doc.createTextNode(String.valueOf(ttf.getLastChar())));
            Element widths = doc.createElement("widths");
            sel.appendChild(widths);
            i = ttf.getFirstChar();
            while (i <= ttf.getLastChar()) {
                el = doc.createElement("char");
                widths.appendChild(el);
                el.setAttribute("idx", String.valueOf(i));
                el.setAttribute("wdt", String.valueOf(ttf.getCharWidth(i)));
                i = (short)(i + 1);
            }
        }
        Iterator iterator = isCid ? ttf.getKerning().keySet().iterator() : ttf.getAnsiKerning().keySet().iterator();
        while (iterator.hasNext()) {
            Integer kpx1 = (Integer)iterator.next();
            el = doc.createElement("kerning");
            el.setAttribute("kpx1", kpx1.toString());
            root.appendChild(el);
            Element el2 = null;
            HashMap h2 = isCid ? (HashMap)ttf.getKerning().get(kpx1) : (HashMap)ttf.getAnsiKerning().get(kpx1);
            Iterator enum2 = h2.keySet().iterator();
            while (enum2.hasNext()) {
                Integer kpx2 = (Integer)enum2.next();
                if (!isCid && kpx2 >= 256) continue;
                el2 = doc.createElement("pair");
                el2.setAttribute("kpx2", kpx2.toString());
                Integer val = (Integer)h2.get(kpx2);
                el2.setAttribute("kern", val.toString());
                el.appendChild(el2);
            }
        }
        return doc;
    }

    private String stripWhiteSpace(String s) {
        char[] ch = new char[s.length()];
        s.getChars(0, s.length(), ch, 0);
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < ch.length) {
            if (ch[i] != ' ' && ch[i] != '\r' && ch[i] != '\n' && ch[i] != '\t') {
                stb.append(ch[i]);
            }
            ++i;
        }
        return stb.toString();
    }

    private String escapeString(String str) {
        StringBuffer esc = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '\\') {
                esc.append("\\\\");
            } else {
                esc.append(str.charAt(i));
            }
            ++i;
        }
        return esc.toString();
    }
}

